/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="visit_template")
public class VisitTemplate
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String shortName;
    private Boolean approved;
    private Boolean relativeTime;
    private String nursing;
    private String nutrition;
    private String processing;
    private String setup;
    private Sublocation sublocation;
    private Date createdDate;
    private VisitType visitType;
    private Study study;
    private Boolean institutionNonCRC;
    private Boolean nonInstitutionNonCRC;
    private Boolean researchPharmacy;
    private Boolean active;
    private Date lastUpdateTime;
    private Integer duration;
    private Boolean billable;
    private String comment;

    public VisitTemplate() {
        super(null);
    }

    public VisitTemplate(Integer id, String name, String shortName, Boolean approved, Boolean relativeTime, String nursing, String nutrition, String processing, String setup, Sublocation sublocation, Date createdDate, VisitType visitType, Study study, Boolean institutionNonCRC, Boolean nonInstitutionNonCRC, Boolean researchPharmacy, Boolean active, Date lastUpdateTime, Integer duration, Boolean billable) {
        super(id);
        this.name = name;
        this.shortName = shortName;
        this.approved = approved;
        this.relativeTime = relativeTime;
        this.nursing = nursing;
        this.nutrition = nutrition;
        this.processing = processing;
        this.setup = setup;
        this.sublocation = sublocation;
        this.createdDate = createdDate;
        this.visitType = visitType;
        this.study = study;
        this.institutionNonCRC = institutionNonCRC;
        this.nonInstitutionNonCRC = nonInstitutionNonCRC;
        this.researchPharmacy = researchPharmacy;
        this.active = active;
        this.lastUpdateTime = lastUpdateTime;
        this.duration = duration;
        this.billable = billable;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="short_name")
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Column(name="billable")
    public Boolean getBillable() {
        return this.billable;
    }

    public void setBillable(Boolean billable) {
        this.billable = billable;
    }

    @Column(name="approved")
    public Boolean getApproved() {
        return this.approved;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    @Column(name="relative_time")
    public Boolean getRelativeTime() {
        return this.relativeTime;
    }

    public void setRelativeTime(Boolean relativeTime) {
        this.relativeTime = relativeTime;
    }

    @Column(name="duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Column(name="nursing")
    public String getNursing() {
        return this.nursing;
    }

    public void setNursing(String nursing) {
        this.nursing = VisitTemplate.spaceIfNull(nursing);
    }

    private static String spaceIfNull(String s) {
        return s == null ? " " : s;
    }

    @Column(name="nutrition")
    public String getNutrition() {
        return this.nutrition;
    }

    public void setNutrition(String nutrition) {
        this.nutrition = VisitTemplate.spaceIfNull(nutrition);
    }

    @Column(name="processing")
    public String getProcessing() {
        return this.processing;
    }

    public void setProcessing(String processing) {
        this.processing = VisitTemplate.spaceIfNull(processing);
    }

    @Column(name="setup")
    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = VisitTemplate.spaceIfNull(setup);
    }

    @JoinColumn(name="sublocation", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Sublocation getSublocation() {
        return this.sublocation;
    }

    public void setSublocation(Sublocation sublocation) {
        this.sublocation = sublocation;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="created_date")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @JoinColumn(name="visit_type", referencedColumnName="id")
    @ManyToOne(optional=false)
    @Basic(optional=false)
    public VisitType getVisitType() {
        return this.visitType;
    }

    public void setVisitType(VisitType visitType) {
        this.visitType = visitType;
    }

    @JoinColumn(name="study", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    @Column(name="institution_non_crc")
    public Boolean getInstitutionNonCRC() {
        return this.institutionNonCRC;
    }

    public void setInstitutionNonCRC(Boolean institutionNonCRC) {
        this.institutionNonCRC = institutionNonCRC;
    }

    @Column(name="non_institution_non_crc")
    public Boolean getNonInstitutionNonCRC() {
        return this.nonInstitutionNonCRC;
    }

    public void setNonInstitutionNonCRC(Boolean nonInstitutionNonCRC) {
        this.nonInstitutionNonCRC = nonInstitutionNonCRC;
    }

    @Column(name="research_pharmacy")
    public Boolean getResearchPharmacy() {
        return this.researchPharmacy;
    }

    public void setResearchPharmacy(Boolean researchPharmacy) {
        this.researchPharmacy = researchPharmacy;
    }

    @Column(name="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Column(name="last_update_time")
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Transient
    public String getApprovedString() {
        if (this.approved != null && this.approved.booleanValue()) {
            return "Approved";
        }
        return "Not Approved";
    }

    public String toString() {
        return "VisitTemplate [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    public static class VisitTemplateBuilder {
        private String name;
        private String shortName;
        private Boolean approved;
        private Boolean relativeTime;
        private String nursing;
        private String nutrition;
        private String processing;
        private String setup;
        private Sublocation sublocation;
        private Date createdDate;
        private VisitType visitType;
        private Study study;
        private Boolean institutionNonCRC;
        private Boolean nonInstitutionNonCRC;
        private Boolean researchPharmacy;
        private Boolean active;
        private Date lastUpdateTime;
        private Integer duration;
        private Boolean billable;
        private Integer id;

        public VisitTemplateBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public VisitTemplateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VisitTemplateBuilder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public VisitTemplateBuilder approved(Boolean approved) {
            this.approved = approved;
            return this;
        }

        public VisitTemplateBuilder relativeTime(Boolean relativeTime) {
            this.relativeTime = relativeTime;
            return this;
        }

        public VisitTemplateBuilder nursing(String nursing) {
            this.nursing = nursing;
            return this;
        }

        public VisitTemplateBuilder nutrition(String nutrition) {
            this.nutrition = nutrition;
            return this;
        }

        public VisitTemplateBuilder processing(String processing) {
            this.processing = processing;
            return this;
        }

        public VisitTemplateBuilder setup(String setup) {
            this.setup = setup;
            return this;
        }

        public VisitTemplateBuilder sublocation(Sublocation sublocation) {
            this.sublocation = sublocation;
            return this;
        }

        public VisitTemplateBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public VisitTemplateBuilder visitType(VisitType visitType) {
            this.visitType = visitType;
            return this;
        }

        public VisitTemplateBuilder study(Study study) {
            this.study = study;
            return this;
        }

        public VisitTemplateBuilder institutionNonCRC(Boolean institutionNonCRC) {
            this.institutionNonCRC = institutionNonCRC;
            return this;
        }

        public VisitTemplateBuilder nonInstitutionNonCRC(Boolean nonInstitutionNonCRC) {
            this.nonInstitutionNonCRC = nonInstitutionNonCRC;
            return this;
        }

        public VisitTemplateBuilder researchPharmacy(Boolean researchPharmacy) {
            this.researchPharmacy = researchPharmacy;
            return this;
        }

        public VisitTemplateBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public VisitTemplateBuilder lastUpdateTime(Date lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public VisitTemplateBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public VisitTemplateBuilder billable(Boolean billable) {
            this.billable = billable;
            return this;
        }

        public VisitTemplate create() {
            return new VisitTemplate(this.id, this.name, this.shortName, this.approved, this.relativeTime, this.nursing, this.nutrition, this.processing, this.setup, this.sublocation, this.createdDate, this.visitType, this.study, this.institutionNonCRC, this.nonInstitutionNonCRC, this.researchPharmacy, this.active, this.lastUpdateTime, this.duration, this.billable);
        }
    }
}

