/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.dto.response.GetSearchVisitResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceTimeBoundsAndCountResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithTraListDTO;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.persistence.CriteriaQueryHelper;
import edu.harvard.catalyst.scheduler.persistence.HqlClauses;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class TemplateResourceDAO
extends SiteDAO {
    @Autowired
    StudyDAO studyDAO;

    public List<TemplateResource> findTemplateResourcesByVisitAndResource(Integer visitTemplate, Integer rId) {
        String hql = "select tr from TemplateResource tr where tr.visitTemplate.id = :visitTemplate and tr.resource.id = :rId";
        Query query = this.newQuery("select tr from TemplateResource tr where tr.visitTemplate.id = :visitTemplate and tr.resource.id = :rId").setParameter("visitTemplate", (Object)visitTemplate).setParameter("rId", (Object)rId);
        List result = query.list();
        return result;
    }

    public List<TemplateResource> getTemplateResourcesUsedOnDay(int vtId, int selectedMinutesStartOfDay, int nextMinutesStartOfDay) {
        String hql = "SELECT tr FROM TemplateResource tr  INNER JOIN tr.visitTemplate vt WHERE vt.id = :vtId AND (tr.startMinutes >= :selectedMinutesStartOfDay)AND (tr.endMinutes < :nextMinutesStartOfDay)";
        Query hqlQuery = this.newQuery("SELECT tr FROM TemplateResource tr  INNER JOIN tr.visitTemplate vt WHERE vt.id = :vtId AND (tr.startMinutes >= :selectedMinutesStartOfDay)AND (tr.endMinutes < :nextMinutesStartOfDay)").setParameter("vtId", (Object)vtId).setParameter("selectedMinutesStartOfDay", (Object)selectedMinutesStartOfDay).setParameter("nextMinutesStartOfDay", (Object)nextMinutesStartOfDay);
        List templateResourceList = hqlQuery.list();
        return templateResourceList;
    }

    public List<TemplateResource> findTemplateResourcesByVisit(VisitTemplate visit) {
        return this.findTemplateResourcesByVisit(visit, "");
    }

    public List<TemplateResource> findTemplateResourcesByVisitAndBillable(VisitTemplate visit, boolean isBillable, String sortBy, String orderBy, int page, int maxResults) {
        String sortExpression = " order by " + sortBy + " " + orderBy;
        String queryString = "select tr from TemplateResource tr where tr.visitTemplate = :visit and tr.billable = :isBillable " + sortExpression;
        Query query = this.newQuery(queryString);
        query.setParameter("visit", (Object)visit);
        query.setParameter("isBillable", (Object)isBillable);
        List templateResourceList = query.list();
        return templateResourceList;
    }

    public List<TemplateResource> findTemplateResourcesByVisit(VisitTemplate visit, String sortExpression) {
        String queryString = "select tr from TemplateResource tr where tr.visitTemplate = :visit " + sortExpression;
        Query query = this.newQuery(queryString).setParameter("visit", (Object)visit);
        List templateResourceList = query.list();
        return templateResourceList;
    }

    public List<TemplateResourceWithTraListDTO> findTemplateResourcesAndAnnotationsByVisit(Integer visitId, String sortExpression) {
        String queryString = "select tr, tra from TemplateResourceAnnotations tra right join tra.templateResource tr where tr.visitTemplate.id = :visitId " + sortExpression;
        Query query = this.newQuery(queryString).setParameter("visitId", (Object)visitId);
        List queryResultRowList = query.list();
        HashMap dtoMap = Maps.newHashMap();
        ArrayList resultList = Lists.newArrayList();
        for (Object[] queryResultRow : queryResultRowList) {
            TemplateResource tr = (TemplateResource)queryResultRow[0];
            TemplateResourceAnnotations tra = (TemplateResourceAnnotations)queryResultRow[1];
            TemplateResourceWithTraListDTO associatedTrwalDto = (TemplateResourceWithTraListDTO)dtoMap.get(tr);
            if (associatedTrwalDto == null) {
                associatedTrwalDto = new TemplateResourceWithTraListDTO(tr);
                dtoMap.put(tr, associatedTrwalDto);
                resultList.add(associatedTrwalDto);
            }
            TemplateResourceWithTraListDTO trwalDto = (TemplateResourceWithTraListDTO)dtoMap.get(tr);
            if (tra == null) continue;
            trwalDto.getTraList().add(tra);
        }
        return resultList;
    }

    public GetSearchVisitResourceResponse findTemplateResourcesByVisit(Integer visitId, String sortByParam, String orderBy, Integer page, Integer maxResults) {
        maxResults = MiscUtil.negativeIsInfinity(maxResults);
        Object sortBy = sortByParam.equalsIgnoreCase("tr.startMinutes") ? " tr.startMinutes " + orderBy + ", tr.endMinutes " : (sortByParam.equalsIgnoreCase("tr.endMinutes") ? " tr.endMinutes " + orderBy + ", tr.startMinutes " : sortByParam);
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visitId);
        String whereClause = HqlClauses.whereBuilder().equalTo(Optional.of("r.id"), "tr.resource").equalTo(Optional.of(":vt"), "tr.visitTemplate").build();
        String simpleHql = "select tr from TemplateResource tr, Resource r " + whereClause + " order by " + (String)sortBy + " " + orderBy;
        Query mainQuery = this.newQuery(simpleHql).setParameter("vt", (Object)visitTemplate);
        long total = mainQuery.list().size();
        int offset = (page - 1) * maxResults;
        mainQuery.setFirstResult(offset);
        mainQuery.setMaxResults(maxResults.intValue());
        List resultRows = mainQuery.list();
        return GetSearchVisitResourceResponse.createGetSearchVisitsResponse(resultRows, total);
    }

    public List<TemplateResourceAnnotations> findTemplateResourceAnnotationsByTemplateResource(TemplateResource tr) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), TemplateResourceAnnotations.class);
        criteriaHelper.whereEquals("templateResource", tr);
        return criteriaHelper.getQuery().list();
    }

    public TemplateResource findTemplateResourceLowest(VisitTemplate visitTemplate) {
        String findTemplateResource = "SELECT tr FROM TemplateResource tr WHERE  tr.visitTemplate = :visitTemplate order by tr.startMinutes ASC";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr WHERE  tr.visitTemplate = :visitTemplate order by tr.startMinutes ASC").setParameter("visitTemplate", (Object)visitTemplate).setFirstResult(0).setMaxResults(1);
        List brs = query.list();
        return (TemplateResource)brs.get(0);
    }

    public ResourceTimeBoundsAndCountResponseDTO findTemplateResourceCountEarliestLatest(int visitTemplate) {
        String findTemplateResource = "SELECT min(startMinutes), max(endMinutes), count(id) FROM TemplateResource a WHERE a.visitTemplate.id = :visitTemplate";
        Query query = this.newQuery("SELECT min(startMinutes), max(endMinutes), count(id) FROM TemplateResource a WHERE a.visitTemplate.id = :visitTemplate").setParameter("visitTemplate", (Object)visitTemplate);
        List resultRows = query.list();
        Object[] row0 = (Object[])resultRows.get(0);
        Date earliestStartDate = (Date)row0[0];
        Date latestEndDate = (Date)row0[1];
        Long count = (Long)row0[2];
        return ResourceTimeBoundsAndCountResponseDTO.fromTriple(count, earliestStartDate, latestEndDate);
    }

    public List<TemplateResource> findRoomTemplateResourcesByVisit(VisitTemplate visitTemplate) {
        String findTemplateResource = "SELECT tr FROM TemplateResource tr, Resource r WHERE  tr.visitTemplate = :visitTemplate and tr.resource = r.id and r.resourceType = :resourceType";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr, Resource r WHERE  tr.visitTemplate = :visitTemplate and tr.resource = r.id and r.resourceType = :resourceType").setParameter("visitTemplate", (Object)visitTemplate).setParameter("resourceType", (Object)ResourceType.Room);
        return query.list();
    }

    public List<TemplateResource> findFixedTemplateResourcesByVisit(VisitTemplate visit) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), TemplateResource.class);
        criteriaHelper.whereEquals("visitTemplate", visit);
        criteriaHelper.whereIsNull("groupId");
        criteriaHelper.whereEquals("floatable", Boolean.FALSE);
        return criteriaHelper.getQuery().list();
    }

    public List<TemplateResource> findUngroupedTemplateResourcesTypeByVisit(VisitTemplate visit, String templateResourceType) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), TemplateResource.class);
        criteriaHelper.whereEquals("visitTemplate", visit);
        criteriaHelper.whereIsNull("groupId");
        criteriaHelper.whereEquals(templateResourceType, Boolean.TRUE);
        return criteriaHelper.getQuery().list();
    }

    public List<TemplateResourceGroup> findTemplateResourceGroupByVisitAndTemplate(VisitTemplate visit, TemplateResource templateResource) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), TemplateResourceGroup.class);
        criteriaHelper.whereEquals("templateResource", templateResource);
        criteriaHelper.whereEquals("visit", visit);
        return criteriaHelper.getQuery().list();
    }

    public TemplateResource findTemplateResourceById(int id) {
        return this.findById(TemplateResource.class, id);
    }
}

