/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public final class DateUtility {
    public static final int MINS_PER_HR = 60;
    public static final int MINS_PER_DAY = 1440;
    public static final int MINUTES_PER_PERIOD = 15;
    public static final int PERIODS_PER_DAY = 96;
    public static final long MILLISECS_PER_MIN = 60000L;
    private static final int TWO_DIGIT_TIME = 10;
    public static Calendar TEMPLATE_RESOURCE_CALENDAR_ORIGIN = Calendar.getInstance();
    public static LocalDate TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN;
    public static LocalDateTime TEMPLATE_RESOURCE_LOCAL_DATE_TIME_ORIGIN;
    public static Date TEMPLATE_RESOURCE_DATE_ORIGIN;
    private final DateFormat monthDayYear = new SimpleDateFormat("MM/dd/yyyy");
    private final DateFormat dateHrMinSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DateFormat ie8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final DateFormat gantt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final DateFormat otherBrowser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final DateFormat subjectDate = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss");
    private final DateFormat fullCalendar = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss Z (zzzz)");
    private final DateFormat yearMonthDay = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat dateHrMin = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final DateFormat dayMonthYear = new SimpleDateFormat("dd-MM-yyyy");
    private final DateFormat dateTime = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
    private final DateFormat date24HTime = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    private final DateFormat hrMin = new SimpleDateFormat("HH:mm");
    private final DateFormat clockHrMin = new SimpleDateFormat("hh:mm aa");
    private final DateFormat hr = new SimpleDateFormat("HH");
    private final DateFormat min = new SimpleDateFormat("mm");
    private final DateFormat dayMonthDayYear = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss");
    private static final int MILLISEC_IN_A_DAY = 86400000;
    private static final ThreadLocal<DateUtility> dateUtilityThreadLocal;

    public static final DateFormat monthDayYear() {
        return DateUtility.getDateUtility().monthDayYear;
    }

    public static final DateFormat dateHourMinSec() {
        return DateUtility.getDateUtility().dateHrMinSec;
    }

    public static final DateFormat ie8() {
        return DateUtility.getDateUtility().ie8;
    }

    public static final DateFormat otherBrowser() {
        return DateUtility.getDateUtility().otherBrowser;
    }

    public static final DateFormat gantt() {
        return DateUtility.getDateUtility().gantt;
    }

    public static final DateFormat subjectDate() {
        return DateUtility.getDateUtility().subjectDate;
    }

    public static final DateFormat fullCalendar() {
        return DateUtility.getDateUtility().fullCalendar;
    }

    public static final DateFormat yearMonthDay() {
        return DateUtility.getDateUtility().yearMonthDay;
    }

    public static final DateFormat dateHourMin() {
        return DateUtility.getDateUtility().dateHrMin;
    }

    public static final DateFormat dateMonthYear() {
        return DateUtility.getDateUtility().dayMonthYear;
    }

    public static final DateFormat dateMonthDayYear() {
        return DateUtility.getDateUtility().dayMonthDayYear;
    }

    public static final DateFormat dateTime() {
        return DateUtility.getDateUtility().dateTime;
    }

    public static final DateFormat date24HTime() {
        return DateUtility.getDateUtility().date24HTime;
    }

    public static final DateFormat hourMin() {
        return DateUtility.getDateUtility().hrMin;
    }

    public static final DateFormat hour() {
        return DateUtility.getDateUtility().hr;
    }

    public static final DateFormat min() {
        return DateUtility.getDateUtility().min;
    }

    private DateUtility() {
    }

    static DateUtility getDateUtility() {
        DateUtility dateUtility = dateUtilityThreadLocal.get();
        if (dateUtility == null) {
            dateUtility = new DateUtility();
            dateUtilityThreadLocal.set(dateUtility);
        }
        return dateUtility;
    }

    public static String format(DateFormat format, Date date) {
        String value = null;
        if (date != null) {
            value = format.format(date);
        }
        return value;
    }

    public static Date parse(DateFormat format, String value) {
        if (value.isEmpty()) {
            return null;
        }
        Date date = null;
        try {
            date = format.parse(value);
        }
        catch (ParseException pe) {
            SchedulerRuntimeException.logAndThrow("Bad format '" + format + "' or value '" + value + "'", pe);
        }
        return date;
    }

    public static Date parseLong(String value) {
        Date result = null;
        if (MiscUtil.isNonNullNonEmpty(value)) {
            Date date = new Date();
            Long dateLong = Long.parseLong(value);
            date.setTime(dateLong);
            result = date;
        }
        return result;
    }

    public static Date nextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateUtility.clearTime(cal);
        cal.add(5, 1);
        return cal.getTime();
    }

    private static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static Date startOfDay(Calendar cal) {
        DateUtility.clearTime(cal);
        return cal.getTime();
    }

    public static int compareDateDifference(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.clear();
        cal2.clear();
        cal1.setTime(date1);
        cal2.setTime(date2);
        long results = (cal2.getTimeInMillis() - cal1.getTimeInMillis()) / 86400000L;
        int result = (int)results + 1;
        if (result < 0) {
            return -(result + -1);
        }
        return result;
    }

    public static int day2minusDay1(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        DateUtility.clearTime(cal1);
        DateUtility.clearTime(cal2);
        long deltaMillis = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        return (int)(deltaMillis / 86400000L);
    }

    public static int deltaMinutesBetweenDate1Date2(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        int offset = cal1.get(16);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        cal2.set(16, offset);
        long deltaMillis = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        return (int)(deltaMillis / 60000L);
    }

    public static Date adjustDateToHMS(Date date, int hour, int minute, int second) {
        TimeZone tz = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(tz);
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar.getTime();
    }

    public static Date adjustDateToEndOfDay(Date date) {
        return DateUtility.adjustDateToHMS(date, 23, 59, 59);
    }

    public static Date adjustDateToStartOfDay(Date date) {
        return DateUtility.adjustDateToHMS(date, 0, 0, 0);
    }

    public static int convertMillisecondsToMinutes(long milliseconds) {
        return Math.round(milliseconds / 1000L / 60L);
    }

    public static int convertMillisToMinutes(long milliseconds) {
        return (int)(milliseconds / 1000L / 60L);
    }

    public static int getDayOfTheWeek(Date startDate) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(startDate);
        return cal.get(7);
    }

    public static List<Date> dateInterval(Date initial, Date endDate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        Date startDate = DateUtility.adjustDateToStartOfDay(initial);
        while (DateUtility.isStartDateBeforeEndDate(startDate, endDate)) {
            dates.add(startDate);
            startDate = DateUtility.incrementDay(startDate);
        }
        return dates;
    }

    public static Date incrementDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    private static boolean isStartDateBeforeEndDate(Date startDate, Date endDate) {
        return startDate.getTime() <= endDate.getTime();
    }

    public static String retrieveDayOfWeek(int day) {
        String days = day == 1 ? "SUN" : (day == 2 ? "MON" : (day == 3 ? "TUE" : (day == 4 ? "WED" : (day == 5 ? "THU" : (day == 6 ? "FRI" : (day == 7 ? "SAT" : null))))));
        return days;
    }

    public static Date oldZoneDeltaDate(Date startDate, int minutes) {
        return new Date(startDate.getTime() + (long)minutes * 60000L);
    }

    public static LocalDateTime oldZoneDeltaDate8(LocalDateTime startDate, int minutes) {
        return startDate.plusMinutes(minutes);
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static LocalDate dateToLocalDate(Date date) {
        return DateUtility.instantToLocalDate(date.toInstant());
    }

    public static int overnightsBetweenDates(Date start, Date end) {
        LocalDate startLDate = DateUtility.dateToLocalDate(start);
        LocalDate endLDate = DateUtility.dateToLocalDate(end);
        int result = (int)ChronoUnit.DAYS.between(startLDate, endLDate);
        return result;
    }

    public static LocalDate instantToLocalDate(Instant instant) {
        return instant.atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static int minutesIntoDay(int minutes) {
        return minutes % 1440;
    }

    public static Date minutesFromOriginToDate(long minutes) {
        return DateUtility.toDate(TEMPLATE_RESOURCE_LOCAL_DATE_TIME_ORIGIN.plusMinutes(minutes));
    }

    public static Date originDatePlusMinutes(long minutes) {
        return Date.from(TEMPLATE_RESOURCE_DATE_ORIGIN.toInstant().plusSeconds(minutes * 60L));
    }

    public static Date toDate(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        return Date.from(ldt.atZone(ZoneOffset.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate ld) {
        return Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static boolean earlierAndLaterAreSameLocalDay(int earlierMinutes, int laterMinutes) {
        int earlierDay = earlierMinutes / 1440;
        int laterDay = laterMinutes / 1440;
        return earlierDay == laterDay;
    }

    public static boolean minutesIntervalOverlapsDaysOffset(int candidateStart, int candidateEnd, int offsetInDays) {
        int viewStart = (offsetInDays - 1) * 1440;
        int viewEnd = viewStart + 1440;
        boolean result = DateUtility.minutesIntervalsOverlap(candidateStart, candidateEnd, viewStart, viewEnd);
        return result;
    }

    public static boolean minutesIntervalsOverlap(int resourceStart, int resourceEnd, int viewStart, int viewEnd) {
        return resourceStart < viewEnd && resourceEnd > viewEnd || resourceStart < viewStart && resourceEnd > viewStart || resourceStart >= viewStart && resourceEnd <= viewEnd || resourceEnd == viewStart;
    }

    public static boolean overlap(Date startTime, Date endTime, Date otherStartTime, Date otherEndTime) {
        if (endTime.before(startTime)) {
            SchedulerRuntimeException.logAndThrow("End time is before start time");
        }
        if (otherEndTime.before(otherStartTime)) {
            SchedulerRuntimeException.logAndThrow("End time is before start time");
        }
        return !startTime.before(otherStartTime) && startTime.before(otherEndTime) || !startTime.after(otherStartTime) && endTime.after(otherStartTime);
    }

    public static int dateToDayNumber(Date date) {
        LocalDateTime localDateTime = DateUtility.dateToLocalDate(date).atStartOfDay();
        int result = (int)(1L + Duration.between(TEMPLATE_RESOURCE_LOCAL_DATE_TIME_ORIGIN, localDateTime).toDays());
        return result;
    }

    public static int minutesToDayNumber(int minutes) {
        return 1 + minutes / 1440;
    }

    public static int convertMinutesToStartDayZeroOffset(int time) {
        return time / 1440;
    }

    public static int convertTotalMinutesToMinutesInHour(int time) {
        return time % 60;
    }

    public static int convertMinutesToHourInDay(int time) {
        return time / 60 % 24;
    }

    public static String padTime(int timeUnit) {
        return timeUnit < 10 ? "0" + timeUnit : "" + timeUnit;
    }

    public static int minutesSinceOrigin(Date date) {
        return DateUtility.minutesBetweenDates(TEMPLATE_RESOURCE_DATE_ORIGIN, date);
    }

    public static int minutesBetweenDates(Date earlier, Date later) {
        Instant laterInstant;
        Instant earlierInstant = Instant.from(Instant.ofEpochMilli(earlier.getTime()));
        long duration = Duration.between(earlierInstant, laterInstant = Instant.from(Instant.ofEpochMilli(later.getTime()))).toMinutes();
        if (duration > Integer.MAX_VALUE) {
            SchedulerRuntimeException.logAndThrow("int has overflowed: too many minutes between: " + earlier + " and " + later);
        }
        return (int)duration;
    }

    public static Timestamp formatFilterByDateTime(String filterString) {
        Date d;
        String OLD_FORMAT = "MM/dd/yy HH:mm";
        String NEW_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy HH:mm");
        try {
            d = sdf.parse(filterString);
        }
        catch (ParseException e) {
            return null;
        }
        sdf.applyPattern("yyyy-MM-dd HH:mm:ss.S");
        String newDateString = sdf.format(d);
        Timestamp timestamp = Timestamp.valueOf(newDateString);
        return timestamp;
    }

    public static String dayHrMinSecFormat(Date date) {
        String result = date == null ? null : DateUtility.format(DateUtility.dateHourMinSec(), date);
        return result;
    }

    public static Date oneMillisecondBeforeNow() {
        return new Date(new Date().getTime() - 1L);
    }

    static {
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(1, 2012);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(2, 1);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(5, 1);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(11, 0);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(12, 0);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(13, 0);
        TEMPLATE_RESOURCE_CALENDAR_ORIGIN.set(14, 0);
        TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN = DateUtility.instantToLocalDate(TEMPLATE_RESOURCE_CALENDAR_ORIGIN.toInstant());
        TEMPLATE_RESOURCE_DATE_ORIGIN = TEMPLATE_RESOURCE_CALENDAR_ORIGIN.getTime();
        TEMPLATE_RESOURCE_LOCAL_DATE_TIME_ORIGIN = TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN.atStartOfDay();
        dateUtilityThreadLocal = new ThreadLocal();
    }
}

