/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.batchSubjects;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.batchSubjects.BatchDumpChanges;
import edu.harvard.catalyst.scheduler.entity.NightlyBatchChanges;
import edu.harvard.catalyst.scheduler.persistence.NightlyDAO;
import edu.harvard.catalyst.scheduler.util.FactoryMockKey;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import edu.harvard.catalyst.scheduler.util.TestUtils;
import java.security.Key;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BatchDumpChangesTest {
    BatchDumpChanges batchDumpChanges;
    NightlyDAO nightlyDAO = (NightlyDAO)Mockito.mock(NightlyDAO.class);
    @Mock
    private Appender mockAppender;
    @Captor
    private ArgumentCaptor<LoggingEvent> captorLoggingEvent;

    @Before
    public void setup() {
        Logger root = Logger.getRootLogger();
        root.addAppender(this.mockAppender);
        root.setLevel(Level.INFO);
        FactoryMockKey keyFactory = new FactoryMockKey();
        Key key = keyFactory.createKey();
        SubjectDataEncryptor.setEncryptionKey((Key)key);
        this.batchDumpChanges = new BatchDumpChanges(this.nightlyDAO, key);
    }

    @Test
    public void testChanges() throws Exception {
        NightlyBatchChanges nbc1 = new NightlyBatchChanges();
        nbc1.setId(Integer.valueOf(1));
        NightlyBatchChanges nbc2 = new NightlyBatchChanges();
        nbc1.setId(Integer.valueOf(2));
        ArrayList nbcList = Lists.newArrayList((Object[])new NightlyBatchChanges[]{nbc1, nbc2});
        Mockito.when((Object)this.nightlyDAO.findAllChangeRecords(0)).thenReturn((Object)nbcList);
        this.batchDumpChanges.run(Integer.valueOf(0));
        TestUtils.verifyLog((String)"Found 2 Records of Change, starting with record 0", (int)1, (Appender)this.mockAppender, this.captorLoggingEvent);
    }
}

