/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.batchSubjects;

import edu.harvard.catalyst.scheduler.entity.NightlyBatchChanges;
import edu.harvard.catalyst.scheduler.persistence.NightlyDAO;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BatchDumpChanges {
    private static final Logger LOG = Logger.getLogger(BatchDumpChanges.class);
    private final NightlyDAO nightlyDAO;

    @Autowired
    public BatchDumpChanges(NightlyDAO nightlyDAO, @Qualifier(value="encryptionKeyBatch") Key key) {
        this.nightlyDAO = nightlyDAO;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws SQLException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("epic-dump-batch-changes.xml");
        BatchDumpChanges batchDumpChanges = (BatchDumpChanges)context.getBean("batchDumpChanges");
        Integer startRecord = Integer.valueOf(args[0]);
        batchDumpChanges.run(startRecord);
    }

    void run(Integer start) throws SQLException {
        LOG.info((Object)"\n=======================================================================================");
        List<NightlyBatchChanges> nightlyChanges = this.nightlyDAO.findAllChangeRecords(start);
        LOG.info((Object)("Found " + nightlyChanges.size() + " Records of Change, starting with record " + start));
        for (NightlyBatchChanges changes : nightlyChanges) {
            System.out.println("Change " + changes.getId() + ": " + SubjectDataEncryptor.decrypt((String)changes.getChanges()));
        }
        LOG.info((Object)"\n======== Output in console ===============================================================================");
    }
}

