/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SearchDTO {
    List<SearchItem> searchItems;

    public List<SearchItem> setSearchItems(List<SearchItem> searchItems) {
        this.searchItems = searchItems;
        return this.searchItems;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }

    public List<String> searchClauseAtomListWrapper(List<SearchItem> searchItems, Function<String, String> keyMapper) {
        return SearchDTO.searchClauseAtomList(searchItems, keyMapper);
    }

    static String possiblyAdjustValue(SearchItem searchItem) {
        ArrayList ecryptionList;
        String result = searchItem.getValue();
        if (searchItem.key.equals("v.visitType")) {
            result = searchItem.getValue().replaceAll("(\\S) ", "$1");
        }
        if ((ecryptionList = Lists.newArrayList((Object[])new String[]{"s.firstName", "s.lastName", "sm.mrn"})).contains(searchItem.key)) {
            result = SubjectDataEncryptor.encrypt(searchItem.getValue().toUpperCase());
        }
        return result;
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper) {
        return SearchDTO.toSearchClause(searchItems, keyMapper, " AND ", " AND ");
    }

    public static List<String> searchClauseAtomList(List<SearchItem> searchItems, Function<String, String> keyMapper) {
        List<String> searchClauses = searchItems.stream().filter(si -> si.getValue() != null && !si.getValue().isEmpty()).map(si -> {
            StringBuilder searchClause = new StringBuilder((String)keyMapper.apply(si.getKey()));
            String matchClause = " like '%" + SearchDTO.possiblyAdjustValue(si) + "%'";
            if (si.getSearchType() == SearchType.EXACT) {
                matchClause = "='" + SearchDTO.possiblyAdjustValue(si) + "'";
            }
            searchClause.append(matchClause);
            return searchClause.toString();
        }).collect(Collectors.toList());
        return searchClauses;
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper, String joinString, String prependString) {
        String result = "";
        List<String> searchClauses = SearchDTO.searchClauseAtomList(searchItems, keyMapper);
        if (prependString == null) {
            prependString = " ";
        }
        if (!searchClauses.isEmpty()) {
            result = prependString + Joiner.on((String)joinString).join(searchClauses);
        }
        return result;
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper, Function<SearchItem, String> valueMapper) {
        return SearchDTO.toSearchClause(searchItems, keyMapper, valueMapper, " AND ", " AND ");
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper, Function<SearchItem, String> valueMapper, String joinString) {
        return SearchDTO.toSearchClause(searchItems, keyMapper, valueMapper, joinString, joinString);
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper, Function<SearchItem, String> valueMapper, String joinString, String prependString) {
        if (joinString == null) {
            joinString = " AND ";
        }
        if (prependString == null) {
            prependString = " ";
        }
        String result = "";
        List searchClauses = searchItems.stream().filter(si -> si.getValue() != null && !si.getValue().isEmpty()).map(si -> {
            StringBuilder searchClause = new StringBuilder((String)keyMapper.apply(si.getKey()));
            String matchClause = " like '%" + (String)valueMapper.apply((SearchItem)si) + "%'";
            if (si.getSearchType() == SearchType.EXACT) {
                matchClause = "='" + (String)valueMapper.apply((SearchItem)si) + "'";
            }
            searchClause.append(matchClause);
            String searchClauseString = searchClause.toString();
            if (si.getOrSearchItems() != null) {
                String groupedORSearchClause = SearchDTO.toSearchClause(si.getOrSearchItems(), keyMapper, valueMapper, " OR ");
                searchClause.append(groupedORSearchClause);
                searchClauseString = "(" + searchClause + ")";
            }
            return searchClauseString;
        }).collect(Collectors.toList());
        if (!searchClauses.isEmpty()) {
            result = prependString + Joiner.on((String)joinString).join(searchClauses);
        }
        return result;
    }

    public static class SearchItem {
        String key;
        String value;
        SearchType searchType;
        List<SearchItem> orSearchItems;

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        public void setSearchType(SearchType searchType) {
            this.searchType = searchType;
        }

        public List<SearchItem> getOrSearchItems() {
            return this.orSearchItems;
        }

        public void setOrSearchItems(List<SearchItem> orSearchItems) {
            this.orSearchItems = orSearchItems;
        }
    }

    public static enum SearchType {
        EXACT("exact"),
        ANY("any");

        private String type;

        private SearchType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

