/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.StudyUser;
import edu.harvard.catalyst.scheduler.entity.User;
import java.util.ArrayList;
import java.util.List;

public class UserDataResponse {
    private Integer id;
    private String lastName;
    private String firstName;
    private String title;
    private Long totalCount;
    private Boolean status;

    public static List<UserDataResponse> getStudyUserData(List<StudyUser> userList, Long total) {
        ArrayList<UserDataResponse> result = new ArrayList<UserDataResponse>();
        if (userList != null) {
            for (StudyUser user : userList) {
                UserDataResponse studyDataReportResponse = new UserDataResponse(user, total);
                result.add(studyDataReportResponse);
            }
        }
        return result;
    }

    public static List<UserDataResponse> getUserData(List<User> userList, Long total) {
        ArrayList<UserDataResponse> result = new ArrayList<UserDataResponse>();
        if (userList != null) {
            for (User user : userList) {
                UserDataResponse studyDataReportResponse = new UserDataResponse(user, total);
                result.add(studyDataReportResponse);
            }
        }
        return result;
    }

    public UserDataResponse(User user, Long total) {
        if (user == null) {
            SchedulerRuntimeException.logAndThrow("user parameter should be non-null");
        }
        this.id = user.getId();
        this.lastName = user.getLastName();
        this.firstName = user.getFirstName();
        this.title = user.getInstitutionRole().getName();
        this.status = user.getActive();
        this.totalCount = total;
    }

    public UserDataResponse(StudyUser user, Long total) {
        if (user == null) {
            SchedulerRuntimeException.logAndThrow("StudyUser parameter should be non-null");
        }
        this.id = user.getId();
        this.lastName = user.getUser().getLastName();
        this.firstName = user.getUser().getFirstName();
        this.title = user.getUser().getInstitutionRole().getName();
        this.status = user.getActive();
        this.totalCount = total;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public long getTotalCount() {
        return this.totalCount;
    }
}

