/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtoNurseReportDTO
implements CsvAbleDTO {
    private Integer nurseId;
    private String firstName;
    private String middleName;
    private String lastName;
    private String name;
    private String spid;
    private String catalystId;
    private String localId;
    private String studyStatusName;
    private String irb;
    private Date irbExpiration;

    public ProtoNurseReportDTO() {
    }

    public ProtoNurseReportDTO(Integer nurseId, String firstName, String middleName, String lastName, String name, String spid, String catalystId, String localId, String studyStatusName, String irb, Date irbExpiration) {
        this.nurseId = nurseId;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.name = name;
        this.spid = spid;
        this.catalystId = catalystId;
        this.localId = localId;
        this.studyStatusName = studyStatusName;
        this.irb = irb;
        this.irbExpiration = irbExpiration;
    }

    @Deprecated
    public static ProtoNurseReportDTO fromArray(Object[] bagOfFields) {
        return new ProtoNurseReportDTO((Integer)bagOfFields[0], (String)bagOfFields[1], (String)bagOfFields[2], (String)bagOfFields[3], (String)bagOfFields[4], (String)bagOfFields[5], (String)bagOfFields[6], (String)bagOfFields[7], (String)bagOfFields[8], (String)bagOfFields[9], (Date)bagOfFields[10]);
    }

    public Integer getNurseId() {
        return this.nurseId;
    }

    public void setNurseId(Integer nurseId) {
        this.nurseId = nurseId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpid() {
        return this.spid;
    }

    public void setSpid(String spid) {
        this.spid = spid;
    }

    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getStudyStatusName() {
        return this.studyStatusName;
    }

    public void setStudyStatusName(String studyStatusName) {
        this.studyStatusName = studyStatusName;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public Date getIrbExpiration() {
        return this.irbExpiration;
    }

    public void setIrbExpiration(Date irbExpiration) {
        this.irbExpiration = irbExpiration;
    }

    @Override
    public String toCsvHeaders() {
        return "Full Name,Study Name,Catalyst ID,Local Id,Study Status,IRB #,IRB Expiration";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousNurseId = -1;
        for (Object object : dtoList) {
            ProtoNurseReportDTO d = (ProtoNurseReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentNurseId = d.getNurseId();
            if (currentNurseId != previousNurseId) {
                if (previousNurseId != -1) {
                    result.add(" \n");
                }
                result.add(this.toCsvHeaders() + "\n");
                columns.add(MiscUtil.q(MiscUtil.fullName(d.firstName, d.middleName, d.lastName)));
                previousNurseId = currentNurseId;
            } else {
                columns.add("");
            }
            columns.add(MiscUtil.q(d.name));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.studyStatusName));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.showDate(d.irbExpiration)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

