/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.persistence.TemplateResourceDAO;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;

public class TemplateResourceDTO
extends BooleanResultDTO {
    private Integer id;
    private Integer visitTemplate;
    private Integer resource;
    private Boolean billable;
    private Boolean alternate;
    private Date createdDate;
    private Integer duration;
    private Integer floatStart;
    private Integer floatEnd;
    private String floatable;
    private String flexible;
    private Integer startMinutes;
    private Integer endMinutes;
    private List<Integer> selectedAnnotations;
    private List<String> selectedAnnotationsComment;
    private List<Integer> selectedAnnotationsQuantity;
    public static final String NO_CHANGE = "No Change";

    public TemplateResourceDTO() {
    }

    public TemplateResourceDTO(TemplateResource tr, TemplateResourceDAO templateResourceDAO) {
        this.id = tr.getId();
        this.visitTemplate = tr.getVisitTemplate().getId();
        this.resource = tr.getResource().getId();
        this.billable = tr.getBillable();
        this.alternate = tr.getAlternate();
        this.floatStart = tr.getFloatStart();
        this.floatEnd = tr.getFloatEnd();
        this.floatable = tr.getFloatable() != false ? "true" : "false";
        this.flexible = tr.getFlexible() != false ? "true" : "false";
        this.startMinutes = tr.getStartMinutes();
        this.endMinutes = tr.getEndMinutes();
        this.selectedAnnotations = Lists.newArrayList();
        this.selectedAnnotationsComment = Lists.newArrayList();
        this.selectedAnnotationsQuantity = Lists.newArrayList();
        List<TemplateResourceAnnotations> traList = templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(tr);
        traList.forEach(tra -> {
            this.selectedAnnotations.add(tra.getLineLevelAnnotations().getId());
            this.selectedAnnotationsComment.add(tra.getComment());
            this.selectedAnnotationsQuantity.add(tra.getQuantity());
        });
    }

    void appendIfDifferent(StringBuilder builder, String label, Object from, Object to) {
        if (from == null && to != null) {
            builder.append("{").append(label).append(": ").append("null").append(" --> ").append(to).append("}");
        } else if (from != null && !from.equals(to)) {
            builder.append("{").append(label).append(": ").append(from).append(" --> ").append(to).append("}");
        }
    }

    public String diffFromThisToOther(TemplateResourceDTO other) {
        StringBuilder diffBuilder = new StringBuilder();
        this.appendIfDifferent(diffBuilder, "id", this.id, other.id);
        this.appendIfDifferent(diffBuilder, "visitTemplate", this.visitTemplate, other.visitTemplate);
        this.appendIfDifferent(diffBuilder, "resource", this.resource, other.resource);
        this.appendIfDifferent(diffBuilder, "billable", this.billable, other.billable);
        this.appendIfDifferent(diffBuilder, "alternate", this.alternate, other.alternate);
        this.appendIfDifferent(diffBuilder, "floatStart", this.floatStart, other.floatStart);
        this.appendIfDifferent(diffBuilder, "floatEnd", this.floatEnd, other.floatEnd);
        this.appendIfDifferent(diffBuilder, "floatable", this.floatable, other.floatable);
        this.appendIfDifferent(diffBuilder, "flexible", this.flexible, other.flexible);
        this.appendIfDifferent(diffBuilder, "startMinutes", this.startMinutes, other.startMinutes);
        this.appendIfDifferent(diffBuilder, "endMinutes", this.endMinutes, other.endMinutes);
        this.appendIfDifferent(diffBuilder, "annotations", this.canonicalInfoLla(), other.canonicalInfoLla());
        String builderResult = diffBuilder.toString();
        return builderResult.isEmpty() ? NO_CHANGE : builderResult;
    }

    String canonicalInfoLla() {
        TreeSet canonicalStringSet = Sets.newTreeSet();
        for (int i = 0; i < this.selectedAnnotations.size(); ++i) {
            String info = "{" + "id: " + this.selectedAnnotations.get(i) + ". comment: " + this.selectedAnnotationsComment.get(i) + ". quantity: " + this.selectedAnnotationsQuantity.get(i) + "}";
            canonicalStringSet.add(info);
        }
        return Joiner.on((String)",").join((Iterable)canonicalStringSet);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVisitTemplate() {
        return this.visitTemplate;
    }

    public void setVisitTemplate(int visitTemplate) {
        this.visitTemplate = visitTemplate;
    }

    public int getResource() {
        return this.resource;
    }

    public void setResource(int resource) {
        this.resource = resource;
    }

    public boolean isBillable() {
        return this.billable;
    }

    public void setBillable(boolean billable) {
        this.billable = billable;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setAlternate(boolean alternate) {
        this.alternate = alternate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getFloatable() {
        return this.floatable;
    }

    public void setFloatable(String floatable) {
        this.floatable = floatable;
    }

    public String getFlexible() {
        return this.flexible;
    }

    public void setFlexible(String flexible) {
        this.flexible = flexible;
    }

    public List<Integer> getSelectedAnnotations() {
        return this.selectedAnnotations == null ? Lists.newArrayList() : this.selectedAnnotations;
    }

    public List<Integer> getSelectedAnnotationsQuantity() {
        return this.selectedAnnotationsQuantity == null ? Lists.newArrayList() : this.selectedAnnotationsQuantity;
    }

    public List<String> getSelectedAnnotationsComment() {
        return this.selectedAnnotationsComment == null ? Lists.newArrayList() : this.selectedAnnotationsComment;
    }

    public boolean isFlexible() {
        return this.getFlexible() != null && this.getFlexible().equalsIgnoreCase("true");
    }

    public boolean isFloatable() {
        return this.getFloatable() != null && this.getFloatable().equalsIgnoreCase("true");
    }

    public Integer getFloatStart() {
        return this.floatStart;
    }

    public Integer getFloatEnd() {
        return this.floatEnd;
    }

    public void setFloatStart(Integer floatStart) {
        this.floatStart = floatStart;
    }

    public void setFloatEnd(Integer floatEnd) {
        this.floatEnd = floatEnd;
    }

    public void setStartMinutes(Integer startMinutes) {
        this.startMinutes = startMinutes;
    }

    public Integer getStartMinutes() {
        return this.startMinutes;
    }

    public Integer getEndMinutes() {
        return this.endMinutes;
    }

    public void setEndMinutes(Integer endMinutes) {
        this.endMinutes = endMinutes;
    }

    public void setSelectedAnnotations(List<Integer> selectedAnnotations) {
        this.selectedAnnotations = selectedAnnotations;
    }

    public void setSelectedAnnotationsComment(List<String> selectedAnnotationsComment) {
        this.selectedAnnotationsComment = selectedAnnotationsComment;
    }

    public void setSelectedAnnotationsQuantity(List<Integer> selectedAnnotationsQuantity) {
        this.selectedAnnotationsQuantity = selectedAnnotationsQuantity;
    }

    public boolean matches(TemplateResource tr) {
        boolean changed = false;
        changed = changed || this.isAlternate() != tr.getAlternate();
        changed = changed || this.isBillable() != tr.getBillable();
        changed = changed || this.isFlexible() != tr.getFlexible().booleanValue();
        changed = changed || this.isFloatable() != tr.getFloatable().booleanValue();
        changed = changed || tr.getStartMinutes() != null && this.getStartMinutes().intValue() != tr.getStartMinutes().intValue();
        changed = changed || tr.getEndMinutes() != null && this.getEndMinutes().intValue() != tr.getEndMinutes().intValue();
        changed = changed || tr.getFloatStart() != null && this.getFloatStart().intValue() != tr.getFloatStart().intValue();
        changed = changed || tr.getFloatEnd() != null && this.getFloatEnd().intValue() != tr.getFloatEnd().intValue();
        return !changed;
    }
}

