/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.metadata;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xml.XMLObject;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.util.Assert;

public abstract class AbstractMetadataDelegate
implements ObservableMetadataProvider {
    private MetadataProvider delegate;
    List<ObservableMetadataProvider.Observer> observers;

    public AbstractMetadataDelegate(MetadataProvider delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate can't be null");
        this.delegate = delegate;
        this.observers = delegate instanceof ObservableMetadataProvider ? ((ObservableMetadataProvider)delegate).getObservers() : new LinkedList<ObservableMetadataProvider.Observer>();
    }

    public boolean requireValidMetadata() {
        return this.delegate.requireValidMetadata();
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        this.delegate.setRequireValidMetadata(requireValidMetadata);
    }

    public MetadataFilter getMetadataFilter() {
        return this.delegate.getMetadataFilter();
    }

    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        this.delegate.setMetadataFilter(newFilter);
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        return this.delegate.getMetadata();
    }

    public EntitiesDescriptor getEntitiesDescriptor(String name) throws MetadataProviderException {
        return this.delegate.getEntitiesDescriptor(name);
    }

    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        return this.delegate.getEntityDescriptor(entityID);
    }

    public List<RoleDescriptor> getRole(String entityID, QName roleName) throws MetadataProviderException {
        return this.delegate.getRole(entityID, roleName);
    }

    public RoleDescriptor getRole(String entityID, QName roleName, String supportedProtocol) throws MetadataProviderException {
        return this.delegate.getRole(entityID, roleName, supportedProtocol);
    }

    public List<ObservableMetadataProvider.Observer> getObservers() {
        return this.observers;
    }

    public MetadataProvider getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtendedMetadataDelegate) {
            ExtendedMetadataDelegate del = (ExtendedMetadataDelegate)obj;
            return this.delegate.equals(del.getDelegate());
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

