/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.DailyOverviewReportDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class NursingAndRoomDailyOverviewReportDTO
extends DailyOverviewReportDTO {
    @Override
    public String toCsvHeaders() {
        return "Visit Start Time, Visit End Time, Subject Name, MRN, Local ID, Visit Name, Visit Type, Resource Name,Is part of the Visit Off Unit?, Clipboard, Setup, Check-In, Check-Out,Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            NursingAndRoomDailyOverviewReportDTO d = (NursingAndRoomDailyOverviewReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.firstName, d.middleName, d.lastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(d.offInstitution));
            columns.add("");
            columns.add("");
            columns.add("");
            columns.add("");
            columns.add(MiscUtil.q(d.comment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

