/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.LazyList;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Range;
import edu.harvard.catalyst.scheduler.dto.VisitSpecsDTO;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.TimeBoundedIdentity;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.persistence.SearchAlgorithmDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.persistence.TemplateResourceDAO;
import edu.harvard.catalyst.scheduler.service.PermutationGenerator;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchAlgorithmService {
    static final int INCREMENT_FACTOR = 30;
    private final SearchAlgorithmDAO searchAlgorithmDAO;
    private final ResourceDAO resourceDAO;
    private final StudyDAO studyDAO;
    private final SubjectDAO subjectDAO;
    private final TemplateResourceDAO templateResourceDAO;
    static final Comparator<BookedResource> resourceTimeComparator = (o1, o2) -> {
        int startOrder = o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
        if (startOrder != 0) {
            return startOrder;
        }
        return o1.getScheduledEndTime().compareTo(o2.getScheduledEndTime());
    };
    static final Comparator<BookedVisit> visitStartTimeComparator = (o1, o2) -> o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());

    @Autowired
    public SearchAlgorithmService(SearchAlgorithmDAO searchAlgorithmDAO, ResourceDAO resourceDAO, StudyDAO studyDAO, SubjectDAO subjectDAO, TemplateResourceDAO templateResourceDAO) {
        this.searchAlgorithmDAO = searchAlgorithmDAO;
        this.resourceDAO = resourceDAO;
        this.studyDAO = studyDAO;
        this.subjectDAO = subjectDAO;
        this.templateResourceDAO = templateResourceDAO;
    }

    SearchAlgorithmService() {
        this(null, null, null, null, null);
    }

    void setBookedVisits(boolean confirmEvent, boolean rejectedCheck, User user, List<BookedVisit> candidateVisits) {
        if (!rejectedCheck && confirmEvent) {
            user.setBookedVisits(candidateVisits);
        } else if (user.getBookedVisits() != null) {
            user.getBookedVisits().addAll(candidateVisits);
        } else {
            user.setBookedVisits(candidateVisits);
        }
    }

    void sortCandidateVisits(boolean rejectedCheck, List<BookedVisit> candidateVisits) {
        if (rejectedCheck) {
            List<BookedResource> bookedResourceList = candidateVisits.get(0).getBookedResourceList();
            Collections.sort(bookedResourceList, resourceTimeComparator);
        } else {
            Collections.sort(candidateVisits, visitStartTimeComparator);
        }
    }

    public List<BookedVisit> findCandidateVisits(VisitSpecsDTO visitSpecsDTO, UserSession userSession, boolean confirmEvent, boolean rejectedCheck, boolean isInpatient) {
        VisitTemplate selectedVisit = this.studyDAO.findVisitTemplateById(visitSpecsDTO.getVisit());
        Integer visitDurationInMin = selectedVisit.getDuration();
        assert (visitDurationInMin != null);
        SubjectMrn selectedSubjectMrn = this.subjectDAO.findSubjectMrnById(visitSpecsDTO.getSubjectMrnId());
        User user = userSession.getUser();
        Date startDate = new Date(visitSpecsDTO.getStartDate());
        Date endDate = new Date(visitSpecsDTO.getEndDate());
        List<BookedVisit> candidateVisits = this.findCandidateVisits(confirmEvent, rejectedCheck, isInpatient, selectedSubjectMrn, selectedVisit, startDate, endDate);
        this.setBookedVisits(confirmEvent, rejectedCheck, user, candidateVisits);
        this.sortCandidateVisits(rejectedCheck, candidateVisits);
        return candidateVisits;
    }

    boolean isDurationLessThan24Hours(boolean confirmEvent, boolean rejectedCheck, int visitDurationInMin) {
        return confirmEvent || rejectedCheck || visitDurationInMin < 1440;
    }

    List<Date> setupSearchDates(boolean confirmEvent, boolean rejectedCheck, boolean isInpatient, VisitTemplate selectedVisit, Date startDate, Date endDate) {
        List<Object> searchDates;
        int visitDurationInMin = selectedVisit.getDuration();
        if (isInpatient && this.isRelativeTimeTemplate(isInpatient, selectedVisit) && this.isDurationLessThan24Hours(confirmEvent, rejectedCheck, visitDurationInMin)) {
            searchDates = Lists.newArrayList();
            searchDates.add(startDate);
        } else {
            searchDates = !confirmEvent && !rejectedCheck ? DateUtility.dateInterval(startDate, endDate) : DateUtility.dateInterval(startDate, startDate);
        }
        return searchDates;
    }

    public List<BookedVisit> findCandidateVisits(boolean confirmEvent, boolean rejectedCheck, boolean isInpatient, SubjectMrn selectedSubjectMrn, VisitTemplate selectedVisit, Date startDate, Date endDate) {
        List<Date> searchDates = this.setupSearchDates(confirmEvent, rejectedCheck, isInpatient, selectedVisit, startDate, endDate);
        return this.findCandidateVisits(searchDates, startDate, endDate, selectedSubjectMrn, selectedVisit, rejectedCheck, confirmEvent, isInpatient);
    }

    boolean isRelativeTimeTemplate(boolean isInpatient, VisitTemplate selectedVisit) {
        return selectedVisit.getRelativeTime() != null && selectedVisit.getRelativeTime() != false || !isInpatient;
    }

    Map<String, List<TemplateResource>> retrieveFloatResourceList(VisitTemplate visitTemplate) {
        List<TemplateResource> floatTrList = this.searchAlgorithmDAO.getSingleFloatTemplateResources(visitTemplate);
        LinkedHashMap floatResourcesMap = Maps.newLinkedHashMap();
        if (MiscUtil.isNonNullNonEmpty(floatTrList)) {
            for (TemplateResource ftr : floatTrList) {
                String groupKey = ftr.getId().toString();
                List floatResources = floatResourcesMap.containsKey(groupKey) ? (List)floatResourcesMap.get(groupKey) : Lists.newArrayList();
                floatResources.add(ftr);
                floatResourcesMap.put(groupKey, floatResources);
            }
        }
        return floatResourcesMap;
    }

    Map<String, List<TemplateResource>> getGroupedResourceListMap(List<TemplateResourceGroup> resourceGroupList) {
        LinkedHashMap groupedResourceMap = Maps.newLinkedHashMap();
        if (MiscUtil.isNonNullNonEmpty(resourceGroupList)) {
            for (TemplateResourceGroup trg : resourceGroupList) {
                String groupKey = trg.getGroupId();
                List grpResources = groupedResourceMap.containsKey(groupKey) ? (List)groupedResourceMap.get(groupKey) : Lists.newArrayList();
                grpResources.add(trg.getTemplateResource());
                groupedResourceMap.put(groupKey, grpResources);
            }
        }
        return groupedResourceMap;
    }

    Map<String, List<TemplateResource>> retrieveGroupedResourceList(VisitTemplate visitTemplate, boolean flexVsFloat) {
        List<TemplateResourceGroup> groupedResourceList = this.searchAlgorithmDAO.getTemplateResourceGroups(visitTemplate, flexVsFloat);
        return this.getGroupedResourceListMap(groupedResourceList);
    }

    int findMaxEndMinuteRelativeToSearchDate(Date endDate, boolean rejectedCheck, boolean confirmEvent, boolean isInpatient, int visitDurationInMin, int startDateMinuteOfDay, int endDateMinuteOfDay, Date searchDate) {
        int candidateResult = endDateMinuteOfDay;
        if (isInpatient) {
            candidateResult = DateUtility.deltaMinutesBetweenDate1Date2(searchDate, endDate);
            if (this.isDurationLessThan24Hours(confirmEvent, rejectedCheck, visitDurationInMin)) {
                candidateResult += startDateMinuteOfDay;
            }
        }
        return candidateResult;
    }

    List<BookedVisit> findCandidateVisits(List<Date> searchDates, Date startDate, Date endDate, SubjectMrn subjectMrn, VisitTemplate visitTemplate, boolean rejectedCheck, boolean confirmEvent, boolean isInpatient) {
        boolean isRelativeTime = this.isRelativeTimeTemplate(isInpatient, visitTemplate);
        ArrayList candidateVisits = Lists.newArrayList();
        int visitDurationInMin = visitTemplate.getDuration();
        int startDateMinuteOfDay = startDate.getHours() * 60 + startDate.getMinutes();
        int endDateMinuteOfDay = endDate.getHours() * 60 + endDate.getMinutes();
        List<TemplateResource> fixedResources = this.templateResourceDAO.findFixedTemplateResourcesByVisit(visitTemplate);
        Map<String, List<TemplateResource>> floatTrList = this.retrieveFloatResourceList(visitTemplate);
        Map<String, List<TemplateResource>> floatResourceGroupList = this.retrieveGroupedResourceList(visitTemplate, false);
        Map<String, List<TemplateResource>> flexResourceGroupList = this.retrieveGroupedResourceList(visitTemplate, true);
        for (Date searchDate : searchDates) {
            if (isRelativeTime) {
                int maxPossibleEndMinute = this.findMaxEndMinuteRelativeToSearchDate(endDate, rejectedCheck, confirmEvent, isInpatient, visitDurationInMin, startDateMinuteOfDay, endDateMinuteOfDay, searchDate);
                this.calculateAvailableVisitTimeSlotRelative(startDateMinuteOfDay, maxPossibleEndMinute, visitTemplate, subjectMrn, searchDate, candidateVisits, fixedResources, floatTrList, floatResourceGroupList, flexResourceGroupList, rejectedCheck);
                continue;
            }
            this.calculateAvailableVisitTimeSlotClockTime(visitTemplate, subjectMrn, searchDate, endDate, candidateVisits, fixedResources, floatTrList, floatResourceGroupList, flexResourceGroupList, rejectedCheck);
        }
        return candidateVisits;
    }

    boolean isStartPlusDurationLteEnd(int visitTimeSlotEnd, int floatStart, int resourceDurationTimeInMin) {
        return floatStart + resourceDurationTimeInMin <= visitTimeSlotEnd;
    }

    BookedVisit initializeBookedVisit(VisitTemplate visitTemplate, int visitTimeSlotStart, int visitDurationInMin, Date searchDate) {
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setId(1234556);
        bookedVisit.setName(visitTemplate.getName());
        bookedVisit.setStudy(visitTemplate.getStudy());
        bookedVisit.setVisitTemplate(visitTemplate);
        bookedVisit.setVisitType(visitTemplate.getVisitType());
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, MiscUtil.divideByMinsPerHour(visitTimeSlotStart), MiscUtil.moduloMinsPerHour(visitTimeSlotStart));
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, MiscUtil.divideByMinsPerHour(visitTimeSlotStart + visitDurationInMin), MiscUtil.moduloMinsPerHour(visitTimeSlotStart + visitDurationInMin));
        bookedVisit.setScheduledStartTime(startTime);
        bookedVisit.setScheduledEndTime(endTime);
        return bookedVisit;
    }

    void calculateAvailableVisitTimeSlotRelative(int startTimeInMin, int endTimeInMin, VisitTemplate visitTemplate, SubjectMrn subjectMrn, Date searchDate, List<BookedVisit> candidateVisits, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatTrList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, boolean rejectedCheck) {
        int visitDurationInMin = visitTemplate.getDuration();
        int visitTimeSlotStart = startTimeInMin;
        while (this.isStartPlusDurationLteEnd(endTimeInMin, visitTimeSlotStart, visitDurationInMin)) {
            BookedVisit bookedVisit = this.initializeBookedVisit(visitTemplate, visitTimeSlotStart, visitDurationInMin, searchDate);
            bookedVisit.setSubjectMrn(subjectMrn);
            String uniqueKey = RandomStringUtils.randomNumeric((int)8);
            bookedVisit.setUniquekey(uniqueKey);
            this.calculateSomeAvailableResources(visitDurationInMin, searchDate, candidateVisits, fixedResources, floatTrList, floatResourceGroups, flipResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck);
            visitTimeSlotStart += 30;
        }
    }

    void computeAndSetDuration(TemplateResource templateResource) {
        if (templateResource != null) {
            int totalMinutesDelta = 0;
            Date startDate = templateResource.getStartDate();
            Date endDate = templateResource.getEndDate();
            if (startDate != null && endDate != null) {
                int daysDelta = this.getTemplateResourceDay(endDate) - this.getTemplateResourceDay(startDate);
                int hoursDelta = endDate.getHours() - startDate.getHours();
                int minutesDelta = endDate.getMinutes() - startDate.getMinutes();
                totalMinutesDelta = daysDelta * 1440 + hoursDelta * 60 + minutesDelta;
            }
            templateResource.setDuration(totalMinutesDelta);
        }
    }

    void allocateTimeFixedResources(int visitTimeSlotStart, Date searchDate, List<TemplateResource> fixedResources, String groupType) {
        for (TemplateResource fixedTr : fixedResources) {
            this.computeAndSetDuration(fixedTr);
            int resourceDurationTimeInMin = fixedTr.getDuration();
            int resourceStartTimeInMin = fixedTr.getStartDate().getHours() * 60 + fixedTr.getStartDate().getMinutes();
            int curResourceStartTimeHr = MiscUtil.divideByMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin);
            int curResourceStartTimeMin = MiscUtil.moduloMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin);
            int curResourceEndTimeHr = MiscUtil.divideByMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin + resourceDurationTimeInMin);
            int curResourceEndTimeMin = MiscUtil.moduloMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin + resourceDurationTimeInMin);
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(fixedTr.getStartDate()) - 1, curResourceStartTimeHr, curResourceStartTimeMin);
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(fixedTr.getStartDate()) - 1, curResourceEndTimeHr, curResourceEndTimeMin);
            fixedTr.setScheduledStartTime(startTime);
            fixedTr.setScheduledEndTime(endTime);
            fixedTr.setResourceGroupType(groupType);
        }
    }

    boolean checkIfSublocationClosed(TemplateResource templateResource) {
        ResourceSublocation resourceSublocation = this.studyDAO.findSublocationByResource(templateResource.getResource());
        boolean isResourceSublocationClosed = this.searchAlgorithmDAO.isSublocationClosed(resourceSublocation.getSublocation(), templateResource.getScheduledStartTime(), templateResource.getScheduledEndTime());
        if (isResourceSublocationClosed) {
            templateResource.setAvailable("No");
            templateResource.setRejectedResourceMessage("Sub-Location Closure");
            return true;
        }
        return false;
    }

    Set<Integer> getDefaultAvailabilityDaysOfWeek(Date startDate, Date endDate) {
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        HashSet daysOfWeek = Sets.newHashSet();
        Range allowedDays = Range.from((int)1).to(7).inclusive();
        for (int count = 0; count <= diff && count < 7; ++count) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(curDate);
            int day = cal.get(7);
            if (!allowedDays.contains(day)) continue;
            daysOfWeek.add(day);
        }
        return daysOfWeek;
    }

    String getDayOfWeekString(ResourceSchedule rs) {
        String ss = null;
        switch (rs.getDayOfWeek()) {
            case 1: {
                ss = "SUN";
                break;
            }
            case 2: {
                ss = "MON";
                break;
            }
            case 3: {
                ss = "TUE";
                break;
            }
            case 4: {
                ss = "WED";
                break;
            }
            case 5: {
                ss = "THU";
                break;
            }
            case 6: {
                ss = "FRI";
                break;
            }
            case 7: {
                ss = "SAT";
            }
        }
        return ss;
    }

    void populateDefaultSchedule(List<ResourceSchedule> rsList, Map<String, List<ResourceSchedule>> dayOfWeekSchedule) {
        for (ResourceSchedule rs : rsList) {
            String resourceDay = this.getDayOfWeekString(rs);
            if (dayOfWeekSchedule.get(resourceDay) == null) {
                ArrayList schedules = new ArrayList();
                dayOfWeekSchedule.put(resourceDay, schedules);
            }
            dayOfWeekSchedule.get(resourceDay).add(rs);
        }
    }

    Map<String, List<ResourceSchedule>> retrieveResourceDefaultSchedule(Resource resource, Date startDate, Date endDate) {
        HashMap<String, List<ResourceSchedule>> dayOfWeekSchedule = new HashMap<String, List<ResourceSchedule>>();
        Set<Integer> selectedDaysOfWeek = this.getDefaultAvailabilityDaysOfWeek(startDate, endDate);
        ArrayList<Integer> daysOfWeekList = new ArrayList<Integer>(selectedDaysOfWeek);
        List<ResourceSchedule> rsl = this.resourceDAO.findResourceScheduleByResource(resource, daysOfWeekList, false);
        if (MiscUtil.isNonNullNonEmpty(rsl)) {
            this.populateDefaultSchedule(rsl, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    void searchDatesMapping(Map<Date, String> searchDates, Calendar cal, Date curDate) {
        cal.clear();
        cal.setTime(curDate);
        int day = cal.get(7);
        String dayOfWeek = null;
        switch (day) {
            case 1: {
                dayOfWeek = "SUN";
                break;
            }
            case 2: {
                dayOfWeek = "MON";
                break;
            }
            case 3: {
                dayOfWeek = "TUE";
                break;
            }
            case 4: {
                dayOfWeek = "WED";
                break;
            }
            case 5: {
                dayOfWeek = "THU";
                break;
            }
            case 6: {
                dayOfWeek = "FRI";
                break;
            }
            case 7: {
                dayOfWeek = "SAT";
            }
        }
        searchDates.put(curDate, dayOfWeek);
    }

    Map<Date, String> buildSearchDates(Date startDate, Date endDate) {
        TreeMap<Date, String> searchDates = new TreeMap<Date, String>();
        Calendar cal = Calendar.getInstance();
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        if (diff == 0) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, 0, 0, 0);
            this.searchDatesMapping(searchDates, cal, curDate);
        } else if (diff > 0) {
            for (int count = 0; count <= diff; ++count) {
                Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
                this.searchDatesMapping(searchDates, cal, curDate);
            }
        }
        return searchDates;
    }

    Map<Date, String> retrieveDaysOfWeek(Date startDate, Date endDate) {
        return this.buildSearchDates(startDate, endDate);
    }

    TreeMap<Date, List<ResourceSchedule>> loadRelevantDaysOfDefaultSchedule(Date firstDay, Date lastDay, Map<String, List<ResourceSchedule>> resourceDefaultSchedule) {
        TreeMap<Date, List<ResourceSchedule>> result = new TreeMap<Date, List<ResourceSchedule>>();
        Date last_day = DateUtility.nextDay(lastDay);
        Map<Date, String> dateToWeekdayMap = this.retrieveDaysOfWeek(firstDay, last_day);
        for (Map.Entry<Date, String> mapEntry : dateToWeekdayMap.entrySet()) {
            Date date = mapEntry.getKey();
            String weekDay = mapEntry.getValue();
            List<ResourceSchedule> todayScheduleList = resourceDefaultSchedule.get(weekDay);
            result.put(date, todayScheduleList);
        }
        return result;
    }

    int computeDate2PeriodRelativeToDate1(Date date1, Date date2) {
        int numberOfDays = DateUtility.day2minusDay1(date1, date2);
        return numberOfDays * 96 + this.computePeriodOfDate(date2);
    }

    int computeLastPeriod(Date date1, Date date2) {
        int period1 = this.computePeriodOfDate(date1);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        int offset = calendar1.get(16);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar2.set(16, offset);
        long differenceInMillis = calendar2.getTimeInMillis() - calendar1.getTimeInMillis() - 60000L;
        int diffInPeriods = (int)Math.ceil(differenceInMillis / 60000L / 15L);
        return period1 + diffInPeriods;
    }

    int computePeriodOfDate(Date date) {
        int minutes = this.computeMinutesFromHrsAndMins(date);
        return minutes / 15;
    }

    int computeMinutesFromHrsAndMins(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int timeHr = cal.get(11);
        int timeMin = cal.get(12);
        return timeHr * 60 + timeMin;
    }

    void loadIntoPeriodToQuantityMap(int resourceQuantity, int firstPeriod, int lastPeriod, Map<Integer, Integer> periodToQuantityMap) {
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer previousQuantity = periodToQuantityMap.get(i);
            if (previousQuantity == null) {
                previousQuantity = 0;
            }
            periodToQuantityMap.put(i, previousQuantity + resourceQuantity);
        }
    }

    Map<Integer, Integer> loadPeriodToQuantityOverrideMap(TemplateResource requestResource, List<ResourceSchedule> resourceOverrideSchedule) {
        TreeMap<Integer, Integer> periodToQuantityOverrideMap = new TreeMap<Integer, Integer>();
        Date baseDate = requestResource.getScheduledStartTime();
        if (!resourceOverrideSchedule.isEmpty()) {
            List<TimeBoundedIdentity> overrideScheduleList = ResourceSchedule.toTimeBoundedIdentityList(resourceOverrideSchedule);
            for (TimeBoundedIdentity overrideSchedule : overrideScheduleList) {
                Date startTimeDate = overrideSchedule.getStartTime();
                Date endTimeDate = overrideSchedule.getEndTime();
                int firstPeriod = this.computeDate2PeriodRelativeToDate1(baseDate, startTimeDate);
                int lastPeriod = this.computeLastPeriod(baseDate, endTimeDate);
                this.loadIntoPeriodToQuantityMap(overrideSchedule.getQuantity(), firstPeriod, lastPeriod, periodToQuantityOverrideMap);
            }
        }
        return periodToQuantityOverrideMap;
    }

    void loadResourceScheduleIntoPeriodToQuantityMap(ResourceSchedule resourceSchedule, Map<Integer, Integer> periodToQuantityMap, int dayNumber) {
        if (periodToQuantityMap == null) {
            return;
        }
        Date scheduledStartTime = resourceSchedule.getStartTime();
        Date scheduledEndTime = resourceSchedule.getEndTime();
        int periodsOffset = dayNumber * 96;
        int firstPeriod = this.computePeriodOfDate(scheduledStartTime);
        int lastPeriod = this.computeLastPeriod(scheduledStartTime, scheduledEndTime);
        Integer resourceQuantity = resourceSchedule.getQuantity();
        this.loadIntoPeriodToQuantityMap(resourceQuantity, firstPeriod += periodsOffset, lastPeriod += periodsOffset, periodToQuantityMap);
    }

    Map<Integer, Integer> loadPeriodToQuantityDefaultScheduleMap(TreeMap<Date, List<ResourceSchedule>> defaultScheduleMap) {
        TreeMap<Integer, Integer> periodToQuantityDefaultAvailableMap = new TreeMap<Integer, Integer>();
        if (!defaultScheduleMap.isEmpty()) {
            int dayNumber = -1;
            for (Date date : defaultScheduleMap.navigableKeySet()) {
                List<ResourceSchedule> scheduleList = defaultScheduleMap.get(date);
                ++dayNumber;
                if (scheduleList == null) continue;
                for (ResourceSchedule schedule : scheduleList) {
                    this.loadResourceScheduleIntoPeriodToQuantityMap(schedule, periodToQuantityDefaultAvailableMap, dayNumber);
                }
            }
        }
        return periodToQuantityDefaultAvailableMap;
    }

    Map<Integer, Integer> updateDefaultMapWithOverrideMap(Map<Integer, Integer> periodToQuantityOverrideMap, Map<Integer, Integer> periodToQuantityDefaultAvailableMap) {
        TreeMap<Integer, Integer> finalScheduleTreeMap = new TreeMap<Integer, Integer>();
        finalScheduleTreeMap.putAll(periodToQuantityDefaultAvailableMap);
        for (Integer key : periodToQuantityOverrideMap.keySet()) {
            Integer value = periodToQuantityOverrideMap.get(key);
            finalScheduleTreeMap.put(key, value);
        }
        return finalScheduleTreeMap;
    }

    boolean isBookedResourceEqualToTemplateResourceId(Resource candidateTemplateResource, Resource resource) {
        return resource.getId().equals(candidateTemplateResource.getId());
    }

    boolean ifDatesOverlap(Date candidateStartTime, Date candidateEndTime, Date existingStartTime, Date existingEndTime) {
        if (existingStartTime != null && existingEndTime != null) {
            return candidateStartTime.getTime() < existingEndTime.getTime() && existingStartTime.getTime() < candidateEndTime.getTime();
        }
        return false;
    }

    void adjustMapsForBookedResources(Map<Integer, Integer> candidatePeriodToQtyMap, Date reservedStartDate, Date reservedEndDate, Date candidateStartDate) {
        int mapIndexOffset;
        Date dateOfFirstCandidatePeriodToUpdate;
        int reserveDayMinusCandidateDay = DateUtility.day2minusDay1(candidateStartDate, reservedStartDate);
        if (reserveDayMinusCandidateDay < 0) {
            dateOfFirstCandidatePeriodToUpdate = candidateStartDate;
            mapIndexOffset = 0;
        } else {
            dateOfFirstCandidatePeriodToUpdate = reservedStartDate;
            mapIndexOffset = reserveDayMinusCandidateDay * 96;
        }
        int firstPeriod = this.computePeriodOfDate(dateOfFirstCandidatePeriodToUpdate);
        int lastPeriod = this.computeLastPeriod(dateOfFirstCandidatePeriodToUpdate, reservedEndDate);
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            int effectiveIndex = i + mapIndexOffset;
            Integer currentQuantity = candidatePeriodToQtyMap.get(effectiveIndex);
            if (currentQuantity == null) continue;
            candidatePeriodToQtyMap.put(effectiveIndex, currentQuantity - 1);
        }
    }

    void adjustMapsForBookedResource(TemplateResource candidateTemplateResource, Map<Integer, Integer> candidatePeriodToQtyMap, List<BookedResource> availableBookedResourceSlots) {
        for (BookedResource bookedResource : availableBookedResourceSlots) {
            Date reservedStartDate = bookedResource.getScheduledStartTime();
            Date reservedEndDate = bookedResource.getScheduledEndTime();
            Date candidateStartDate = candidateTemplateResource.getScheduledStartTime();
            Date candidateEndDate = candidateTemplateResource.getScheduledEndTime();
            if (!this.isBookedResourceEqualToTemplateResourceId(candidateTemplateResource.getResource(), bookedResource.getResource()) || !this.ifDatesOverlap(candidateStartDate, candidateEndDate, reservedStartDate, reservedEndDate)) continue;
            this.adjustMapsForBookedResources(candidatePeriodToQtyMap, reservedStartDate, reservedEndDate, candidateStartDate);
        }
    }

    void adjustMapsForProvisionalAllocation(int key, Map<Integer, Integer> candidatePeriodToQtyMap) {
        if (candidatePeriodToQtyMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyMap.get(key) - 1;
            candidatePeriodToQtyMap.put(key, quantity);
        }
    }

    boolean setMessageIfUnavailable(int key, Integer currentQuantity, TemplateResource candidateTemplateResource, Map<Integer, Integer> candidatePeriodToQtyOverrideMap, Map<Integer, Integer> candidatePeriodToQtyDefaultMap, boolean isAvailable) {
        if (currentQuantity == null) {
            candidateTemplateResource.setRejectedResourceMessage("No Default Availability Entry Found");
            isAvailable = false;
        } else if (currentQuantity < 1 && candidatePeriodToQtyOverrideMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyOverrideMap.get(key);
            candidateTemplateResource.setRejectedResourceMessage("Temporary Adjustment - Quantity (" + quantity + ") Exhausted");
            isAvailable = false;
        } else if (currentQuantity < 1 && candidatePeriodToQtyDefaultMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyDefaultMap.get(key);
            candidateTemplateResource.setRejectedResourceMessage("Default Availability - Quantity (" + quantity + ") Exhausted");
            isAvailable = false;
        }
        return isAvailable;
    }

    boolean isResourceTimeSlotAvailable(TemplateResource candidateTemplateResource, List<BookedResource> reservedResourceTimeList, Map<Integer, Integer> candidatePeriodToQtyMap, Map<Integer, Integer> candidatePeriodToQtyOverrideMap, Map<Integer, Integer> candidatePeriodToQtyDefaultMap, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        boolean isAvailable = true;
        this.adjustMapsForBookedResource(candidateTemplateResource, candidatePeriodToQtyMap, reservedResourceTimeList);
        if (availableBookedResourceSlots != null) {
            this.adjustMapsForBookedResource(candidateTemplateResource, candidatePeriodToQtyMap, availableBookedResourceSlots);
        }
        Date candidateStartDate = candidateTemplateResource.getScheduledStartTime();
        Date candidateEndDate = candidateTemplateResource.getScheduledEndTime();
        int firstPeriod = this.computePeriodOfDate(candidateStartDate);
        int lastPeriod = this.computeLastPeriod(candidateStartDate, candidateEndDate);
        if (MiscUtil.isNonNullNonEmpty(availableResourceSlots)) {
            for (TemplateResource templateResource : availableResourceSlots) {
                if (!this.isBookedResourceEqualToTemplateResourceId(candidateTemplateResource.getResource(), templateResource.getResource()) || !this.ifDatesOverlap(candidateStartDate, candidateEndDate, templateResource.getScheduledStartTime(), templateResource.getScheduledEndTime())) continue;
                int usedFirstPeriod = this.computePeriodOfDate(templateResource.getScheduledStartTime());
                int usedLastPeriod = this.computeLastPeriod(templateResource.getScheduledStartTime(), templateResource.getScheduledEndTime());
                for (int i = usedFirstPeriod; i <= usedLastPeriod; ++i) {
                    this.adjustMapsForProvisionalAllocation(i, candidatePeriodToQtyMap);
                }
            }
        }
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer currentQuantity = candidatePeriodToQtyMap.get(i);
            isAvailable = this.setMessageIfUnavailable(i, currentQuantity, candidateTemplateResource, candidatePeriodToQtyOverrideMap, candidatePeriodToQtyDefaultMap, isAvailable);
            if (isAvailable) continue;
            return isAvailable;
        }
        return isAvailable;
    }

    boolean checkResourceAvailability(TemplateResource requestResource, List<BookedResource> reservedResourceTimeList, Map<Integer, Integer> periodToQuantityOverrideMap, Map<Integer, Integer> periodToQuantityDefaultAvailableMap, Map<Integer, Integer> finalScheduleTreeMap, List<BookedResource> availableBookedResourceSLots, List<TemplateResource> availableResourceSlots) {
        if (!this.isResourceTimeSlotAvailable(requestResource, reservedResourceTimeList, finalScheduleTreeMap, periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap, availableBookedResourceSLots, availableResourceSlots)) {
            requestResource.setAvailable("No");
            return false;
        }
        return true;
    }

    boolean checkAvailability(TemplateResource requestResource, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        requestResource.setRejectedResourceMessage("");
        requestResource.setAvailable("Yes");
        if (this.checkIfSublocationClosed(requestResource)) {
            return false;
        }
        List<BookedResource> reservedResourceTimeList = this.searchAlgorithmDAO.findOverbookConflictResourcesByVisitStatus(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime());
        Map<String, List<ResourceSchedule>> resourceDefaultSchedule = this.retrieveResourceDefaultSchedule(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime());
        TreeMap<Date, List<ResourceSchedule>> defaultScheduleMap = this.loadRelevantDaysOfDefaultSchedule(requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime(), resourceDefaultSchedule);
        List<ResourceSchedule> resourceOverrideSchedule = this.resourceDAO.findTemporaryAdjustmentsByResource(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime(), true);
        Map<Integer, Integer> periodToQuantityOverrideMap = this.loadPeriodToQuantityOverrideMap(requestResource, resourceOverrideSchedule);
        Map<Integer, Integer> periodToQuantityDefaultAvailableMap = this.loadPeriodToQuantityDefaultScheduleMap(defaultScheduleMap);
        Map<Integer, Integer> finalScheduleTreeMap = this.updateDefaultMapWithOverrideMap(periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap);
        return this.checkResourceAvailability(requestResource, reservedResourceTimeList, periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap, finalScheduleTreeMap, availableBookedResourceSlots, availableResourceSlots);
    }

    List<ResourceAlternate> getResourceAlternates(TemplateResource templateResource) {
        return this.resourceDAO.findResourceAlternates(templateResource.getResource());
    }

    boolean noGroupId(TemplateResource res) {
        return res.getGroupId() == null;
    }

    boolean isFixedResource(TemplateResource templateResource) {
        return templateResource.getFloatable() == false && this.noGroupId(templateResource) && templateResource.getFlexible() == false;
    }

    boolean checkIfReturnResource(TemplateResource templateResource, boolean rejectedCheck, boolean isAvailable, boolean emptyAltList) {
        return isAvailable || rejectedCheck && !templateResource.getAlternate() || rejectedCheck && emptyAltList && this.isFixedResource(templateResource);
    }

    static boolean hasGroupId(TemplateResource r) {
        return r.getGroupId() != null;
    }

    boolean isNotFixedResource(TemplateResource templateResource) {
        return templateResource.getFloatable() != false || SearchAlgorithmService.hasGroupId(templateResource) && templateResource.getFlexible() != false;
    }

    boolean checkIfReturnNull(TemplateResource templateResource, boolean rejectedCheck, boolean emptyAltList) {
        return !rejectedCheck && (!templateResource.getAlternate() || emptyAltList) || rejectedCheck && emptyAltList && this.isNotFixedResource(templateResource);
    }

    TemplateResource createTempResourceSlot(Resource selectedResource, TemplateResource templateResource) {
        TemplateResource slot = templateResource.cloneTemplateResource();
        slot.setResource(selectedResource);
        return slot;
    }

    TemplateResource checkForStandardAlternate(List<ResourceAlternate> resourceAltList, TemplateResource templateResource, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        Function<ResourceAlternate, TemplateResource> toTemplateResource = resourceAlternate -> {
            TemplateResource altResource = this.createTempResourceSlot(resourceAlternate.getAlternateResource(), templateResource);
            altResource.setAlternateResourceUsed(false);
            return altResource;
        };
        Predicate<TemplateResource> isAvailable = tr -> this.checkAvailability((TemplateResource)tr, availableBookedResourceSlots, availableResourceSlots);
        Optional available = LazyList.lazy(resourceAltList).map(toTemplateResource).find(isAvailable);
        return available.map(altResource -> {
            altResource.setAlternateResourceUsed(true);
            altResource.setResourceGroupType(templateResource.getResourceGroupType());
            return altResource;
        }).orElse(null);
    }

    TemplateResource findAvailableResource(TemplateResource templateResource, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        List<ResourceAlternate> resourceAltList;
        boolean isAvailable = this.checkAvailability(templateResource, availableBookedResourceSlots, availableResourceSlots);
        if (this.checkIfReturnResource(templateResource, rejectedCheck, isAvailable, (resourceAltList = this.getResourceAlternates(templateResource)).isEmpty())) {
            return templateResource;
        }
        if (this.checkIfReturnNull(templateResource, rejectedCheck, resourceAltList.isEmpty())) {
            return null;
        }
        TemplateResource altResource = this.checkForStandardAlternate(resourceAltList, templateResource, availableBookedResourceSlots, availableResourceSlots);
        if (altResource != null && altResource.getAlternateResourceUsed().booleanValue()) {
            return altResource;
        }
        if (rejectedCheck && !this.isNotFixedResource(templateResource)) {
            templateResource.setAlternateResourceUsed(true);
            return templateResource;
        }
        return null;
    }

    List<TemplateResource> calculateFixedResourceAvailability(List<TemplateResource> fixedResources, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        for (TemplateResource resource : fixedResources) {
            TemplateResource foundSlot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (foundSlot != null) {
                availableResourceSlots.add(foundSlot);
                continue;
            }
            return null;
        }
        return availableResourceSlots;
    }

    BookedResource createBookedResource(TemplateResource templateResource, BookedVisit bookedVisit) {
        BookedResource bookedResource = new BookedResource();
        bookedResource.setId(4567);
        bookedResource.setBookedVisit(bookedVisit);
        bookedResource.setDuration(templateResource.getDuration());
        bookedResource.setScheduledStartTime(templateResource.getScheduledStartTime());
        bookedResource.setScheduledEndTime(templateResource.getScheduledEndTime());
        bookedResource.setResource(templateResource.getResource());
        bookedResource.setTemplateResource(templateResource);
        bookedResource.setAvailable(templateResource.getAvailable());
        bookedResource.setRejectedResourceMessage(templateResource.getRejectedResourceMessage());
        bookedResource.setBillable(templateResource.getBillable());
        return bookedResource;
    }

    void addResourcesToBookedVisit(List<TemplateResource> templateResources, BookedVisit bookedVisit) {
        List<BookedResource> bookedResources = bookedVisit.getBookedResourceList();
        Object rooms = bookedVisit.getRooms();
        if (rooms == null) {
            rooms = " ";
        }
        if (bookedResources == null) {
            bookedResources = new ArrayList<BookedResource>();
        }
        for (TemplateResource templateResource : templateResources) {
            BookedResource bookedResource = this.createBookedResource(templateResource, bookedVisit);
            bookedResources.add(bookedResource);
            if (!bookedResource.getResource().getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = (String)rooms + bookedResource.getResource().getName() + ", ";
            bookedVisit.setRooms((String)rooms);
        }
        bookedVisit.setBookedResourceList(bookedResources);
    }

    boolean foundAvailableFixedResources(Date searchDate, List<TemplateResource> fixedResources, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        if (MiscUtil.isNonNullNonEmpty(fixedResources)) {
            this.allocateTimeFixedResources(visitTimeSlotStart, searchDate, fixedResources, groupType);
            List<TemplateResource> availableFixedResources = this.removeDuplicates(this.calculateFixedResourceAvailability(fixedResources, rejectedCheck, bookedVisit.getBookedResourceList()));
            if (availableFixedResources != null) {
                this.addResourcesToBookedVisit(availableFixedResources, bookedVisit);
            } else {
                result = false;
            }
        }
        return result;
    }

    boolean isRelativeTimeRejectedVisit(BookedVisit bookedVisit, boolean rejectedCheck, boolean fixedResourcesAvailable) {
        if (!fixedResourcesAvailable && !rejectedCheck) {
            bookedVisit.setRejectedVisit(true);
            bookedVisit.setBookedResourceList(new ArrayList<BookedResource>());
            return true;
        }
        return false;
    }

    int findMultiDayMinutesOffset(List<TemplateResource> originalSequence, int relativeOffset) {
        Date earliestDate = ListUtils.enrich(originalSequence).map(TemplateResource::getStartDate).min((lhs, rhs) -> lhs.compareTo((Date)rhs)).orElse(null);
        int baseStartTime = (this.getTemplateResourceDay(earliestDate) - 1) * 1440 + earliestDate.getHours() * 60 + earliestDate.getMinutes();
        return baseStartTime + relativeOffset;
    }

    TemplateResource duplicateResourceSlot(TemplateResource givenResourceSlot) {
        TemplateResource slot = new TemplateResource();
        slot.setId(givenResourceSlot.getId());
        slot.setAvailableEndTimeInMin(givenResourceSlot.getAvailableEndTimeInMin());
        slot.setAlternate(givenResourceSlot.getAlternate());
        slot.setResource(givenResourceSlot.getResource());
        slot.setBillable(givenResourceSlot.getBillable());
        slot.setAvailableStartTimeInMin(givenResourceSlot.getAvailableStartTimeInMin());
        slot.setDuration(givenResourceSlot.getDuration());
        slot.setFlexible(givenResourceSlot.getFlexible());
        slot.setFloatEnd(givenResourceSlot.getFloatEnd());
        slot.setFloatStart(givenResourceSlot.getFloatStart());
        slot.setFloatable(givenResourceSlot.getFloatable());
        slot.setScheduledEndTime(givenResourceSlot.getScheduledEndTime());
        slot.setScheduledStartTime(givenResourceSlot.getScheduledStartTime());
        slot.setVisitTemplate(givenResourceSlot.getVisitTemplate());
        slot.setStartMinutes(givenResourceSlot.getStartMinutes());
        slot.setEndMinutes(givenResourceSlot.getEndMinutes());
        slot.setGroupId(givenResourceSlot.getGroupId());
        return slot;
    }

    void allocateTime(List<TemplateResource> sortedSequence, int baseStartTime, Date searchDate) {
        int startTimeInMin = baseStartTime;
        ArrayList templateResources = Lists.newArrayList();
        for (TemplateResource templateResource : sortedSequence) {
            int startHr = MiscUtil.divideByMinsPerHour(startTimeInMin);
            int resourceDurationTimeInMin = templateResource.getDuration();
            int endTimeInMin = startTimeInMin + resourceDurationTimeInMin;
            int endHr = MiscUtil.divideByMinsPerHour(endTimeInMin);
            boolean startDay = false;
            boolean endDay = false;
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, startHr, MiscUtil.moduloMinsPerHour(startTimeInMin));
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, endHr, MiscUtil.moduloMinsPerHour(endTimeInMin));
            templateResource.setScheduledStartTime(startTime);
            templateResource.setScheduledEndTime(endTime);
            startTimeInMin = endTimeInMin;
            for (TemplateResource tr : templateResources) {
                if (tr.getStartDate().getTime() != templateResource.getStartDate().getTime()) continue;
                templateResource.setScheduledStartTime(tr.getScheduledStartTime());
                templateResource.setScheduledEndTime(tr.getScheduledEndTime());
                startTimeInMin = endTimeInMin - resourceDurationTimeInMin;
            }
            templateResources.add(templateResource);
        }
    }

    List<TemplateResource> checkTimeSlotAvailability(List<TemplateResource> resources, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
        availableSlots.addAll(availableResourceSlots);
        for (TemplateResource resource : resources) {
            TemplateResource slot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (slot == null) {
                availableSlots.clear();
                return availableSlots;
            }
            availableSlots.add(slot);
        }
        return availableSlots;
    }

    List<TemplateResource> findAvailablePermutationSequence(List<TemplateResource> resources, int minuteOffsetForSlot, Date searchDate, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        TemplateResource slot;
        ArrayList<TemplateResource> availableSequence = null;
        ArrayList<TemplateResource> defaultSequence = null;
        boolean defaultSequences = true;
        BaseEntity previousFirstResource = null;
        boolean isFirstResourceAvailable = true;
        int baseStartTime = this.findMultiDayMinutesOffset(resources, minuteOffsetForSlot);
        PermutationGenerator generator = new PermutationGenerator(resources.size());
        while (generator.hasMore()) {
            List<TemplateResource> foundSlots;
            availableSequence = new ArrayList<TemplateResource>();
            List<Integer> indices = generator.getNext();
            TemplateResource currentFirstResource = this.duplicateResourceSlot(resources.get(indices.get(0)));
            for (int index : indices) {
                slot = this.duplicateResourceSlot(resources.get(index));
                slot.setResourceGroupType(groupType);
                availableSequence.add(slot);
            }
            if (defaultSequences) {
                defaultSequence = new ArrayList<TemplateResource>();
                defaultSequences = false;
                defaultSequence.addAll(availableSequence);
            }
            if (previousFirstResource != null && previousFirstResource.getId().equals(currentFirstResource.getId())) {
                if (!isFirstResourceAvailable) {
                    availableSequence = null;
                    continue;
                }
                this.allocateTime(availableSequence, baseStartTime, searchDate);
                foundSlots = this.checkTimeSlotAvailability(availableSequence, rejectedCheck, availableBookedResourceSlots, new ArrayList<TemplateResource>());
                if (!foundSlots.isEmpty()) {
                    return foundSlots;
                }
                availableSequence = null;
                continue;
            }
            previousFirstResource = currentFirstResource;
            this.allocateTime(availableSequence, baseStartTime, searchDate);
            TemplateResource foundSlot = this.findAvailableResource((TemplateResource)availableSequence.get(0), rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (foundSlot != null) {
                isFirstResourceAvailable = true;
                availableResourceSlots.add(foundSlot);
                availableSequence.remove(foundSlot);
                foundSlots = this.checkTimeSlotAvailability(availableSequence, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
                if (!foundSlots.isEmpty()) {
                    return foundSlots;
                }
                availableResourceSlots.remove(foundSlot);
                availableSequence = null;
                continue;
            }
            isFirstResourceAvailable = false;
            availableSequence = null;
        }
        if (rejectedCheck && availableSequence == null) {
            ArrayList<TemplateResource> rejectedSequence = new ArrayList<TemplateResource>();
            for (TemplateResource resource : defaultSequence) {
                resource.setFlexible(false);
                slot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
                slot.setFlexible(true);
                availableResourceSlots.add(slot);
                rejectedSequence.add(slot);
            }
            return rejectedSequence;
        }
        return availableSequence;
    }

    List<TemplateResource> allocateCheckAvailabilityFlip(int visitTimeSlotStart, Date searchDate, Map<String, List<TemplateResource>> flipResources, boolean rejectedCheck, String groupType, List<BookedResource> availableResourceSlots) {
        ArrayList<TemplateResource> availableFlipResourceSlots = new ArrayList<TemplateResource>();
        for (Map.Entry<String, List<TemplateResource>> flipGrp : flipResources.entrySet()) {
            List<TemplateResource> resources = flipGrp.getValue();
            List<TemplateResource> availableFlipGrp = this.findAvailablePermutationSequence(resources, visitTimeSlotStart, searchDate, rejectedCheck, groupType, availableResourceSlots, availableFlipResourceSlots);
            if (MiscUtil.isNullOrEmpty(availableFlipGrp)) {
                return null;
            }
            availableFlipResourceSlots.addAll(this.removeDuplicates(availableFlipGrp));
        }
        return availableFlipResourceSlots;
    }

    boolean foundAvailableFlipResources(Date searchDate, Map<String, List<TemplateResource>> flipResourceGroups, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        if (MiscUtil.isNonNullNonEmpty(flipResourceGroups)) {
            List<TemplateResource> availableFlipResources = this.allocateCheckAvailabilityFlip(visitTimeSlotStart, searchDate, flipResourceGroups, rejectedCheck, groupType, bookedVisit.getBookedResourceList());
            if (MiscUtil.isNonNullNonEmpty(availableFlipResources)) {
                this.addResourcesToBookedVisit(this.removeDuplicates(availableFlipResources), bookedVisit);
            } else {
                result = false;
            }
        }
        return result;
    }

    void allocateTime(TemplateResource resource, int visitTimeSlotStart, Date searchDate) {
        int resourceDurationTimeInMin = resource.getDuration();
        int resourceStartTimeInMin = resource.getStartDate().getHours() * 60 + resource.getStartDate().getMinutes();
        int resourceEndTimeInMin = resourceStartTimeInMin + resourceDurationTimeInMin;
        int slotOffsetResourceStartMinute = visitTimeSlotStart + resourceStartTimeInMin;
        int slotOffsetResourceEndMinute = visitTimeSlotStart + resourceEndTimeInMin;
        Date startDate = new Date(searchDate.getTime() + (long)slotOffsetResourceStartMinute * 60000L);
        Date candidateResourceStartTime = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, MiscUtil.multiDayMinutesToDailyHour(slotOffsetResourceStartMinute), MiscUtil.multiDayMinutesToHourlyMinute(slotOffsetResourceStartMinute));
        Calendar candidateEndCalendar = Calendar.getInstance();
        candidateEndCalendar.setTimeInMillis(candidateResourceStartTime.getTime() + (long)resourceDurationTimeInMin * 60000L);
        Date candidateResourceEndTime = candidateEndCalendar.getTime();
        resource.setAvailableStartTimeInMin(slotOffsetResourceStartMinute);
        resource.setAvailableEndTimeInMin(slotOffsetResourceEndMinute);
        resource.setScheduledStartTime(candidateResourceStartTime);
        resource.setScheduledEndTime(candidateResourceEndTime);
    }

    List<TemplateResource> allocateCheckAvailabilityUserPreferred(List<TemplateResource> resources, int visitTimeSlotStart, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> foundAvailableSlots) {
        for (TemplateResource templateResource : resources) {
            this.allocateTime(templateResource, visitTimeSlotStart, searchDate);
            TemplateResource foundSlot = this.findAvailableResource(templateResource, rejectedCheck, availableBookedResourceSlots, foundAvailableSlots);
            if (foundSlot == null) {
                return null;
            }
            foundAvailableSlots.add(foundSlot);
        }
        return foundAvailableSlots;
    }

    boolean possiblyCheckVisitEnd(boolean yesCheck, int visitTimeSlotEnd, int floatStart, int resourceDurationTimeInMin) {
        return !yesCheck || this.isStartPlusDurationLteEnd(visitTimeSlotEnd, floatStart, resourceDurationTimeInMin);
    }

    void prepareResourceTimeSlots(int resourceStartTime, int resourceEndTime, Date scheduledStartTime, Date scheduledEndTime, List<TemplateResource> resources) {
        for (TemplateResource resource : resources) {
            resource.setAvailableStartTimeInMin(resourceStartTime);
            resource.setAvailableEndTimeInMin(resourceEndTime);
            resource.setScheduledStartTime(scheduledStartTime);
            resource.setScheduledEndTime(scheduledEndTime);
        }
    }

    List<TemplateResource> findTemplateResourceSlots(List<TemplateResource> resources, int visitTimeSlotEnd, Date searchDate, boolean notUsingClockTime, int floatDelta, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        TemplateResource resource = resources.get(0);
        int resourceDurationTimeInMin = resource.getDuration();
        int resourceFloatDurationStartTimeInMin = resource.getFloatStart();
        int resourceFloatDurationEndTimeInMin = resource.getFloatEnd();
        int floatStart = floatDelta + resourceFloatDurationStartTimeInMin;
        int floatEnd = floatDelta + resourceFloatDurationEndTimeInMin;
        while (this.isStartPlusDurationLteEnd(floatEnd, floatStart, resourceDurationTimeInMin) && this.possiblyCheckVisitEnd(notUsingClockTime, visitTimeSlotEnd, floatStart, resourceDurationTimeInMin)) {
            int startDays = DateUtility.convertMinutesToStartDayZeroOffset(floatStart);
            int startHours = DateUtility.convertMinutesToHourInDay(floatStart);
            int startMinutes = DateUtility.convertTotalMinutesToMinutesInHour(floatStart);
            int endFloatMinutes = floatStart + resourceDurationTimeInMin;
            int endDays = DateUtility.convertMinutesToStartDayZeroOffset(endFloatMinutes);
            int endHours = DateUtility.convertMinutesToHourInDay(endFloatMinutes);
            int endMinutes = DateUtility.convertTotalMinutesToMinutesInHour(endFloatMinutes);
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(searchDate);
            startCalendar.add(5, startDays);
            startCalendar.set(11, startHours);
            startCalendar.add(12, startMinutes);
            Date startTime = startCalendar.getTime();
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(searchDate);
            endCalendar.add(5, endDays);
            endCalendar.set(11, endHours);
            endCalendar.add(12, endMinutes);
            Date endTime = endCalendar.getTime();
            this.prepareResourceTimeSlots(floatStart, floatStart + resourceDurationTimeInMin, startTime, endTime, resources);
            List<TemplateResource> foundSlots = this.checkTimeSlotAvailability(resources, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (!foundSlots.isEmpty()) {
                return foundSlots;
            }
            floatStart += 30;
        }
        return null;
    }

    List<TemplateResource> findAvailableFloatDurationSlots(List<TemplateResource> resources, int visitTimeSlotStart, int visitTimeSlotEnd, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> originalResources = new ArrayList<TemplateResource>();
        if (rejectedCheck) {
            originalResources.addAll(resources);
            List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
                return foundSlots;
            }
            boolean notUsingClockTime = true;
            foundSlots = this.findTemplateResourceSlots(resources, visitTimeSlotEnd, searchDate, true, visitTimeSlotStart, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
                return foundSlots;
            }
            for (TemplateResource r : originalResources) {
                r.setFloatable(false);
            }
            foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            for (TemplateResource r : originalResources) {
                r.setFloatable(true);
            }
            return foundSlots;
        }
        List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
        if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
            return foundSlots;
        }
        boolean notUsingClockTime = true;
        return this.findTemplateResourceSlots(resources, visitTimeSlotEnd, searchDate, true, visitTimeSlotStart, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
    }

    void prepareAndAddToAvailableSlots(int resourceStartTime, int resourceEndTime, Date scheduledStartTime, Date scheduledEndTime, List<TemplateResource> currentResources, List<TemplateResource> availableResourceSlots, String groupType, boolean singleFloatResources) {
        for (TemplateResource resource : currentResources) {
            if (!singleFloatResources && resource.getGroupId().equals(currentResources.get(currentResources.size() - 1).getGroupId())) {
                resource.setAvailableStartTimeInMin(resourceStartTime);
                resource.setAvailableEndTimeInMin(resourceEndTime);
                resource.setScheduledStartTime(scheduledStartTime);
                resource.setScheduledEndTime(scheduledEndTime);
            }
            resource.setResourceGroupType(groupType);
            availableResourceSlots.add(resource);
        }
    }

    List<TemplateResource> allocateCheckAvailabilityFloat(int visitTimeSlotStart, int visitTimeSlotEnd, Date searchDate, Map<String, List<TemplateResource>> floatResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        for (Map.Entry<String, List<TemplateResource>> floatGrps : floatResources.entrySet()) {
            List<TemplateResource> resources = floatGrps.getValue();
            if (resources.isEmpty()) continue;
            ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
            availableSlots.addAll(availableResourceSlots);
            List<TemplateResource> availableFloatResources = this.findAvailableFloatDurationSlots(resources, visitTimeSlotStart, visitTimeSlotEnd, searchDate, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (MiscUtil.isNullOrEmpty(availableFloatResources)) {
                return null;
            }
            this.prepareAndAddToAvailableSlots(resources.get(0).getAvailableStartTimeInMin(), resources.get(0).getAvailableEndTimeInMin(), resources.get(0).getScheduledStartTime(), resources.get(0).getScheduledEndTime(), availableFloatResources, availableResourceSlots, groupType, resources.size() == 1);
        }
        return availableResourceSlots;
    }

    boolean foundAvailableFloatResources(int visitDurationInMin, Date searchDate, Map<String, List<TemplateResource>> floatTrList, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(searchDate);
        Date searchStartDate = DateUtility.startOfDay(startCal);
        if (MiscUtil.isNonNullNonEmpty(floatTrList)) {
            List<TemplateResource> availableFloatResourceList = this.removeDuplicates(this.allocateCheckAvailabilityFloat(visitTimeSlotStart, visitTimeSlotStart + visitDurationInMin, searchStartDate, floatTrList, rejectedCheck, groupType, bookedVisit.getBookedResourceList()));
            if (MiscUtil.isNonNullNonEmpty(availableFloatResourceList)) {
                if (groupType.equalsIgnoreCase("float") && availableFloatResourceList.size() == floatTrList.size() || groupType.equalsIgnoreCase("float group")) {
                    this.addResourcesToBookedVisit(availableFloatResourceList, bookedVisit);
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    void calculateSomeAvailableResources(int visitDurationInMin, Date searchDate, List<BookedVisit> candidateVisits, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatTrList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck) {
        this.addToCandidateVisitList(bookedVisit, candidateVisits);
        boolean fixedResourcesAvailable = this.foundAvailableFixedResources(searchDate, fixedResources, visitTimeSlotStart, bookedVisit, rejectedCheck, "fixed");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, fixedResourcesAvailable)) {
            return;
        }
        boolean singleFloatResourcesAvailable = this.foundAvailableFloatResources(visitDurationInMin, searchDate, floatTrList, visitTimeSlotStart, bookedVisit, rejectedCheck, "float");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, singleFloatResourcesAvailable)) {
            return;
        }
        boolean floatGroupResourcesAvailable = this.foundAvailableFloatResources(visitDurationInMin, searchDate, floatResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck, "float group");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, floatGroupResourcesAvailable)) {
            return;
        }
        boolean flexGroupResourcesAvailable = this.foundAvailableFlipResources(searchDate, flipResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck, "flex");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, flexGroupResourcesAvailable)) {
            return;
        }
    }

    Date modifyDateFieldPlusAmtSetHourMinute(Date date, int field, int amount, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        cal.set(11, hour);
        cal.set(12, minute);
        return cal.getTime();
    }

    void addToCandidateVisitList(BookedVisit candidateVisit, List<BookedVisit> candidateVisits) {
        List<Object> candidateVisitsToAdd = candidateVisits == null ? Lists.newArrayList() : candidateVisits;
        candidateVisitsToAdd.add(candidateVisit);
    }

    int findEarliestInpatientClockStartTime(List<TemplateResource> resources) {
        int earliestStartTimeInMin = Integer.MAX_VALUE;
        int currentStartTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getStartDate() != null) {
                currentStartTimeInMin = this.getTemplateResourceDay(r.getStartDate()) * 1440 + r.getStartDate().getHours() * 60 + r.getStartDate().getMinutes() - 1440;
            }
            if (currentStartTimeInMin >= earliestStartTimeInMin) continue;
            earliestStartTimeInMin = currentStartTimeInMin;
        }
        return earliestStartTimeInMin;
    }

    int findLatestInpatientEndTime(List<TemplateResource> resources) {
        int latestEndTimeInMin = 0;
        int currentEndTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getEndDate() != null) {
                currentEndTimeInMin = this.getTemplateResourceDay(r.getEndDate()) * 1440 + r.getEndDate().getHours() * 60 + r.getEndDate().getMinutes() - 1440;
            }
            if (latestEndTimeInMin == 0) {
                latestEndTimeInMin = currentEndTimeInMin;
                continue;
            }
            if (latestEndTimeInMin <= 0 || currentEndTimeInMin <= latestEndTimeInMin) continue;
            latestEndTimeInMin = currentEndTimeInMin;
        }
        return latestEndTimeInMin;
    }

    int subtractDaysWorthOfMinutes(int totalBefore, int numDaysToSub) {
        return totalBefore - numDaysToSub * 1440;
    }

    BookedVisit initializeClockTimeBookedVisit(VisitTemplate visitTemplate, Date searchDate) {
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setId(1234556);
        bookedVisit.setName(visitTemplate.getName());
        bookedVisit.setStudy(visitTemplate.getStudy());
        bookedVisit.setVisitTemplate(visitTemplate);
        bookedVisit.setVisitType(visitTemplate.getVisitType());
        List<TemplateResource> trs = this.templateResourceDAO.findTemplateResourcesByVisit(visitTemplate);
        int startTimeInMin = this.findEarliestInpatientClockStartTime(trs);
        int endTimeInMin = this.findLatestInpatientEndTime(trs);
        int startDay = startTimeInMin / 1440;
        int startInMin = this.subtractDaysWorthOfMinutes(startTimeInMin, startDay);
        int startHr = MiscUtil.divideByMinsPerHour(startInMin);
        int startMin = MiscUtil.moduloMinsPerHour(startInMin);
        int endDay = MiscUtil.divideByMinsPerDay(endTimeInMin);
        int endInMin = this.subtractDaysWorthOfMinutes(endTimeInMin, endDay);
        int endHr = MiscUtil.divideByMinsPerHour(endInMin);
        int endMin = MiscUtil.moduloMinsPerHour(endInMin);
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, startDay, startHr, startMin);
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, endDay, endHr, endMin);
        bookedVisit.setScheduledStartTime(startTime);
        bookedVisit.setScheduledEndTime(endTime);
        return bookedVisit;
    }

    boolean isRejectedVisit(boolean rejectedCheck, BookedVisit bookedVisit, List<TemplateResource> availableResourceList) {
        if (MiscUtil.isNonNullNonEmpty(availableResourceList)) {
            bookedVisit.setRejectedVisit(false);
            this.addResourcesToBookedVisit(availableResourceList, bookedVisit);
            if (rejectedCheck) {
                bookedVisit.setRejectedVisit(true);
            }
        } else {
            bookedVisit.setRejectedVisit(true);
            bookedVisit.setBookedResourceList(new ArrayList<BookedResource>());
            return true;
        }
        return false;
    }

    void calculateAvailableVisitTimeSlotClockTime(VisitTemplate visitTemplate, SubjectMrn subjectMrn, Date searchDate, Date endDateParam, List<BookedVisit> candidateVisits, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatTrList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, boolean rejectedCheck) {
        BookedVisit bookedVisit = this.initializeClockTimeBookedVisit(visitTemplate, searchDate);
        Date endDate = this.modifyDateFieldPlusAmtSetHourMinute(endDateParam, 6, 0, bookedVisit.getScheduledEndTime().getHours(), bookedVisit.getScheduledEndTime().getMinutes());
        if (bookedVisit.getScheduledEndTime().equals(endDate) || bookedVisit.getScheduledEndTime().before(endDate)) {
            List<TemplateResource> availableFlipResources;
            List<TemplateResource> availableFloatResources;
            List<TemplateResource> availableFloatResourceList;
            bookedVisit.setSubjectMrn(subjectMrn);
            String uniqueKey = RandomStringUtils.randomNumeric((int)8);
            bookedVisit.setUniquekey(uniqueKey);
            this.addToCandidateVisitList(bookedVisit, candidateVisits);
            this.allocateTimeFixedResourcesClockTime(searchDate, fixedResources, "fixed");
            List<TemplateResource> availableFixedResources = this.calculateFixedResourceAvailability(fixedResources, rejectedCheck, bookedVisit.getBookedResourceList());
            if (this.isRejectedVisit(rejectedCheck, bookedVisit, availableFixedResources)) {
                return;
            }
            if (MiscUtil.isNonNullNonEmpty(floatTrList) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFloatResourceList = this.removeDuplicates(this.allocateCheckAvailabilityFloatClockTime(searchDate, floatTrList, rejectedCheck, "float", bookedVisit.getBookedResourceList())))) {
                return;
            }
            if (MiscUtil.isNonNullNonEmpty(floatResourceGroups) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFloatResources = this.removeDuplicates(this.allocateCheckAvailabilityFloatClockTime(searchDate, floatResourceGroups, rejectedCheck, "float group", bookedVisit.getBookedResourceList())))) {
                return;
            }
            if (MiscUtil.isNonNullNonEmpty(flipResourceGroups) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFlipResources = this.removeDuplicates(this.allocateCheckAvailabilityFlipClockTime(searchDate, flipResourceGroups, rejectedCheck, "flex", bookedVisit.getBookedResourceList())))) {
                return;
            }
        }
    }

    <A> List<A> removeDuplicates(List<A> availableResourceList) {
        if (MiscUtil.isNonNullNonEmpty(availableResourceList)) {
            return ListUtils.enrich(availableResourceList).distinct().toList();
        }
        return availableResourceList;
    }

    int getTemplateResourceDay(Date r) {
        if (r.getMonth() > 1) {
            return r.getDate() + (r.getMonth() - 1) * 29;
        }
        return r.getDate();
    }

    void allocateTimeFixedResourcesClockTime(Date searchDate, List<TemplateResource> fixedResources, String groupType) {
        int startDay = 1;
        int endDay = 1;
        for (TemplateResource resource : fixedResources) {
            if (resource.getStartDate() != null) {
                startDay = this.getTemplateResourceDay(resource.getStartDate());
            }
            if (resource.getEndDate() != null) {
                endDay = this.getTemplateResourceDay(resource.getEndDate());
            }
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, --startDay, resource.getStartDate().getHours(), resource.getStartDate().getMinutes());
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, --endDay, resource.getEndDate().getHours(), resource.getEndDate().getMinutes());
            resource.setScheduledStartTime(startTime);
            resource.setScheduledEndTime(endTime);
            resource.setResourceGroupType(groupType);
        }
    }

    void allocateTimeClockTime(TemplateResource resource, Date searchDate) {
        int resourceStartTimeInMin = resource.getStartDate().getHours() * 60 + resource.getStartDate().getMinutes();
        int resourceEndTimeInMin = resource.getEndDate().getHours() * 60 + resource.getEndDate().getMinutes();
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, resource.getStartDate().getHours(), resource.getStartDate().getMinutes());
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getEndDate()) - 1, MiscUtil.divideByMinsPerHour(resourceEndTimeInMin), MiscUtil.moduloMinsPerHour(resourceEndTimeInMin));
        resource.setAvailableStartTimeInMin(resourceStartTimeInMin);
        resource.setAvailableEndTimeInMin(resourceEndTimeInMin);
        resource.setScheduledStartTime(startTime);
        resource.setScheduledEndTime(endTime);
    }

    List<TemplateResource> allocateCheckAvailabilityUserPreferredClockTime(List<TemplateResource> resources, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> foundAvailableSlots) {
        for (TemplateResource resource : resources) {
            this.allocateTimeClockTime(resource, searchDate);
            TemplateResource foundSlot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, foundAvailableSlots);
            if (foundSlot != null) {
                foundAvailableSlots.add(foundSlot);
                continue;
            }
            return null;
        }
        return foundAvailableSlots;
    }

    List<TemplateResource> findAvailableFloatDurationSlotsClockTime(List<TemplateResource> resources, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> originalResources = new ArrayList<TemplateResource>();
        if (rejectedCheck) {
            originalResources.addAll(resources);
            List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(resources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
                return foundSlots;
            }
            boolean notUsingClockTime = false;
            int visitTimeSlotEnd = -1;
            boolean floatDelta = false;
            foundSlots = this.findTemplateResourceSlots(resources, -1, searchDate, false, 0, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
                return foundSlots;
            }
            for (TemplateResource r : originalResources) {
                r.setFloatable(false);
            }
            foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(originalResources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            for (TemplateResource r : originalResources) {
                r.setFloatable(true);
            }
            return foundSlots;
        }
        List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(resources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
        if (MiscUtil.isNonNullNonEmpty(foundSlots)) {
            return foundSlots;
        }
        boolean notUsingClockTime = false;
        int visitTimeSlotEnd = -1;
        boolean floatDelta = false;
        return this.findTemplateResourceSlots(resources, -1, searchDate, false, 0, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
    }

    List<TemplateResource> allocateCheckAvailabilityFloatClockTime(Date searchDate, Map<String, List<TemplateResource>> floatResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(searchDate);
        Date searchStartDate = DateUtility.startOfDay(startCal);
        for (Map.Entry<String, List<TemplateResource>> floatGroups : floatResources.entrySet()) {
            List<TemplateResource> resources = floatGroups.getValue();
            if (resources.isEmpty()) continue;
            ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
            availableSlots.addAll(availableResourceSlots);
            List<TemplateResource> availableFloatResources = this.findAvailableFloatDurationSlotsClockTime(resources, searchStartDate, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (MiscUtil.isNonNullNonEmpty(availableFloatResources)) {
                this.prepareAndAddToAvailableSlots(resources.get(0).getAvailableStartTimeInMin(), resources.get(0).getAvailableEndTimeInMin(), resources.get(0).getScheduledStartTime(), resources.get(0).getScheduledEndTime(), availableFloatResources, availableResourceSlots, groupType, resources.size() == 1);
                continue;
            }
            return null;
        }
        return availableResourceSlots;
    }

    List<TemplateResource> allocateCheckAvailabilityFlipClockTime(Date searchDate, Map<String, List<TemplateResource>> flipResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableFlipResourceSlots = new ArrayList<TemplateResource>();
        LazyList lazyTemplateResourceLists = LazyList.lazy(new ArrayList<Map.Entry<String, List<TemplateResource>>>(flipResources.entrySet())).map(flipGrp -> {
            List resources = (List)flipGrp.getValue();
            List<TemplateResource> availableFlipGrp = this.removeDuplicates(this.findAvailablePermutationSequence(resources, 0, searchDate, rejectedCheck, groupType, availableBookedResourceSlots, availableFlipResourceSlots));
            if (MiscUtil.isNullOrEmpty(availableFlipGrp)) {
                return null;
            }
            availableFlipResourceSlots.addAll(availableFlipGrp);
            return availableFlipGrp;
        });
        if (lazyTemplateResourceLists.exists(MiscUtil::isNullOrEmpty)) {
            return null;
        }
        return availableFlipResourceSlots;
    }

    Map<Integer, Integer> getPeriodToQuantityMap(List<ResourceSchedule> resourceScheduleList) {
        HashMap<Integer, Integer> periodToQuantityMap = new HashMap<Integer, Integer>();
        for (ResourceSchedule resourceSchedule : resourceScheduleList) {
            this.loadResourceScheduleIntoPeriodToQuantityMap(resourceSchedule, periodToQuantityMap, 0);
        }
        return periodToQuantityMap;
    }
}

