/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpBrokenContent;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.utils.Exceptions;

public class InputBuffer {
    private Request serverRequest;
    private HttpRequestPacket request;
    private FilterChainContext ctx;
    private boolean processingChars;
    private boolean closed;
    private Buffer inputContentBuffer;
    private Connection connection;
    private int markPos = -1;
    private int readAheadLimit = -1;
    private int readCount = 0;
    private String encoding = "ISO-8859-1";
    private CharsetDecoder decoder;
    private final Map<String, CharsetDecoder> decoders = new HashMap<String, CharsetDecoder>();
    private boolean contentRead;
    private ReadHandler handler;
    private int requestedSize;
    private boolean asyncEnabled;
    private final CharBuffer singleCharBuf = CharBuffer.allocate(1);
    private float averageCharsPerByte = 1.0f;
    private boolean isWaitingDataAsynchronously;

    public void initialize(Request serverRequest, FilterChainContext ctx) {
        if (serverRequest == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx cannot be null.");
        }
        this.serverRequest = serverRequest;
        this.request = serverRequest.getRequest();
        this.ctx = ctx;
        this.connection = ctx.getConnection();
        Object message = ctx.getMessage();
        if (message instanceof HttpContent) {
            HttpContent content = (HttpContent)message;
            InputBuffer.checkHttpTrailer(content);
            this.inputContentBuffer = content.getContent();
            this.contentRead = content.isLast();
            content.recycle();
            this.inputContentBuffer.allowBufferDispose(true);
        }
    }

    public void setDefaultEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void recycle() {
        this.inputContentBuffer.tryDispose();
        this.inputContentBuffer = null;
        this.connection = null;
        this.decoder = null;
        this.ctx = null;
        this.handler = null;
        this.processingChars = false;
        this.closed = false;
        this.contentRead = false;
        this.asyncEnabled = false;
        this.markPos = -1;
        this.readAheadLimit = -1;
        this.requestedSize = -1;
        this.readCount = 0;
        this.averageCharsPerByte = 1.0f;
        this.isWaitingDataAsynchronously = false;
        this.encoding = "ISO-8859-1";
    }

    public void processingChars() {
        if (!this.processingChars) {
            this.processingChars = true;
            String enc = this.request.getCharacterEncoding();
            if (enc != null) {
                this.encoding = enc;
                CharsetDecoder localDecoder = this.getDecoder();
                this.averageCharsPerByte = localDecoder.averageCharsPerByte();
            }
        }
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.inputContentBuffer.hasRemaining()) {
            if (!this.asyncEnabled) {
                if (this.fill(1) == -1) {
                    return -1;
                }
            } else {
                throw new IllegalStateException("Can't block and wait for data in non-blocking mode");
            }
        }
        if (this.readAheadLimit != -1) {
            ++this.readCount;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        return this.inputContentBuffer.get() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.inputContentBuffer.hasRemaining()) {
            if (!this.asyncEnabled) {
                if (this.fill(1) == -1) {
                    return -1;
                }
            } else {
                throw new IllegalStateException("Can't block and wait for data in non-blocking mode");
            }
        }
        int nlen = Math.min(this.inputContentBuffer.remaining(), len);
        if (this.readAheadLimit != -1) {
            this.readCount += nlen;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        this.inputContentBuffer.get(b, off, nlen);
        this.inputContentBuffer.shrink();
        return nlen;
    }

    public int readyData() {
        if (this.closed) {
            return 0;
        }
        return this.processingChars ? this.availableChar() : this.available();
    }

    public int available() {
        return this.closed ? 0 : this.inputContentBuffer.remaining();
    }

    public Buffer getBuffer() {
        return this.inputContentBuffer.duplicate();
    }

    public Buffer readBuffer() {
        return this.readBuffer(this.inputContentBuffer.remaining());
    }

    public Buffer readBuffer(int size) {
        Buffer buffer;
        int remaining = this.inputContentBuffer.remaining();
        if (size > remaining) {
            throw new IllegalStateException("Can not read more bytes than available");
        }
        if (size == remaining) {
            buffer = this.inputContentBuffer;
            this.inputContentBuffer = Buffers.EMPTY_BUFFER;
        } else {
            Buffer tmpBuffer = this.inputContentBuffer.split(this.inputContentBuffer.position() + size);
            buffer = this.inputContentBuffer;
            this.inputContentBuffer = tmpBuffer;
        }
        return buffer;
    }

    public ReadHandler getReadHandler() {
        return this.handler;
    }

    public int read(CharBuffer target) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null.");
        }
        int read = this.fillChars(1, target, !this.asyncEnabled);
        if (this.readAheadLimit != -1) {
            this.readCount += read;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        return read;
    }

    public int readChar() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.singleCharBuf.position(0);
        int read = this.read(this.singleCharBuf);
        if (read == -1) {
            return -1;
        }
        char c = this.singleCharBuf.get(0);
        this.singleCharBuf.position(0);
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (len == 0) {
            return 0;
        }
        CharBuffer buf = CharBuffer.wrap(cbuf, off, len);
        return this.read(buf);
    }

    public boolean ready() {
        if (this.closed) {
            return false;
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        return this.inputContentBuffer.hasRemaining() || this.request.isExpectContent();
    }

    public void fillFully(int length) throws IOException {
        int remaining = length - this.inputContentBuffer.remaining();
        if (remaining > 0) {
            this.fill(remaining);
        }
    }

    public int availableChar() {
        return (int)((float)this.inputContentBuffer.remaining() * this.averageCharsPerByte);
    }

    public void mark(int readAheadLimit) {
        if (readAheadLimit > 0) {
            this.markPos = this.inputContentBuffer.position();
            this.readCount = 0;
            this.readAheadLimit = readAheadLimit;
        }
    }

    public boolean markSupported() {
        if (this.processingChars) {
            throw new IllegalStateException();
        }
        return true;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.readAheadLimit == -1 && this.markPos == -1) {
            throw new IOException("Mark not set");
        }
        if (this.readAheadLimit != -1) {
            if (this.markPos == -1) {
                throw new IOException("Mark not set");
            }
            this.readCount = 0;
        }
        this.inputContentBuffer.position(this.markPos);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public long skip(long n, boolean block) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!block && n > (long)this.inputContentBuffer.remaining()) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        if (!this.processingChars) {
            if (n <= 0L) {
                return 0L;
            }
            if (block) {
                if (!this.inputContentBuffer.hasRemaining() && this.fill((int)n) == -1) {
                    return -1L;
                }
                if ((long)this.inputContentBuffer.remaining() < n) {
                    this.fill((int)n);
                }
            }
            long nlen = Math.min((long)this.inputContentBuffer.remaining(), n);
            this.inputContentBuffer.position(this.inputContentBuffer.position() + (int)nlen);
            this.inputContentBuffer.shrink();
            return nlen;
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        CharBuffer skipBuffer = CharBuffer.allocate((int)n);
        if (this.fillChars((int)n, skipBuffer, block) == -1) {
            return 0L;
        }
        return Math.min((long)skipBuffer.remaining(), n);
    }

    public void finished() throws IOException {
        if (!this.contentRead) {
            this.contentRead = true;
            ReadHandler localHandler = this.handler;
            if (localHandler != null) {
                this.handler = null;
                try {
                    localHandler.onAllDataRead();
                }
                catch (Throwable t) {
                    localHandler.onError(t);
                    throw Exceptions.makeIOException((Throwable)t);
                }
            }
        }
    }

    public boolean isFinished() {
        return this.contentRead;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void notifyAvailable(ReadHandler handler) {
        this.notifyAvailable(handler, 1);
    }

    public void notifyAvailable(ReadHandler handler, int size) {
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null.");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("size should be positive integer");
        }
        if (this.handler != null) {
            throw new IllegalStateException("Illegal attempt to register a new handler before the existing handler has been notified");
        }
        if (this.closed || this.isFinished()) {
            try {
                handler.onAllDataRead();
            }
            catch (Throwable ioe) {
                handler.onError(ioe);
            }
            return;
        }
        int available = this.readyData();
        if (InputBuffer.shouldNotifyNow(size, available)) {
            try {
                handler.onDataAvailable();
            }
            catch (Throwable ioe) {
                handler.onError(ioe);
            }
            return;
        }
        this.requestedSize = size;
        this.handler = handler;
        if (!this.isWaitingDataAsynchronously) {
            this.isWaitingDataAsynchronously = true;
            this.serverRequest.initiateAsyncronousDataReceiving();
        }
    }

    public boolean append(HttpContent httpContent) throws IOException {
        this.isWaitingDataAsynchronously = false;
        if (!HttpContent.isBroken((HttpContent)httpContent)) {
            boolean askForMoreDataInThisThread;
            Buffer buffer = httpContent.getContent();
            if (this.closed) {
                buffer.dispose();
                return false;
            }
            ReadHandler localHandler = this.handler;
            boolean bl = askForMoreDataInThisThread = localHandler != null;
            if (buffer.hasRemaining()) {
                int available;
                this.updateInputContentBuffer(buffer);
                if (!httpContent.isLast() && localHandler != null && (available = this.readyData()) >= this.requestedSize) {
                    askForMoreDataInThisThread = false;
                    this.handler = null;
                    try {
                        localHandler.onDataAvailable();
                    }
                    catch (Throwable t) {
                        localHandler.onError(t);
                        throw Exceptions.makeIOException((Throwable)t);
                    }
                }
            }
            if (httpContent.isLast()) {
                askForMoreDataInThisThread = false;
                InputBuffer.checkHttpTrailer(httpContent);
                this.finished();
            }
            if (askForMoreDataInThisThread) {
                this.isWaitingDataAsynchronously = true;
            }
            return askForMoreDataInThisThread;
        }
        ReadHandler localHandler = this.handler;
        this.handler = null;
        if (!this.closed && localHandler != null) {
            localHandler.onError((Throwable)((HttpBrokenContent)httpContent).getException());
        }
        return false;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }

    public void terminate() {
        ReadHandler localHandler = this.handler;
        if (localHandler != null) {
            this.handler = null;
            if (this.connection.isOpen()) {
                localHandler.onError((Throwable)new CancellationException());
            } else {
                localHandler.onError((Throwable)new EOFException());
            }
        }
    }

    private int fill(int requestedLen) throws IOException {
        int read;
        Buffer b;
        for (read = 0; read < requestedLen && this.request.isExpectContent(); read += b.remaining()) {
            ReadResult rr = this.ctx.read();
            HttpContent c = (HttpContent)rr.getMessage();
            InputBuffer.checkHttpTrailer(c);
            b = c.getContent();
            this.updateInputContentBuffer(b);
            rr.recycle();
            c.recycle();
        }
        if (read > 0 || requestedLen == 0) {
            return read;
        }
        return -1;
    }

    private int fillChars(int requestedLen, CharBuffer dst, boolean block) throws IOException {
        int read = 0;
        if (this.inputContentBuffer.hasRemaining()) {
            read = this.fillAvailableChars(requestedLen, dst);
        }
        if (!block && read < requestedLen) {
            throw new IllegalStateException("Can't block and wait for data in non-blocking mode");
        }
        if (read >= requestedLen) {
            dst.flip();
            return read;
        }
        if (!this.request.isExpectContent()) {
            dst.flip();
            return read > 0 ? read : -1;
        }
        CharsetDecoder decoderLocal = this.getDecoder();
        boolean isNeedMoreInput = false;
        boolean last = false;
        while (read < requestedLen && this.request.isExpectContent()) {
            if (isNeedMoreInput || !this.inputContentBuffer.hasRemaining()) {
                ReadResult rr = this.ctx.read();
                HttpContent c = (HttpContent)rr.getMessage();
                this.updateInputContentBuffer(c.getContent());
                last = c.isLast();
                rr.recycle();
                c.recycle();
                isNeedMoreInput = false;
            }
            ByteBuffer bytes = this.inputContentBuffer.toByteBuffer();
            int bytesPos = bytes.position();
            int dstPos = dst.position();
            CoderResult result = decoderLocal.decode(bytes, dst, false);
            int producedChars = dst.position() - dstPos;
            int consumedBytes = bytes.position() - bytesPos;
            read += producedChars;
            if (consumedBytes > 0) {
                bytes.position(bytesPos);
                this.inputContentBuffer.position(this.inputContentBuffer.position() + consumedBytes);
                this.inputContentBuffer.shrink();
            } else {
                isNeedMoreInput = true;
            }
            if (!last && result != CoderResult.OVERFLOW) continue;
            break;
        }
        dst.flip();
        if (last && read == 0) {
            read = -1;
        }
        return read;
    }

    private int fillAvailableChars(int requestedLen, CharBuffer dst) {
        CoderResult result;
        int consumedBytesNow;
        int producedCharsNow;
        CharsetDecoder decoderLocal = this.getDecoder();
        ByteBuffer bb = this.inputContentBuffer.toByteBuffer();
        int oldBBPos = bb.position();
        int producedChars = 0;
        int consumedBytes = 0;
        int remaining = requestedLen;
        do {
            int charPos = dst.position();
            int bbPos = bb.position();
            result = decoderLocal.decode(bb, dst, false);
            producedCharsNow = dst.position() - charPos;
            consumedBytesNow = bb.position() - bbPos;
            producedChars += producedCharsNow;
            consumedBytes += consumedBytesNow;
        } while ((remaining -= producedCharsNow) > 0 && (producedCharsNow > 0 || consumedBytesNow > 0) && bb.hasRemaining() && result == CoderResult.UNDERFLOW);
        bb.position(oldBBPos);
        this.inputContentBuffer.position(this.inputContentBuffer.position() + consumedBytes);
        if (this.readAheadLimit == -1) {
            this.inputContentBuffer.shrink();
        }
        return producedChars;
    }

    private void updateInputContentBuffer(Buffer buffer) {
        buffer.allowBufferDispose(true);
        if (this.inputContentBuffer.hasRemaining()) {
            this.toCompositeInputContentBuffer().append((Object)buffer);
        } else {
            this.inputContentBuffer.tryDispose();
            this.inputContentBuffer = buffer;
        }
    }

    private static boolean shouldNotifyNow(int size, int available) {
        return available != 0 && available >= size;
    }

    private CharsetDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = this.decoders.get(this.encoding);
            if (this.decoder == null) {
                Charset cs = Charsets.lookupCharset((String)this.encoding);
                this.decoder = cs.newDecoder();
                this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
                this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.decoders.put(this.encoding, this.decoder);
            } else {
                this.decoder.reset();
            }
        }
        return this.decoder;
    }

    private CompositeBuffer toCompositeInputContentBuffer() {
        if (!this.inputContentBuffer.isComposite()) {
            CompositeBuffer compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.connection.getTransport().getMemoryManager());
            compositeBuffer.allowBufferDispose(true);
            compositeBuffer.allowInternalBuffersDispose(true);
            compositeBuffer.append((Object)this.inputContentBuffer);
            this.inputContentBuffer = compositeBuffer;
        }
        return (CompositeBuffer)this.inputContentBuffer;
    }

    private static void checkHttpTrailer(HttpContent httpContent) {
        if (HttpTrailer.isTrailer((HttpContent)httpContent)) {
            HttpTrailer httpTrailer = (HttpTrailer)httpContent;
            HttpHeader httpHeader = httpContent.getHttpHeader();
            MimeHeaders trailerHeaders = httpTrailer.getHeaders();
            int size = trailerHeaders.size();
            for (int i = 0; i < size; ++i) {
                httpHeader.addHeader(trailerHeaders.getName(i).toString(), trailerHeaders.getValue(i).toString());
            }
        }
    }
}

