/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.response;

import java.net.URI;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.web.client.response.DefaultResponseCreator;

public abstract class MockRestResponseCreators {
    private MockRestResponseCreators() {
    }

    public static DefaultResponseCreator withSuccess() {
        return new DefaultResponseCreator(HttpStatus.OK);
    }

    public static DefaultResponseCreator withSuccess(String body, MediaType mediaType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(mediaType);
    }

    public static DefaultResponseCreator withSuccess(byte[] body, MediaType contentType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(contentType);
    }

    public static DefaultResponseCreator withSuccess(Resource body, MediaType contentType) {
        return new DefaultResponseCreator(HttpStatus.OK).body(body).contentType(contentType);
    }

    public static DefaultResponseCreator withCreatedEntity(URI location) {
        return new DefaultResponseCreator(HttpStatus.CREATED).location(location);
    }

    public static DefaultResponseCreator withNoContent() {
        return new DefaultResponseCreator(HttpStatus.NO_CONTENT);
    }

    public static DefaultResponseCreator withBadRequest() {
        return new DefaultResponseCreator(HttpStatus.BAD_REQUEST);
    }

    public static DefaultResponseCreator withUnauthorizedRequest() {
        return new DefaultResponseCreator(HttpStatus.UNAUTHORIZED);
    }

    public static DefaultResponseCreator withServerError() {
        return new DefaultResponseCreator(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static DefaultResponseCreator withStatus(HttpStatus status) {
        return new DefaultResponseCreator(status);
    }
}

