/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.AbstractLobCreator;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.StreamUtils;

public class ContextualLobCreator
extends AbstractLobCreator
implements LobCreator {
    private LobCreationContext lobCreationContext;
    private static final Class[] CREATION_METHOD_SIG = new Class[0];
    private static final Object[] CREATION_METHOD_ARGS = new Object[0];
    private static final LobCreationContext.Callback CREATE_BLOB_CALLBACK = new CallbackImpl(ContextualLobCreator.getConnectionlobCreationMethod("createBlob"));
    private static final LobCreationContext.Callback CREATE_CLOB_CALLBACK = new CallbackImpl(ContextualLobCreator.getConnectionlobCreationMethod("createClob"));
    private static final LobCreationContext.Callback CREATE_NCLOB_CALLBACK = new CallbackImpl(ContextualLobCreator.getConnectionlobCreationMethod("createNClob"));

    public ContextualLobCreator(LobCreationContext lobCreationContext) {
        this.lobCreationContext = lobCreationContext;
    }

    public Blob createBlob() {
        return (Blob)this.lobCreationContext.execute(CREATE_BLOB_CALLBACK);
    }

    public Blob createBlob(byte[] bytes) {
        try {
            Blob blob = this.createBlob();
            blob.setBytes(1L, bytes);
            return blob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set BLOB bytes after creation", e);
        }
    }

    public Blob createBlob(InputStream inputStream, long length) {
        try {
            Blob blob = this.createBlob();
            OutputStream byteStream = blob.setBinaryStream(1L);
            StreamUtils.copy(inputStream, byteStream);
            byteStream.flush();
            byteStream.close();
            return blob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to prepare BLOB binary stream for writing", e);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to write stream contents to BLOB", e);
        }
    }

    public Clob createClob() {
        return (Clob)this.lobCreationContext.execute(CREATE_CLOB_CALLBACK);
    }

    public Clob createClob(String string) {
        try {
            Clob clob = this.createClob();
            clob.setString(1L, string);
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set CLOB string after creation", e);
        }
    }

    public Clob createClob(Reader reader, long length) {
        try {
            Clob clob = this.createClob();
            Writer writer = clob.setCharacterStream(1L);
            StreamUtils.copy(reader, writer);
            writer.flush();
            writer.close();
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to prepare CLOB stream for writing", e);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to write CLOB stream content", e);
        }
    }

    public Clob createNClob() {
        return (Clob)this.lobCreationContext.execute(CREATE_NCLOB_CALLBACK);
    }

    public Clob createNClob(String string) {
        try {
            Clob clob = this.createNClob();
            clob.setString(1L, string);
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to set NCLOB string after creation", e);
        }
    }

    public Clob createNClob(Reader reader, long length) {
        try {
            Clob clob = this.createNClob();
            Writer writer = clob.setCharacterStream(1L);
            StreamUtils.copy(reader, writer);
            writer.flush();
            writer.close();
            return clob;
        }
        catch (SQLException e) {
            throw new JDBCException("Unable to prepare NCLOB stream for writing", e);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to write NCLOB stream content", e);
        }
    }

    private static Method getConnectionlobCreationMethod(String methodName) {
        try {
            return Connection.class.getMethod(methodName, CREATION_METHOD_SIG);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("JDBC driver did not implement " + methodName);
        }
    }

    private static class CallbackImpl
    implements LobCreationContext.Callback {
        private final Method creationMethod;

        private CallbackImpl(Method creationMethod) {
            this.creationMethod = creationMethod;
        }

        public Object executeOnConnection(Connection connection) throws SQLException {
            try {
                return this.creationMethod.invoke((Object)connection, CREATION_METHOD_ARGS);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SQLException) {
                    throw (SQLException)e.getTargetException();
                }
                throw new HibernateException("Exception invoking " + this.creationMethod.getName(), e.getTargetException());
            }
            catch (AbstractMethodError e) {
                throw new IllegalStateException("Useable implementation of " + this.creationMethod.getName() + " not found.");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Illegal access attempt on JDBC method " + this.creationMethod.getName());
            }
        }
    }
}

