/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.entity.HasId;
import edu.harvard.catalyst.scheduler.entity.HasReportFiltersNameAndId;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum ResourceType implements HasId,
HasReportFiltersNameAndId
{
    Nursing(1),
    Nutrition(2),
    Room(3),
    Lab(4),
    Other(5);

    private int id;

    private ResourceType(int id) {
        this.id = id;
    }

    @Override
    public int getReportFiltersId() {
        return this.ordinal();
    }

    @Override
    public String getReportFiltersName() {
        return this.name();
    }

    public boolean isNursing() {
        return this == Nursing;
    }

    public boolean isNutrition() {
        return this == Nutrition;
    }

    public boolean isRoom() {
        return this == Room;
    }

    public boolean isLab() {
        return this == Lab;
    }

    public boolean isOther() {
        return this == Other;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return "ResourceType [id=" + this.id + ", name=" + this.getName() + "]";
    }

    public static Optional<ResourceType> findById(int id) {
        return ListUtils.enrich((Object[])ResourceType.values()).find(rt -> rt.id == id);
    }

    public static List<ResourceType> valueList() {
        return Arrays.asList(ResourceType.values());
    }
}

