/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VisitDurationByVisitTypeReportDTO
implements CsvAbleDTO {
    private Integer visitId;
    private String studyName;
    private String visitName;
    private String visitType;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private Integer duration;
    private Date checkInTime;
    private Date checkOutTime;

    public Integer getVisitId() {
        return this.visitId;
    }

    public void setVisitId(Integer visitId) {
        this.visitId = visitId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    @Override
    public String toCsvHeaders() {
        return "Local ID,Booked Visit ID,Scheduled Start Time,Scheduled End Time,Visit Type,Visit Name,Check In Date,Check Out Date,Visit Duration";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            VisitDurationByVisitTypeReportDTO d = (VisitDurationByVisitTypeReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.visitId));
            columns.add(MiscUtil.showDateTime(d.scheduledStartTime));
            columns.add(MiscUtil.showDateTime(d.scheduledEndTime));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.showDateTime(d.checkInTime));
            columns.add(MiscUtil.showDateTime(d.checkOutTime));
            columns.add(MiscUtil.formatEndMinusStart(d.checkInTime, d.checkOutTime));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

