/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hibernate.HibernateException;

public class HibernateMethodLookupDispatcher {
    private static final SecurityActions SECURITY_ACTIONS = new SecurityActions();
    private static final Function<Object, Class<?>> STACK_FRAME_GET_DECLARING_CLASS_FUNCTION;
    private static Object stackWalker;
    private static Method stackWalkerWalkMethod;
    private static Method stackFrameGetDeclaringClass;
    private static Set<String> authorizedClasses;

    public static Method getDeclaredMethod(final Class<?> type, final String name, final Class<?>[] parameters) {
        PrivilegedAction<Method> getDeclaredMethodAction = new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return type.getDeclaredMethod(name, parameters);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    return null;
                }
            }
        };
        return HibernateMethodLookupDispatcher.doPrivilegedAction(getDeclaredMethodAction);
    }

    public static Method getMethod(final Class<?> type, final String name, final Class<?>[] parameters) {
        PrivilegedAction<Method> getMethodAction = new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return type.getMethod(name, parameters);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    return null;
                }
            }
        };
        return HibernateMethodLookupDispatcher.doPrivilegedAction(getMethodAction);
    }

    private static Method doPrivilegedAction(PrivilegedAction<Method> privilegedAction) {
        Class<?> callerClass = HibernateMethodLookupDispatcher.getCallerClass();
        if (!authorizedClasses.contains(callerClass.getName())) {
            throw new SecurityException("Unauthorized call by class " + callerClass);
        }
        return System.getSecurityManager() != null ? AccessController.doPrivileged(privilegedAction) : privilegedAction.run();
    }

    static void registerAuthorizedClass(String className) {
        authorizedClasses.add(className);
    }

    private static Class<?> getCallerClass() {
        PrivilegedAction getCallerClassAction = new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    if (stackWalker != null) {
                        Optional clazzOptional = (Optional)stackWalkerWalkMethod.invoke(stackWalker, new Function<Stream, Object>(){

                            @Override
                            public Object apply(Stream stream) {
                                return stream.map(STACK_FRAME_GET_DECLARING_CLASS_FUNCTION).skip(System.getSecurityManager() != null ? 6L : 5L).findFirst();
                            }
                        });
                        if (!clazzOptional.isPresent()) {
                            throw new HibernateException("Unable to determine the caller class");
                        }
                        return (Class)clazzOptional.get();
                    }
                    return SECURITY_ACTIONS.getCallerClass();
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new SecurityException("Unable to determine the caller class", e);
                }
            }
        };
        return System.getSecurityManager() != null ? (Class)AccessController.doPrivileged(getCallerClassAction) : (Class)getCallerClassAction.run();
    }

    static {
        authorizedClasses = ConcurrentHashMap.newKeySet();
        PrivilegedAction<Void> initializeGetCallerClassRequirementsAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Class<?> stackWalkerClass = null;
                try {
                    stackWalkerClass = Class.forName("java.lang.StackWalker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (stackWalkerClass != null) {
                    try {
                        Class<?> optionClass = Class.forName("java.lang.StackWalker$Option");
                        stackWalker = stackWalkerClass.getMethod("getInstance", optionClass).invoke(null, optionClass.getEnumConstants()[0]);
                        stackWalkerWalkMethod = stackWalkerClass.getMethod("walk", Function.class);
                        stackFrameGetDeclaringClass = Class.forName("java.lang.StackWalker$StackFrame").getMethod("getDeclaringClass", new Class[0]);
                    }
                    catch (Throwable e) {
                        throw new HibernateException("Unable to initialize the stack walker", e);
                    }
                }
                return null;
            }
        };
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(initializeGetCallerClassRequirementsAction);
        } else {
            initializeGetCallerClassRequirementsAction.run();
        }
        STACK_FRAME_GET_DECLARING_CLASS_FUNCTION = new Function<Object, Class<?>>(){

            @Override
            public Class<?> apply(Object t) {
                try {
                    return (Class)stackFrameGetDeclaringClass.invoke(t, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new HibernateException("Unable to get stack frame declaring class", e);
                }
            }
        };
    }

    private static class SecurityActions
    extends SecurityManager {
        private SecurityActions() {
        }

        private Class<?> getCallerClass() {
            return this.getClassContext()[7];
        }
    }
}

