/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.core;

import edu.harvard.catalyst.scheduler.util.MiscUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SchedulerRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LogManager.getLogger(SchedulerRuntimeException.class);

    private SchedulerRuntimeException(String message, Exception cause) {
        super(message, cause);
    }

    public SchedulerRuntimeException() {
        super("");
    }

    public SchedulerRuntimeException(Throwable cause) {
        super("", cause);
    }

    void log() {
        String message = this.getMessage();
        Throwable cause = this.getCause();
        String logMessage = cause != null ? message + " -- Cause: " + cause.getMessage() : message;
        this.logger.info("\n=====> " + logMessage);
        if (cause != null) {
            this.logger.info(MiscUtil.throwableToStackTraceString(cause));
        }
    }

    public static void logAndMaybeThrow(String message, boolean doThrow, Exception cause) {
        SchedulerRuntimeException sre = new SchedulerRuntimeException(message, cause);
        sre.log();
        if (doThrow) {
            throw sre;
        }
    }

    public static void logAndMaybeThrow(String message, boolean doThrow) {
        SchedulerRuntimeException.logAndMaybeThrow(message, doThrow, null);
    }

    public static void logDontThrow(String message, Exception cause) {
        SchedulerRuntimeException.logAndMaybeThrow(message, false, cause);
    }

    public static void logDontThrow(String message) {
        SchedulerRuntimeException.logAndMaybeThrow(message, false);
    }

    public static void logAndThrow(String message, Exception cause) {
        SchedulerRuntimeException.logAndMaybeThrow(message, true, cause);
    }

    public static void logAndThrow(String message) {
        SchedulerRuntimeException.logAndMaybeThrow(message, true);
    }
}

