/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import java.util.Map;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.AbstractBinder;

public class ServiceFinderBinder<T>
extends AbstractBinder {
    private final Class<T> contract;
    private final Map<String, Object> applicationProperties;
    private final RuntimeType runtimeType;

    public ServiceFinderBinder(Class<T> contract, Map<String, Object> applicationProperties, RuntimeType runtimeType) {
        this.contract = contract;
        this.applicationProperties = applicationProperties;
        this.runtimeType = runtimeType;
    }

    @Override
    protected void configure() {
        boolean METAINF_SERVICES_LOOKUP_DISABLE_DEFAULT = false;
        boolean disableMetainfServicesLookup = false;
        if (this.applicationProperties != null) {
            disableMetainfServicesLookup = CommonProperties.getValue(this.applicationProperties, this.runtimeType, "jersey.config.disableMetainfServicesLookup", false, Boolean.class);
        }
        if (!disableMetainfServicesLookup) {
            for (Class<T> t : ServiceFinder.find(this.contract, true).toClassArray()) {
                this.bind(t).to(this.contract);
            }
        }
    }
}

