/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.core;

import org.apache.log4j.Logger;

public final class SchedulerRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SchedulerRuntimeException.class);

    private SchedulerRuntimeException(String message, boolean log, Exception cause) {
        super(message, cause);
        if (log) {
            String logMessage = cause != null ? message + " -- Cause: " + cause.getMessage() : message;
            LOG.info((Object)logMessage);
        }
    }

    public static void logAndMaybeThrow(String message, boolean doThrow, Exception cause) {
        if (doThrow) {
            throw new SchedulerRuntimeException(message, true, cause);
        }
    }

    public static void logDontThrow(String message, Exception cause) {
        SchedulerRuntimeException.logAndMaybeThrow(message, false, cause);
    }

    public static void logDontThrow(String message) {
        SchedulerRuntimeException.logAndMaybeThrow(message, false, null);
    }

    public static void logAndThrow(String message, Exception cause) {
        SchedulerRuntimeException.logAndMaybeThrow(message, true, cause);
    }

    public static void logAndThrow(String message) {
        SchedulerRuntimeException.logAndMaybeThrow(message, true, null);
    }
}

