/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.Subject;
import java.util.Date;

public class SubjectDetailResponse {
    private Integer id;
    private String firstName;
    private String lastName;
    private String middleName;
    private int genderId;
    private String genderName;
    private int raceId;
    private String raceName;
    private int ethnicityId;
    private String ethnicityName;
    private Date birthdate;
    private String mrn;
    private String comment;
    private String streetAddress1;
    private String streetAddress2;
    private String city;
    private int stateId;
    private String stateName;
    private int countryId;
    private String countryName;
    private String zip;
    private String primaryContactNumber;
    private String secondaryContactNumber;
    private String subjectSchedulerId;

    public SubjectDetailResponse(Subject subject) {
        if (subject == null) {
            SchedulerRuntimeException.logAndThrow("Subject parameter should be non-null");
        }
        this.id = subject.getId();
        this.firstName = subject.getFirstName();
        this.lastName = subject.getLastName();
        this.middleName = subject.getMiddleName();
        this.genderId = subject.getGender().getId();
        this.genderName = subject.getGender().getName();
        this.raceId = subject.getRace().getId();
        this.raceName = subject.getRace().getName();
        this.ethnicityId = subject.getEthnicity().getId();
        this.ethnicityName = subject.getEthnicity().getName();
        this.birthdate = subject.getBirthdate();
        this.mrn = subject.getMrn();
        this.comment = subject.getComment();
        this.streetAddress1 = subject.getStreetAddress1();
        this.streetAddress2 = subject.getStreetAddress2();
        this.city = subject.getCity();
        if (subject.getState() != null) {
            this.stateId = subject.getState().getId();
            this.stateName = subject.getState().getName();
        }
        this.countryId = subject.getCountry().getId();
        this.countryName = subject.getCountry().getName();
        this.zip = subject.getZip();
        this.primaryContactNumber = subject.getPrimaryContactNumber();
        this.secondaryContactNumber = subject.getSecondaryContactNumber();
        this.subjectSchedulerId = subject.getSubjectSchedulerId();
    }
}

