/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.TemplateApprovalHistory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VisitApprovalModelResponseDTO {
    private List<VisitApproval> templateApprovals;

    VisitApprovalModelResponseDTO(List<VisitApproval> resourceList) {
        this.templateApprovals = resourceList;
    }

    public static List<VisitApproval> fromTemplateApprovalHistoryList(List<TemplateApprovalHistory> templateApprovalHistorys, Long total) {
        ArrayList<VisitApproval> resourceList = new ArrayList<VisitApproval>();
        for (TemplateApprovalHistory templateApprovalHistory : templateApprovalHistorys) {
            VisitApproval visitApproval = new VisitApproval(templateApprovalHistory, total);
            resourceList.add(visitApproval);
        }
        return resourceList;
    }

    public static class VisitApproval {
        private Integer id;
        private String userFullName;
        private Date statusChangeTime;
        private String comment;
        private Date visitCreatedDate;
        private String userRole;
        private String userTitle;
        private String approved;
        private String finalApproval;
        private Long totalCount;

        VisitApproval(TemplateApprovalHistory templateApprovalHistory, Long total) {
            if (templateApprovalHistory == null) {
                SchedulerRuntimeException.logAndThrow("TemplateApprovalHistory parameter should be non-null");
            }
            this.id = templateApprovalHistory.getId();
            this.userFullName = templateApprovalHistory.getUserFullName();
            this.statusChangeTime = templateApprovalHistory.getStatusChangeTime();
            this.comment = templateApprovalHistory.getComment();
            this.visitCreatedDate = templateApprovalHistory.getVisitCreatedDate();
            this.userRole = templateApprovalHistory.getUserRole();
            this.userTitle = templateApprovalHistory.getUserTitle();
            this.finalApproval = templateApprovalHistory.getVisitTemplate().getApproved() != false ? "Approved" : "Not Approved";
            this.approved = templateApprovalHistory.isApproved() ? "Approved" : "Not Approved";
            this.totalCount = total;
        }
    }
}

