/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="resource")
public class Resource
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -6852528504208574939L;
    private String name;
    private ResourceType resourceType;
    private Integer sharedResource;
    private List<Sublocation> sublocations;
    private List<ResourceAlternate> alternateResourceList;
    private List<ResourceAlternate> sourceResourceList;
    private List<ResourceSchedule> defaultScheduleList;
    private List<ResourceSchedule> overrideScheduleList;

    @Deprecated
    public Resource() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public Resource(Integer id, String name, ResourceType resourceType, Integer sharedResource, List<Sublocation> sublocations, List<ResourceAlternate> alternateResourceList, List<ResourceAlternate> sourceResourceList, List<ResourceSchedule> defaultScheduleList, List<ResourceSchedule> overrideScheduleList) {
        super(null);
        this.id = id;
        this.name = name;
        this.resourceType = resourceType;
        this.sharedResource = sharedResource;
        this.sublocations = sublocations;
        this.alternateResourceList = alternateResourceList;
        this.sourceResourceList = sourceResourceList;
        this.defaultScheduleList = defaultScheduleList;
        this.overrideScheduleList = overrideScheduleList;
    }

    @Column(name="name")
    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="shared_resource")
    @Basic(optional=true)
    public Integer getSharedResource() {
        return this.sharedResource;
    }

    public void setSharedResource(Integer sharedResource) {
        this.sharedResource = sharedResource;
    }

    @Column(name="type")
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @ManyToMany(fetch=FetchType.EAGER, targetEntity=Sublocation.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="resource_sublocation", joinColumns={@JoinColumn(name="resource")}, inverseJoinColumns={@JoinColumn(name="sublocation")})
    public List<Sublocation> getSublocations() {
        return this.sublocations;
    }

    public void setSublocations(List<Sublocation> sublocations) {
        this.sublocations = sublocations;
    }

    @Transient
    public List<ResourceAlternate> getAlternateResourceList() {
        return this.alternateResourceList;
    }

    public void setAlternateResourceList(List<ResourceAlternate> alternateResourceList) {
        this.alternateResourceList = alternateResourceList;
    }

    @Transient
    public List<ResourceAlternate> getSourceResourceList() {
        return this.sourceResourceList;
    }

    public void setSourceResourceList(List<ResourceAlternate> sourceResourceList) {
        this.sourceResourceList = sourceResourceList;
    }

    @Transient
    public List<ResourceSchedule> getDefaultScheduleList() {
        return this.defaultScheduleList;
    }

    public void setDefaultScheduleList(List<ResourceSchedule> defaultScheduleList) {
        this.defaultScheduleList = defaultScheduleList;
    }

    @Transient
    public List<ResourceSchedule> getOverrideScheduleList() {
        return this.overrideScheduleList;
    }

    public void setOverrideScheduleList(List<ResourceSchedule> overrideScheduleList) {
        this.overrideScheduleList = overrideScheduleList;
    }

    public String toString() {
        return "Resource [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

