/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class SiteDAO {
    @Autowired
    protected SessionFactory sessionFactory;

    public void createEntity(BaseEntity entity) {
        Session session = this.session();
        session.save((Object)entity);
        session.flush();
    }

    public void updateEntity(BaseEntity entity) {
        Session session = this.session();
        session.update((Object)entity);
        session.flush();
    }

    public void deleteEntity(BaseEntity entity) {
        Session session = this.session();
        session.delete((Object)entity);
        session.flush();
    }

    public <T extends BaseEntity> T findById(Class<T> entityClass, Integer id) {
        Criteria crit = this.newCriteria(entityClass);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        return (T)((BaseEntity)crit.uniqueResult());
    }

    public String findNameById(String tableName, Integer id, boolean first) {
        return first ? this.findFieldById(tableName, id, "firstName") : this.findFieldById(tableName, id, "name");
    }

    public String findNameById(String tableName, Integer id) {
        return this.findFieldById(tableName, id, "name");
    }

    public String findFieldById(String tableName, Integer id, String fieldName) {
        String findName = "SELECT table." + fieldName + " FROM " + tableName + " table  WHERE table.id = :id ";
        Query query = this.newQuery(findName);
        query.setParameter("id", (Object)id);
        query.setCacheable(true);
        String result = (String)query.uniqueResult();
        return result;
    }

    protected <T extends BaseEntity> List<T> findAll(Class<T> entityClass) {
        return this.newCriteria(entityClass).list();
    }

    public int findTotalByQuery(String sqlQuery) {
        BigInteger bi = (BigInteger)this.newSqlQuery(sqlQuery).uniqueResult();
        return bi.intValue();
    }

    Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    Criteria newCriteria(Class<? extends BaseEntity> entityClass) {
        return this.session().createCriteria(entityClass);
    }

    Query newQuery(String hql) {
        return this.session().createQuery(hql);
    }

    SQLQuery newSqlQuery(String sql) {
        return this.session().createSQLQuery(sql);
    }
}

