/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.LazyList;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Range;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.BookedVisitDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.GetTemplateResourceGroupDTO;
import edu.harvard.catalyst.scheduler.dto.TemplateResourceDTO;
import edu.harvard.catalyst.scheduler.dto.VisitCancelStatus;
import edu.harvard.catalyst.scheduler.dto.VisitTime;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.GanttComboResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttGroupablesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourceInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetSearchVisitResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudyVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.OverbookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceTimeBoundsAndCountResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithLlaListDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithTraListDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.HasEmail;
import edu.harvard.catalyst.scheduler.entity.HasFirstName;
import edu.harvard.catalyst.scheduler.entity.HasLastName;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.OverrideBookedResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceAnnotation;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.TimeBoundedIdentity;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.AppointmentConfirmer;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ConfirmationStatus;
import edu.harvard.catalyst.scheduler.service.ConflictChecker;
import edu.harvard.catalyst.scheduler.service.GanttInfoSortType;
import edu.harvard.catalyst.scheduler.service.PermutationGenerator;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Component;

@Component
public class AppointmentService {
    private static final int INCREMENT_FACTOR = 30;
    private final MailHandler mailHandler;
    private final AuthDAO authDAO;
    private final AuditService auditService;
    private final AppointmentDAO appointmentDAO;
    private final ResourceDAO resourceDAO;
    private final StudyDAO studyDAO;
    private final SubjectDAO subjectDAO;
    private final ConflictChecker conflictChecker;
    private final AppointmentConfirmer appointmentConfirmer;
    private final Object confirmationLock = new Object();
    private final Map<String, Function10<User, String, String, String, Integer, Integer, Boolean, Boolean, Date, Date, List<BookedVisitsResponse>>> filterBookedVisitsListOps = Maps.newHashMap((Map)ImmutableMap.builder().put((Object)"1", this::filterAppointmentsBySubjectLastName).put((Object)"2", this::filterAppointmentsByLocalId).put((Object)"3", this::filterAppointmentsBySubjectMRN).build());
    static final Comparator<BookedVisit> bookedVisitAvailabilityComparator = (o1, o2) -> o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
    static final Comparator<BookedResource> eventResourceComparator = (o1, o2) -> {
        int nameOrder = o1.getScheduledStartTime().compareTo(o2.getScheduledStartTime());
        if (nameOrder != 0) {
            return nameOrder;
        }
        return o1.getScheduledEndTime().compareTo(o2.getScheduledEndTime());
    };
    final ConflictChecker defaultConflictChecker = (visitTime, userSession, isInpatient) -> {
        List<BookedVisit> availableTimeSlots = this.searchAvailabilityData(visitTime, userSession, true, false, isInpatient);
        boolean resourcesAvailable = false;
        BookedVisit bookedVisit = availableTimeSlots.get(0);
        List<BookedResource> bookedResourceList = bookedVisit.getBookedResourceList();
        if (bookedResourceList != null && !bookedResourceList.isEmpty()) {
            resourcesAvailable = true;
            for (BookedResource br : bookedResourceList) {
                Boolean alternateResourceUsed = br.getTemplateResource().getAlternateResourceUsed();
                if (alternateResourceUsed == null || !alternateResourceUsed.booleanValue()) continue;
                visitTime.setAlternateResourceUsed("During the confirmation process, one or more of the resources you were trying to schedule became unavailable. Good news! A standard alternate was substituted and your appointment was confirmed. Please review the booked visit by clicking on the appointment block.");
            }
        }
        return resourcesAvailable;
    };

    @Autowired
    public AppointmentService(AppointmentDAO appointmentDAO, ResourceDAO resourceDAO, StudyDAO studyDAO, AuthDAO authDAO, AuditService auditService, MailHandler mailHandler, @Qualifier(value="subjectDaoConfigured") SubjectDAO subjectDAO) {
        this(appointmentDAO, resourceDAO, studyDAO, authDAO, auditService, mailHandler, subjectDAO, Optional.empty(), Optional.empty());
    }

    private static final <T> Optional<T> nullToEmpty(Optional<T> o) {
        return o != null ? o : Optional.empty();
    }

    public AppointmentService(AppointmentDAO appointmentDAO, ResourceDAO resourceDAO, StudyDAO studyDAO, AuthDAO authDAO, AuditService auditService, MailHandler mailHandler, SubjectDAO subjectDAO, Optional<ConflictChecker> conflictChecker, Optional<AppointmentConfirmer> appointmentConfirmer) {
        this.appointmentDAO = appointmentDAO;
        this.resourceDAO = resourceDAO;
        this.studyDAO = studyDAO;
        this.authDAO = authDAO;
        this.auditService = auditService;
        this.mailHandler = mailHandler;
        this.subjectDAO = subjectDAO;
        this.conflictChecker = AppointmentService.nullToEmpty(conflictChecker).orElse(this.defaultConflictChecker);
        this.appointmentConfirmer = AppointmentService.nullToEmpty(appointmentConfirmer).orElseGet(() -> new DefaultAppointmentConfirmer());
    }

    AppointmentService() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public GetStudyVisitsResponse getStudyVisits(String nullableFilterString, String ofSortBy, String ofOrderBy, Integer ofPage, Integer ofMaxResults, Integer ofStudyId, Boolean ofApproved) {
        return this.studyDAO.getStudyVisits(nullableFilterString, ofSortBy, ofOrderBy, ofPage, ofMaxResults, ofStudyId, ofApproved);
    }

    public GetSearchVisitResourceResponse getVisitResources(String ofSortBy, String ofOrderBy, Integer ofPage, Integer ofMaxResults, Integer ofVisitId) {
        return this.studyDAO.findTemplateResourcesByVisit(ofVisitId, ofSortBy, ofOrderBy, ofPage, ofMaxResults);
    }

    public List<VisitCommentsResponse.VisitComment> getAppointmentComments(int bookedVisitId) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        return this.appointmentDAO.findAppointmentCommentsByVisit(bookedVisit);
    }

    public BookedVisitDTO logViewBookedVisit(BookedVisitDTO bookedVisitDTO, User user, String ipAddress) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitDTO.getId());
        this.auditService.logAppointmentActivity(ipAddress, bookedVisit, user, "Appointment List View Detail", null, null);
        return bookedVisitDTO;
    }

    public BookedVisitDTO logIncompleteOverrideActions(BookedVisitDTO bv, User user, String ipAddress, String action) {
        BookedResource s = this.appointmentDAO.findBookedResourceById(bv.getId());
        this.auditService.logAppointmentOverrideActivity(ipAddress, s.getBookedVisit(), s.getResource(), user, action, null, null);
        return bv;
    }

    public List<CalendarVisitsResponse> getCalendarBookedVisits(int userId, String filterString, String filterId, Date startMonth, Date endMonth, String remoteHost, boolean homeView) {
        User user = this.authDAO.findUserById(userId);
        List<CalendarVisitsResponse> visits = this.getCalendarBookedVisitsByFilter(filterString, filterId, user, startMonth, endMonth, homeView);
        String action = "Appointment Calendar Viewed";
        if (homeView) {
            action = "HOME SCREEN - Appointment Calendar View.";
        }
        this.auditService.logViewActivity(remoteHost, user, action);
        return visits;
    }

    void setRooms(List<BookedVisit> visits) {
        if (visits != null) {
            for (BookedVisit bookedVisit : visits) {
                String rooms = " ";
                List<BookedResource> bookedResources = this.appointmentDAO.findRoomBookedResourcesByBookedVisit(bookedVisit.getId());
                if (bookedResources == null) continue;
                for (BookedResource bookedResource : bookedResources) {
                    if (!bookedResource.getResource().getResourceType().getName().equalsIgnoreCase("Room")) continue;
                    rooms = rooms + bookedResource.getResource().getName() + ", ";
                    bookedVisit.setRooms(rooms);
                }
            }
        }
    }

    List<CalendarVisitsResponse> getCalendarBookedVisitsByFilter(String filterString, String filterId, User user, Date startMonth, Date endMonth, boolean homeView) {
        List<Object> result = Lists.newArrayList();
        List<Study> userAccessibleStudies = null;
        if (user.isStudyStaff()) {
            userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
        }
        result = !filterId.isEmpty() ? this.filterCalendarVisitsResponses(filterString, filterId, user, startMonth, endMonth, homeView, result, userAccessibleStudies) : this.appointmentDAO.getCalendarBookedVisits(filterString, startMonth, endMonth, homeView, userAccessibleStudies, user.isStudyStaff());
        return result;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponses(String filterString, String filterId, User user, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result, List<Study> userAccessibleStudies) {
        List<CalendarVisitsResponse> filteredResult = filterId.equalsIgnoreCase("5") ? this.filterCalendarVisitsResponsesBySubjectLastName(filterString, startMonth, endMonth, homeView, result, userAccessibleStudies) : (filterId.equalsIgnoreCase("6") ? this.filterCalendarVisitsResponsesByStudyLocalId(filterString, user, startMonth, endMonth, homeView, result) : (filterId.equalsIgnoreCase("7") ? this.filterCalendarVisitsResponsesByResourceName(filterString, startMonth, endMonth, homeView, userAccessibleStudies) : this.filterBookedVisitsByAppointmentStatus(filterId, user, startMonth, endMonth, homeView, userAccessibleStudies)));
        return filteredResult;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesByResourceName(String filterString, Date startMonth, Date endMonth, boolean homeView, List<Study> userAccessibleStudies) {
        return this.appointmentDAO.findBookedVisitsByResource(filterString, userAccessibleStudies, startMonth, endMonth, homeView);
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesByStudyLocalId(String filterString, User user, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result) {
        List<Study> studyList = this.studyDAO.findStudyListByPersonAndLocalID(user, filterString);
        if (studyList.size() > 0) {
            return this.appointmentDAO.findAllBookedVisitsByStudy(studyList, startMonth, endMonth, homeView);
        }
        return result;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesBySubjectLastName(String filterString, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result, List<Study> userAccessibleStudies) {
        List<StudySubject> totalStudySubjectList;
        List<Subject> subjects = this.subjectDAO.filterSubjectByLastNames(filterString);
        if (subjects.size() > 0 && (totalStudySubjectList = this.studyDAO.findStudySubjectBySubjectListAndStudyList(subjects, userAccessibleStudies)).size() > 0) {
            return this.appointmentDAO.findAllBookedVisitsByStudySubject(totalStudySubjectList, startMonth, endMonth, homeView);
        }
        return result;
    }

    public List<CalendarVisitsResponse> filterBookedVisitsByAppointmentStatus(String filterId, User user, Date startMonth, Date endMonth, boolean homeView, List<Study> userAccessibleStudies) {
        int appointmentStatusId = Integer.parseInt(filterId);
        return this.appointmentDAO.findBookedVisitsByApppointmentStatus(appointmentStatusId, startMonth, endMonth, homeView, userAccessibleStudies, user.isStudyStaff());
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisitsHomeList(Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults, int userId, String remoteHost) {
        List<BookedVisitsResponse> visits;
        User user = this.authDAO.findUserById(userId);
        if (user.isStudyStaff()) {
            List<Study> userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
            visits = this.appointmentDAO.getOnlyTodaysBookedVisitsByStudy(userAccessibleStudies, startDate, endDate, sortBy, orderBy, page, maxResults);
        } else {
            visits = this.appointmentDAO.getOnlyTodaysBookedVisits(startDate, endDate, sortBy, orderBy, page, maxResults);
        }
        this.auditService.logViewActivity(remoteHost, user, "HOME SCREEN - Appointment List View.");
        return visits;
    }

    AppointmentStatus scheduledStatus() {
        return this.appointmentDAO.findScheduledStatus();
    }

    AppointmentStatus checkedInStatus() {
        return this.appointmentDAO.findCheckedInStatus();
    }

    AppointmentStatus checkedOutStatus() {
        return this.appointmentDAO.findCheckedOutStatus();
    }

    AppointmentStatus cancelledStatus() {
        return this.appointmentDAO.findCancelledStatus();
    }

    public BooleanResultDTO crudTemplateResources(TemplateResourceDTO trDto, String institution, String templatePath, String actionType, User user, String host) {
        trDto.setResult(true);
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(trDto.getVisitTemplate());
        if (actionType.equalsIgnoreCase("add_template_resource") || actionType.equalsIgnoreCase("copy_template_resource")) {
            Resource resource = this.resourceDAO.findResourceById(trDto.getResource());
            TemplateResource templateResource = new TemplateResource(trDto, resource, visitTemplate);
            this.appointmentDAO.createEntity(templateResource);
            this.createTemplateAnnotations(trDto, templateResource);
            this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
            this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE CREATE", null, null);
        } else if (actionType.equalsIgnoreCase("edit_template_resource")) {
            this.editTemplateResource(trDto, institution, templatePath, user, host, false);
        } else if (actionType.equalsIgnoreCase("edit_template_resource_check_diff_only")) {
            boolean updated = this.editTemplateResource(trDto, institution, templatePath, user, host, true);
            trDto.setResult(updated);
        } else if (actionType.equalsIgnoreCase("delete_template_resource")) {
            this.deleteTemplateResource(trDto, institution, templatePath);
            if (trDto.isResult()) {
                this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE DELETE", null, null);
            }
        }
        if (trDto.isResult()) {
            visitTemplate = this.studyDAO.findVisitById(trDto.getVisitTemplate());
            trDto.setInfoMsg(visitTemplate.getApproved() != false ? "Approved" : "Not Approved");
        }
        return trDto;
    }

    public void deleteTemplateResource(TemplateResourceDTO trDto, String institution, String templatePath) {
        TemplateResource selectedTemplateResource = this.appointmentDAO.findTemplateResourceById(trDto.getId());
        VisitTemplate visitTemplate = selectedTemplateResource.getVisitTemplate();
        if (this.deleteTemplateResourceValidation(trDto, selectedTemplateResource)) {
            if (AppointmentService.hasGroupId(selectedTemplateResource)) {
                List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(selectedTemplateResource.getGroupId());
                if (!selectedTemplateResource.getFloatable().booleanValue()) {
                    List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(selectedTemplateResource.getId())).collect(Collectors.toList());
                    if (this.areFlexResourcesLinkable(trDto, remainingTrs)) {
                        TemplateResourceGroup templateResourceGroup = this.appointmentDAO.findTemplateResourceGroup(selectedTemplateResource);
                        this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                        this.appointmentDAO.deleteEntity(templateResourceGroup);
                        this.appointmentDAO.deleteEntity(selectedTemplateResource);
                        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
                    }
                } else {
                    this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                    this.deleteTemplateResourceGroups(selectedTemplateResource, trgList);
                    this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
                }
            } else {
                this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                this.appointmentDAO.deleteEntity(selectedTemplateResource);
                this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
            }
        } else {
            trDto.setResult(false);
        }
    }

    public BooleanResultDTO checkIfResourcesLinkableOnDeleteUnlink(Integer templateResourceId, String longName, String templatePath) {
        BooleanResultDTO dto = new BooleanResultDTO();
        dto.setResult(true);
        TemplateResource selectedTemplateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(selectedTemplateResource.getGroupId());
        List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(selectedTemplateResource.getId())).collect(Collectors.toList());
        this.areFlexResourcesLinkable(dto, remainingTrs);
        Integer s = trgList.size();
        dto.setErrorMsg(s.toString());
        return dto;
    }

    void deleteTemplateResourceGroups(TemplateResource selectedTemplateResource, List<TemplateResourceGroup> trgList) {
        trgList.forEach(i -> {
            TemplateResource tr = this.resourceDAO.findTemplateResourceById(i.getTemplateResource().getId());
            tr.setGroupId(null);
            this.appointmentDAO.updateEntity(tr);
            this.appointmentDAO.deleteEntity((BaseEntity)i);
        });
        this.appointmentDAO.deleteEntity(selectedTemplateResource);
    }

    public boolean editTemplateResource(TemplateResourceDTO newTrDto, String institution, String templatePath, User user, String host, Boolean diffCheckOnly) {
        TemplateResource tr = this.appointmentDAO.findTemplateResourceById(newTrDto.getId());
        TemplateResourceDTO oldTrDto = new TemplateResourceDTO(tr, this.appointmentDAO);
        String updateString = oldTrDto.diffFromThisToOther(newTrDto);
        if (diffCheckOnly.booleanValue()) {
            return !updateString.equals("No Change");
        }
        boolean userUpdated = tr.possiblyUpdateMyNonResourceFields(newTrDto);
        userUpdated = this.possiblyUpdateThisTrsResourceField(newTrDto, tr) || userUpdated;
        userUpdated = this.possiblyUpdateThisTrsAnnotations(newTrDto, tr) || userUpdated;
        Date now = new Date();
        tr.setLastUpdateTime(now);
        this.appointmentDAO.updateEntity(tr);
        VisitTemplate visitTemplate = tr.getVisitTemplate();
        if (userUpdated) {
            this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
        }
        this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE RESOURCE", updateString, null);
        return userUpdated;
    }

    boolean possiblyUpdateThisTrsResourceField(TemplateResourceDTO trDto, TemplateResource tr) {
        boolean updated = false;
        if (tr.getResource().getId().intValue() != trDto.getResource()) {
            List<TemplateResourceAnnotations> currentTRAs = this.resourceDAO.findTemplateAnnotationsByTemplateResource(tr);
            currentTRAs.forEach(this.appointmentDAO::deleteEntity);
            Resource resource = this.resourceDAO.findResourceById(trDto.getResource());
            tr.setResource(resource);
            updated = true;
        }
        return updated;
    }

    public TemplateResource createTemplateResource(TemplateResourceDTO tr, String institution, String templatePath) {
        Resource resource = this.resourceDAO.findResourceById(tr.getResource());
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(tr.getVisitTemplate());
        TemplateResource templateResource = new TemplateResource(tr, resource, visitTemplate);
        this.appointmentDAO.createEntity(templateResource);
        this.createTemplateAnnotations(tr, templateResource);
        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
        return templateResource;
    }

    private void createTemplateAnnotations(TemplateResourceDTO tr, TemplateResource s) {
        if (!tr.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < tr.getSelectedAnnotations().size(); ++i) {
                TemplateResourceAnnotations tra = new TemplateResourceAnnotations();
                tra.setTemplateResource(s);
                tra.setLineLevelAnnotations(this.resourceDAO.findLineLevelAnnotationsById(tr.getSelectedAnnotations().get(i)));
                tra.setQuantity(tr.getSelectedAnnotationsQuantity().get(i));
                tra.setComment(tr.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(tra);
            }
        }
    }

    void sendVisitTemplateResourceUpdatedEmail(VisitTemplate visit, String institution, boolean newVisitResource, String templatePath) {
        String visitName = visit.getName();
        Study study = visit.getStudy();
        String studyName = study.getName();
        String localId = study.getLocalId();
        String catalystId = study.getCatalystId();
        String irb = study.getIrb();
        String prefix = newVisitResource ? "New Resource added to the visit Template : " : "Visit Template Resource has been updated : ";
        String title = prefix + visit.getName();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate newVisit = group.getInstanceOf("visitCreatedEmail");
        newVisit.setAttribute("institution", (Object)institution);
        newVisit.setAttribute("visitName", (Object)visitName);
        newVisit.setAttribute("studyName", (Object)studyName);
        newVisit.setAttribute("localId", (Object)localId);
        newVisit.setAttribute("catalystId", (Object)catalystId);
        newVisit.setAttribute("irb", (Object)irb);
        List<User> adminDirector = this.authDAO.findAdminDirectorUserByRole();
        List<User> nurseManager = this.authDAO.findNurseManagerUserByRole();
        List<User> nutritionManager = this.authDAO.findNutritionManagerUserByRole();
        List<User> finalApprover = this.authDAO.findFinalApproverByRole();
        boolean noProtocolNutritionist = study.getProtocolNutritionist() == null || study.getProtocolNutritionistString() == "N/A";
        boolean hasProtocolNutritionist = !noProtocolNutritionist;
        boolean noProtocolNurse = study.getProtocolNurse() == null || study.getProtocolNurseString() == "N/A";
        boolean hasProtocolNurse = !noProtocolNurse;
        boolean noScheduler = study.getScheduler() == null;
        boolean hasScheduler = !noScheduler;
        String schedulerEmail = hasScheduler ? study.getScheduler().getPreferredNotificationEmail() : "";
        String protocolNutritionistEmail = hasProtocolNutritionist ? study.getProtocolNutritionist().getPreferredNotificationEmail() : "";
        String protocolNurseEmail = hasProtocolNurse ? study.getProtocolNurse().getPreferredNotificationEmail() : "";
        Optional<String> none = Optional.empty();
        if (hasScheduler && noProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, none, none);
        } else if (noScheduler && hasProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(protocolNutritionistEmail, title, newVisit, none, none);
        } else if (noScheduler && noProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, none, none);
        } else if (hasScheduler && hasProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, Optional.of(protocolNutritionistEmail), none);
        } else if (hasScheduler && noProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, Optional.of(schedulerEmail), none);
        } else if (noScheduler && hasProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, Optional.of(protocolNutritionistEmail), none);
        } else if (hasScheduler && hasProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, Optional.of(protocolNurseEmail), Optional.of(study.getProtocolNutritionist().getEmail()));
        }
        this.sendMessagesToHigherUps(adminDirector, title, newVisit);
        this.sendMessagesToHigherUps(nurseManager, title, newVisit);
        this.sendMessagesToHigherUps(nutritionManager, title, newVisit);
        this.sendMessagesToHigherUps(finalApprover, title, newVisit);
    }

    private void sendMessagesToHigherUps(List<User> managers, String title, StringTemplate newVisit) {
        Function<User, SimpleMailMessage> toMessage = u -> new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(newVisit.toString()).build();
        ListUtils.enrich(managers).map(toMessage).forEach(this.mailHandler::sendOptionalEmails);
    }

    private void sendMessage(String recipient, String title, StringTemplate newVisit, Optional<String> ccRecipient, Optional<String> bccRecipient) {
        MailMessageBuilder builder = new MailMessageBuilder().to(recipient).subject(title).text(newVisit.toString());
        ccRecipient.ifPresent(builder::cc);
        bccRecipient.ifPresent(builder::bcc);
        this.mailHandler.sendOptionalEmails(builder.build());
    }

    public BooleanResultDTO updateTemplateResourcesBillable(Integer visitId, String templateResourcesCommaString, boolean isBillable) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(visitId);
        List templateResourcesId = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)templateResourcesCommaString)).stream().map(Integer::parseInt).collect(Collectors.toList());
        templateResourcesId.stream().forEach(trId -> {
            TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById((int)trId);
            templateResource.setBillable(isBillable);
            Date now = new Date();
            templateResource.setLastUpdateTime(now);
            this.appointmentDAO.updateEntity(templateResource);
        });
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            visitTemplate.setLastUpdateTime(new Date());
            this.appointmentDAO.updateEntity(visitTemplate);
        }
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanResultDTO updateTemplateResourceTime(Integer templateResourceId, String startDate, String endDate) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(templateResource.getVisitTemplate().getId());
        Date trStartDate = DateUtility.parse(DateUtility.gantt(), startDate);
        Date trEndDate = DateUtility.parse(DateUtility.gantt(), endDate);
        if (templateResource.getFloatable().booleanValue()) {
            int trStartDay = this.getTemplateResourceDay(trStartDate);
            int floatStart = trStartDay * 1440 + trStartDate.getHours() * 60 + trStartDate.getMinutes() - 1440;
            int trEndDay = this.getTemplateResourceDay(trEndDate);
            int floatEnd = trEndDay * 1440 + trEndDate.getHours() * 60 + trEndDate.getMinutes() - 1440;
            templateResource.setFloatStart(floatStart);
            templateResource.setFloatEnd(floatEnd);
        } else {
            templateResource.setStartDate(trStartDate);
            templateResource.setEndDate(trEndDate);
            this.computeAndSetDuration(templateResource);
        }
        templateResource.setLastUpdateTime(new Date());
        this.appointmentDAO.updateEntity(templateResource);
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            visitTemplate.setLastUpdateTime(new Date());
        }
        List<TemplateResource> templateResourcesByVisit = this.studyDAO.findTemplateResourcesByVisit(visitTemplate);
        int totalDuration = this.computeTotalDuration(visitTemplate, templateResourcesByVisit);
        visitTemplate.setDuration(totalDuration);
        this.appointmentDAO.updateEntity(visitTemplate);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public GanttResourceInfoDTO getGanttResourceInfo(Integer visitId, Integer trId, int dayOffset) {
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(trId);
        List<TemplateResource> allTrsForResourceAndVisit = this.studyDAO.findTemplateResourcesByVisitAndResource(visitId, templateResource.getResource().getId());
        GanttResourceInfoDTO ganttResourceInfo = new GanttResourceInfoDTO(allTrsForResourceAndVisit, dayOffset);
        return ganttResourceInfo;
    }

    void sendOverBookedVisitEmail(BookedVisit visit, String institution, String templatePath, List<String> conditions) {
        String visitName = visit.getName();
        Study study = visit.getStudy();
        String localId = study.getLocalId();
        String visitType = visit.getVisitType().getName();
        String sublocation = visit.getVisitTemplate().getSublocation().getName();
        Date startTime = visit.getScheduledStartTime();
        Date endTime = visit.getScheduledEndTime();
        NameAndEmail pi = NameAndEmail.of(study.getInvestigator());
        NameAndEmail primarySchedulingContact = NameAndEmail.of(study.getScheduler());
        NameAndEmail protoNurse = NameAndEmail.of(study.getProtocolNurse());
        NameAndEmail protoNutritionist = NameAndEmail.of(study.getProtocolNutritionist());
        String title = visitName + "," + "Local ID " + localId + "," + "was overbooked for " + visit.getScheduledStartTime();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate stringTemplate = group.getInstanceOf("overbookEmail");
        stringTemplate.setAttribute("institution", (Object)institution);
        stringTemplate.setAttribute("visitName", (Object)visitName);
        stringTemplate.setAttribute("localId", (Object)localId);
        stringTemplate.setAttribute("visitType", (Object)visitType);
        stringTemplate.setAttribute("sublocation", (Object)sublocation);
        stringTemplate.setAttribute("startTime", (Object)startTime);
        stringTemplate.setAttribute("endTime", (Object)endTime);
        stringTemplate.setAttribute("piName", (Object)pi.name);
        stringTemplate.setAttribute("piEmail", (Object)pi.email);
        stringTemplate.setAttribute("primarySchedulingContactName", (Object)primarySchedulingContact.name);
        stringTemplate.setAttribute("primarySchedulingContactEmail", (Object)primarySchedulingContact.email);
        stringTemplate.setAttribute("protoNurseName", (Object)protoNurse.name);
        stringTemplate.setAttribute("protoNurseEmail", (Object)protoNurse.email);
        stringTemplate.setAttribute("protoNutritionistName", (Object)protoNutritionist.name);
        stringTemplate.setAttribute("protoNutritionistEmail", (Object)protoNutritionist.email);
        stringTemplate.setAttribute("conditions", conditions);
        this.sendEmailNotifications(study, title, stringTemplate);
    }

    private void copyTemplateAnnotations(List<TemplateResourceAnnotations> tras, TemplateResource clonedRes) {
        ListUtils.enrich(tras).map(tra -> {
            TemplateResourceAnnotations clonedResAnn = new TemplateResourceAnnotations();
            clonedResAnn.setComment(tra.getComment());
            clonedResAnn.setLineLevelAnnotations(tra.getLineLevelAnnotations());
            clonedResAnn.setTemplateResource(clonedRes);
            clonedResAnn.setQuantity(tra.getQuantity());
            return clonedResAnn;
        }).forEach(this.studyDAO::createEntity);
    }

    int computeTotalDuration(VisitTemplate visitTemplate, List<TemplateResource> templateResourceList) {
        int latestEndTime;
        int earliestStartTime;
        if (templateResourceList.isEmpty()) {
            return 0;
        }
        if (visitTemplate.getRelativeTime().booleanValue()) {
            earliestStartTime = this.findEarliestInpatientStartTime(templateResourceList);
            latestEndTime = this.findLatestInpatientEndTime(templateResourceList);
        } else {
            earliestStartTime = this.findEarliestInpatientClockStartTime(templateResourceList);
            latestEndTime = this.findLatestInpatientEndTime(templateResourceList);
        }
        return latestEndTime - earliestStartTime;
    }

    public boolean populateCurrentDayCopyables(int visitId, int currentDay, List<TemplateResource> nonGroupTrsToCopy, List<TemplateResource> flexGroupedTrsToCopy, List<TemplateResource> floatGroupedTrsToCopy, List<TemplateResource> trsCandidatesForCopy) {
        Date selectedDateStartOfDay = DateUtility.toDate(DateUtility.TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN.plusDays(currentDay - 1));
        Date nextDateStartOfDay = DateUtility.toDate(DateUtility.TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN.plusDays(currentDay));
        trsCandidatesForCopy.addAll(this.getTemplateResourcesUsedBetween(visitId, selectedDateStartOfDay, nextDateStartOfDay));
        trsCandidatesForCopy.stream().forEach(tr -> {
            if (tr.getGroupId() == null) {
                if (tr.getFloatable().booleanValue()) {
                    this.checkIfSingleDayFloatResources(nonGroupTrsToCopy, selectedDateStartOfDay, nextDateStartOfDay, (TemplateResource)tr);
                } else {
                    nonGroupTrsToCopy.add((TemplateResource)tr);
                }
            } else if (tr.getFlexible().booleanValue()) {
                flexGroupedTrsToCopy.add((TemplateResource)tr);
            } else {
                this.checkIfSingleDayFloatResources(floatGroupedTrsToCopy, selectedDateStartOfDay, nextDateStartOfDay, (TemplateResource)tr);
            }
        });
        return nonGroupTrsToCopy.size() + floatGroupedTrsToCopy.size() > 0 || this.dayHasCopyableFlexGroups(flexGroupedTrsToCopy);
    }

    private void checkIfSingleDayFloatResources(List<TemplateResource> floatTrsToCopy, Date selectedDateStartOfDay, Date nextDateStartOfDay, TemplateResource tr) {
        Date floatStartLdt = DateUtility.minutesFromOriginToDate(tr.getFloatStart().intValue());
        Date floatEndLdt = DateUtility.minutesFromOriginToDate(tr.getFloatEnd().intValue());
        if ((floatStartLdt.after(selectedDateStartOfDay) || floatStartLdt.equals(selectedDateStartOfDay)) && floatEndLdt.before(nextDateStartOfDay)) {
            floatTrsToCopy.add(tr);
        }
    }

    public boolean isDayCopyable(int visitId, int currentDay) {
        return this.populateCurrentDayCopyables(visitId, currentDay, Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList());
    }

    public void copyDayVisitResources(int visitId, int currentDay, String targetDaysCommaString, String institution, String templatePath) {
        ArrayList trsCandidatesForCopy;
        ArrayList floatGroupedTrsToCopy;
        ArrayList flexGroupedTrsToCopy;
        ArrayList nonGroupTrsToCopy = Lists.newArrayList();
        boolean doCopy = this.populateCurrentDayCopyables(visitId, currentDay, nonGroupTrsToCopy, flexGroupedTrsToCopy = Lists.newArrayList(), floatGroupedTrsToCopy = Lists.newArrayList(), trsCandidatesForCopy = Lists.newArrayList());
        if (!doCopy) {
            return;
        }
        List<Integer> targetDayOffsets = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)targetDaysCommaString)).stream().map(Integer::parseInt).collect(Collectors.toList());
        this.copyNonGroupTrs(currentDay, nonGroupTrsToCopy, targetDayOffsets);
        this.copyFlexGroupTrs(currentDay, flexGroupedTrsToCopy, targetDayOffsets);
        this.copyFloatGroupTrs(currentDay, floatGroupedTrsToCopy, targetDayOffsets);
        VisitTemplate theVisit = ((TemplateResource)trsCandidatesForCopy.get(0)).getVisitTemplate();
        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, theVisit);
    }

    Map<String, List<TemplateResource>> groupTrsToGroupIdMapToLists(List<TemplateResource> groupedTrs) {
        HashMap result = Maps.newHashMap();
        groupedTrs.stream().forEach(tr -> {
            String groupId = tr.getGroupId();
            List trList = (List)result.get(groupId);
            if (trList == null) {
                trList = Lists.newArrayList();
                result.put(groupId, trList);
            }
            trList.add(tr);
        });
        return result;
    }

    void copyFloatGroupTrs(int currentDay, List<TemplateResource> floatGroupedTrsToCopy, List<Integer> targetDayOffsets) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(floatGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> aGroupsTrList = groupIdToTrList.get(groupId);
            this.copyGroupResources(currentDay, targetDayOffsets, aGroupsTrList);
        }
    }

    boolean flexGroupIsCopyable(List<TemplateResource> theGroupsTrgListFromThisDay, String groupId) {
        List<TemplateResourceGroup> theGroupsTrListFromTotalVisit = this.appointmentDAO.findTrgListByGroupId(groupId);
        return theGroupsTrgListFromThisDay.size() == theGroupsTrListFromTotalVisit.size();
    }

    boolean dayHasCopyableFlexGroups(List<TemplateResource> flexGroupedTrsToCopy) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(flexGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> theGroupsTrgListFromThisDay = groupIdToTrList.get(groupId);
            if (!this.flexGroupIsCopyable(theGroupsTrgListFromThisDay, groupId)) continue;
            return true;
        }
        return false;
    }

    void copyFlexGroupTrs(int currentDay, List<TemplateResource> flexGroupedTrsToCopy, List<Integer> targetDayOffsets) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(flexGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> theGroupsTrgListFromThisDay = groupIdToTrList.get(groupId);
            if (!this.flexGroupIsCopyable(theGroupsTrgListFromThisDay, groupId)) continue;
            this.copyGroupResources(currentDay, targetDayOffsets, theGroupsTrgListFromThisDay);
        }
    }

    void copyGroupResources(int currentDay, List<Integer> targetDayOffsets, List<TemplateResource> theGroupsTrgListFromThisDay) {
        for (Integer dayOffset : targetDayOffsets) {
            String newGroupId = UUID.randomUUID().toString();
            for (TemplateResource trToCopy : theGroupsTrgListFromThisDay) {
                List<TemplateResourceAnnotations> traList = this.studyDAO.findTemplateResourceAnnotationsByTemplateResource(trToCopy);
                TemplateResource clonedTr = this.copyTemplateResourceMostOfTheWay(currentDay, trToCopy, dayOffset);
                clonedTr.setGroupId(newGroupId);
                this.copyTemplateResourceFinalSteps(traList, clonedTr);
                TemplateResourceGroup templateResourceGroup = new TemplateResourceGroup();
                templateResourceGroup.setTemplateResource(clonedTr);
                templateResourceGroup.setGroupId(newGroupId);
                templateResourceGroup.setFlexGroup(clonedTr.getFlexible());
                templateResourceGroup.setVisit(clonedTr.getVisitTemplate());
                this.create(templateResourceGroup);
            }
        }
    }

    void copyNonGroupTrs(int currentDay, List<TemplateResource> nonGroupTrsToCopy, List<Integer> targetDayOffsets) {
        for (TemplateResource trToCopy : nonGroupTrsToCopy) {
            List<TemplateResourceAnnotations> traList = this.studyDAO.findTemplateResourceAnnotationsByTemplateResource(trToCopy);
            for (Integer dayOffset : targetDayOffsets) {
                TemplateResource clonedTr = this.copyTemplateResourceMostOfTheWay(currentDay, trToCopy, dayOffset);
                this.copyTemplateResourceFinalSteps(traList, clonedTr);
            }
        }
    }

    void copyTemplateResourceFinalSteps(List<TemplateResourceAnnotations> traList, TemplateResource clonedTr) {
        clonedTr.setId(null);
        this.studyDAO.createEntity(clonedTr);
        this.copyTemplateAnnotations(traList, clonedTr);
    }

    TemplateResource copyTemplateResourceMostOfTheWay(int currentDay, TemplateResource trToCopy, Integer dayOffset) {
        int dayDelta = dayOffset - currentDay;
        int minutesDelta = 1440 * dayDelta;
        TemplateResource clonedTr = trToCopy.cloneTemplateResource();
        LocalDateTime startPlusDelta = DateUtility.dateToLocalDateTime(trToCopy.getStartDate()).plusDays(dayDelta);
        LocalDateTime endPlusDelta = DateUtility.dateToLocalDateTime(trToCopy.getEndDate()).plusDays(dayDelta);
        clonedTr.setStartDate(DateUtility.toDate(startPlusDelta));
        clonedTr.setEndDate(DateUtility.toDate(endPlusDelta));
        Date now = new Date();
        clonedTr.setCreatedDate(now);
        clonedTr.setLastUpdateTime(now);
        if (trToCopy.getFloatable().booleanValue()) {
            clonedTr.setFloatStart(trToCopy.getFloatStart() + minutesDelta);
            clonedTr.setFloatEnd(trToCopy.getFloatEnd() + minutesDelta);
        }
        return clonedTr;
    }

    private boolean noGroupId(TemplateResource res) {
        return res.getGroupId() == null;
    }

    public ResourceTimeBoundsAndCountResponseDTO findTemplateResourceCountEarliestLatest(int visitId) {
        return this.studyDAO.findTemplateResourceCountEarliestLatest(visitId);
    }

    public List<TemplateResource> getTemplateResourcesUsedBetween(int visitId, Date selectedDayStartOfDay, Date nextDayStartOfDay) {
        List<TemplateResource> templateResourceResultList = this.studyDAO.getTemplateResourcesUsedOnDay(visitId, selectedDayStartOfDay, nextDayStartOfDay);
        return templateResourceResultList;
    }

    public List<TemplateResource> getSelectableTemplateResources(int visitId, GanttInfoSortType sortType, boolean isBillable) {
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visitId);
        return this.studyDAO.findTemplateResourcesByVisitAndBillable(visitTemplate, sortType.getSingleSortClause(), isBillable);
    }

    public List<TemplateResource> getTemplateResources(int visitId, boolean addQuantities) {
        return this.getTemplateResources(visitId, addQuantities, "");
    }

    public List<TemplateResource> getTemplateResources(int visitId, boolean addQuantities, String sortExpression) {
        List<TemplateResourceWithTraListDTO> trWithAnnotationsDtoList = this.studyDAO.findTemplateResourcesAndAnnotationsByVisit(visitId, sortExpression);
        ArrayList trsWithAnnotationsString = Lists.newArrayList();
        for (TemplateResourceWithTraListDTO trwaDto : trWithAnnotationsDtoList) {
            TemplateResource tr = trwaDto.getTemplateResource();
            tr.determineAnnotationsString(trwaDto.getTraList(), addQuantities);
            trsWithAnnotationsString.add(tr);
        }
        return trsWithAnnotationsString;
    }

    private static boolean hasGroupId(TemplateResource r) {
        return r.getGroupId() != null;
    }

    public TemplateResourceWithLlaListDTO getTemplateResourceDataWithAnnotations(int templateResourceId) {
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        List<TemplateResourceAnnotations> traList = this.resourceDAO.findTemplateAnnotationsByTemplateResource(templateResource);
        List<LineLevelAnnotations> llaList = this.getResourceAnnotations(templateResource.getResource().getId());
        for (int i = 0; i < traList.size(); ++i) {
            int indexOf = llaList.indexOf(traList.get(i).getLineLevelAnnotations());
            llaList.get(indexOf).setSelected(true);
            llaList.get(indexOf).setQuantity(traList.get(i).getQuantity());
            llaList.get(indexOf).setComment(traList.get(i).getComment());
            llaList.get(indexOf).setResourceAnnotations(traList.get(i).getId());
        }
        Collections.sort(llaList, new LineLevelAnnotations.AnnotationsComparator());
        TemplateResourceWithLlaListDTO templateResourceWithLlaListDTO = new TemplateResourceWithLlaListDTO(templateResource, llaList);
        return templateResourceWithLlaListDTO;
    }

    public List<TemplateResource> getUngroupedTemplateResourcesByType(int visitId, String templateResourceType) {
        VisitTemplate visit = this.studyDAO.findVisitById(visitId);
        return this.studyDAO.findUngroupedTemplateResourcesTypeByVisit(visit, templateResourceType);
    }

    public GanttComboResponseDTO getTemplateResourcesForGanttCombo(Integer visitId, int dayOffset, GanttInfoSortType sortType) {
        GanttComboResponseDTO result = new GanttComboResponseDTO();
        List<TemplateResource> allTrsForVisit = this.getTemplateResources(visitId, true, sortType.getSortClause());
        result.setInfoDayResources(this.getGanttInfoDay(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Resources));
        result.setInfoDayEvents(this.getGanttInfoDay(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoMultiResources(this.getGanttInfoMulti(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Resources));
        result.setInfoMultiEvents(this.getGanttInfoMulti(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoFloatResources(this.getGanttInfoFloat(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.ResourcesGroup));
        result.setInfoFloatEvents(this.getGanttInfoFloat(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoFlexResources(this.getGanttInfoFlex(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.ResourcesGroup));
        result.setInfoFlexEvents(this.getGanttInfoFlex(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        return result;
    }

    public GanttResponseDTO getGanttInfoDay(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.occursInOneDay() && tr.startDayOffsetMatches(dayOffset) && !tr.isGrouped());
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoMulti(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> !tr.occursInOneDay() && tr.resourceOverlapsDayOffset(dayOffset) && !tr.isGrouped());
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoFloat(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.isGrouped() && tr.resourceOverlapsDayOffset(dayOffset) && tr.getFloatable() != false);
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoFlex(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.isGrouped() && tr.resourceOverlapsDayOffset(dayOffset) && tr.getFlexible() != false);
        return ganttResponseDTO;
    }

    public GanttGroupablesResponseDTO getGanttInfoCandidateGroupables(Integer visitId, Integer templateResourceId, GanttResponseDTO.GanttGroupingType groupingType) {
        GanttGroupablesResponseDTO ganttGroupablesResponseDTO = groupingType.create(this.getTemplateResources(visitId, true), templateResourceId);
        return ganttGroupablesResponseDTO;
    }

    boolean possiblyUpdateThisTrsAnnotations(TemplateResourceDTO trDto, TemplateResource templateResource) {
        List<TemplateResourceAnnotations> currentTRAs = this.resourceDAO.findTemplateAnnotationsByTemplateResource(templateResource);
        ArrayList candidateTRAs = Lists.newArrayList();
        List<Integer> selectedAnnotationIDs = trDto.getSelectedAnnotations();
        for (int i = 0; i < selectedAnnotationIDs.size(); ++i) {
            LineLevelAnnotations lla = this.resourceDAO.findLineLevelAnnotationsById(selectedAnnotationIDs.get(i));
            TemplateResourceAnnotations tra = new TemplateResourceAnnotations();
            tra.setTemplateResource(templateResource);
            tra.setLineLevelAnnotations(lla);
            tra.setQuantity(trDto.getSelectedAnnotationsQuantity().get(i));
            tra.setComment(trDto.getSelectedAnnotationsComment().get(i));
            candidateTRAs.add(tra);
        }
        boolean updated = this.nonCoextensionalLists(candidateTRAs, currentTRAs);
        if (updated) {
            currentTRAs.forEach(this.appointmentDAO::deleteEntity);
            candidateTRAs.forEach(this.appointmentDAO::createEntity);
        }
        return updated;
    }

    <T> boolean nonCoextensionalLists(List<T> list1, List<T> list2) {
        HashSet set2;
        HashSet set1 = Sets.newHashSet(list1);
        return !set1.equals(set2 = Sets.newHashSet(list2));
    }

    public BooleanResultDTO unlinkOneResource(Integer deserterId, String institution, String templatePath) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(true);
        TemplateResource deserterTr = this.appointmentDAO.findTemplateResourceById(deserterId);
        if (deserterTr == null || deserterTr.getGroupId() == null) {
            booleanResultDTO.setResult(false);
            booleanResultDTO.setErrorMsg("Selected Resource does not exist, or is not linked in a group.");
            return booleanResultDTO;
        }
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(deserterTr.getGroupId());
        if (!trgList.isEmpty()) {
            if (trgList.get(0).getTemplateResource().getFloatable().booleanValue()) {
                this.unlinkDyadicGroup(institution, templatePath, trgList);
            } else {
                this.unlinkOneFromNonDyadicGroup(booleanResultDTO, institution, templatePath, deserterTr, trgList);
            }
        }
        return booleanResultDTO;
    }

    void unlinkDyadicGroup(String institution, String templatePath, List<TemplateResourceGroup> trgList) {
        for (TemplateResourceGroup trg : trgList) {
            this.lowLevelUnlinkOneTr(institution, templatePath, trg);
        }
    }

    void lowLevelUnlinkOneTr(String institution, String templatePath, TemplateResourceGroup theTrg) {
        Date now = new Date();
        VisitTemplate visitTemplate = theTrg.getVisit();
        TemplateResource theTr = theTrg.getTemplateResource();
        theTr.setGroupId(null);
        theTr.setLastUpdateTime(now);
        if (visitTemplate.getApproved().booleanValue()) {
            this.sendVisitTemplateResourceUpdatedEmail(theTr.getVisitTemplate(), institution, false, templatePath);
        }
        visitTemplate.setApproved(false);
        visitTemplate.setLastUpdateTime(now);
        this.update(visitTemplate, theTr);
        this.delete(theTrg);
    }

    BooleanResultDTO unlinkOneFromNonDyadicGroup(BooleanResultDTO booleanResultDTO, String institution, String templatePath, TemplateResource deserterTr, List<TemplateResourceGroup> trgList) {
        List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(deserterTr.getId())).collect(Collectors.toList());
        List deserterTrgsUnitList = trgList.stream().filter(trg -> trg.getTemplateResource().getId().equals(deserterTr.getId())).collect(Collectors.toList());
        if (this.similarResourcesAreLinkable(booleanResultDTO, remainingTrs)) {
            this.lowLevelUnlinkOneTr(institution, templatePath, (TemplateResourceGroup)deserterTrgsUnitList.get(0));
        }
        return booleanResultDTO;
    }

    public BooleanResultDTO unlinkGroup(String groupId, String institution, String templatePath) {
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(groupId);
        if (!trgList.isEmpty()) {
            trgList.stream().forEach(trg -> this.lowLevelUnlinkOneTr(institution, templatePath, (TemplateResourceGroup)trg));
        }
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO(true);
        return booleanResultDTO;
    }

    private void update(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::updateEntity, es);
    }

    private void delete(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::deleteEntity, es);
    }

    private void create(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::createEntity, es);
    }

    private void doDaoOp(Consumer<? super BaseEntity> op, BaseEntity ... es) {
        for (BaseEntity e : es) {
            op.accept(e);
        }
    }

    public BooleanResultDTO linkTemplateResourcesAsNewGroup(GetTemplateResourceGroupDTO booleanResultDTO, String institution, String templatePath) {
        boolean result = true;
        List<TemplateResource> templateResourceList = booleanResultDTO.getLinkResources().stream().map(this.appointmentDAO::findTemplateResourceById).collect(Collectors.toList());
        if (templateResourceList.isEmpty() || templateResourceList.contains(null)) {
            result = false;
        } else if (!this.similarResourcesAreLinkable(booleanResultDTO, templateResourceList)) {
            result = false;
        } else {
            this.linkTemplateResourcesAsNewGroup(templateResourceList, institution, templatePath);
        }
        booleanResultDTO.setResult(result);
        return booleanResultDTO;
    }

    void linkTemplateResourcesAsNewGroup(List<TemplateResource> templateResourceList, String institution, String templatePath) {
        String groupId = UUID.randomUUID().toString();
        for (TemplateResource templateResource : templateResourceList) {
            TemplateResourceGroup templateResourceGroup = new TemplateResourceGroup();
            VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(templateResource.getVisitTemplate().getId());
            templateResourceGroup.setTemplateResource(templateResource);
            templateResource.setGroupId(groupId);
            if (visitTemplate.getApproved().booleanValue()) {
                this.sendVisitTemplateResourceUpdatedEmail(visitTemplate, institution, false, templatePath);
            }
            Date now = new Date();
            templateResource.setLastUpdateTime(now);
            visitTemplate.setLastUpdateTime(now);
            visitTemplate.setApproved(Boolean.FALSE);
            templateResourceGroup.setGroupId(groupId);
            templateResourceGroup.setFlexGroup(templateResource.getFlexible());
            templateResourceGroup.setVisit(visitTemplate);
            this.update(visitTemplate, templateResource);
            this.create(templateResourceGroup);
        }
    }

    boolean similarResourcesAreLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        boolean floatables = templateResourceList.get(0).getFloatable();
        if (floatables) {
            return this.areFloatResourcesLinkable(booleanResultDTO, templateResourceList);
        }
        return this.areFlexResourcesLinkable(booleanResultDTO, templateResourceList);
    }

    boolean areFlexResourcesLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        String statusMsg = TemplateResource.isValidFlexGroup(templateResourceList);
        return this.isLinkableResourcesMsg(booleanResultDTO, statusMsg, templateResourceList.get(0));
    }

    boolean areFloatResourcesLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        String statusMsg = TemplateResource.isValidFloatGroup(templateResourceList);
        return this.isLinkableResourcesMsg(booleanResultDTO, statusMsg, templateResourceList.get(0));
    }

    private boolean isLinkableResourcesMsg(BooleanResultDTO booleanResultDTO, String statusMsg, TemplateResource templateResource) {
        if (!statusMsg.equalsIgnoreCase("OK")) {
            booleanResultDTO.setResult(false);
            booleanResultDTO.setErrorMsg(statusMsg);
            booleanResultDTO.setInfoMsg(templateResource.getGroupId());
            return false;
        }
        return true;
    }

    private void deleteTemplateResourceAnnotations(TemplateResource selectedTemplateResource) {
        List<TemplateResourceAnnotations> templateResourceAnnotations = this.appointmentDAO.findTemplateResourceAnnotationsByTemplateResource(selectedTemplateResource);
        templateResourceAnnotations.forEach(this.appointmentDAO::deleteEntity);
    }

    boolean deleteTemplateResourceValidation(TemplateResourceDTO templateResourceDTO, TemplateResource selectedTemplateResource) {
        boolean isResourceBooked = this.appointmentDAO.findBookedResourcesByBookedVisit(selectedTemplateResource);
        if (isResourceBooked) {
            templateResourceDTO.setInfoMsg("resource is booked");
            templateResourceDTO.setErrorMsg("At least one visit has been scheduled from this visit template, so you cannot delete a resource. Please create a new visit template with the current list of resources.");
            return false;
        }
        return true;
    }

    void adjustDurationUnapproveAndUpdateVisitTemplate(String institution, String templatePath, VisitTemplate visitTemplate) {
        List<TemplateResource> templateResourcesByVisit = this.studyDAO.findTemplateResourcesByVisit(visitTemplate);
        int totalDuration = this.computeTotalDuration(visitTemplate, templateResourcesByVisit);
        visitTemplate.setDuration(totalDuration);
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            this.sendVisitTemplateResourceUpdatedEmail(visitTemplate, institution, true, templatePath);
        }
        visitTemplate.setLastUpdateTime(new Date());
        this.appointmentDAO.updateEntity(visitTemplate);
    }

    TemplateResource findAvailableResource(TemplateResource resource, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        List<ResourceAlternate> resourceAltList;
        boolean isAvailable = this.checkAvailability(resource, availableBookedResourceSlots, availableResourceSlots);
        if (this.checkIfReturnResource(resource, rejectedCheck, isAvailable, (resourceAltList = this.getResourceAlternates(resource)).isEmpty())) {
            return resource;
        }
        if (this.checkIfReturnNull(resource, rejectedCheck, resourceAltList.isEmpty())) {
            return null;
        }
        TemplateResource altResource = this.checkForStandardAlternate(resourceAltList, resource, availableBookedResourceSlots, availableResourceSlots);
        if (altResource != null && altResource.getAlternateResourceUsed().booleanValue()) {
            return altResource;
        }
        if (rejectedCheck && !this.isNotFixedResource(resource)) {
            resource.setAlternateResourceUsed(true);
            return resource;
        }
        return null;
    }

    private List<ResourceAlternate> getResourceAlternates(TemplateResource resource) {
        return this.resourceDAO.findResourceAlternates(resource.getResource());
    }

    private TemplateResource checkForStandardAlternate(List<ResourceAlternate> resourceAltList, TemplateResource resource, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        Function<ResourceAlternate, TemplateResource> toTemplateResource = resourceAlternate -> {
            TemplateResource altResource = this.createTempResourceSlot(resourceAlternate.getAlternateResource(), resource);
            altResource.setAlternateResourceUsed(false);
            return altResource;
        };
        Predicate<TemplateResource> isAvailable = tr -> this.checkAvailability((TemplateResource)tr, availableBookedResourceSlots, availableResourceSlots);
        Optional available = LazyList.lazy(resourceAltList).map(toTemplateResource).find(isAvailable);
        return available.map(altResource -> {
            altResource.setAlternateResourceUsed(true);
            altResource.setResourceGroupType(resource.getResourceGroupType());
            return altResource;
        }).orElse(null);
    }

    private boolean checkIfReturnNull(TemplateResource resource, boolean rejectedCheck, boolean resourceAltList) {
        return !rejectedCheck && (!resource.getAlternate() || resourceAltList) || rejectedCheck && resourceAltList && this.isNotFixedResource(resource);
    }

    private boolean isNotFixedResource(TemplateResource resource) {
        return resource.getFloatable() != false || AppointmentService.hasGroupId(resource) && resource.getFlexible() != false;
    }

    private boolean checkIfReturnResource(TemplateResource resource, boolean rejectedCheck, boolean isAvailable, boolean resourceAltListEmpty) {
        return isAvailable || rejectedCheck && !resource.getAlternate() || rejectedCheck && resourceAltListEmpty && this.isFixedResource(resource);
    }

    private boolean isFixedResource(TemplateResource resource) {
        return resource.getFloatable() == false && this.noGroupId(resource) && resource.getFlexible() == false;
    }

    TemplateResource createTempResourceSlot(Resource selectedResource, TemplateResource resource) {
        TemplateResource slot = resource.cloneTemplateResource();
        slot.setResource(selectedResource);
        return slot;
    }

    Map<Date, List<ResourceSchedule>> retrieveResourceOverrideSchedule(Resource resource, Date startTime, Date endTime) {
        HashMap<Date, List<ResourceSchedule>> dayOfWeekSchedule = new HashMap<Date, List<ResourceSchedule>>();
        List<ResourceSchedule> overrideScheduleList = this.resourceDAO.findExceptionSchedule(resource, startTime, endTime, true);
        if (!overrideScheduleList.isEmpty()) {
            this.populateOverrideScheduleByDate(overrideScheduleList, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    void populateSublocationClosureIntervalScheduleByDate(List<SublocationClosureInterval> resourceScheduleCollection, Map<Date, List<SublocationClosureInterval>> dayOfWeekSchedule) {
        if (resourceScheduleCollection != null && !resourceScheduleCollection.isEmpty()) {
            for (SublocationClosureInterval rs : resourceScheduleCollection) {
                Map<Date, String> weekDays = this.retrieveDaysOfWeek(rs.getStartTime(), rs.getEndTime());
                if (weekDays == null) continue;
                for (Map.Entry<Date, String> entry : weekDays.entrySet()) {
                    Date dayOfWeek = entry.getKey();
                    List<Object> schedules = dayOfWeekSchedule.containsKey(dayOfWeek) ? dayOfWeekSchedule.get(dayOfWeek) : new ArrayList();
                    SublocationClosureInterval es = this.createNewSublocationClosureIntervalByDate(rs, entry.getKey());
                    schedules.add(es);
                    dayOfWeekSchedule.put(dayOfWeek, schedules);
                }
            }
        }
    }

    void populateOverrideScheduleByDate(List<ResourceSchedule> resourceScheduleCollection, Map<Date, List<ResourceSchedule>> dayOfWeekSchedule) {
        if (resourceScheduleCollection != null && !resourceScheduleCollection.isEmpty()) {
            for (ResourceSchedule rs : resourceScheduleCollection) {
                Map<Date, String> weekDays = this.retrieveDaysOfWeek(rs.getStartTime(), rs.getEndTime());
                if (weekDays == null) continue;
                for (Map.Entry<Date, String> entry : weekDays.entrySet()) {
                    Date dayOfWeek = entry.getKey();
                    List<Object> schedules = dayOfWeekSchedule.containsKey(dayOfWeek) ? dayOfWeekSchedule.get(dayOfWeek) : new ArrayList();
                    ResourceSchedule es = this.createNewExceptionScheduleByDate(rs, entry.getKey());
                    schedules.add(es);
                    dayOfWeekSchedule.put(dayOfWeek, schedules);
                }
            }
        }
    }

    Map<Date, String> retrieveDaysOfWeek(Date startDate, Date endDate) {
        return this.buildSearchDates(startDate, endDate);
    }

    ResourceSchedule createNewExceptionScheduleByDate(ResourceSchedule curSchedule, Date startDate) {
        ResourceSchedule es = new ResourceSchedule();
        es.setDayOfWeek(null);
        es.setEndTime(startDate);
        es.setEndTime(curSchedule.getEndTime());
        es.setId(curSchedule.getId());
        es.setQuantity(curSchedule.getQuantity());
        es.setStartTime(startDate);
        es.setStartTime(curSchedule.getStartTime());
        return es;
    }

    SublocationClosureInterval createNewSublocationClosureIntervalByDate(SublocationClosureInterval curSchedule, Date startDate) {
        SublocationClosureInterval es = new SublocationClosureInterval();
        es.setEndTime(startDate);
        es.setEndTime(curSchedule.getEndTime());
        es.setId(curSchedule.getId());
        es.setStartTime(startDate);
        es.setStartTime(curSchedule.getStartTime());
        return es;
    }

    Map<Date, String> buildSearchDates(Date startDate, Date endDate) {
        TreeMap<Date, String> searchDates = new TreeMap<Date, String>();
        Calendar cal = Calendar.getInstance();
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        if (diff == 0) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, 0, 0, 0);
            this.searchDatesMapping(searchDates, cal, curDate);
        } else if (diff > 0) {
            for (int count = 0; count <= diff; ++count) {
                Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
                this.searchDatesMapping(searchDates, cal, curDate);
            }
        }
        return searchDates;
    }

    void searchDatesMapping(Map<Date, String> searchDates, Calendar cal, Date curDate) {
        cal.clear();
        cal.setTime(curDate);
        int day = cal.get(7);
        String dayOfWeek = null;
        switch (day) {
            case 1: {
                dayOfWeek = "SUN";
                break;
            }
            case 2: {
                dayOfWeek = "MON";
                break;
            }
            case 3: {
                dayOfWeek = "TUE";
                break;
            }
            case 4: {
                dayOfWeek = "WED";
                break;
            }
            case 5: {
                dayOfWeek = "THU";
                break;
            }
            case 6: {
                dayOfWeek = "FRI";
                break;
            }
            case 7: {
                dayOfWeek = "SAT";
            }
        }
        searchDates.put(curDate, dayOfWeek);
    }

    void populateDefaultSchedule(List<ResourceSchedule> rsList, Map<String, List<ResourceSchedule>> dayOfWeekSchedule) {
        for (ResourceSchedule rs : rsList) {
            String resourceDay = this.getDayOfWeekString(rs);
            if (dayOfWeekSchedule.get(resourceDay) == null) {
                ArrayList schedules = new ArrayList();
                dayOfWeekSchedule.put(resourceDay, schedules);
            }
            dayOfWeekSchedule.get(resourceDay).add(rs);
        }
    }

    private String getDayOfWeekString(ResourceSchedule rs) {
        String ss = null;
        switch (rs.getDayOfWeek()) {
            case 1: {
                ss = "SUN";
                break;
            }
            case 2: {
                ss = "MON";
                break;
            }
            case 3: {
                ss = "TUE";
                break;
            }
            case 4: {
                ss = "WED";
                break;
            }
            case 5: {
                ss = "THU";
                break;
            }
            case 6: {
                ss = "FRI";
                break;
            }
            case 7: {
                ss = "SAT";
            }
        }
        return ss;
    }

    void addToBookedVisit(List<TemplateResource> resources, BookedVisit bookedVisit) {
        List<BookedResource> bookedResources = bookedVisit.getBookedResourceList();
        String rooms = bookedVisit.getRooms();
        if (rooms == null) {
            rooms = " ";
        }
        if (bookedResources == null) {
            bookedResources = new ArrayList<BookedResource>();
        }
        for (TemplateResource resource : resources) {
            BookedResource bookedResource = this.createBookedResource(resource, bookedVisit);
            bookedResources.add(bookedResource);
            if (!bookedResource.getResource().getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = rooms + bookedResource.getResource().getName() + ", ";
            bookedVisit.setRooms(rooms);
        }
        bookedVisit.setBookedResourceList(bookedResources);
    }

    BookedResource createBookedResource(TemplateResource resource, BookedVisit bookedVisit) {
        BookedResource bookedResource = new BookedResource();
        bookedResource.setId(4567);
        bookedResource.setBookedVisit(bookedVisit);
        bookedResource.setDuration(resource.getDuration());
        bookedResource.setScheduledStartTime(resource.getScheduledStartTime());
        bookedResource.setScheduledEndTime(resource.getScheduledEndTime());
        bookedResource.setResource(resource.getResource());
        bookedResource.setTemplateResource(resource);
        bookedResource.setAvailable(resource.getAvailable());
        bookedResource.setRejectedResourceMessage(resource.getRejectedResourceMessage());
        bookedResource.setBillable(resource.getBillable());
        return bookedResource;
    }

    boolean checkAvailability(TemplateResource requestResource, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        requestResource.setRejectedResourceMessage("");
        requestResource.setAvailable("Yes");
        if (this.checkIfSublocationClosed(requestResource)) {
            return false;
        }
        List<BookedResource> reservedResourceTimeList = this.appointmentDAO.findOverbookConflictResourcesByVisitStatus(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime());
        Map<String, List<ResourceSchedule>> resourceDefaultSchedule = this.retrieveResourceDefaultSchedule(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime());
        TreeMap<Date, List<ResourceSchedule>> defaultScheduleMap = this.loadRelevantDaysOfDefaultSchedule(requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime(), resourceDefaultSchedule);
        List<ResourceSchedule> resourceOverrideSchedule = this.resourceDAO.findTemporaryAdjustmentsByResource(requestResource.getResource(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime(), true);
        Map<Integer, Integer> periodToQuantityOverrideMap = this.loadPeriodToQuantityOverrideMap(requestResource, resourceOverrideSchedule);
        Map<Integer, Integer> periodToQuantityDefaultAvailableMap = this.loadPeriodToQuantityDefaultScheduleMap(defaultScheduleMap);
        Map<Integer, Integer> finalScheduleTreeMap = this.updateDefaultMapWithOverrideMap(periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap);
        return this.checkResourceAvailability(requestResource, reservedResourceTimeList, periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap, finalScheduleTreeMap, availableBookedResourceSlots, availableResourceSlots);
    }

    private boolean checkResourceAvailability(TemplateResource requestResource, List<BookedResource> reservedResourceTimeList, Map<Integer, Integer> periodToQuantityOverrideMap, Map<Integer, Integer> periodToQuantityDefaultAvailableMap, Map<Integer, Integer> finalScheduleTreeMap, List<BookedResource> availableBookedResourceSLots, List<TemplateResource> availableResourceSlots) {
        if (!this.isResourceTimeSlotAvailable(requestResource, reservedResourceTimeList, finalScheduleTreeMap, periodToQuantityOverrideMap, periodToQuantityDefaultAvailableMap, availableBookedResourceSLots, availableResourceSlots)) {
            requestResource.setAvailable("No");
            return false;
        }
        return true;
    }

    private Map<Integer, Integer> updateDefaultMapWithOverrideMap(Map<Integer, Integer> periodToQuantityOverrideMap, Map<Integer, Integer> periodToQuantityDefaultAvailableMap) {
        TreeMap<Integer, Integer> finalScheduleTreeMap = new TreeMap<Integer, Integer>();
        finalScheduleTreeMap.putAll(periodToQuantityDefaultAvailableMap);
        for (Integer key : periodToQuantityOverrideMap.keySet()) {
            Integer value = periodToQuantityOverrideMap.get(key);
            finalScheduleTreeMap.put(key, value);
        }
        return finalScheduleTreeMap;
    }

    private boolean checkIfSublocationClosed(TemplateResource requestResource) {
        ResourceSublocation resourceSublocation = this.studyDAO.findSublocationByResource(requestResource.getResource());
        boolean isResourceSublocationClosed = this.appointmentDAO.isSublocationClosed(resourceSublocation.getSublocation(), requestResource.getScheduledStartTime(), requestResource.getScheduledEndTime());
        if (isResourceSublocationClosed) {
            requestResource.setAvailable("No");
            requestResource.setRejectedResourceMessage("Sub-Location Closure");
            return true;
        }
        return false;
    }

    private Map<Integer, Integer> loadPeriodToQuantityDefaultScheduleMap(TreeMap<Date, List<ResourceSchedule>> defaultScheduleMap) {
        TreeMap<Integer, Integer> periodToQuantityDefaultAvailableMap = new TreeMap<Integer, Integer>();
        if (!defaultScheduleMap.isEmpty()) {
            int dayNumber = -1;
            for (Date date : defaultScheduleMap.navigableKeySet()) {
                List<ResourceSchedule> scheduleList = defaultScheduleMap.get(date);
                ++dayNumber;
                if (scheduleList == null) continue;
                for (ResourceSchedule schedule : scheduleList) {
                    this.loadResourceScheduleIntoPeriodToQuantityMap(schedule, periodToQuantityDefaultAvailableMap, dayNumber);
                }
            }
        }
        return periodToQuantityDefaultAvailableMap;
    }

    private Map<Integer, Integer> loadPeriodToQuantityOverrideMap(TemplateResource requestResource, List<ResourceSchedule> resourceOverrideSchedule) {
        TreeMap<Integer, Integer> periodToQuantityOverrideMap = new TreeMap<Integer, Integer>();
        Date baseDate = requestResource.getScheduledStartTime();
        if (!resourceOverrideSchedule.isEmpty()) {
            List<TimeBoundedIdentity> overrideScheduleList = ResourceSchedule.toTimeBoundedIdentityList(resourceOverrideSchedule);
            for (TimeBoundedIdentity overrideSchedule : overrideScheduleList) {
                Date startTimeDate = overrideSchedule.getStartTime();
                Date endTimeDate = overrideSchedule.getEndTime();
                int firstPeriod = this.computeDate2PeriodRelativeToDate1(baseDate, startTimeDate);
                int lastPeriod = this.computeLastPeriod(baseDate, endTimeDate);
                this.loadIntoPeriodToQuantityMap(overrideSchedule.getQuantity(), firstPeriod, lastPeriod, periodToQuantityOverrideMap);
            }
        }
        return periodToQuantityOverrideMap;
    }

    TreeMap<Date, List<ResourceSchedule>> loadRelevantDaysOfDefaultSchedule(Date firstDay, Date lastDay, Map<String, List<ResourceSchedule>> resourceDefaultSchedule) {
        TreeMap<Date, List<ResourceSchedule>> result = new TreeMap<Date, List<ResourceSchedule>>();
        Date last_day = DateUtility.nextDay(lastDay);
        Map<Date, String> dateToWeekdayMap = this.retrieveDaysOfWeek(firstDay, last_day);
        for (Map.Entry<Date, String> mapEntry : dateToWeekdayMap.entrySet()) {
            Date date = mapEntry.getKey();
            String weekDay = mapEntry.getValue();
            List<ResourceSchedule> todayScheduleList = resourceDefaultSchedule.get(weekDay);
            result.put(date, todayScheduleList);
        }
        return result;
    }

    int computePeriodOfDate(Date date) {
        int minutes = this.computeMinutesFromHrsAndMins(date);
        return minutes / 15;
    }

    int computeDate2PeriodRelativeToDate1(Date date1, Date date2) {
        int numberOfDays = DateUtility.day2minusDay1(date1, date2);
        return numberOfDays * 96 + this.computePeriodOfDate(date2);
    }

    int computeLastPeriod(Date date1, Date date2) {
        int period1 = this.computePeriodOfDate(date1);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        int offset = calendar1.get(16);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar2.set(16, offset);
        long differenceInMillis = calendar2.getTimeInMillis() - calendar1.getTimeInMillis() - 60000L;
        int diffInPeriods = (int)Math.ceil(differenceInMillis / 60000L / 15L);
        return period1 + diffInPeriods;
    }

    boolean isResourceTimeSlotAvailable(TemplateResource candidateTemplateResource, List<BookedResource> reservedResourceTimeList, Map<Integer, Integer> candidatePeriodToQtyMap, Map<Integer, Integer> candidatePeriodToQtyOverrideMap, Map<Integer, Integer> candidatePeriodToQtyDefaultMap, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        boolean isAvailable = true;
        this.adjustMapsForBookedResource(candidateTemplateResource, candidatePeriodToQtyMap, reservedResourceTimeList);
        if (availableBookedResourceSlots != null) {
            this.adjustMapsForBookedResource(candidateTemplateResource, candidatePeriodToQtyMap, availableBookedResourceSlots);
        }
        Date candidateStartDate = candidateTemplateResource.getScheduledStartTime();
        Date candidateEndDate = candidateTemplateResource.getScheduledEndTime();
        int firstPeriod = this.computePeriodOfDate(candidateStartDate);
        int lastPeriod = this.computeLastPeriod(candidateStartDate, candidateEndDate);
        if (availableResourceSlots != null && !availableResourceSlots.isEmpty()) {
            for (TemplateResource templateResource : availableResourceSlots) {
                if (!this.isBookedResourceEqualToTemplateResourceId(candidateTemplateResource.getResource(), templateResource.getResource()) || !this.ifDatesOverlap(candidateStartDate, candidateEndDate, templateResource.getScheduledStartTime(), templateResource.getScheduledEndTime())) continue;
                int usedFirstPeriod = this.computePeriodOfDate(templateResource.getScheduledStartTime());
                int usedLastPeriod = this.computeLastPeriod(templateResource.getScheduledStartTime(), templateResource.getScheduledEndTime());
                for (int i = usedFirstPeriod; i <= usedLastPeriod; ++i) {
                    this.adjustMapsForProvisionalAllocation(i, candidatePeriodToQtyMap);
                }
            }
        }
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer currentQuantity = candidatePeriodToQtyMap.get(i);
            isAvailable = this.setMessageIfUnavailable(i, currentQuantity, candidateTemplateResource, candidatePeriodToQtyOverrideMap, candidatePeriodToQtyDefaultMap, isAvailable);
            if (isAvailable) continue;
            return isAvailable;
        }
        return isAvailable;
    }

    boolean ifDatesOverlap(Date candidateStartTime, Date candidateEndTime, Date existingStartTime, Date existingEndTime) {
        if (existingStartTime != null && existingEndTime != null) {
            return candidateStartTime.getTime() < existingEndTime.getTime() && existingStartTime.getTime() < candidateEndTime.getTime();
        }
        return false;
    }

    private boolean isBookedResourceEqualToTemplateResourceId(Resource candidateTemplateResource, Resource resource) {
        return resource.getId().equals(candidateTemplateResource.getId());
    }

    private void adjustMapsForBookedResource(TemplateResource candidateTemplateResource, Map<Integer, Integer> candidatePeriodToQtyMap, List<BookedResource> availableBookedResourceSlots) {
        for (BookedResource bookedResource : availableBookedResourceSlots) {
            Date reservedStartDate = bookedResource.getScheduledStartTime();
            Date reservedEndDate = bookedResource.getScheduledEndTime();
            Date candidateStartDate = candidateTemplateResource.getScheduledStartTime();
            Date candidateEndDate = candidateTemplateResource.getScheduledEndTime();
            if (!this.isBookedResourceEqualToTemplateResourceId(candidateTemplateResource.getResource(), bookedResource.getResource()) || !this.ifDatesOverlap(candidateStartDate, candidateEndDate, reservedStartDate, reservedEndDate)) continue;
            this.adjustMapsForBookedResources(candidatePeriodToQtyMap, reservedStartDate, reservedEndDate, candidateStartDate);
        }
    }

    void adjustMapsForProvisionalAllocation(int key, Map<Integer, Integer> candidatePeriodToQtyMap) {
        if (candidatePeriodToQtyMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyMap.get(key) - 1;
            candidatePeriodToQtyMap.put(key, quantity);
        }
    }

    boolean setMessageIfUnavailable(int key, Integer currentQuantity, TemplateResource candidateTemplateResource, Map<Integer, Integer> candidatePeriodToQtyOverrideMap, Map<Integer, Integer> candidatePeriodToQtyDefaultMap, boolean isAvailable) {
        if (currentQuantity == null) {
            candidateTemplateResource.setRejectedResourceMessage("No Default Availability Entry Found");
            isAvailable = false;
        } else if (currentQuantity < 1 && candidatePeriodToQtyOverrideMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyOverrideMap.get(key);
            candidateTemplateResource.setRejectedResourceMessage("Temporary Adjustment - Quantity (" + quantity + ") Exhausted");
            isAvailable = false;
        } else if (currentQuantity < 1 && candidatePeriodToQtyDefaultMap.containsKey(key)) {
            int quantity = candidatePeriodToQtyDefaultMap.get(key);
            candidateTemplateResource.setRejectedResourceMessage("Default Availability - Quantity (" + quantity + ") Exhausted");
            isAvailable = false;
        }
        return isAvailable;
    }

    private void adjustMapsForBookedResources(Map<Integer, Integer> candidatePeriodToQtyMap, Date reservedStartDate, Date reservedEndDate, Date candidateStartDate) {
        int mapIndexOffset;
        Date dateOfFirstCandidatePeriodToUpdate;
        int reserveDayMinusCandidateDay = DateUtility.day2minusDay1(candidateStartDate, reservedStartDate);
        if (reserveDayMinusCandidateDay < 0) {
            dateOfFirstCandidatePeriodToUpdate = candidateStartDate;
            mapIndexOffset = 0;
        } else {
            dateOfFirstCandidatePeriodToUpdate = reservedStartDate;
            mapIndexOffset = reserveDayMinusCandidateDay * 96;
        }
        int firstPeriod = this.computePeriodOfDate(dateOfFirstCandidatePeriodToUpdate);
        int lastPeriod = this.computeLastPeriod(dateOfFirstCandidatePeriodToUpdate, reservedEndDate);
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            int effectiveIndex = i + mapIndexOffset;
            Integer currentQuantity = candidatePeriodToQtyMap.get(effectiveIndex);
            if (currentQuantity == null) continue;
            candidatePeriodToQtyMap.put(effectiveIndex, currentQuantity - 1);
        }
    }

    void loadIntoPeriodToQuantityMap(int resourceQuantity, int firstPeriod, int lastPeriod, Map<Integer, Integer> periodToQuantityMap) {
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer previousQuantity = periodToQuantityMap.get(i);
            if (previousQuantity == null) {
                previousQuantity = 0;
            }
            periodToQuantityMap.put(i, previousQuantity + resourceQuantity);
        }
    }

    void loadResourceScheduleIntoPeriodToQuantityMap(ResourceSchedule resourceSchedule, Map<Integer, Integer> periodToQuantityMap, int dayNumber) {
        if (periodToQuantityMap == null) {
            return;
        }
        Date scheduledStartTime = resourceSchedule.getStartTime();
        Date scheduledEndTime = resourceSchedule.getEndTime();
        int periodsOffset = dayNumber * 96;
        int firstPeriod = this.computePeriodOfDate(scheduledStartTime);
        int lastPeriod = this.computeLastPeriod(scheduledStartTime, scheduledEndTime);
        Integer resourceQuantity = resourceSchedule.getQuantity();
        this.loadIntoPeriodToQuantityMap(resourceQuantity, firstPeriod += periodsOffset, lastPeriod += periodsOffset, periodToQuantityMap);
    }

    Map<Integer, Integer> getPeriodToQuantityMap(List<ResourceSchedule> resourceScheduleList) {
        HashMap<Integer, Integer> periodToQuantityMap = new HashMap<Integer, Integer>();
        for (ResourceSchedule resourceSchedule : resourceScheduleList) {
            this.loadResourceScheduleIntoPeriodToQuantityMap(resourceSchedule, periodToQuantityMap, 0);
        }
        return periodToQuantityMap;
    }

    float computeTotalResources(Date scheduledStartTime, Date scheduledEndTime, List<TimeBoundedIdentity> scheduleList, Map<Integer, Integer> periodToQuantityMap) {
        float totalResources = -1.0f;
        int day = 0;
        for (TimeBoundedIdentity schedule : scheduleList) {
            Date startTimeDate = schedule.getStartTime();
            Date endTimeDate = schedule.getEndTime();
            int firstPeriod = this.computePeriodOfDate(startTimeDate) + 96 * day;
            int lastPeriod = this.computeLastPeriod(startTimeDate, endTimeDate) + 96 * day;
            this.loadIntoPeriodToQuantityMap(schedule.getQuantity(), firstPeriod, lastPeriod, periodToQuantityMap);
            ++day;
        }
        int firstPeriod = this.computePeriodOfDate(scheduledStartTime);
        int lastPeriod = this.computeLastPeriod(scheduledStartTime, scheduledEndTime);
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer currentQuantity = periodToQuantityMap.get(i);
            if ((currentQuantity == null || currentQuantity < 0) && totalResources == -1.0f) {
                return -1.0f;
            }
            if (currentQuantity == null || currentQuantity < 0 && totalResources != -1.0f) {
                return totalResources;
            }
            if (currentQuantity != null && totalResources == -1.0f) {
                totalResources = currentQuantity.intValue();
                continue;
            }
            if (currentQuantity == null || !((float)currentQuantity.intValue() < totalResources)) continue;
            totalResources = currentQuantity.intValue();
        }
        return totalResources;
    }

    int computeMinutesFromHrsAndMins(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int timeHr = cal.get(11);
        int timeMin = cal.get(12);
        return timeHr * 60 + timeMin;
    }

    float retrieveTotalResourcesFromOverrideSchedule(List<ResourceSchedule> scheduleListParam, Date scheduledStartTime, Date scheduledEndTime, Map<Integer, Integer> periodToQuantityMap) {
        ArrayList<TimeBoundedIdentity> finalScheduleList = new ArrayList<TimeBoundedIdentity>();
        List<TimeBoundedIdentity> scheduleList = ResourceSchedule.toTimeBoundedIdentityList(scheduleListParam);
        if (scheduleList != null) {
            finalScheduleList.addAll(scheduleList);
        }
        return this.computeTotalResources(scheduledStartTime, scheduledEndTime, finalScheduleList, periodToQuantityMap);
    }

    Date modifyDateFieldPlusAmtSetHourMinute(Date date, int field, int amount, int hour, int minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        cal.set(11, hour);
        cal.set(12, minute);
        return cal.getTime();
    }

    Date beginningOfDayPlus(Date date, int deltaDays) {
        LocalDateTime ldt = DateUtility.dateToLocalDateTime(date);
        LocalDateTime cleared = ldt.withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime adjusted = cleared.plusDays(deltaDays);
        return DateUtility.toDate(adjusted);
    }

    Date beginningOfDay(Date date) {
        return this.beginningOfDayPlus(date, 0);
    }

    int findEarliestStartTime(List<TemplateResource> resources) {
        int earliestStartTimeInMin = 0;
        int currentStartTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getStartDate() != null) {
                currentStartTimeInMin = r.getStartDate().getHours() * 60 + r.getStartDate().getMinutes();
            }
            if (earliestStartTimeInMin == 0 || currentStartTimeInMin == 0) {
                earliestStartTimeInMin = 0;
                continue;
            }
            if (earliestStartTimeInMin <= 0 || currentStartTimeInMin >= earliestStartTimeInMin) continue;
            earliestStartTimeInMin = currentStartTimeInMin;
        }
        return earliestStartTimeInMin;
    }

    int findLatestEndTime(List<TemplateResource> resources) {
        int latestEndTimeInMin = 0;
        int currentEndTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getEndDate() != null) {
                currentEndTimeInMin = r.getEndDate().getHours() * 60 + r.getEndDate().getMinutes();
            }
            if (latestEndTimeInMin == 0) {
                latestEndTimeInMin = currentEndTimeInMin;
                continue;
            }
            if (latestEndTimeInMin <= 0 || currentEndTimeInMin <= latestEndTimeInMin) continue;
            latestEndTimeInMin = currentEndTimeInMin;
        }
        return latestEndTimeInMin;
    }

    int findEarliestInpatientStartTime(List<TemplateResource> resources) {
        int earliestStartTimeInMin = 0;
        int currentStartTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getStartDate() != null) {
                currentStartTimeInMin = this.getTemplateResourceDay(r.getStartDate()) * 1440 + r.getStartDate().getHours() * 60 + r.getStartDate().getMinutes() - 1440;
            }
            if (earliestStartTimeInMin == 0 || currentStartTimeInMin == 0) {
                earliestStartTimeInMin = 0;
                continue;
            }
            if (earliestStartTimeInMin <= 0 || currentStartTimeInMin >= earliestStartTimeInMin) continue;
            earliestStartTimeInMin = currentStartTimeInMin;
        }
        return earliestStartTimeInMin;
    }

    int findEarliestInpatientClockStartTime(List<TemplateResource> resources) {
        int earliestStartTimeInMin = Integer.MAX_VALUE;
        int currentStartTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getStartDate() != null) {
                currentStartTimeInMin = this.getTemplateResourceDay(r.getStartDate()) * 1440 + r.getStartDate().getHours() * 60 + r.getStartDate().getMinutes() - 1440;
            }
            if (currentStartTimeInMin >= earliestStartTimeInMin) continue;
            earliestStartTimeInMin = currentStartTimeInMin;
        }
        return earliestStartTimeInMin;
    }

    int getTemplateResourceDay(Date r) {
        if (r.getMonth() > 1) {
            return r.getDate() + (r.getMonth() - 1) * 29;
        }
        return r.getDate();
    }

    int findLatestInpatientEndTime(List<TemplateResource> resources) {
        int latestEndTimeInMin = 0;
        int currentEndTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getEndDate() != null) {
                currentEndTimeInMin = this.getTemplateResourceDay(r.getEndDate()) * 1440 + r.getEndDate().getHours() * 60 + r.getEndDate().getMinutes() - 1440;
            }
            if (latestEndTimeInMin == 0) {
                latestEndTimeInMin = currentEndTimeInMin;
                continue;
            }
            if (latestEndTimeInMin <= 0 || currentEndTimeInMin <= latestEndTimeInMin) continue;
            latestEndTimeInMin = currentEndTimeInMin;
        }
        return latestEndTimeInMin;
    }

    public List<BookedVisit> searchAvailabilityData(VisitTime visitTime, UserSession userSession, boolean confirmEvent, boolean rejectedCheck, boolean isInpatient) {
        VisitTemplate selectedVisit = this.studyDAO.findVisitTemplateById(visitTime.getVisit());
        Integer visitDurationInMin = selectedVisit.getDuration();
        if (visitDurationInMin == null) {
            return null;
        }
        StudySubject selectedSubject = this.studyDAO.findStudySubjectById(visitTime.getSubject());
        User user = userSession.getUser();
        Date startDate = new Date(visitTime.getStartDate());
        Date endDate = new Date(visitTime.getEndDate());
        List<BookedVisit> searchAvailabilityData = this.getSearchedAppointments(confirmEvent, rejectedCheck, isInpatient, selectedSubject, selectedVisit, startDate, endDate);
        this.setBookedVisits(confirmEvent, rejectedCheck, user, searchAvailabilityData);
        this.sortSearchedAppointments(rejectedCheck, searchAvailabilityData);
        return searchAvailabilityData;
    }

    void setBookedVisits(boolean confirmEvent, boolean rejectedCheck, User user, List<BookedVisit> searchAvailabilityData) {
        if (!rejectedCheck && confirmEvent) {
            user.setBookedVisits(searchAvailabilityData);
        } else if (user.getBookedVisits() != null) {
            user.getBookedVisits().addAll(searchAvailabilityData);
        } else {
            user.setBookedVisits(searchAvailabilityData);
        }
    }

    void sortSearchedAppointments(boolean rejectedCheck, List<BookedVisit> searchAvailabilityData) {
        if (rejectedCheck) {
            List<BookedResource> bookedResourceList = searchAvailabilityData.get(0).getBookedResourceList();
            Collections.sort(bookedResourceList, eventResourceComparator);
        } else {
            Collections.sort(searchAvailabilityData, bookedVisitAvailabilityComparator);
        }
    }

    public List<BookedVisit> getSearchedAppointments(boolean confirmEvent, boolean rejectedCheck, boolean isInpatient, StudySubject selectedSubject, VisitTemplate selectedVisit, Date startDate, Date endDate) {
        List<Date> searchDates = this.setupSearchDates(confirmEvent, rejectedCheck, isInpatient, selectedVisit, startDate, endDate);
        return this.findAvailableVisitTimeSlots(searchDates, startDate, endDate, selectedSubject, selectedVisit, rejectedCheck, confirmEvent, isInpatient);
    }

    private List<Date> setupSearchDates(boolean confirmEvent, boolean rejectedCheck, boolean isInpatient, VisitTemplate selectedVisit, Date startDate, Date endDate) {
        List<Object> searchDates;
        int visitDurationInMin = selectedVisit.getDuration();
        if (isInpatient && this.isRelativeTimeTemplate(isInpatient, selectedVisit) && this.isDurationLessThan24Hours(confirmEvent, rejectedCheck, visitDurationInMin)) {
            searchDates = Lists.newArrayList();
            searchDates.add(startDate);
        } else {
            searchDates = !confirmEvent && !rejectedCheck ? DateUtility.dateInterval(startDate, endDate) : DateUtility.dateInterval(startDate, startDate);
        }
        return searchDates;
    }

    private boolean isRelativeTimeTemplate(boolean isInpatient, VisitTemplate selectedVisit) {
        return selectedVisit.getRelativeTime() != null && selectedVisit.getRelativeTime() != false || !isInpatient;
    }

    private boolean isDurationLessThan24Hours(boolean confirmEvent, boolean rejectedCheck, int visitDurationInMin) {
        return confirmEvent || rejectedCheck || visitDurationInMin < 1440;
    }

    String handleDoubleRoomCheck(BookedVisit visitEvent) {
        String doubleRoomUsed = null;
        for (BookedResource r : visitEvent.getBookedResourceList()) {
            boolean isRoom = r.getResource().getResourceType().isRoom();
            if (!isRoom || !this.isSharedRoom(r.getResource())) continue;
            Resource sharedResource = this.resourceDAO.findResourceById(r.getResource().getSharedResource());
            if (doubleRoomUsed != null) {
                doubleRoomUsed = doubleRoomUsed + this.checkIfDoubleRoomBeingUsed(r, sharedResource, visitEvent.getStudySubject().getSubject());
                continue;
            }
            doubleRoomUsed = this.checkIfDoubleRoomBeingUsed(r, sharedResource, visitEvent.getStudySubject().getSubject());
        }
        return doubleRoomUsed;
    }

    String checkIfDoubleRoomBeingUsed(BookedResource bookedResource, Resource sharedResource, Subject subject) {
        String overBookedMessage = null;
        List<BookedResource> systemBookedResources = this.appointmentDAO.findBookedResources(sharedResource);
        if (systemBookedResources == null || systemBookedResources.isEmpty()) {
            return overBookedMessage;
        }
        for (BookedResource r : systemBookedResources) {
            if (!(bookedResource.getScheduledStartTime().equals(r.getScheduledStartTime()) && bookedResource.getScheduledEndTime().equals(r.getScheduledEndTime()) || bookedResource.getScheduledStartTime().after(r.getScheduledStartTime()) && bookedResource.getScheduledStartTime().before(r.getScheduledEndTime())) && (!bookedResource.getScheduledStartTime().before(r.getScheduledStartTime()) || !bookedResource.getScheduledEndTime().after(r.getScheduledStartTime()))) continue;
            Gender genderCode = this.studyDAO.findGenderById(r.getBookedVisit().getStudySubject().getSubject().getGender().getId());
            if (subject.getGender().equals(r.getBookedVisit().getStudySubject().getSubject().getGender())) continue;
            if (overBookedMessage != null) {
                overBookedMessage = overBookedMessage + r.getResource().getName() + " (Shared Private room) has been booked for a Subject whose Sex is " + genderCode.getName();
                continue;
            }
            overBookedMessage = r.getResource().getName() + " (Shared Private room) has been booked for a Subject whose Sex is " + genderCode.getName();
        }
        return overBookedMessage;
    }

    boolean isSharedRoom(Resource resource) {
        Resource rs = this.resourceDAO.findResourceById(resource.getId());
        if (rs.getSharedResource() == null) {
            return false;
        }
        Resource obtainedSharedResource = this.resourceDAO.findResourceById(resource.getSharedResource());
        return obtainedSharedResource != null;
    }

    void calculateAvailableVisitTimeSlotRelative(int startTimeInMin, int endTimeInMin, VisitTemplate visitData, StudySubject studySubject, Date searchDate, List<BookedVisit> availableVisitTimeSlots, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatResourceList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, boolean rejectedCheck) {
        int visitDurationInMin = visitData.getDuration();
        int visitTimeSlotStart = startTimeInMin;
        while (this.isStartPlusDurationLtEnd(endTimeInMin, visitTimeSlotStart, visitDurationInMin)) {
            BookedVisit bookedVisit = this.initializeBookedVisit(visitData, visitTimeSlotStart, visitDurationInMin, searchDate);
            bookedVisit.setStudySubject(studySubject);
            String uniqueKey = RandomStringUtils.randomNumeric((int)8);
            bookedVisit.setUniquekey(uniqueKey);
            this.calculateSomeAvailableResources(visitDurationInMin, searchDate, availableVisitTimeSlots, fixedResources, floatResourceList, floatResourceGroups, flipResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck);
            visitTimeSlotStart += 30;
        }
    }

    BookedVisit initializeBookedVisit(VisitTemplate visitData, int visitTimeSlotStart, int visitDurationInMin, Date searchDate) {
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setId(1234556);
        bookedVisit.setName(visitData.getName());
        bookedVisit.setStudy(visitData.getStudy());
        bookedVisit.setVisitTemplate(visitData);
        bookedVisit.setVisitType(visitData.getVisitType());
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, this.divideByMinsPerHour(visitTimeSlotStart), this.moduloMinsPerHour(visitTimeSlotStart));
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, this.divideByMinsPerHour(visitTimeSlotStart + visitDurationInMin), this.moduloMinsPerHour(visitTimeSlotStart + visitDurationInMin));
        bookedVisit.setScheduledStartTime(startTime);
        bookedVisit.setScheduledEndTime(endTime);
        return bookedVisit;
    }

    void calculateAvailableVisitTimeSlotClockTime(VisitTemplate visitData, StudySubject studySubject, Date searchDate, Date endDateParam, List<BookedVisit> availableVisitTimeSlots, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatResourceList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, boolean rejectedCheck) {
        BookedVisit bookedVisit = this.initializeClockTimeBookedVisit(visitData, searchDate);
        Date endDate = this.modifyDateFieldPlusAmtSetHourMinute(endDateParam, 6, 0, bookedVisit.getScheduledEndTime().getHours(), bookedVisit.getScheduledEndTime().getMinutes());
        if (bookedVisit.getScheduledEndTime().equals(endDate) || bookedVisit.getScheduledEndTime().before(endDate)) {
            List<TemplateResource> availableFlipResources;
            List<TemplateResource> availableFloatResources;
            List<TemplateResource> availableFloatResourceList;
            bookedVisit.setStudySubject(studySubject);
            String uniqueKey = RandomStringUtils.randomNumeric((int)8);
            bookedVisit.setUniquekey(uniqueKey);
            this.addToAvailableBookedVisitList(bookedVisit, availableVisitTimeSlots);
            this.allocateTimeFixedResourcesClockTime(searchDate, fixedResources, "fixed");
            List<TemplateResource> availableFixedResources = this.calculateFixedResourceAvailability(fixedResources, rejectedCheck, bookedVisit.getBookedResourceList());
            if (this.isRejectedVisit(rejectedCheck, bookedVisit, availableFixedResources)) {
                return;
            }
            if (this.checkIfMapEmptyOrNull(floatResourceList) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFloatResourceList = this.removeDuplicates(this.allocateCheckAvailabilityFloatClockTime(searchDate, floatResourceList, rejectedCheck, "float", bookedVisit.getBookedResourceList())))) {
                return;
            }
            if (this.checkIfMapEmptyOrNull(floatResourceGroups) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFloatResources = this.removeDuplicates(this.allocateCheckAvailabilityFloatClockTime(searchDate, floatResourceGroups, rejectedCheck, "float group", bookedVisit.getBookedResourceList())))) {
                return;
            }
            if (this.checkIfMapEmptyOrNull(flipResourceGroups) && this.isRejectedVisit(rejectedCheck, bookedVisit, availableFlipResources = this.removeDuplicates(this.allocateCheckAvailabilityFlipClockTime(searchDate, flipResourceGroups, rejectedCheck, "flex", bookedVisit.getBookedResourceList())))) {
                return;
            }
        }
    }

    private <A> List<A> removeDuplicates(List<A> availableResourceList) {
        if (AppointmentService.neitherNullNorEmpty(availableResourceList)) {
            return ListUtils.enrich(availableResourceList).distinct().toList();
        }
        return availableResourceList;
    }

    private boolean checkIfMapEmptyOrNull(Map<String, List<TemplateResource>> floatResourceList) {
        return floatResourceList != null && !floatResourceList.isEmpty();
    }

    private boolean isRejectedVisit(boolean rejectedCheck, BookedVisit bookedVisit, List<TemplateResource> availableResourceList) {
        if (AppointmentService.neitherNullNorEmpty(availableResourceList)) {
            bookedVisit.setRejectedVisit(false);
            this.addToBookedVisit(availableResourceList, bookedVisit);
            if (rejectedCheck) {
                bookedVisit.setRejectedVisit(true);
            }
        } else {
            bookedVisit.setRejectedVisit(true);
            bookedVisit.setBookedResourceList(new ArrayList<BookedResource>());
            return true;
        }
        return false;
    }

    List<TemplateResource> allocateCheckAvailabilityFlipClockTime(Date searchDate, Map<String, List<TemplateResource>> flipResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableFlipResourceSlots = new ArrayList<TemplateResource>();
        LazyList lazyTemplateResourceLists = LazyList.lazy(new ArrayList<Map.Entry<String, List<TemplateResource>>>(flipResources.entrySet())).map(flipGrp -> {
            List resources = (List)flipGrp.getValue();
            List<TemplateResource> availableFlipGrp = this.removeDuplicates(this.findAvailablePermutationSequence(resources, 0, searchDate, rejectedCheck, groupType, availableBookedResourceSlots, availableFlipResourceSlots));
            if (availableFlipGrp == null || availableFlipGrp.isEmpty()) {
                return null;
            }
            availableFlipResourceSlots.addAll(availableFlipGrp);
            return availableFlipGrp;
        });
        if (lazyTemplateResourceLists.exists(AppointmentService::isNullOrEmpty)) {
            return null;
        }
        return availableFlipResourceSlots;
    }

    int findMultiDayMinutesOffset(List<TemplateResource> originalSequence, int relativeOffset) {
        Date earliestDate = ListUtils.enrich(originalSequence).map(TemplateResource::getStartDate).min((lhs, rhs) -> lhs.compareTo((Date)rhs)).orElse(null);
        int baseStartTime = (this.getTemplateResourceDay(earliestDate) - 1) * 1440 + earliestDate.getHours() * 60 + earliestDate.getMinutes();
        return baseStartTime + relativeOffset;
    }

    List<TemplateResource> findAvailablePermutationSequence(List<TemplateResource> resources, int minuteOffsetForSlot, Date searchDate, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        TemplateResource slot;
        ArrayList<TemplateResource> availableSequence = null;
        ArrayList<TemplateResource> defaultSequence = null;
        boolean defaultSequences = true;
        BaseEntity previousFirstResource = null;
        boolean isFirstResourceAvailable = true;
        int baseStartTime = this.findMultiDayMinutesOffset(resources, minuteOffsetForSlot);
        PermutationGenerator generator = new PermutationGenerator(resources.size());
        while (generator.hasMore()) {
            List<TemplateResource> foundSlots;
            availableSequence = new ArrayList<TemplateResource>();
            List<Integer> indices = generator.getNext();
            TemplateResource currentFirstResource = this.duplicateResourceSlot(resources.get(indices.get(0)));
            for (int index : indices) {
                slot = this.duplicateResourceSlot(resources.get(index));
                slot.setResourceGroupType(groupType);
                availableSequence.add(slot);
            }
            if (defaultSequences) {
                defaultSequence = new ArrayList<TemplateResource>();
                defaultSequences = false;
                defaultSequence.addAll(availableSequence);
            }
            if (previousFirstResource != null && previousFirstResource.getId().equals(currentFirstResource.getId())) {
                if (!isFirstResourceAvailable) {
                    availableSequence = null;
                    continue;
                }
                this.allocateTime(availableSequence, baseStartTime, searchDate);
                foundSlots = this.checkTimeSlotAvailability(availableSequence, rejectedCheck, availableBookedResourceSlots, new ArrayList<TemplateResource>());
                if (!foundSlots.isEmpty()) {
                    return foundSlots;
                }
                availableSequence = null;
                continue;
            }
            previousFirstResource = currentFirstResource;
            this.allocateTime(availableSequence, baseStartTime, searchDate);
            TemplateResource foundSlot = this.findAvailableResource((TemplateResource)availableSequence.get(0), rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (foundSlot != null) {
                isFirstResourceAvailable = true;
                availableResourceSlots.add(foundSlot);
                availableSequence.remove(foundSlot);
                foundSlots = this.checkTimeSlotAvailability(availableSequence, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
                if (!foundSlots.isEmpty()) {
                    return foundSlots;
                }
                availableResourceSlots.remove(foundSlot);
                availableSequence = null;
                continue;
            }
            isFirstResourceAvailable = false;
            availableSequence = null;
        }
        if (rejectedCheck && availableSequence == null) {
            ArrayList<TemplateResource> rejectedSequence = new ArrayList<TemplateResource>();
            for (TemplateResource resource : defaultSequence) {
                resource.setFlexible(false);
                slot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
                slot.setFlexible(true);
                availableResourceSlots.add(slot);
                rejectedSequence.add(slot);
            }
            return rejectedSequence;
        }
        return availableSequence;
    }

    TemplateResource duplicateResourceSlot(TemplateResource givenResourceSlot) {
        TemplateResource slot = new TemplateResource();
        slot.setId(givenResourceSlot.getId());
        slot.setAvailableEndTimeInMin(givenResourceSlot.getAvailableEndTimeInMin());
        slot.setAlternate(givenResourceSlot.getAlternate());
        slot.setResource(givenResourceSlot.getResource());
        slot.setBillable(givenResourceSlot.getBillable());
        slot.setAvailableStartTimeInMin(givenResourceSlot.getAvailableStartTimeInMin());
        slot.setDuration(givenResourceSlot.getDuration());
        slot.setFlexible(givenResourceSlot.getFlexible());
        slot.setFloatEnd(givenResourceSlot.getFloatEnd());
        slot.setFloatStart(givenResourceSlot.getFloatStart());
        slot.setFloatable(givenResourceSlot.getFloatable());
        slot.setScheduledEndTime(givenResourceSlot.getScheduledEndTime());
        slot.setScheduledStartTime(givenResourceSlot.getScheduledStartTime());
        slot.setVisitTemplate(givenResourceSlot.getVisitTemplate());
        slot.setStartDate(givenResourceSlot.getStartDate());
        slot.setEndDate(givenResourceSlot.getEndDate());
        slot.setGroupId(givenResourceSlot.getGroupId());
        return slot;
    }

    List<TemplateResource> allocateCheckAvailabilityFloatClockTime(Date searchDate, Map<String, List<TemplateResource>> floatResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(searchDate);
        Date searchStartDate = DateUtility.startOfDay(startCal);
        for (Map.Entry<String, List<TemplateResource>> floatGroups : floatResources.entrySet()) {
            List<TemplateResource> resources = floatGroups.getValue();
            if (resources.isEmpty()) continue;
            ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
            availableSlots.addAll(availableResourceSlots);
            List<TemplateResource> availableFloatResources = this.findAvailableFloatDurationSlotsClockTime(resources, searchStartDate, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (AppointmentService.neitherNullNorEmpty(availableFloatResources)) {
                this.prepareAndAddToAvailableSlots(resources.get(0).getAvailableStartTimeInMin(), resources.get(0).getAvailableEndTimeInMin(), resources.get(0).getScheduledStartTime(), resources.get(0).getScheduledEndTime(), availableFloatResources, availableResourceSlots, groupType, resources.size() == 1);
                continue;
            }
            return null;
        }
        return availableResourceSlots;
    }

    List<TemplateResource> findAvailableFloatDurationSlotsClockTime(List<TemplateResource> resources, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> originalResources = new ArrayList<TemplateResource>();
        if (rejectedCheck) {
            originalResources.addAll(resources);
            List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(resources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
                return foundSlots;
            }
            boolean notUsingClockTime = false;
            int visitTimeSlotEnd = -1;
            boolean floatDelta = false;
            foundSlots = this.findTemplateResourceSlots(resources, -1, searchDate, false, 0, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
                return foundSlots;
            }
            for (TemplateResource r : originalResources) {
                r.setFloatable(false);
            }
            foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(originalResources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            for (TemplateResource r : originalResources) {
                r.setFloatable(true);
            }
            return foundSlots;
        }
        List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferredClockTime(resources, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
        if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
            return foundSlots;
        }
        boolean notUsingClockTime = false;
        int visitTimeSlotEnd = -1;
        boolean floatDelta = false;
        return this.findTemplateResourceSlots(resources, -1, searchDate, false, 0, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
    }

    List<TemplateResource> allocateCheckAvailabilityUserPreferredClockTime(List<TemplateResource> resources, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> foundAvailableSlots) {
        for (TemplateResource resource : resources) {
            this.allocateTimeClockTime(resource, searchDate);
            TemplateResource foundSlot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, foundAvailableSlots);
            if (foundSlot != null) {
                foundAvailableSlots.add(foundSlot);
                continue;
            }
            return null;
        }
        return foundAvailableSlots;
    }

    void allocateTimeClockTime(TemplateResource resource, Date searchDate) {
        int resourceStartTimeInMin = resource.getStartDate().getHours() * 60 + resource.getStartDate().getMinutes();
        int resourceEndTimeInMin = resource.getEndDate().getHours() * 60 + resource.getEndDate().getMinutes();
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, resource.getStartDate().getHours(), resource.getStartDate().getMinutes());
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getEndDate()) - 1, this.divideByMinsPerHour(resourceEndTimeInMin), this.moduloMinsPerHour(resourceEndTimeInMin));
        resource.setAvailableStartTimeInMin(resourceStartTimeInMin);
        resource.setAvailableEndTimeInMin(resourceEndTimeInMin);
        resource.setScheduledStartTime(startTime);
        resource.setScheduledEndTime(endTime);
    }

    void allocateTimeFixedResourcesClockTime(Date searchDate, List<TemplateResource> fixedResources, String groupType) {
        int startDay = 1;
        int endDay = 1;
        for (TemplateResource resource : fixedResources) {
            if (resource.getStartDate() != null) {
                startDay = this.getTemplateResourceDay(resource.getStartDate());
            }
            if (resource.getEndDate() != null) {
                endDay = this.getTemplateResourceDay(resource.getEndDate());
            }
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, --startDay, resource.getStartDate().getHours(), resource.getStartDate().getMinutes());
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, --endDay, resource.getEndDate().getHours(), resource.getEndDate().getMinutes());
            resource.setScheduledStartTime(startTime);
            resource.setScheduledEndTime(endTime);
            resource.setResourceGroupType(groupType);
        }
    }

    BookedVisit initializeClockTimeBookedVisit(VisitTemplate visitData, Date searchDate) {
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setId(1234556);
        bookedVisit.setName(visitData.getName());
        bookedVisit.setStudy(visitData.getStudy());
        bookedVisit.setVisitTemplate(visitData);
        bookedVisit.setVisitType(visitData.getVisitType());
        List<TemplateResource> trs = this.studyDAO.findTemplateResourcesByVisit(visitData);
        int startTimeInMin = this.findEarliestInpatientClockStartTime(trs);
        int endTimeInMin = this.findLatestInpatientEndTime(trs);
        int startDay = startTimeInMin / 1440;
        int startInMin = this.subtractDaysWorthOfMinutes(startTimeInMin, startDay);
        int startHr = this.divideByMinsPerHour(startInMin);
        int startMin = this.moduloMinsPerHour(startInMin);
        int endDay = this.divideByMinsPerDay(endTimeInMin);
        int endInMin = this.subtractDaysWorthOfMinutes(endTimeInMin, endDay);
        int endHr = this.divideByMinsPerHour(endInMin);
        int endMin = this.moduloMinsPerHour(endInMin);
        Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, startDay, startHr, startMin);
        Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, endDay, endHr, endMin);
        bookedVisit.setScheduledStartTime(startTime);
        bookedVisit.setScheduledEndTime(endTime);
        return bookedVisit;
    }

    List<BookedVisit> findAvailableVisitTimeSlots(List<Date> searchDates, Date startDate, Date endDate, StudySubject studySubject, VisitTemplate visitData, boolean rejectedCheck, boolean confirmEvent, boolean isInpatient) {
        boolean isRelativeTime = this.isRelativeTimeTemplate(isInpatient, visitData);
        ArrayList availableVisitTimeSlots = Lists.newArrayList();
        int visitDurationInMin = visitData.getDuration();
        int startTimeInMin = startDate.getHours() * 60 + startDate.getMinutes();
        int endTimeInMin = endDate.getHours() * 60 + endDate.getMinutes();
        List<TemplateResource> fixedResources = this.studyDAO.findFixedTemplateResourcesByVisit(visitData);
        Map<String, List<TemplateResource>> floatResourceList = this.retrieveFloatResourceList(visitData);
        Map<String, List<TemplateResource>> floatResourceGroupList = this.retrieveGroupedResourceList(visitData, Boolean.FALSE);
        Map<String, List<TemplateResource>> flexResourceGroupList = this.retrieveGroupedResourceList(visitData, Boolean.TRUE);
        for (Date searchDate : searchDates) {
            if (isRelativeTime) {
                endTimeInMin = this.updateInpatientEndTime(endDate, rejectedCheck, confirmEvent, isInpatient, visitDurationInMin, startTimeInMin, endTimeInMin, searchDate);
                this.calculateAvailableVisitTimeSlotRelative(startTimeInMin, endTimeInMin, visitData, studySubject, searchDate, availableVisitTimeSlots, fixedResources, floatResourceList, floatResourceGroupList, flexResourceGroupList, rejectedCheck);
                continue;
            }
            this.calculateAvailableVisitTimeSlotClockTime(visitData, studySubject, searchDate, endDate, availableVisitTimeSlots, fixedResources, floatResourceList, floatResourceGroupList, flexResourceGroupList, rejectedCheck);
        }
        return availableVisitTimeSlots;
    }

    private int updateInpatientEndTime(Date endDate, boolean rejectedCheck, boolean confirmEvent, boolean isInpatient, int visitDurationInMin, int startTimeInMin, int endTimeInMin, Date searchDate) {
        if (isInpatient) {
            endTimeInMin = DateUtility.minsFromDate1ToDate2(searchDate, endDate);
            if (this.isDurationLessThan24Hours(confirmEvent, rejectedCheck, visitDurationInMin)) {
                endTimeInMin += startTimeInMin;
            }
        }
        return endTimeInMin;
    }

    Map<String, List<TemplateResource>> retrieveGroupedResourceList(VisitTemplate visitData, boolean isFlex) {
        List<TemplateResourceGroup> groupedResourceList = this.appointmentDAO.getTemplateResourceGroups(visitData, isFlex);
        return this.getGroupedResourceListMap(groupedResourceList);
    }

    private Map<String, List<TemplateResource>> getGroupedResourceListMap(List<TemplateResourceGroup> resourceGroupList) {
        LinkedHashMap resourceGrpMap = Maps.newLinkedHashMap();
        if (resourceGroupList != null && !resourceGroupList.isEmpty()) {
            for (TemplateResourceGroup f : resourceGroupList) {
                String groupKey = f.getGroupId();
                List grpResources = resourceGrpMap.containsKey(groupKey) ? (List)resourceGrpMap.get(groupKey) : Lists.newArrayList();
                grpResources.add(f.getTemplateResource());
                resourceGrpMap.put(groupKey, grpResources);
            }
        }
        return resourceGrpMap;
    }

    Map<String, List<TemplateResource>> retrieveFloatResourceList(VisitTemplate visitData) {
        List<TemplateResource> floatResourceList = this.appointmentDAO.getSingleFloatTemplateResources(visitData);
        LinkedHashMap floatResourcesMap = Maps.newLinkedHashMap();
        if (AppointmentService.neitherNullNorEmpty(floatResourceList)) {
            for (TemplateResource f : floatResourceList) {
                String groupKey = f.getId().toString();
                List floatResources = floatResourcesMap.containsKey(groupKey) ? (List)floatResourcesMap.get(groupKey) : Lists.newArrayList();
                floatResources.add(f);
                floatResourcesMap.put(groupKey, floatResources);
            }
        }
        return floatResourcesMap;
    }

    void addToAvailableBookedVisitList(BookedVisit currentTimeSlot, List<BookedVisit> availableVisitTimeSlots) {
        List<Object> availableVisitTimeSlotsToAdd = availableVisitTimeSlots == null ? Lists.newArrayList() : availableVisitTimeSlots;
        availableVisitTimeSlotsToAdd.add(currentTimeSlot);
    }

    List<TemplateResource> allocateCheckAvailabilityFlip(int visitTimeSlotStart, Date searchDate, Map<String, List<TemplateResource>> flipResources, boolean rejectedCheck, String groupType, List<BookedResource> availableResourceSlots) {
        ArrayList<TemplateResource> availableFlipResourceSlots = new ArrayList<TemplateResource>();
        for (Map.Entry<String, List<TemplateResource>> flipGrp : flipResources.entrySet()) {
            List<TemplateResource> resources = flipGrp.getValue();
            List<TemplateResource> availableFlipGrp = this.findAvailablePermutationSequence(resources, visitTimeSlotStart, searchDate, rejectedCheck, groupType, availableResourceSlots, availableFlipResourceSlots);
            if (availableFlipGrp == null || availableFlipGrp.isEmpty()) {
                return null;
            }
            availableFlipResourceSlots.addAll(this.removeDuplicates(availableFlipGrp));
        }
        return availableFlipResourceSlots;
    }

    void allocateTime(List<TemplateResource> sortedSequence, int baseStartTime, Date searchDate) {
        int startTimeInMin = baseStartTime;
        ArrayList templateResources = Lists.newArrayList();
        for (TemplateResource templateResource : sortedSequence) {
            int startHr = this.divideByMinsPerHour(startTimeInMin);
            int resourceDurationTimeInMin = templateResource.getDuration();
            int endTimeInMin = startTimeInMin + resourceDurationTimeInMin;
            int endHr = this.divideByMinsPerHour(endTimeInMin);
            boolean startDay = false;
            boolean endDay = false;
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, startHr, this.moduloMinsPerHour(startTimeInMin));
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, 0, endHr, this.moduloMinsPerHour(endTimeInMin));
            templateResource.setScheduledStartTime(startTime);
            templateResource.setScheduledEndTime(endTime);
            startTimeInMin = endTimeInMin;
            for (TemplateResource tr : templateResources) {
                if (tr.getStartDate().getTime() != templateResource.getStartDate().getTime()) continue;
                templateResource.setScheduledStartTime(tr.getScheduledStartTime());
                templateResource.setScheduledEndTime(tr.getScheduledEndTime());
                startTimeInMin = endTimeInMin - resourceDurationTimeInMin;
            }
            templateResources.add(templateResource);
        }
    }

    void allocateTimeFixedResources(int visitTimeSlotStart, Date searchDate, List<TemplateResource> fixedResources, String groupType) {
        for (TemplateResource resource : fixedResources) {
            this.computeAndSetDuration(resource);
            int resourceDurationTimeInMin = resource.getDuration();
            int resourceStartTimeInMin = resource.getStartDate().getHours() * 60 + resource.getStartDate().getMinutes();
            int curResourceStartTimeHr = this.divideByMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin);
            int curResourceStartTimeMin = this.moduloMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin);
            int curResourceEndTimeHr = this.divideByMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin + resourceDurationTimeInMin);
            int curResourceEndTimeMin = this.moduloMinsPerHour(visitTimeSlotStart + resourceStartTimeInMin + resourceDurationTimeInMin);
            Date startTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, curResourceStartTimeHr, curResourceStartTimeMin);
            Date endTime = this.modifyDateFieldPlusAmtSetHourMinute(searchDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, curResourceEndTimeHr, curResourceEndTimeMin);
            resource.setScheduledStartTime(startTime);
            resource.setScheduledEndTime(endTime);
            resource.setResourceGroupType(groupType);
        }
    }

    List<TemplateResource> calculateFixedResourceAvailability(List<TemplateResource> fixedResources, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        for (TemplateResource resource : fixedResources) {
            TemplateResource foundSlot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (foundSlot != null) {
                availableResourceSlots.add(foundSlot);
                continue;
            }
            return null;
        }
        return availableResourceSlots;
    }

    List<TemplateResource> allocateCheckAvailabilityFloat(int visitTimeSlotStart, int visitTimeSlotEnd, Date searchDate, Map<String, List<TemplateResource>> floatResources, boolean rejectedCheck, String groupType, List<BookedResource> availableBookedResourceSlots) {
        ArrayList<TemplateResource> availableResourceSlots = new ArrayList<TemplateResource>();
        for (Map.Entry<String, List<TemplateResource>> floatGrps : floatResources.entrySet()) {
            List<TemplateResource> resources = floatGrps.getValue();
            if (resources.isEmpty()) continue;
            ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
            availableSlots.addAll(availableResourceSlots);
            List<TemplateResource> availableFloatResources = this.findAvailableFloatDurationSlots(resources, visitTimeSlotStart, visitTimeSlotEnd, searchDate, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (availableFloatResources == null || availableFloatResources.isEmpty()) {
                return null;
            }
            this.prepareAndAddToAvailableSlots(resources.get(0).getAvailableStartTimeInMin(), resources.get(0).getAvailableEndTimeInMin(), resources.get(0).getScheduledStartTime(), resources.get(0).getScheduledEndTime(), availableFloatResources, availableResourceSlots, groupType, resources.size() == 1);
        }
        return availableResourceSlots;
    }

    void prepareAndAddToAvailableSlots(int resourceStartTime, int resourceEndTime, Date scheduledStartTime, Date scheduledEndTime, List<TemplateResource> currentResources, List<TemplateResource> availableResourceSlots, String groupType, boolean singleFloatResources) {
        for (TemplateResource resource : currentResources) {
            if (!singleFloatResources && resource.getGroupId().equals(currentResources.get(currentResources.size() - 1).getGroupId())) {
                resource.setAvailableStartTimeInMin(resourceStartTime);
                resource.setAvailableEndTimeInMin(resourceEndTime);
                resource.setScheduledStartTime(scheduledStartTime);
                resource.setScheduledEndTime(scheduledEndTime);
            }
            resource.setResourceGroupType(groupType);
            availableResourceSlots.add(resource);
        }
    }

    List<TemplateResource> findAvailableFloatDurationSlots(List<TemplateResource> resources, int visitTimeSlotStart, int visitTimeSlotEnd, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> originalResources = new ArrayList<TemplateResource>();
        if (rejectedCheck) {
            originalResources.addAll(resources);
            List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
                return foundSlots;
            }
            boolean notUsingClockTime = true;
            foundSlots = this.findTemplateResourceSlots(resources, visitTimeSlotEnd, searchDate, true, visitTimeSlotStart, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
                return foundSlots;
            }
            for (TemplateResource r : originalResources) {
                r.setFloatable(false);
            }
            foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            for (TemplateResource r : originalResources) {
                r.setFloatable(true);
            }
            return foundSlots;
        }
        List<TemplateResource> foundSlots = this.allocateCheckAvailabilityUserPreferred(resources, visitTimeSlotStart, searchDate, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
        if (AppointmentService.neitherNullNorEmpty(foundSlots)) {
            return foundSlots;
        }
        boolean notUsingClockTime = true;
        return this.findTemplateResourceSlots(resources, visitTimeSlotEnd, searchDate, true, visitTimeSlotStart, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
    }

    List<TemplateResource> findTemplateResourceSlots(List<TemplateResource> resources, int visitTimeSlotEnd, Date searchDate, boolean notUsingClockTime, int floatDelta, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        TemplateResource resource = resources.get(0);
        int resourceDurationTimeInMin = resource.getDuration();
        int resourceFloatDurationStartTimeInMin = resource.getFloatStart();
        int resourceFloatDurationEndTimeInMin = resource.getFloatEnd();
        int floatStart = floatDelta + resourceFloatDurationStartTimeInMin;
        int floatEnd = floatDelta + resourceFloatDurationEndTimeInMin;
        while (this.isStartPlusDurationLtEnd(floatEnd, floatStart, resourceDurationTimeInMin) && this.possiblyCheckVisitEnd(notUsingClockTime, visitTimeSlotEnd, floatStart, resourceDurationTimeInMin)) {
            int startDays = DateUtility.convertMinutesToStartDayZeroOffset(floatStart);
            int startHours = DateUtility.convertMinutesToHourInDay(floatStart);
            int startMinutes = DateUtility.convertTotalMinutesToMinutesInHour(floatStart);
            int endFloatMinutes = floatStart + resourceDurationTimeInMin;
            int endDays = DateUtility.convertMinutesToStartDayZeroOffset(endFloatMinutes);
            int endHours = DateUtility.convertMinutesToHourInDay(endFloatMinutes);
            int endMinutes = DateUtility.convertTotalMinutesToMinutesInHour(endFloatMinutes);
            Calendar startCalendar = Calendar.getInstance();
            startCalendar.setTime(searchDate);
            startCalendar.add(5, startDays);
            startCalendar.set(11, startHours);
            startCalendar.add(12, startMinutes);
            Date startTime = startCalendar.getTime();
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(searchDate);
            endCalendar.add(5, endDays);
            endCalendar.set(11, endHours);
            endCalendar.add(12, endMinutes);
            Date endTime = endCalendar.getTime();
            this.prepareResourceTimeSlots(floatStart, floatStart + resourceDurationTimeInMin, startTime, endTime, resources);
            List<TemplateResource> foundSlots = this.checkTimeSlotAvailability(resources, rejectedCheck, availableBookedResourceSlots, availableResourceSlots);
            if (!foundSlots.isEmpty()) {
                return foundSlots;
            }
            floatStart += 30;
        }
        return null;
    }

    boolean possiblyCheckVisitEnd(boolean yesCheck, int visitTimeSlotEnd, int floatStart, int resourceDurationTimeInMin) {
        return !yesCheck || this.isStartPlusDurationLtEnd(visitTimeSlotEnd, floatStart, resourceDurationTimeInMin);
    }

    boolean isStartPlusDurationLtEnd(int visitTimeSlotEnd, int floatStart, int resourceDurationTimeInMin) {
        return floatStart + resourceDurationTimeInMin <= visitTimeSlotEnd;
    }

    void prepareResourceTimeSlots(int resourceStartTime, int resourceEndTime, Date scheduledStartTime, Date scheduledEndTime, List<TemplateResource> resources) {
        for (TemplateResource resource : resources) {
            resource.setAvailableStartTimeInMin(resourceStartTime);
            resource.setAvailableEndTimeInMin(resourceEndTime);
            resource.setScheduledStartTime(scheduledStartTime);
            resource.setScheduledEndTime(scheduledEndTime);
        }
    }

    List<TemplateResource> checkTimeSlotAvailability(List<TemplateResource> resources, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        ArrayList<TemplateResource> availableSlots = new ArrayList<TemplateResource>();
        availableSlots.addAll(availableResourceSlots);
        for (TemplateResource resource : resources) {
            TemplateResource slot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, availableSlots);
            if (slot == null) {
                availableSlots.clear();
                return availableSlots;
            }
            availableSlots.add(slot);
        }
        return availableSlots;
    }

    List<TemplateResource> allocateCheckAvailabilityUserPreferred(List<TemplateResource> resources, int visitTimeSlotStart, Date searchDate, boolean rejectedCheck, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> foundAvailableSlots) {
        for (TemplateResource resource : resources) {
            this.allocateTime(resource, visitTimeSlotStart, searchDate);
            TemplateResource foundSlot = this.findAvailableResource(resource, rejectedCheck, availableBookedResourceSlots, foundAvailableSlots);
            if (foundSlot == null) {
                return null;
            }
            foundAvailableSlots.add(foundSlot);
        }
        return foundAvailableSlots;
    }

    void allocateTime(TemplateResource resource, int visitTimeSlotStart, Date searchDate) {
        int resourceDurationTimeInMin = resource.getDuration();
        int resourceStartTimeInMin = resource.getStartDate().getHours() * 60 + resource.getStartDate().getMinutes();
        int resourceEndTimeInMin = resourceStartTimeInMin + resourceDurationTimeInMin;
        int slotOffsetResourceStartMinute = visitTimeSlotStart + resourceStartTimeInMin;
        int slotOffsetResourceEndMinute = visitTimeSlotStart + resourceEndTimeInMin;
        Date startDate = new Date(searchDate.getTime() + (long)slotOffsetResourceStartMinute * 60000L);
        Date candidateResourceStartTime = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, this.getTemplateResourceDay(resource.getStartDate()) - 1, this.multiDayMinutesToDailyHour(slotOffsetResourceStartMinute), this.multiDayMinutesToHourlyMinute(slotOffsetResourceStartMinute));
        Calendar candidateEndCalendar = Calendar.getInstance();
        candidateEndCalendar.setTimeInMillis(candidateResourceStartTime.getTime() + (long)resourceDurationTimeInMin * 60000L);
        Date candidateResourceEndTime = candidateEndCalendar.getTime();
        resource.setAvailableStartTimeInMin(slotOffsetResourceStartMinute);
        resource.setAvailableEndTimeInMin(slotOffsetResourceEndMinute);
        resource.setScheduledStartTime(candidateResourceStartTime);
        resource.setScheduledEndTime(candidateResourceEndTime);
    }

    int multiDayMinutesToHourlyMinute(int slotOffsetEndMinute) {
        return slotOffsetEndMinute % 60;
    }

    int multiDayMinutesToDailyHour(int slotOffsetStartMinute) {
        return slotOffsetStartMinute % 1440 / 60;
    }

    public List<LineLevelAnnotations> getResourceAnnotations(int resource) {
        Resource r = this.resourceDAO.findResourceById(resource);
        ArrayList<LineLevelAnnotations> rs = new ArrayList<LineLevelAnnotations>();
        List<ResourceAnnotation> ra = this.resourceDAO.findResourcesAnnotationsByResource(r);
        if (ra != null && !ra.isEmpty()) {
            for (int i = 0; i < ra.size(); ++i) {
                rs.add(ra.get(i).getLineLevelAnnotations());
            }
        }
        Collections.sort(rs, new LineLevelAnnotations.AnnotationsComparator());
        return rs;
    }

    void computeAndSetDuration(TemplateResource templateResource) {
        if (templateResource != null) {
            int totalMinutesDelta = 0;
            Date startDate = templateResource.getStartDate();
            Date endDate = templateResource.getEndDate();
            if (startDate != null && templateResource.getEndDate() != null) {
                int daysDelta = this.getTemplateResourceDay(endDate) - this.getTemplateResourceDay(startDate);
                int hoursDelta = endDate.getHours() - startDate.getHours();
                int minutesDelta = endDate.getMinutes() - startDate.getMinutes();
                totalMinutesDelta = daysDelta * 1440 + hoursDelta * 60 + minutesDelta;
            }
            templateResource.setDuration(totalMinutesDelta);
        }
    }

    public BookedVisit rescheduleData(VisitTime visitTime, User user, String ipAddress, String templatePath, Boolean followOriginalTemplate) {
        BookedVisit result = followOriginalTemplate != null && followOriginalTemplate != false ? this.rescheduleDataFromTemplate(visitTime, user, ipAddress, templatePath) : this.rescheduleDataFromVisit(visitTime, user, ipAddress);
        return result;
    }

    public BookedVisit rescheduleDataFromTemplate(VisitTime visitTime, User user, String ipAddress, String templatePath) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(visitTime.getBookedvisit());
        VisitTemplate visitTemplate = bookedVisit.getVisitTemplate();
        Date eventDate = new Date(visitTime.getStartDate());
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(visitTime.getOverrideReason());
        if (visitTime.getOverrideReason() != 0) {
            visitTime.setOverride(true);
        }
        TemplateResource templateResourceLowest = this.studyDAO.findTemplateResourceLowest(visitTemplate);
        Date lowestStartDate = templateResourceLowest.getStartDate();
        Calendar scheduledEndTimeCal = this.updateDatesForBV(visitTemplate, eventDate, lowestStartDate);
        BookedVisit clonedVisit = this.createClonedBookedVisit(user, bookedVisit, eventDate, scheduledEndTimeCal);
        List<TemplateResource> templateResourceList = this.studyDAO.findTemplateResourcesByVisit(visitTemplate);
        this.setRoomsForBVFromTemplate(clonedVisit, templateResourceList);
        this.createBookedVisitComments(visitTime, user, ipAddress, clonedVisit);
        int eventDateMinutesDelta = 0;
        if (visitTemplate.getVisitType().isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        } else {
            eventDateMinutesDelta = eventDate.getHours() * 60 + eventDate.getMinutes();
        }
        this.setupBookedResourcesForBookedVisit(user, templatePath, templateResourceList, eventDate, clonedVisit, eventDateMinutesDelta);
        this.logRescheduleAppointment(user, ipAddress, overrideReason, clonedVisit);
        return clonedVisit;
    }

    private void setRoomsForBVFromTemplate(BookedVisit clonedVisit, List<TemplateResource> templateResourceList) {
        String rooms = " ";
        for (TemplateResource templateResource : templateResourceList) {
            Resource resource = templateResource.getResource();
            if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = resource.getName() + ", ";
        }
        clonedVisit.setRooms(rooms);
    }

    private Calendar updateDatesForBV(VisitTemplate visitTemplate, Date eventDate, Date lowestStartDate) {
        if (visitTemplate.getVisitType().isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        }
        Calendar scheduledEndTimeCal = Calendar.getInstance();
        scheduledEndTimeCal.clear();
        scheduledEndTimeCal.setTime(eventDate);
        scheduledEndTimeCal.add(12, visitTemplate.getDuration());
        scheduledEndTimeCal.set(13, 0);
        scheduledEndTimeCal.set(14, 0);
        return scheduledEndTimeCal;
    }

    BookedVisit tryCloneVisit(BookedVisit bookedVisit) {
        return bookedVisit.cloneBookedVisit();
    }

    public BookedVisit rescheduleDataFromVisit(VisitTime visitTime, User user, String ipAddress) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(visitTime.getBookedvisit());
        VisitTemplate visitTemplate = bookedVisit.getVisitTemplate();
        Date eventDate = new Date(visitTime.getStartDate());
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(visitTime.getOverrideReason());
        if (visitTime.getOverrideReason() != 0) {
            visitTime.setOverride(true);
        }
        BookedResource bookedResourceLowest = this.studyDAO.findBookedResourceLowest(bookedVisit);
        List<BookedResource> bookedResourceList = this.appointmentDAO.findBookedResourcesByBookedVisit(bookedVisit);
        Date earliestBookedResourceTime = bookedResourceLowest.getScheduledStartTime();
        Date latestBookedResourceTime = this.appointmentDAO.findLatestBookedResourcesByBookedVisit(bookedVisit);
        int visitDuration = (int)(latestBookedResourceTime.getTime() / 60000L - earliestBookedResourceTime.getTime() / 60000L);
        VisitType visitType = visitTemplate.getVisitType();
        Calendar scheduledEndTimeCal = this.createStartAndEndDateForBV(visitTemplate, eventDate, bookedResourceLowest, visitDuration, visitType);
        Date originalVisitStartDate = bookedVisit.getScheduledStartTime();
        BookedVisit clonedVisit = this.createClonedBookedVisit(user, bookedVisit, eventDate, scheduledEndTimeCal);
        this.setRoomsForBVFromBookedVisit(bookedResourceList, clonedVisit);
        this.createBookedVisitComments(visitTime, user, ipAddress, clonedVisit);
        this.setupResourcesForRescheduledByVisit(bookedResourceList, clonedVisit, eventDate, originalVisitStartDate);
        this.logRescheduleAppointment(user, ipAddress, overrideReason, clonedVisit);
        return clonedVisit;
    }

    private void setRoomsForBVFromBookedVisit(List<BookedResource> bookedResourceList, BookedVisit clonedVisit) {
        String rooms = " ";
        for (BookedResource bookedResource : bookedResourceList) {
            Resource resource = bookedResource.getResource();
            if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = resource.getName() + ", ";
        }
        clonedVisit.setRooms(rooms);
    }

    private Calendar createStartAndEndDateForBV(VisitTemplate visitTemplate, Date eventDate, BookedResource bookedResourceLowest, int visitDuration, VisitType visitType) {
        if (visitType.isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            Date lowestStartDate = bookedResourceLowest.getScheduledStartTime();
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        }
        Calendar scheduledEndTimeCal = Calendar.getInstance();
        scheduledEndTimeCal.clear();
        scheduledEndTimeCal.setTime(eventDate);
        scheduledEndTimeCal.add(12, visitDuration);
        scheduledEndTimeCal.set(13, 0);
        scheduledEndTimeCal.set(14, 0);
        return scheduledEndTimeCal;
    }

    private void createBookedVisitComments(VisitTime visitTime, User user, String ipAddress, BookedVisit clonedVisit) {
        if (visitTime.getComment() != null && !visitTime.getComment().isEmpty()) {
            Comments comments = new Comments();
            comments.setComment(visitTime.getComment());
            comments.setBookedVisit(clonedVisit);
            comments.setUser(user);
            comments.setDate(new Date());
            this.appointmentDAO.createEntity(comments);
            this.auditService.logAppointmentActivity(ipAddress, clonedVisit, user, "CREATE BOOKED VISIT COMMENT", null, null);
        }
    }

    private BookedVisit createClonedBookedVisit(User user, BookedVisit bookedVisit, Date eventDate, Calendar scheduledEndTimeCal) {
        BookedVisit clonedVisit = this.tryCloneVisit(bookedVisit);
        clonedVisit.setId(null);
        clonedVisit.setAppointmentStatusReason(null);
        clonedVisit.setCancelStatus(null);
        clonedVisit.setAppointmentStatus(this.scheduledStatus());
        clonedVisit.setScheduledStartTime(eventDate);
        clonedVisit.setScheduledEndTime(scheduledEndTimeCal.getTime());
        clonedVisit.setCancelDate(null);
        clonedVisit.setCancelStatusReason(null);
        clonedVisit.setComment("");
        clonedVisit.setSchedulingTime(new Date());
        clonedVisit.setSchedulingUserEcommonsId(user.getEcommonsId());
        clonedVisit.setSchedulingFlavor("RESCHEDULED APPOINTMENT");
        this.appointmentDAO.createEntity(clonedVisit);
        return clonedVisit;
    }

    private void logRescheduleAppointment(User user, String ipAddress, AppointmentOverrideReason overrideReason, BookedVisit clonedVisit) {
        ActivityLog al = new ActivityLog();
        al.setActionPerformed("RESCHEDULED APPOINTMENT");
        al.setBookedVisit(clonedVisit);
        al.setPerformingUser(user);
        al.setDate(new Date());
        al.setIpAddress(ipAddress);
        al.setAppointmentOverrideReason(overrideReason);
        this.appointmentDAO.createEntity(al);
    }

    void setupResourcesForRescheduledByVisit(List<BookedResource> bookedResourceList, BookedVisit clonedVisit, Date eventDate, Date originalVisitStartDate) {
        ArrayList clonedBookedResourceList = Lists.newArrayList();
        for (BookedResource bookedResource : bookedResourceList) {
            BookedResource clonedBookedResource = bookedResource.cloneBookedResource();
            clonedBookedResource.setId(null);
            clonedBookedResource.setBookedVisit(clonedVisit);
            clonedBookedResourceList.add(clonedBookedResource);
            Integer deltaStartTime = (int)(clonedBookedResource.getScheduledStartTime().getTime() - originalVisitStartDate.getTime());
            Date newStartTime = new Date(eventDate.getTime() + (long)deltaStartTime.intValue());
            clonedBookedResource.setScheduledStartTime(newStartTime);
            long endDuration = clonedBookedResource.getDuration().intValue();
            long endDurationMillis = endDuration * 60L * 1000L;
            long newEndTimeMillis = newStartTime.getTime();
            Date newEndTime = new Date(newEndTimeMillis + endDurationMillis);
            clonedBookedResource.setScheduledEndTime(newEndTime);
            this.appointmentDAO.createEntity(clonedBookedResource);
            List<OverrideBookedResourceAnnotations> obrasToClone = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(bookedResource);
            for (OverrideBookedResourceAnnotations obraToClone : obrasToClone) {
                OverrideBookedResourceAnnotations clonedObra = obraToClone.cloneObra();
                clonedObra.setBookedResource(clonedBookedResource);
                this.appointmentDAO.createEntity(clonedObra);
            }
        }
    }

    boolean overbookTimeWithin24Hours(Date visitStartTime, Date overbookTime) {
        long diff = visitStartTime.getTime() - overbookTime.getTime();
        long diffHours = diff / 3600000L;
        return diffHours <= 24L;
    }

    void persistBookedResources(List<BookedResource> resources, BookedVisit bookedVisit) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (BookedResource resource : resources) {
            resource.setBookedVisit(bookedVisit);
            resource.setBillable(resource.getTemplateResource().getBillable());
            this.appointmentDAO.createEntity(resource);
            List<TemplateResourceAnnotations> tr = this.appointmentDAO.findTemplateResourceAnnotationsByTemplateResource(resource.getTemplateResource());
            if (tr.size() <= 0) continue;
            for (TemplateResourceAnnotations tra : tr) {
                OverrideBookedResourceAnnotations bookedResourceAnnotations = new OverrideBookedResourceAnnotations();
                bookedResourceAnnotations.setBookedResource(resource);
                bookedResourceAnnotations.setLineLevelAnnotations(tra.getLineLevelAnnotations());
                bookedResourceAnnotations.setComment(tra.getComment());
                bookedResourceAnnotations.setQuantity(tra.getQuantity());
                this.appointmentDAO.createEntity(bookedResourceAnnotations);
            }
        }
    }

    void persistVisit(BookedVisit visit, UserSession user, String ipAddress) {
        visit.setSchedulingTime(new Date());
        visit.setSchedulingUserEcommonsId(user.getUser().getEcommonsId());
        visit.setSchedulingFlavor("SCHEDULED APPOINTMENT");
        this.appointmentDAO.createEntity(visit);
        this.auditService.logAppointmentActivity(ipAddress, visit, user.getUser(), "SCHEDULED APPOINTMENT", null, null);
    }

    public BookedVisit confirmOverbookRoomData(VisitTime ap, User user, String ipAddress, String templatePath) {
        Date eventDate = new Date(ap.getStartDate());
        StudySubject selectedSubject = this.studyDAO.findStudySubjectById(ap.getSubject());
        VisitTemplate selectedVisit = this.studyDAO.findVisitTemplateById(ap.getVisit());
        TemplateResource templateResourceLowest = this.studyDAO.findTemplateResourceLowest(selectedVisit);
        int eventDateMinutesDelta = 0;
        if (selectedVisit.getVisitType().isInpatient() && !selectedVisit.getRelativeTime().booleanValue()) {
            eventDate.setHours(templateResourceLowest.getStartDate().getHours());
            eventDate.setMinutes(templateResourceLowest.getStartDate().getMinutes());
            eventDate.setSeconds(0);
        } else {
            eventDateMinutesDelta = eventDate.getHours() * 60 + eventDate.getMinutes();
        }
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(ap.getOverrideReason());
        BookedVisit independentVisit = new BookedVisit();
        independentVisit.setAppointmentStatus(this.scheduledStatus());
        independentVisit.setAppointmentStatusReason(null);
        independentVisit.setBookedResourceList(null);
        independentVisit.setCancelDate(null);
        independentVisit.setCancelStatus(null);
        independentVisit.setCancelStatusReason(null);
        independentVisit.setCheckInDate(null);
        independentVisit.setCheckOutDate(null);
        independentVisit.setCheckoutStatusReason(null);
        independentVisit.setName(selectedVisit.getName());
        independentVisit.setScheduledEndTime(eventDate);
        independentVisit.setScheduledStartTime(eventDate);
        independentVisit.setStudy(selectedVisit.getStudy());
        independentVisit.setStudySubject(selectedSubject);
        independentVisit.setVisitTemplate(selectedVisit);
        independentVisit.setVisitType(selectedVisit.getVisitType());
        independentVisit.setComment("");
        this.appointmentDAO.createEntity(independentVisit);
        List<TemplateResource> templateResourcesByVisit = this.studyDAO.findTemplateResourcesByVisit(selectedVisit);
        List<Resource> selectedResources = this.setupBookedResourcesForAppointmentWithVisitTime(ap, user, templatePath, eventDate, independentVisit, templateResourcesByVisit, eventDateMinutesDelta);
        if (ap.getOverrideReason() != 0) {
            ap.setOverride(true);
        }
        if (!selectedResources.isEmpty()) {
            ActivityLog al = new ActivityLog();
            al.setActionPerformed("OVERBOOK");
            al.setBookedVisit(independentVisit);
            al.setPerformingUser(user);
            al.setDate(new Date());
            al.setIpAddress(ipAddress);
            al.setAppointmentOverrideReason(overrideReason);
            this.appointmentDAO.createEntity(al);
            String rooms = " ";
            for (Resource resource : selectedResources) {
                if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
                rooms = rooms + resource.getName() + ", ";
                independentVisit.setRooms(rooms);
            }
            independentVisit.setSchedulingTime(new Date());
            independentVisit.setSchedulingUserEcommonsId(user.getEcommonsId());
            independentVisit.setSchedulingFlavor("OVERBOOK");
            this.appointmentDAO.updateEntity(independentVisit);
            if (this.overbookTimeWithin24Hours(independentVisit.getScheduledStartTime(), Calendar.getInstance().getTime())) {
                List<TemplateResource> trs = this.studyDAO.findTemplateResourcesByVisit(selectedVisit);
                ArrayList<String> conditions = new ArrayList<String>();
                boolean containsNursingResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                boolean containsNutritionResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                boolean containsLabResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                if (containsNursingResources) {
                    conditions.add("This visit contains Nursing resources. ");
                }
                if (containsNutritionResources) {
                    conditions.add("This visit contains Nutrition resources. ");
                }
                if (containsLabResources) {
                    conditions.add("This visit contains Lab resources. ");
                }
                this.sendOverBookedVisitEmail(independentVisit, user.getInstitution().getLongName(), templatePath, conditions);
            }
        }
        return independentVisit;
    }

    public BookedVisit overbookRoomData(VisitTime visitTime) {
        Date visitStartTime = new Date(visitTime.getStartDate());
        StudySubject selectedSubject = this.studyDAO.findStudySubjectById(visitTime.getSubject());
        VisitTemplate selectedVisitTemplate = this.studyDAO.findVisitTemplateById(visitTime.getVisit());
        TemplateResource templateResourceLowest = this.studyDAO.findTemplateResourceLowest(selectedVisitTemplate);
        if (selectedVisitTemplate.getVisitType().isInpatient() && !selectedVisitTemplate.getRelativeTime().booleanValue()) {
            visitStartTime.setHours(templateResourceLowest.getStartDate().getHours());
            visitStartTime.setMinutes(templateResourceLowest.getStartDate().getMinutes());
            visitStartTime.setSeconds(0);
        }
        AppointmentStatus status = this.scheduledStatus();
        int minutes = visitStartTime.getHours() * 60 + visitStartTime.getMinutes();
        int endMinutes = minutes + selectedVisitTemplate.getDuration();
        int hours = this.divideByMinsPerHour(endMinutes);
        int min = this.moduloMinsPerHour(endMinutes);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(visitStartTime);
        cal.set(11, hours);
        cal.set(12, min);
        cal.set(13, 0);
        cal.set(14, 0);
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setAppointmentStatus(status);
        bookedVisit.setAppointmentStatusReason(null);
        bookedVisit.setBookedResourceList(null);
        bookedVisit.setCancelDate(null);
        bookedVisit.setCancelStatus(null);
        bookedVisit.setCancelStatusReason(null);
        bookedVisit.setCheckInDate(null);
        bookedVisit.setCheckOutDate(null);
        bookedVisit.setCheckoutStatusReason(null);
        bookedVisit.setComment("");
        bookedVisit.setName(selectedVisitTemplate.getName());
        bookedVisit.setScheduledEndTime(cal.getTime());
        bookedVisit.setScheduledStartTime(visitStartTime);
        bookedVisit.setStudy(selectedVisitTemplate.getStudy());
        bookedVisit.setStudySubject(selectedSubject);
        bookedVisit.setVisitTemplate(selectedVisitTemplate);
        bookedVisit.setVisitType(selectedVisitTemplate.getVisitType());
        List<TemplateResource> templateResourcesForSelectedVisit = this.studyDAO.findTemplateResourcesByVisit(selectedVisitTemplate);
        List<Resource> roomResources = this.resourceDAO.getRooms();
        if (visitTime.getRoomSelected() == 0) {
            TemplateResource templateResource = new TemplateResource();
            this.setupTemplateResource(templateResource, selectedVisitTemplate, bookedVisit);
            for (Resource alternateResource : roomResources) {
                templateResource.setResource(alternateResource);
                TemplateResource altResource = this.createTempResourceSlot(alternateResource, templateResource);
                boolean isAvailable = this.checkAvailability(altResource, bookedVisit.getBookedResourceList(), templateResourcesForSelectedVisit);
                if (!isAvailable) continue;
                templateResource.setResource(altResource.getResource());
                bookedVisit.setSelectedRoom(altResource.getResource());
                break;
            }
        } else if (visitTime.getRoomSelected() != 0) {
            Resource room = this.resourceDAO.findResourceById(visitTime.getRoomSelected());
            bookedVisit.setSelectedRoom(room);
        }
        this.setTemplateResourceTimes(visitStartTime, templateResourcesForSelectedVisit);
        return bookedVisit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfirmationStatus confirmEvent(VisitTime visitTime, UserSession user, String ipAddress, String institution, String templatePath, boolean isInpatient) {
        Object object = this.confirmationLock;
        synchronized (object) {
            Date startDate = new Date(visitTime.getStartDate());
            Date endDate = new Date(visitTime.getEndDate());
            if (this.timeSlotAvailable(visitTime, user, isInpatient)) {
                if (visitTime.getDoubleRoomMessage() == null) {
                    this.confirmVisitBooking(visitTime, user, ipAddress, institution, templatePath, startDate, endDate);
                } else {
                    this.confirmVisitBookingAfterDoubleRoomMessage(visitTime, user, ipAddress, institution, templatePath, startDate, endDate);
                }
                return ConfirmationStatus.Confirmed;
            }
            return ConfirmationStatus.NotConfirmed;
        }
    }

    boolean timeSlotAvailable(VisitTime visitTime, UserSession userSession, boolean isInpatient) {
        return this.conflictChecker.timeSlotAvailable(visitTime, userSession, isInpatient);
    }

    void confirmVisitBookingAfterDoubleRoomMessage(VisitTime visitTime, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
        this.appointmentConfirmer.confirmVisitBookingAfterDoubleRoomMessage(visitTime, userSession, ipAddress, institution, templatePath, startDate, endDate);
    }

    void confirmVisitBooking(VisitTime visitTime, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
        this.appointmentConfirmer.confirmVisitBooking(visitTime, userSession, ipAddress, institution, templatePath, startDate, endDate);
    }

    void sendWeighedMealEmail(BookedVisit resVisit, BookedResource br, String institution, String templatePath) {
        String title = "Weighed Meal booked for : " + br.getScheduledStartTime();
        String visitName = resVisit.getName();
        String studyName = resVisit.getStudy().getName();
        String localId = resVisit.getStudy().getLocalId();
        String catalystId = resVisit.getStudy().getCatalystId();
        String irb = resVisit.getStudy().getIrb();
        String investigator = null;
        if (resVisit.getStudy().getInvestigator() != null) {
            investigator = resVisit.getStudy().getInvestigator().getFirstName() + ' ' + resVisit.getStudy().getInvestigator().getLastName();
        }
        String startTime = resVisit.getScheduledStartTime().toString();
        String endTime = resVisit.getScheduledEndTime().toString();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate meal = group.getInstanceOf("weighedMealEmail");
        meal.setAttribute("institution", (Object)institution);
        meal.setAttribute("visitName", (Object)visitName);
        meal.setAttribute("studyName", (Object)studyName);
        meal.setAttribute("investigator", (Object)investigator);
        meal.setAttribute("startTime", (Object)startTime);
        meal.setAttribute("endTime", (Object)endTime);
        meal.setAttribute("localId", (Object)localId);
        meal.setAttribute("catalystId", (Object)catalystId);
        meal.setAttribute("irb", (Object)irb);
        if (resVisit.getStudy().getProtocolNutritionist() == null) {
            List<User> user = this.authDAO.findNutritionManagerUserByRole();
            for (User us : user) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(us.getPreferredNotificationEmail()).subject(title).text(meal.toString()).build());
            }
        } else if (resVisit.getStudy().getProtocolNutritionist() != null) {
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(resVisit.getStudy().getProtocolNutritionist().getPreferredNotificationEmail()).subject(title).text(meal.toString()).build());
        }
    }

    BookedVisit createBookedVisit(VisitTime curEvent, UserSession userSession, Date startDate, Date endDate) {
        Optional<Object> selectedSubjectOption = curEvent.getSubject() != 0 ? Optional.ofNullable(this.studyDAO.findStudySubjectById(curEvent.getSubject())) : Optional.empty();
        Optional<VisitTemplate> selectedVisitOption = Optional.ofNullable(this.studyDAO.findVisitTemplateById(curEvent.getVisit()));
        StudySubject subject = selectedSubjectOption.orElse(null);
        VisitTemplate selectedVisit = selectedVisitOption.orElse(null);
        BookedVisit resVisit = new BookedVisit();
        User user = userSession.getUser();
        resVisit.setVisitTemplate(selectedVisit);
        Study s = this.studyDAO.findStudyById(curEvent.getStudy());
        resVisit.setStudy(s);
        resVisit.setAppointmentStatus(this.scheduledStatus());
        resVisit.setScheduledStartTime(startDate);
        resVisit.setScheduledEndTime(endDate);
        resVisit.setBookedResourceList(user.getBookedVisits().get(0).getBookedResourceList());
        if (resVisit.getBookedResourceList() == null) {
            resVisit.setBookedResourceList(Lists.newArrayList());
        }
        resVisit.setStudySubject(subject);
        resVisit.setComment("");
        resVisit.setName(selectedVisit.getName());
        resVisit.setVisitType(selectedVisit.getVisitType());
        resVisit.setAppointmentStatusReason(null);
        return resVisit;
    }

    Comments createCommentsRecordIfNonemptyComment(BookedVisit bookedVisit, User user, String ipAddress) {
        Comments comments = null;
        String commentString = bookedVisit.getComment();
        if (commentString != null && !commentString.isEmpty()) {
            comments = new Comments();
            comments.setComment(commentString);
            comments.setBookedVisit(bookedVisit);
            comments.setUser(user);
            comments.setDate(new Date());
            this.appointmentDAO.createEntity(comments);
            this.auditService.logAppointmentActivity(ipAddress, bookedVisit, user, "CREATE BOOKED VISIT COMMENT", null, null);
        }
        return comments;
    }

    VisitCancelStatus calculateVisitCancelStatus(Date visitScheduledStartTime, Date cancelStatusTime, int cancelTimeHr, int cancelTimeMin) {
        Calendar cal = Calendar.getInstance();
        if (cancelStatusTime != null) {
            cal.clear();
            cal.setTime(cancelStatusTime);
        }
        if (cancelTimeHr >= 0) {
            cal.set(11, cancelTimeHr);
        }
        if (cancelTimeMin >= 0) {
            cal.set(12, cancelTimeMin);
        }
        return this.calculateCancellationStatus(visitScheduledStartTime, cal.getTime());
    }

    VisitCancelStatus calculateCancellationStatus(Date visitStartTime, Date cancelTime) {
        VisitCancelStatus status = this.cancelTimeAfterScheduledTime(visitStartTime, cancelTime) ? new VisitCancelStatus(5, "No Show") : (this.cancelTimeWithin48Hours(visitStartTime, cancelTime) ? new VisitCancelStatus(6, "Late Cancellation") : new VisitCancelStatus(7, "Cancellation"));
        return status;
    }

    boolean cancelTimeWithin48Hours(Date visitStartTime, Date cancelTime) {
        long diff = visitStartTime.getTime() - cancelTime.getTime();
        long diffHours = diff / 3600000L;
        return diffHours > 0L && diffHours <= 48L;
    }

    boolean cancelTimeAfterScheduledTime(Date visitStartTime, Date cancelTime) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(visitStartTime);
        cal.set(14, 0);
        Date visTime = cal.getTime();
        cal.clear();
        cal.setTime(cancelTime);
        cal.set(14, 0);
        Date curCancelTime = cal.getTime();
        return !curCancelTime.equals(visTime) && curCancelTime.after(visTime);
    }

    public Comments saveComment(VisitTime s, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(s.getId());
        bv.setComment(s.getComment());
        this.appointmentDAO.updateEntity(bv);
        return this.createCommentsRecordIfNonemptyComment(bv, user, ipAddress);
    }

    public BookedVisit checkInVisit(VisitTime s, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(s.getId());
        if (s.getCheckInDate() == 0L) {
            bv.setCheckInDate(Calendar.getInstance().getTime());
        } else {
            bv.setCheckInDate(new Date(s.getCheckInDate()));
        }
        bv.setAppointmentStatus(this.checkedInStatus());
        this.appointmentDAO.updateEntity(bv);
        this.auditService.logAppointmentActivity(ipAddress, bv, user, "CHECKED-IN APPOINTMENT", null, null);
        return bv;
    }

    public BookedVisit checkOutVisit(VisitTime s, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(s.getId());
        if (s.getCheckOutDate() == 0L) {
            bv.setCheckOutDate(Calendar.getInstance().getTime());
        } else {
            bv.setCheckOutDate(new Date(s.getCheckOutDate()));
        }
        bv.setOmmittedActivities(s.isOmmittedActivities());
        bv.setVaryDuration(s.isVaryDuration());
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(s.getAppointmentStatusReason());
        bv.setAppointmentStatusReason(reason);
        bv.setAppointmentStatus(this.checkedOutStatus());
        bv.setCheckoutStatusReason(reason);
        this.appointmentDAO.updateEntity(bv);
        ArrayList visits = Lists.newArrayList();
        visits.add(bv);
        this.setRooms(visits);
        this.auditService.logAppointmentActivity(ipAddress, bv, user, "CHECKED-OUT APPOINTMENT", null, null);
        return bv;
    }

    public BookedVisit batchEntryUpdate(VisitTime s, User user, String ipAddress, String templatePath) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(s.getId());
        bv.setErrorMsg("true");
        if (s.getCheckOutDate() != 0L) {
            this.setCheckOutDate(s, bv);
        }
        if (!bv.getErrorMsg().equalsIgnoreCase("true")) {
            return bv;
        }
        if (s.getCheckInDate() != 0L) {
            this.setCheckInDate(s, bv);
        }
        if (s.getCheckoutStatusReason() != 0) {
            this.setCheckOutReason(s, bv);
        } else if (s.getCancelStatusReason() != 0) {
            this.setCancellationReason(s, bv);
        } else {
            bv.setAppointmentStatus(this.checkedInStatus());
        }
        if (s.getCancelDate() != 0L) {
            this.setLateCancellationCalculation(s, user, templatePath, bv);
        }
        this.appointmentDAO.updateEntity(bv);
        this.auditService.logAppointmentActivity(ipAddress, bv, user, "BATCH ENTRY", null, null);
        bv.setErrorMsg("true");
        return bv;
    }

    void setLateCancellationCalculation(VisitTime s, User user, String templatePath, BookedVisit bv) {
        Date cancelStatusTime = new Date(s.getCancelDate());
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(cancelStatusTime);
        cal.set(11, 0);
        cal.set(12, 0);
        VisitCancelStatus visitCancelStatus = this.calculateVisitCancelStatus(bv.getScheduledStartTime(), cancelStatusTime, 0, 0);
        CancellationStatus cancelStatus = this.appointmentDAO.findCancellationStatusById(visitCancelStatus.getId());
        bv.setCancelStatus(cancelStatus);
        if (cancelStatus.getId().equals(6)) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
    }

    void setCancellationReason(VisitTime s, BookedVisit bv) {
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(s.getCancelStatusReason());
        bv.setCancelStatusReason(reason);
        bv.setAppointmentStatusReason(reason);
        if (s.getCancelDate() != 0L) {
            bv.setCancelDate(new Date(s.getCancelDate()));
        } else {
            bv.setCancelDate(Calendar.getInstance().getTime());
        }
        bv.setAppointmentStatus(this.cancelledStatus());
        bv.setCheckInDate(null);
        bv.setCheckoutStatusReason(null);
        bv.setCheckOutDate(null);
        bv.setCheckoutStatusReasonName(null);
    }

    void setCheckOutReason(VisitTime s, BookedVisit bv) {
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(s.getCheckoutStatusReason());
        bv.setCheckoutStatusReason(reason);
        bv.setAppointmentStatusReason(reason);
        bv.setAppointmentStatus(this.checkedOutStatus());
        bv.setCancelStatusReason(null);
        bv.setCancelDate(null);
    }

    void setCheckOutDate(VisitTime s, BookedVisit bv) {
        Date checkout = new Date(s.getCheckOutDate());
        Date checkInDate = new Date(s.getCheckInDate());
        long checkIn = s.getCheckInDate();
        if (checkIn == 0L && bv.getCheckInDate().before(checkout)) {
            bv.setCheckOutDate(checkout);
        } else if (checkIn != 0L && checkInDate.before(checkout)) {
            bv.setCheckOutDate(checkout);
        } else {
            bv.setErrorMsg("Please Note: Check-Out Date needs to be greater than Check-In Date.");
        }
    }

    void setCheckInDate(VisitTime s, BookedVisit bv) {
        bv.setCheckInDate(new Date(s.getCheckInDate()));
        bv.setCancelDate(null);
        bv.setCancelStatusReason(null);
    }

    void sendLateCancellationEmail(BookedVisit visit, String institution, String templatePath) {
        String visitName = visit.getName();
        String visitType = visit.getVisitType().getName();
        String sublocation = visit.getVisitTemplate().getSublocation().getName();
        String localId = visit.getStudy().getLocalId();
        String startTime = DateUtility.format(DateUtility.dateHourMin(), visit.getScheduledStartTime());
        String cancellationTime = DateUtility.format(DateUtility.dateHourMin(), new Date());
        Study study = visit.getStudy();
        String title = "Urgent! Late Cancellation of " + visitName;
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate stringTemplate = group.getInstanceOf("lateCancellationEmail");
        stringTemplate.setAttribute("institution", (Object)institution);
        stringTemplate.setAttribute("visitName", (Object)visitName);
        stringTemplate.setAttribute("visitType", (Object)visitType);
        stringTemplate.setAttribute("sublocation", (Object)sublocation);
        stringTemplate.setAttribute("localId", (Object)localId);
        stringTemplate.setAttribute("startTime", (Object)startTime);
        stringTemplate.setAttribute("cancellationTime", (Object)cancellationTime);
        this.sendEmailNotifications(study, title, stringTemplate);
    }

    void sendEmailNotifications(Study study, String title, StringTemplate stringTemplate) {
        ArrayList<User> studyTeam = new ArrayList<User>();
        if (study.getScheduler() != null) {
            studyTeam.add(study.getScheduler());
        }
        if (study.getInvestigator() != null) {
            studyTeam.add(study.getInvestigator());
        }
        if (study.getProtocolNurse() != null) {
            studyTeam.add(study.getProtocolNurse());
        }
        if (study.getProtocolNutritionist() != null) {
            studyTeam.add(study.getProtocolNutritionist());
        }
        if (study.getPhysician() != null) {
            studyTeam.add(study.getPhysician());
        }
        List<User> nurseManager = this.authDAO.findNurseManagerUserByRole();
        List<User> nutritionDirector = this.authDAO.findNutritionManagerUserByRole();
        List<User> scheduler = this.authDAO.findSchedulerUserByInstitutionRole();
        List<User> finalApprover = this.authDAO.findFinalApproverByRole();
        List<User> adminDirector = this.authDAO.findAdminDirectorUserByRole();
        List<User> crcAdmin = this.authDAO.findCRCAdminByRole();
        if (studyTeam.size() > 0 || !studyTeam.isEmpty()) {
            for (User u : studyTeam) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (nurseManager.size() > 0 || !nurseManager.isEmpty()) {
            for (User u : nurseManager) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (nutritionDirector.size() > 0 || !nutritionDirector.isEmpty()) {
            for (User u : nutritionDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (scheduler.size() > 0 || !scheduler.isEmpty()) {
            for (User u : scheduler) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (finalApprover.size() > 0 || !finalApprover.isEmpty()) {
            for (User u : finalApprover) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (adminDirector.size() > 0 || !adminDirector.isEmpty()) {
            for (User u : adminDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (crcAdmin.size() > 0 || !crcAdmin.isEmpty()) {
            for (User u : adminDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
    }

    public BookedVisit cancelVisit(VisitTime s, User user, String ipAddress, String templatePath) {
        BooleanResultDTO result = new BooleanResultDTO();
        result.setResult(false);
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(s.getId());
        Calendar cal = Calendar.getInstance();
        boolean cancelTimeHr = false;
        boolean cancelTimeMin = false;
        if (s.getCancelDate() == 0L) {
            bv.setCancelDate(Calendar.getInstance().getTime());
        } else {
            bv.setCancelDate(new Date(s.getCancelDate()));
        }
        Date cancelStatusTime = bv.getCancelDate();
        cal.clear();
        cal.setTime(cancelStatusTime);
        cal.set(11, 0);
        cal.set(12, 0);
        VisitCancelStatus visitCancelStatus = this.calculateVisitCancelStatus(bv.getScheduledStartTime(), cancelStatusTime, 0, 0);
        CancellationStatus cancelStatus = this.appointmentDAO.findCancellationStatusById(visitCancelStatus.getId());
        bv.setCancelStatus(cancelStatus);
        if (cancelStatus.getId().equals(6)) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(s.getAppointmentStatusReason());
        bv.setAppointmentStatus(this.cancelledStatus());
        bv.setAppointmentStatusReason(reason);
        bv.setCancelStatusReason(reason);
        this.appointmentDAO.updateEntity(bv);
        ArrayList visits = Lists.newArrayList();
        visits.add(bv);
        this.setRooms(visits);
        if (this.cancelTimeWithin48Hours(bv.getScheduledStartTime(), Calendar.getInstance().getTime())) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
        this.auditService.logAppointmentActivity(ipAddress, bv, user, "CANCELLED APPOINTMENT", null, null);
        result.setResult(true);
        return bv;
    }

    BookedVisit getVisitDetails(int bookedVisitId, User user, String remoteHost, boolean clicked) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        if (clicked) {
            if (bookedVisit.getAppointmentStatus().getName().equalsIgnoreCase("cancellation")) {
                this.auditService.logAppointmentActivity(remoteHost, bookedVisit, user, "Clicked on the cancelled appointment and viewed the resources list.", null, null);
            } else {
                this.auditService.logAppointmentActivity(remoteHost, bookedVisit, user, "Clicked on the " + bookedVisit.getAppointmentStatus().getName() + " appointment and viewed the resources list.", null, null);
            }
        }
        bookedVisit.setScheduledata("");
        bookedVisit.setUserdata("");
        Date scheduleDate = null;
        String action = "";
        String performingUser = null;
        if (bookedVisit.getSchedulingFlavor() != null) {
            if (bookedVisit.getSchedulingFlavor().equalsIgnoreCase("OVERBOOK")) {
                action = "Overbooked on: ";
            } else if (bookedVisit.getSchedulingFlavor().equalsIgnoreCase("Scheduled Appointment")) {
                action = "Scheduled on: ";
            }
        }
        if (bookedVisit.getSchedulingTime() != null) {
            scheduleDate = bookedVisit.getSchedulingTime();
        }
        if (bookedVisit.getSchedulingUserEcommonsId() != null) {
            performingUser = bookedVisit.getSchedulingUserEcommonsId();
        }
        if (scheduleDate != null) {
            bookedVisit.setScheduleDate(scheduleDate);
            bookedVisit.setScheduledata(action + DateUtility.format(DateUtility.dateHourMin(), scheduleDate));
            bookedVisit.setUserdata("by user:" + performingUser);
        }
        return bookedVisit;
    }

    public BookedVisit getVisitDetails(int bookedVisitId, User user, String remoteHost) {
        boolean permittedToGet = this.appointmentDAO.canUserSeeBookedVisit(user, bookedVisitId);
        if (!permittedToGet) {
            SchedulerRuntimeException.logAndThrow("User not allowed to get details for requested study");
        }
        return this.getVisitDetails(bookedVisitId, user, remoteHost, true);
    }

    public List<BookedResourcesResponse> getBookedResources(int bookedVisitId, String sortBy, String orderBy, int page, int maxResults) {
        return this.appointmentDAO.getBookedResourcesListByBookedVisit(bookedVisitId, sortBy, orderBy, page, maxResults);
    }

    public List<BookedResourcesResponse> getEventResources(String eventId, User user) {
        ArrayList<BookedResourcesResponse> bookedResourcesResponses = new ArrayList<BookedResourcesResponse>();
        for (BookedVisit bookedVisit : user.getBookedVisits()) {
            if (!bookedVisit.getUniquekey().equalsIgnoreCase(eventId)) continue;
            List<BookedResource> resources = bookedVisit.getBookedResourceList();
            boolean subjectAvailable = this.appointmentDAO.findConflictingBookedVisitsBySubject(bookedVisit.getStudySubject().getSubject().getId(), bookedVisit.getScheduledStartTime(), bookedVisit.getScheduledEndTime());
            if (resources != null) {
                for (int i = 0; i < resources.size(); ++i) {
                    resources.get(i).setId(i + 1000);
                }
                Collections.sort(resources, eventResourceComparator);
            }
            for (BookedResource resource : resources) {
                BookedResourcesResponse bookedResourcesResponse = new BookedResourcesResponse(resource.getId(), resource.getResource().getName(), "", resource.getScheduledStartTime(), resource.getScheduledEndTime(), resource.getRejectedResourceMessage(), resource.getAvailable(), resource.getTemplateResource().getResourceGroupType(), Long.valueOf(resources.size()), subjectAvailable);
                bookedResourcesResponses.add(bookedResourcesResponse);
            }
        }
        return bookedResourcesResponses;
    }

    public BooleanResultDTO deleteBookedResourceOverride(VisitTime tr, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        BookedResource br = this.appointmentDAO.findBookedResourceById(tr.getId());
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(br.getBookedVisit().getId());
        List<OverrideBookedResourceAnnotations> tempAnnotations = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(br);
        for (OverrideBookedResourceAnnotations tempAnnotation : tempAnnotations) {
            this.appointmentDAO.deleteEntity(tempAnnotation);
        }
        ActivityLog al = new ActivityLog();
        AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(tr.getOverrideReason());
        al.setAppointmentOverrideReason(aor);
        al.setAffectedResource(br.getResource());
        al.setActionPerformed(aor.getName());
        al.setDate(new Date());
        al.setPerformingUser(user);
        al.setIpAddress(ipAddress);
        al.setBookedVisit(br.getBookedVisit());
        this.appointmentDAO.deleteEntity(br);
        BookedResource bookedResourceLowest = this.studyDAO.findBookedResourceLowest(bookedVisit);
        Date earliestBookedResourceTime = bookedResourceLowest.getScheduledStartTime();
        Date latestBookedResourceTime = this.appointmentDAO.findLatestBookedResourcesByBookedVisit(bookedVisit);
        bookedVisit.setScheduledStartTime(earliestBookedResourceTime);
        bookedVisit.setScheduledEndTime(latestBookedResourceTime);
        this.appointmentDAO.updateEntity(bookedVisit);
        this.appointmentDAO.createEntity(al);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    int moduloMinsPerHour(int totalMinutes) {
        return this.multiDayMinutesToHourlyMinute(totalMinutes);
    }

    int divideByMinsPerHour(int totalMinutes) {
        return totalMinutes / 60;
    }

    int divideByMinsPerDay(int totalMinutes) {
        return totalMinutes / 1440;
    }

    public BooleanResultDTO editBookedResourceOverride(VisitTime tr, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        BookedResource br = this.appointmentDAO.findBookedResourceById(tr.getId());
        Resource r = this.resourceDAO.findResourceById(tr.getResource());
        ActivityLog al = new ActivityLog();
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(br.getBookedVisit().getId());
        AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(tr.getOverrideReason());
        al.setAppointmentOverrideReason(aor);
        al.setActionPerformed(aor.getName());
        al.setAffectedResource(br.getResource());
        al.setDate(new Date());
        al.setPerformingUser(user);
        al.setIpAddress(ipAddress);
        al.setBookedVisit(bookedVisit);
        al.setChangesDetail("Resource : " + br.getResource().getName() + " to " + r.getName() + ", " + " Start Time : " + br.getScheduledStartTime() + " to " + new Date(tr.getStartDate()) + ", " + " End Time : " + br.getScheduledEndTime() + " to " + new Date(tr.getEndDate()));
        br.setResource(r);
        br.setBillable(tr.isBillable());
        br.setScheduledStartTime(new Date(tr.getStartDate()));
        br.setScheduledEndTime(new Date(tr.getEndDate()));
        long start = br.getScheduledStartTime().getTime() / 60000L;
        long end = br.getScheduledEndTime().getTime() / 60000L;
        int intStart = (int)start;
        int intEnd = (int)end;
        int duration = intEnd - intStart;
        br.setDuration(duration);
        this.appointmentDAO.updateEntity(br);
        List<OverrideBookedResourceAnnotations> tempAnnotations = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(br);
        for (OverrideBookedResourceAnnotations tempAnnotation : tempAnnotations) {
            this.appointmentDAO.deleteEntity(tempAnnotation);
        }
        if (!tr.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < tr.getSelectedAnnotations().size(); ++i) {
                LineLevelAnnotations lla = this.resourceDAO.findLineLevelAnnotationsById(tr.getSelectedAnnotations().get(i));
                OverrideBookedResourceAnnotations ann = new OverrideBookedResourceAnnotations();
                ann.setBookedResource(br);
                ann.setLineLevelAnnotations(lla);
                ann.setQuantity(tr.getSelectedAnnotationsQuantity().get(i));
                ann.setComment(tr.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(ann);
            }
        }
        this.adjustAndPersistBookedVisit(bookedVisit, br);
        this.appointmentDAO.createEntity(al);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanResultDTO addBookedResourceOverride(VisitTime tr, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(tr.getId());
        Resource r = this.resourceDAO.findResourceById(tr.getResource());
        BookedResource br = new BookedResource();
        br.setBookedVisit(bookedVisit);
        br.setResource(r);
        br.setBillable(tr.isBillable());
        br.setScheduledStartTime(new Date(tr.getStartDate()));
        br.setScheduledEndTime(new Date(tr.getEndDate()));
        long start = br.getScheduledStartTime().getTime() / 60000L;
        long end = br.getScheduledEndTime().getTime() / 60000L;
        int intStart = (int)start;
        int intEnd = (int)end;
        int duration = intEnd - intStart;
        br.setDuration(duration);
        this.appointmentDAO.createEntity(br);
        this.adjustAndPersistBookedVisit(bookedVisit, br);
        if (!tr.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < tr.getSelectedAnnotations().size(); ++i) {
                OverrideBookedResourceAnnotations obra = new OverrideBookedResourceAnnotations();
                obra.setBookedResource(br);
                obra.setLineLevelAnnotations(this.resourceDAO.findLineLevelAnnotationsById(tr.getSelectedAnnotations().get(i)));
                obra.setQuantity(tr.getSelectedAnnotationsQuantity().get(i));
                obra.setComment(tr.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(obra);
            }
        }
        ActivityLog al = new ActivityLog();
        AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(tr.getOverrideReason());
        al.setAppointmentOverrideReason(aor);
        al.setActionPerformed(aor.getName());
        al.setDate(new Date());
        al.setPerformingUser(user);
        al.setIpAddress(ipAddress);
        al.setBookedVisit(bookedVisit);
        al.setAffectedResource(r);
        this.appointmentDAO.createEntity(al);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    void adjustAndPersistBookedVisit(BookedVisit bookedVisit, BookedResource br) {
        BookedResource bookedResourceHighest = this.appointmentDAO.findOrderedBookedResource(br.getBookedVisit(), "a.scheduledEndTime", "DESC");
        BookedResource bookedResourceLowest = this.appointmentDAO.findOrderedBookedResource(br.getBookedVisit(), "a.scheduledStartTime", "ASC");
        bookedVisit.setScheduledEndTime(bookedResourceHighest.getScheduledEndTime());
        bookedVisit.setScheduledStartTime(bookedResourceLowest.getScheduledStartTime());
        this.appointmentDAO.updateEntity(bookedVisit);
    }

    int subtractDaysWorthOfMinutes(int totalBefore, int numDaysToSub) {
        return totalBefore - numDaysToSub * 1440;
    }

    public List<Resource> getResources() {
        return this.resourceDAO.findResourcesListedInResourceSublocation();
    }

    public List<OverbookedResourcesResponse> selectedVisitForOverbookChecks(int bookedVisitId) {
        List resources;
        HashMap<String, List<BookedResource>> overBookedData = new HashMap<String, List<BookedResource>>();
        float totalOverrideAvailable = 0.0f;
        Map<Date, List<SublocationClosureInterval>> resourceSublocationSchedule = null;
        BookedVisit visit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        List<BookedResource> scheduledResources = this.appointmentDAO.findBookedResourcesByBookedVisit(visit);
        ArrayList<OverbookedResourcesResponse> list = new ArrayList<OverbookedResourcesResponse>();
        for (BookedResource bookedResource : scheduledResources) {
            List<BookedResource> filteredScheduledResources = this.appointmentDAO.findOverbookConflictResourcesByVisitStatus(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            if (filteredScheduledResources.isEmpty()) {
                filteredScheduledResources = new ArrayList<BookedResource>();
                filteredScheduledResources.add(bookedResource);
            }
            Map<String, List<ResourceSchedule>> resourceDefaultSchedule = this.retrieveResourceDefaultSchedule(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            resourceSublocationSchedule = null;
            Map<Date, List<ResourceSchedule>> resourceOverrideSchedule = this.retrieveResourceOverrideSchedule(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            if (resourceDefaultSchedule == null && resourceOverrideSchedule == null) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (filteredScheduledResources != null && !filteredScheduledResources.isEmpty()) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
            }
            totalOverrideAvailable = this.totalOverrideResourceAvailable(bookedResource, resourceOverrideSchedule);
            ResourceSublocation s = this.studyDAO.findSublocationByResource(bookedResource.getResource());
            if (s != null) {
                resourceSublocationSchedule = this.retrieveSublocationSchedule(s.getSublocation(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            }
            if (!resourceSublocationSchedule.isEmpty()) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (filteredScheduledResources != null && !filteredScheduledResources.isEmpty()) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
                continue;
            }
            if (totalOverrideAvailable == 0.0f) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (filteredScheduledResources != null && !filteredScheduledResources.isEmpty()) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
                continue;
            }
            TreeMap<Integer, Integer> candidatePeriodToQtyMap = new TreeMap<Integer, Integer>();
            boolean isAvailable = true;
            for (BookedResource reservedTime : filteredScheduledResources) {
                Date reservedStartDate = reservedTime.getScheduledStartTime();
                Date reservedEndDate = reservedTime.getScheduledEndTime();
                Date candidateStartDate = bookedResource.getScheduledStartTime();
                this.adjustMapsForBookedResources(candidatePeriodToQtyMap, reservedStartDate, reservedEndDate, candidateStartDate);
            }
            Date candidateStartDate = bookedResource.getScheduledStartTime();
            Date candidateEndDate = bookedResource.getScheduledEndTime();
            int firstPeriod = this.computePeriodOfDate(candidateStartDate);
            int lastPeriod = this.computeLastPeriod(candidateStartDate, candidateEndDate);
            for (int i = firstPeriod; i <= lastPeriod; ++i) {
                Integer currentQuantity = (Integer)candidatePeriodToQtyMap.get(i);
                if (currentQuantity != null && currentQuantity >= 0) continue;
                isAvailable = false;
                break;
            }
            if (isAvailable) continue;
            resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
            if (filteredScheduledResources != null && !filteredScheduledResources.isEmpty()) {
                resources.addAll(filteredScheduledResources);
            }
            overBookedData.put(bookedResource.getResource().getName(), resources);
        }
        if (overBookedData != null) {
            for (Map.Entry entry : overBookedData.entrySet()) {
                resources = (ArrayList)entry.getValue();
                if (resources == null || resources.isEmpty()) continue;
                for (BookedResource r : resources) {
                    String conflictedTimePeriod = "";
                    if (!resourceSublocationSchedule.isEmpty()) {
                        r.setConflictedTime("Sublocation Closed.");
                    } else if (totalOverrideAvailable == 0.0f) {
                        r.setConflictedTime("Resource temporarily adjusted.");
                    } else if (resources.size() > 1) {
                        r.setConflictedTime(this.getConflictedTimePeriod(resources));
                    } else {
                        Date end1 = ((BookedResource)resources.get(0)).getScheduledEndTime();
                        Date start1 = ((BookedResource)resources.get(0)).getScheduledStartTime();
                        conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
                        r.setConflictedTime(conflictedTimePeriod);
                    }
                    OverbookedResourcesResponse overbookedResourcesResponse = new OverbookedResourcesResponse(r, resources.size());
                    list.add(overbookedResourcesResponse);
                }
            }
        } else {
            list = null;
        }
        return list;
    }

    Map<Date, List<SublocationClosureInterval>> retrieveSublocationSchedule(Sublocation sublocations, Date startTime, Date endTime) {
        HashMap<Date, List<SublocationClosureInterval>> dayOfWeekSchedule = new HashMap<Date, List<SublocationClosureInterval>>();
        List<SublocationClosureInterval> sublocationScheduleList = this.appointmentDAO.findSublocationSchedule(sublocations, startTime, endTime);
        if (sublocationScheduleList != null && !sublocationScheduleList.isEmpty()) {
            this.populateSublocationClosureIntervalScheduleByDate(sublocationScheduleList, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    Map<String, List<ResourceSchedule>> retrieveResourceDefaultSchedule(Resource resource, Date startDate, Date endDate) {
        HashMap<String, List<ResourceSchedule>> dayOfWeekSchedule = new HashMap<String, List<ResourceSchedule>>();
        Set<Integer> selectedDaysOfWeek = this.getDefaultAvailabilityDaysOfWeek(startDate, endDate);
        ArrayList<Integer> daysOfWeekList = new ArrayList<Integer>(selectedDaysOfWeek);
        List<ResourceSchedule> rsl = this.resourceDAO.findResourceScheduleByResource(resource, daysOfWeekList, false);
        if (rsl != null && !rsl.isEmpty()) {
            this.populateDefaultSchedule(rsl, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    Set<Integer> getDefaultAvailabilityDaysOfWeek(Date startDate, Date endDate) {
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        HashSet daysOfWeek = Sets.newHashSet();
        Range allowedDays = Range.from((int)1).to(7).inclusive();
        for (int count = 0; count <= diff && count < 7; ++count) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTime(curDate);
            int day = cal.get(7);
            if (!allowedDays.contains(day)) continue;
            daysOfWeek.add(day);
        }
        return daysOfWeek;
    }

    List<Date> buildSearchDate(Date startDate, Date endDate) {
        ArrayList<Date> searchDates = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        if (diff == 0) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, 0, 0, 0);
            cal.clear();
            cal.setTime(curDate);
            searchDates.add(curDate);
            return searchDates;
        }
        for (int count = 0; count < diff; ++count) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
            cal.clear();
            cal.setTime(curDate);
            searchDates.add(curDate);
        }
        return searchDates;
    }

    float totalOverrideResourceAvailable(BookedResource curSelectedResource, Map<Date, List<ResourceSchedule>> resourceOverrideSchedule) {
        if (curSelectedResource == null || resourceOverrideSchedule == null) {
            return 0.0f;
        }
        float totalAvailable = -1.0f;
        Date requestStartDate = this.beginningOfDay(curSelectedResource.getScheduledStartTime());
        Date requestEndDate = this.beginningOfDay(curSelectedResource.getScheduledEndTime());
        List<Date> searchDates = this.buildSearchDate(requestStartDate, requestEndDate);
        ArrayList<ResourceSchedule> overrideSchedule = null;
        if (searchDates != null && !searchDates.isEmpty()) {
            overrideSchedule = new ArrayList<ResourceSchedule>();
            for (Date date : searchDates) {
                List<ResourceSchedule> tempOverrideSchedule = resourceOverrideSchedule.get(date);
                boolean exists = resourceOverrideSchedule.containsKey(date);
                if (!exists) continue;
                overrideSchedule.addAll(tempOverrideSchedule);
            }
        }
        if (overrideSchedule == null) {
            return -1.0f;
        }
        TreeMap<Integer, Integer> candidatePeriodToQtyMap = new TreeMap<Integer, Integer>();
        if (overrideSchedule != null && !overrideSchedule.isEmpty()) {
            totalAvailable = this.retrieveTotalResourcesFromOverrideSchedule(overrideSchedule, curSelectedResource.getScheduledStartTime(), curSelectedResource.getScheduledEndTime(), candidatePeriodToQtyMap);
        }
        if (totalAvailable == -1.0f) {
            return -1.0f;
        }
        if (totalAvailable == 0.0f) {
            return 0.0f;
        }
        return totalAvailable;
    }

    String getConflictedTimePeriod(List<BookedResource> resources) {
        String conflictedTimePeriod = "";
        boolean i = false;
        Date start1 = resources.get(0).getScheduledStartTime();
        Date end1 = resources.get(0).getScheduledEndTime();
        Date start2 = resources.get(1).getScheduledStartTime();
        Date end2 = resources.get(1).getScheduledEndTime();
        if (start1.after(start2) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.after(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end2);
        } else if (start1.before(start2) && end1.before(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start1.after(start2) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        } else if (start1.after(start2) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        } else if (start2.after(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start1.equals(start2) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start1.before(start2) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start2.before(start1) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.equals(start1) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.equals(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        }
        return conflictedTimePeriod;
    }

    String adjustConflictingTimePeriods(String conflictedTimePeriod, Date start1, Date end1) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(start1);
        String startTimeDate = DateUtility.format(DateUtility.monthDayYear(), cal.getTime());
        String conflictedStartTimePeriod = conflictedTimePeriod + startTimeDate + " ";
        int hr = cal.get(11);
        int min = cal.get(12);
        conflictedStartTimePeriod = conflictedStartTimePeriod + DateUtility.padTime(hr) + ":";
        String conflictedEndTimePeriod = conflictedStartTimePeriod = conflictedStartTimePeriod + DateUtility.padTime(min) + " to ";
        cal.clear();
        cal.setTime(end1);
        String endTimeDate = DateUtility.format(DateUtility.monthDayYear(), cal.getTime());
        conflictedEndTimePeriod = conflictedEndTimePeriod + " " + endTimeDate + " ";
        int min1 = cal.get(12);
        int hr1 = cal.get(11);
        conflictedEndTimePeriod = conflictedEndTimePeriod + DateUtility.padTime(hr1) + ":";
        conflictedEndTimePeriod = conflictedEndTimePeriod + DateUtility.padTime(min1);
        return conflictedEndTimePeriod;
    }

    public void logViewVisits(User user, String ipAddress, String action) {
        this.auditService.logUserActivity(ipAddress, null, user, action, null, null);
    }

    public List<TemplateResource> getRoomResources(int visitId) {
        VisitTemplate v = this.studyDAO.findVisitTemplateById(visitId);
        List<TemplateResource> trs = this.studyDAO.findRoomTemplateResourcesByVisit(v);
        return trs.isEmpty() ? null : trs;
    }

    public List<OverbookTimelineDataResponseDTO> getOverbookTimelineData(Date selectedStartDate, Date selectedEndDate, int resourceTypeId, List<Integer> sublocations, String orderBy, User user) {
        ResourceType resourceType = ResourceType.findById(resourceTypeId).get();
        return this.appointmentDAO.getOverbookTimelineData(selectedStartDate, selectedEndDate, resourceType, sublocations, orderBy, user);
    }

    void checkMealsAndPersistVisit(UserSession userSession, String ipAddress, String institution, String templatePath, BookedVisit resVisit) {
        for (BookedResource br : resVisit.getBookedResourceList()) {
            br.setBookedVisit(resVisit);
            if (!br.getResource().getName().contains("Meal, Weighed/Controlled")) continue;
            this.sendWeighedMealEmail(resVisit, br, institution, templatePath);
        }
        List<BookedResource> resources = resVisit.getBookedResourceList();
        this.persistVisit(resVisit, userSession, ipAddress);
        this.persistBookedResources(resources, resVisit);
    }

    void calculateSomeAvailableResources(int visitDurationInMin, Date searchDate, List<BookedVisit> availableVisitTimeSlots, List<TemplateResource> fixedResources, Map<String, List<TemplateResource>> floatResourceList, Map<String, List<TemplateResource>> floatResourceGroups, Map<String, List<TemplateResource>> flipResourceGroups, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck) {
        this.addToAvailableBookedVisitList(bookedVisit, availableVisitTimeSlots);
        boolean fixedResourcesAvailable = this.foundAvailableFixedResources(searchDate, fixedResources, visitTimeSlotStart, bookedVisit, rejectedCheck, "fixed");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, fixedResourcesAvailable)) {
            return;
        }
        boolean singleFloatResourcesAvailable = this.foundAvailableFloatResources(visitDurationInMin, searchDate, floatResourceList, visitTimeSlotStart, bookedVisit, rejectedCheck, "float");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, singleFloatResourcesAvailable)) {
            return;
        }
        boolean floatGroupResourcesAvailable = this.foundAvailableFloatResources(visitDurationInMin, searchDate, floatResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck, "float group");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, floatGroupResourcesAvailable)) {
            return;
        }
        boolean flexGroupResourcesAvailable = this.foundAvailableFlipResources(searchDate, flipResourceGroups, visitTimeSlotStart, bookedVisit, rejectedCheck, "flex");
        if (this.isRelativeTimeRejectedVisit(bookedVisit, rejectedCheck, flexGroupResourcesAvailable)) {
            return;
        }
    }

    private boolean isRelativeTimeRejectedVisit(BookedVisit bookedVisit, boolean rejectedCheck, boolean fixedResourcesAvailable) {
        if (!fixedResourcesAvailable && !rejectedCheck) {
            bookedVisit.setRejectedVisit(true);
            bookedVisit.setBookedResourceList(new ArrayList<BookedResource>());
            return true;
        }
        return false;
    }

    boolean foundAvailableFlipResources(Date searchDate, Map<String, List<TemplateResource>> flipResourceGroups, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        if (this.checkIfMapEmptyOrNull(flipResourceGroups)) {
            List<TemplateResource> availableFlipResources = this.allocateCheckAvailabilityFlip(visitTimeSlotStart, searchDate, flipResourceGroups, rejectedCheck, groupType, bookedVisit.getBookedResourceList());
            if (AppointmentService.neitherNullNorEmpty(availableFlipResources)) {
                this.addToBookedVisit(this.removeDuplicates(availableFlipResources), bookedVisit);
            } else {
                result = false;
            }
        }
        return result;
    }

    boolean foundAvailableFloatResources(int visitDurationInMin, Date searchDate, Map<String, List<TemplateResource>> floatResourceList, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(searchDate);
        Date searchStartDate = DateUtility.startOfDay(startCal);
        if (this.checkIfMapEmptyOrNull(floatResourceList)) {
            List<TemplateResource> availableFloatResourceList = this.removeDuplicates(this.allocateCheckAvailabilityFloat(visitTimeSlotStart, visitTimeSlotStart + visitDurationInMin, searchStartDate, floatResourceList, rejectedCheck, groupType, bookedVisit.getBookedResourceList()));
            if (AppointmentService.neitherNullNorEmpty(availableFloatResourceList)) {
                if (groupType.equalsIgnoreCase("float") && availableFloatResourceList.size() == floatResourceList.size() || groupType.equalsIgnoreCase("float group")) {
                    this.addToBookedVisit(availableFloatResourceList, bookedVisit);
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private static boolean neitherNullNorEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    boolean foundAvailableFixedResources(Date searchDate, List<TemplateResource> fixedResources, int visitTimeSlotStart, BookedVisit bookedVisit, boolean rejectedCheck, String groupType) {
        boolean result = true;
        if (AppointmentService.neitherNullNorEmpty(fixedResources)) {
            this.allocateTimeFixedResources(visitTimeSlotStart, searchDate, fixedResources, groupType);
            List<TemplateResource> availableFixedResources = this.removeDuplicates(this.calculateFixedResourceAvailability(fixedResources, rejectedCheck, bookedVisit.getBookedResourceList()));
            if (availableFixedResources != null) {
                this.addToBookedVisit(availableFixedResources, bookedVisit);
            } else {
                result = false;
            }
        }
        return result;
    }

    List<Resource> setupBookedResourcesForAppointmentWithVisitTime(VisitTime visitTime, User user, String templatePath, Date eventDate, BookedVisit bookedVisit, List<TemplateResource> templateResourceList, int eventDateMinutesDelta) {
        ArrayList accumulatedResourceList = Lists.newArrayList();
        for (TemplateResource templateResource : templateResourceList) {
            this.setupOneBookedResourceForAppointment(visitTime, user, templatePath, accumulatedResourceList, bookedVisit, templateResource, eventDateMinutesDelta, eventDate);
        }
        return accumulatedResourceList;
    }

    void setupOneBookedResourceForAppointment(VisitTime visitTime, User user, String templatePath, List<Resource> accumulatedResourceList, BookedVisit bookedVisit, TemplateResource templateResource, int eventDateMinutesDelta, Date eventStartDate) {
        Date trStartDate = templateResource.getStartDate();
        Date trEndDate = templateResource.getEndDate();
        Calendar startCal = this.getDateAdjustedForEvent(eventStartDate, trStartDate, eventDateMinutesDelta);
        Calendar endCal = this.getDateAdjustedForEvent(eventStartDate, trEndDate, eventDateMinutesDelta);
        Resource resource = this.probablyAccumulateResult(visitTime, accumulatedResourceList, templateResource);
        Integer duration = (int)((endCal.getTimeInMillis() - startCal.getTimeInMillis()) / 60000L);
        BookedResource bookedResource = new BookedResource();
        bookedResource.setBookedVisit(bookedVisit);
        bookedResource.setDuration(duration);
        bookedResource.setScheduledStartTime(startCal.getTime());
        bookedResource.setScheduledEndTime(endCal.getTime());
        bookedResource.setResource(resource);
        bookedResource.setTemplateResource(templateResource);
        bookedResource.setBillable(templateResource.getBillable());
        this.appointmentDAO.createEntity(bookedResource);
        if (bookedVisit.getScheduledEndTime().before(bookedResource.getScheduledEndTime())) {
            bookedVisit.setScheduledEndTime(bookedResource.getScheduledEndTime());
        }
        this.persistAnnotationsForBookedResource(user, templatePath, bookedVisit, templateResource, bookedResource);
    }

    void setupBookedResourcesForBookedVisit(User user, String templatePath, List<TemplateResource> templateResourceList, Date eventDate, BookedVisit bookedVisit, int eventDateMinutesDelta) {
        LazyList bookedResources = LazyList.lazy(templateResourceList).map(templateResource -> {
            Date trStartDate = templateResource.getStartDate();
            Date trEndDate = templateResource.getEndDate();
            Calendar startCal = this.getDateAdjustedForEvent(eventDate, trStartDate, eventDateMinutesDelta);
            Calendar endCal = this.getDateAdjustedForEvent(eventDate, trEndDate, eventDateMinutesDelta);
            Integer duration = (int)((endCal.getTimeInMillis() - startCal.getTimeInMillis()) / 60000L);
            BookedResource newBookedResource = new BookedResource();
            newBookedResource.setResource(templateResource.getResource());
            newBookedResource.setId(null);
            newBookedResource.setTemplateResource((TemplateResource)templateResource);
            newBookedResource.setBookedVisit(bookedVisit);
            newBookedResource.setDuration(duration);
            newBookedResource.setBillable(templateResource.getBillable());
            newBookedResource.setScheduledStartTime(startCal.getTime());
            newBookedResource.setScheduledEndTime(endCal.getTime());
            return Pair.pair((Object)templateResource, (Object)newBookedResource);
        });
        Consumer<Pair> justCreate = pair -> this.appointmentDAO.createEntity((BaseEntity)pair.second);
        Consumer<Pair> persistAnnotations = pair -> this.persistAnnotationsForBookedResource(user, templatePath, bookedVisit, (TemplateResource)pair.first, (BookedResource)pair.second);
        Consumer<Pair> persist = justCreate.andThen(persistAnnotations);
        bookedResources.forEach(persist);
    }

    Resource probablyAccumulateResult(VisitTime visitTime, List<Resource> accumulatedResourceList, TemplateResource templateResource) {
        Resource templateResourcesResource;
        Resource resultResource = templateResourcesResource = this.resourceDAO.findResourceById(templateResource.getResource().getId());
        if (templateResourcesResource.getResourceType().getName().equalsIgnoreCase("ROOM")) {
            if (visitTime.getRoomSelected() != 0) {
                Resource selectedRoomResource = this.resourceDAO.findResourceById(visitTime.getRoomSelected());
                accumulatedResourceList.add(selectedRoomResource);
                resultResource = selectedRoomResource;
            }
        } else {
            accumulatedResourceList.add(templateResourcesResource);
        }
        return resultResource;
    }

    void persistAnnotationsForBookedResource(User user, String templatePath, BookedVisit bookedVisit, TemplateResource templateResource, BookedResource bookedResource) {
        List<Object> la = templateResource != null ? this.appointmentDAO.findTemplateResourceAnnotationsByTemplateResource(templateResource) : Collections.emptyList();
        ListUtils.enrich(la).map(templateResourceAnnotations -> {
            OverrideBookedResourceAnnotations obra = new OverrideBookedResourceAnnotations();
            obra.setBookedResource(bookedResource);
            obra.setLineLevelAnnotations(templateResourceAnnotations.getLineLevelAnnotations());
            obra.setQuantity(templateResourceAnnotations.getQuantity());
            obra.setComment(templateResourceAnnotations.getComment());
            return obra;
        }).forEach(this.appointmentDAO::createEntity);
        if (bookedResource.getResource().getName().contains("Meal, Weighed/Controlled")) {
            this.sendWeighedMealEmail(bookedVisit, bookedResource, user.getInstitution().getLongName(), templatePath);
        }
    }

    void setTemplateResourceTimes(Date eventStartDate, List<TemplateResource> templateResourceList) {
        for (TemplateResource templateResource : templateResourceList) {
            Date trStartDate = templateResource.getStartDate();
            Date trEndDate = templateResource.getEndDate();
            int eventDateHoursAndMinutesDelta = eventStartDate.getHours() * 60 + eventStartDate.getMinutes();
            Calendar startCal = this.getDateAdjustedForEvent(eventStartDate, trStartDate, eventDateHoursAndMinutesDelta);
            Calendar endCal = this.getDateAdjustedForEvent(eventStartDate, trEndDate, eventDateHoursAndMinutesDelta);
            templateResource.setScheduledStartTime(startCal.getTime());
            templateResource.setScheduledEndTime(endCal.getTime());
            this.computeAndSetDuration(templateResource);
        }
    }

    Calendar getDateAdjustedForEvent(Date eventStartDate, Date templateResourceDate, int resourceMinutesDelta) {
        int resourceStartMinuteAdjusted = templateResourceDate.getHours() * 60 + templateResourceDate.getMinutes() + resourceMinutesDelta;
        int resourceAdjustedStartHour = this.divideByMinsPerHour(resourceStartMinuteAdjusted);
        int resourceAdjustedStartMins = this.moduloMinsPerHour(resourceStartMinuteAdjusted);
        Calendar templateResourceTime = Calendar.getInstance();
        templateResourceTime.setTimeInMillis(templateResourceDate.getTime());
        templateResourceTime.set(11, 0);
        templateResourceTime.set(12, 0);
        templateResourceTime.set(13, 0);
        templateResourceTime.set(14, 0);
        long templateTime = templateResourceTime.getTimeInMillis();
        long templateResourceStartTime = DateUtility.TEMPLATE_RESOURCE_CALENDAR_ORIGIN.getTimeInMillis();
        long bookedResouceRelativeTime = templateTime - templateResourceStartTime;
        long adjustedBookedResourceStartTime = eventStartDate.getTime() + bookedResouceRelativeTime;
        Calendar bookedResourceTime = Calendar.getInstance();
        bookedResourceTime.setTimeInMillis(adjustedBookedResourceStartTime);
        bookedResourceTime.set(11, resourceAdjustedStartHour);
        bookedResourceTime.set(12, resourceAdjustedStartMins);
        bookedResourceTime.set(13, 0);
        bookedResourceTime.set(14, 0);
        return bookedResourceTime;
    }

    TemplateResource setupTemplateResource(TemplateResource templateResource, VisitTemplate visitTemplate, BookedVisit bookedVisit) {
        templateResource.setId(123456);
        templateResource.setVisitTemplate(visitTemplate);
        templateResource.setStartDate(bookedVisit.getScheduledStartTime());
        templateResource.setEndDate(bookedVisit.getScheduledEndTime());
        Integer startTimeInteger = bookedVisit.getScheduledStartTime().getDay() * 1440 + bookedVisit.getScheduledStartTime().getHours() * 60 + bookedVisit.getScheduledStartTime().getMinutes() - 1440;
        Integer endTimeInteger = bookedVisit.getScheduledEndTime().getDay() * 1440 + bookedVisit.getScheduledEndTime().getHours() * 60 + bookedVisit.getScheduledEndTime().getMinutes() - 1440;
        Integer duration = endTimeInteger - startTimeInteger;
        templateResource.setDuration(duration);
        templateResource.setScheduledStartTime(bookedVisit.getScheduledStartTime());
        templateResource.setScheduledEndTime(bookedVisit.getScheduledEndTime());
        this.computeAndSetDuration(templateResource);
        return templateResource;
    }

    public BookedResource getBookedResourceData(int id, String remoteHost, User user) {
        BookedResource br = this.appointmentDAO.findBookedResourceById(id);
        this.auditService.logAppointmentOverrideActivity(remoteHost, br.getBookedVisit(), br.getResource(), user, "Edit - Overriding an Appointment (Incomplete Action)", null, null);
        return br;
    }

    public List<VisitTemplatesResponse> getVisitsByStudy(int studyId, boolean active, String sortBy, String orderBy, int page, int maxResults) {
        return this.studyDAO.getStudyVisitsByStatus(studyId, active, sortBy, orderBy, page, maxResults);
    }

    public List<BookedVisitsResponse> getBookedVisitsList(int userId, String filterString, String filterId, String sortBy, String orderBy, int page, int maxResults, String remoteHost, boolean initialLoad, Date fromDate, Date toDate) {
        User user = this.authDAO.findUserById(userId);
        List<BookedVisitsResponse> visits = user.isStudyStaff() ? this.getStudyStaffMonthlyBookedVisitsNew(filterString, filterId, sortBy, orderBy, page, maxResults, user, initialLoad, fromDate, toDate) : this.getRegMonthlyBookedVisitsList(user, filterString, filterId, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        this.auditService.logViewActivity(remoteHost, user, " Appointment Calendar List View.");
        return visits;
    }

    List<BookedVisitsResponse> getStudyStaffMonthlyBookedVisitsNew(String filterString, String filterId, String sortBy, String orderBy, int page, int maxResults, User user, boolean initialLoad, Date fromDate, Date toDate) {
        List<Object> visits = Lists.newArrayList();
        if (filterId != null && !"0".equals(filterId.toLowerCase())) {
            visits = this.getFilterBookedVisitsList(user, filterString, filterId, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        } else {
            List<Study> userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
            if (userAccessibleStudies != null && !userAccessibleStudies.isEmpty()) {
                visits = this.appointmentDAO.findAllBookedVisitsByStudyStaff(userAccessibleStudies, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
            }
        }
        return visits;
    }

    List<BookedVisitsResponse> getRegMonthlyBookedVisitsList(User user, String filterString, String filterId, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        List<BookedVisitsResponse> visits = filterId != null && !"0".equals(filterId.toLowerCase()) ? this.getFilterBookedVisitsList(user, filterString, filterId, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate) : this.appointmentDAO.getAllBookedVisits(sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        return visits;
    }

    List<BookedVisitsResponse> getFilterBookedVisitsList(User user, String filterString, String filterId, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        String key = filterId.toLowerCase();
        boolean isKnownId = this.filterBookedVisitsListOps.containsKey(key);
        if (isKnownId && filterString != null) {
            return this.filterBookedVisitsListOps.get(key).apply(user, filterString, sortBy, orderBy, page, maxResults, user.isStudyStaff(), initialLoad, fromDate, toDate);
        }
        return new ArrayList<BookedVisitsResponse>();
    }

    private List<BookedVisitsResponse> filterAppointmentsBySubjectMRN(User user, String filterString, String sortBy, String orderBy, int page, int maxResults, boolean isStudyStaff, boolean initialLoad, Date fromDate, Date toDate) {
        List<BookedVisitsResponse> visits;
        List<Subject> subjects = this.subjectDAO.filterSubjectsByMRN(filterString, user.getInstitutionRole());
        if (isStudyStaff) {
            List<Study> userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
            visits = this.appointmentDAO.getBookedVisitsListBySubjectAndStudy(userAccessibleStudies, subjects, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        } else {
            visits = this.appointmentDAO.getBookedVisitsListBySubject(subjects, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        }
        return visits;
    }

    private List<BookedVisitsResponse> filterAppointmentsByLocalId(User user, String filterString, String sortBy, String orderBy, int page, int maxResults, boolean isStudyStaff, boolean initialLoad, Date fromDate, Date toDate) {
        List<Study> studies = isStudyStaff ? this.studyDAO.findStudyListByPersonAndLocalID(user, filterString) : this.studyDAO.findStudyByName(filterString);
        return this.appointmentDAO.getBookedVisitsListByStudy(studies, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
    }

    private List<BookedVisitsResponse> filterAppointmentsBySubjectLastName(User user, String filterString, String sortBy, String orderBy, int page, int maxResults, boolean isStudyStaff, boolean initialLoad, Date fromDate, Date toDate) {
        List<BookedVisitsResponse> visits;
        List<Subject> subjects = this.subjectDAO.getSubjectByLastName(filterString, user.getInstitutionRole());
        if (isStudyStaff) {
            List<Study> userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
            visits = this.appointmentDAO.getBookedVisitsListBySubjectAndStudy(userAccessibleStudies, subjects, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        } else {
            visits = this.appointmentDAO.getBookedVisitsListBySubject(subjects, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        }
        return visits;
    }

    public BookedVisitDetailResponse getBookedVisitData(int bookedVisitId) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        return new BookedVisitDetailResponse(bookedVisit);
    }

    public boolean isStudyMember(User user, int id) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(id);
        return this.studyDAO.isStudyByPersonAndStudy(user, bookedVisit.getStudy());
    }

    public StudySubject findStudySubjectById(int subject) {
        return this.subjectDAO.findStudySubjectById(subject);
    }

    final class DefaultAppointmentConfirmer
    implements AppointmentConfirmer {
        DefaultAppointmentConfirmer() {
        }

        @Override
        public void confirmVisitBooking(VisitTime ap, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
            BookedVisit resVisit = AppointmentService.this.createBookedVisit(ap, userSession, startDate, endDate);
            String doubleRoomMessage = AppointmentService.this.handleDoubleRoomCheck(resVisit);
            if (doubleRoomMessage == null) {
                AppointmentService.this.checkMealsAndPersistVisit(userSession, ipAddress, institution, templatePath, resVisit);
            } else {
                ap.setDoubleRoomMessage(doubleRoomMessage);
            }
        }

        @Override
        public void confirmVisitBookingAfterDoubleRoomMessage(VisitTime ap, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
            ap.setDoubleRoomMessage(null);
            BookedVisit resVisit = AppointmentService.this.createBookedVisit(ap, userSession, startDate, endDate);
            AppointmentService.this.checkMealsAndPersistVisit(userSession, ipAddress, institution, templatePath, resVisit);
        }
    }

    @FunctionalInterface
    private static interface Function10<A, B, C, D, E, F, G, H, I, J, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8, I var9, J var10);
    }

    private static final class NameAndEmail {
        public final String name;
        public final String email;
        private static final NameAndEmail BothNull = new NameAndEmail(null, null);

        private static <A extends HasFirstName & HasLastName> NameAndEmail of(A entity) {
            if (entity == null) {
                return BothNull;
            }
            String name = entity.getFirstName() + " " + ((HasLastName)entity).getLastName();
            return new NameAndEmail(name, ((HasEmail)entity).getEmail());
        }

        private NameAndEmail(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }
}

