/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.PasswordResetDTO;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.AuthService;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/auth")
@Singleton
@Component
public class AuthResource
extends SecuredResource {
    private AuthService service;

    @Autowired
    public AuthResource(AuthService service) {
        this.service = service;
    }

    AuthResource() {
    }

    @GET
    @Path(value="/getUserData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getUserData() {
        User user = this.getUser();
        user.setBookedVisits(null);
        return this.gson.toJson((Object)user);
    }

    @POST
    @Path(value="/passwordReset")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String passwordReset(@FormParam(value="data") String data) {
        PasswordResetDTO passwordResetDTO = (PasswordResetDTO)this.gson.fromJson(data, PasswordResetDTO.class);
        boolean result = this.service.doPasswordReset(passwordResetDTO);
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(result);
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @POST
    @Path(value="/updateSession")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String updateSession() {
        UserSession userSession = this.service.updateSession(this.getUserSession());
        this.updateUserSession(userSession);
        return "OK";
    }
}

