/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.MetadataManager;

public class CachingMetadataManager
extends MetadataManager {
    private Map<String, String> aliasCache;
    private Map<String, EntityDescriptor> basicMetadataCache;
    private Map<byte[], EntityDescriptor> hashMetadataCache;
    private Map<String, ExtendedMetadata> extendedMetadataCache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ValueLoader<String, String> aliasLoader = new ValueLoader<String, String>(){

        @Override
        public String getValue(String identifier) throws MetadataProviderException {
            return CachingMetadataManager.super.getEntityIdForAlias(identifier);
        }
    };
    private final ValueLoader<EntityDescriptor, String> entityLoader = new ValueLoader<EntityDescriptor, String>(){

        @Override
        public EntityDescriptor getValue(String identifier) throws MetadataProviderException {
            return CachingMetadataManager.super.getEntityDescriptor(identifier);
        }
    };
    private final ValueLoader<EntityDescriptor, byte[]> entityHashLoader = new ValueLoader<EntityDescriptor, byte[]>(){

        @Override
        public EntityDescriptor getValue(byte[] identifier) throws MetadataProviderException {
            return CachingMetadataManager.super.getEntityDescriptor(identifier);
        }
    };
    private final ValueLoader<ExtendedMetadata, String> extendedLoader = new ValueLoader<ExtendedMetadata, String>(){

        @Override
        public ExtendedMetadata getValue(String identifier) throws MetadataProviderException {
            return CachingMetadataManager.super.getExtendedMetadata(identifier);
        }
    };

    public CachingMetadataManager(List<MetadataProvider> providers) throws MetadataProviderException {
        super(providers);
        this.aliasCache = new HashMap<String, String>();
        this.basicMetadataCache = new HashMap<String, EntityDescriptor>();
        this.hashMetadataCache = new HashMap<byte[], EntityDescriptor>();
        this.extendedMetadataCache = new HashMap<String, ExtendedMetadata>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshMetadata() {
        try {
            this.lock.writeLock().lock();
            this.log.debug("Clearing metadata cache");
            this.aliasCache = new HashMap<String, String>();
            this.basicMetadataCache = new HashMap<String, EntityDescriptor>();
            this.hashMetadataCache = new HashMap<byte[], EntityDescriptor>();
            this.extendedMetadataCache = new HashMap<String, ExtendedMetadata>();
            super.refreshMetadata();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getEntityIdForAlias(String entityAlias) throws MetadataProviderException {
        return this.getFromCacheOrUpdate(this.aliasCache, entityAlias, this.aliasLoader);
    }

    public EntityDescriptor getEntityDescriptor(String entityID) throws MetadataProviderException {
        return this.getFromCacheOrUpdate(this.basicMetadataCache, entityID, this.entityLoader);
    }

    @Override
    public EntityDescriptor getEntityDescriptor(byte[] hash) throws MetadataProviderException {
        return this.getFromCacheOrUpdate(this.hashMetadataCache, hash, this.entityHashLoader);
    }

    @Override
    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        return this.getFromCacheOrUpdate(this.extendedMetadataCache, entityID, this.extendedLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, U> T getFromCacheOrUpdate(Map<U, T> cache, U key, ValueLoader<T, U> valueLoader) throws MetadataProviderException {
        if (key == null) {
            return null;
        }
        this.lock.readLock().lock();
        if (cache.containsKey(key)) {
            T item = cache.get(key);
            this.lock.readLock().unlock();
            return item;
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        if (cache.containsKey(key)) {
            T item = cache.get(key);
            this.lock.writeLock().unlock();
            return item;
        }
        try {
            T value = valueLoader.getValue(key);
            cache.put(key, value);
            T t = value;
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static interface ValueLoader<T, U> {
        public T getValue(U var1) throws MetadataProviderException;
    }
}

