/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectsDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponse;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ServiceHelpers;
import edu.harvard.catalyst.scheduler.service.StudyService;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SubjectService
implements ServiceHelpers {
    private final SubjectDAO subjectDAO;
    private final StudyDAO studyDAO;
    private final AuditService auditService;
    private final StudyService studyService;
    private final AppointmentDAO appointmentDAO;
    private static final Logger LOGGER = Logger.getLogger(SubjectService.class);

    @Autowired
    public SubjectService(AuditService auditService, @Qualifier(value="subjectDaoConfigured") SubjectDAO subjectDaoConfigured, StudyDAO studyDAO, StudyService studyService, AppointmentDAO appointmentDAO, @Qualifier(value="encryptionKey") Key encryptionKey) {
        this.auditService = auditService;
        this.studyService = studyService;
        this.subjectDAO = subjectDaoConfigured;
        this.studyDAO = studyDAO;
        this.appointmentDAO = appointmentDAO;
        SubjectDataEncryptor.setEncryptionKey(encryptionKey);
    }

    SubjectService() {
        this(null, null, null, null, null, null);
    }

    public SubjectsDTO createSubject(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = new Subject();
        if (!"".equalsIgnoreCase(subjectDTO.getMrn()) && !this.subjectDAO.checkMrn(subjectDTO.getMrn())) {
            LOGGER.info((Object)"Mrn already exists mismatch -- cancelling creation of subject");
            subjectDTO.setResult(false);
            subjectDTO.setErrorMsg("Mrn already exists mismatch -- cancelling creation of subject");
            return subjectDTO;
        }
        String schedulerId = this.generateSchedulerId(user.getInstitution().getName());
        if (schedulerId == null) {
            LOGGER.info((Object)"Subject Scheduler ID already exists mismatch -- cancelling creation of subject");
            subjectDTO.setResult(false);
            subjectDTO.setErrorMsg("Subject Scheduler ID already exists mismatch -- cancelling creation of subject");
            return subjectDTO;
        }
        subject.setActive(Boolean.TRUE);
        subject.setCreatedDate(new Date());
        this.setSomeEntityValuesViaDto(subject, subjectDTO);
        subjectDTO.setSubjectSchedulerId(schedulerId);
        subject.setSubjectSchedulerId(schedulerId);
        this.subjectDAO.createSubject(subject);
        this.auditService.logSubjectActivity(ipAddress, subject, user, "CREATE SUBJECT", null, null);
        if (subjectDTO.getStudyId() > 0 && subjectDTO.getStudyId() != 0) {
            Study study = this.studyDAO.findStudyById(subjectDTO.getStudyId());
            StudySubject studySubject = new StudySubject();
            studySubject.setActive(Boolean.TRUE);
            studySubject.setStudy(study);
            studySubject.setSubject(subject);
            try {
                this.studyDAO.createEntity(studySubject);
            }
            catch (ConstraintViolationException ex) {
                SchedulerRuntimeException.logDontThrow("createSubject() constraint violation", (Exception)((Object)ex));
            }
            this.studyService.stampStudyAndLogStudySubjectActivity(ipAddress, study, subject, user, "ADD STUDY SUBJECT", null, null);
        }
        subjectDTO.setResult(true);
        return subjectDTO;
    }

    String generateSchedulerId(String institutionName) {
        return Stream.generate(() -> this.makeRandomId(institutionName)).limit(100L).filter(this.subjectDAO::checkSubjectSchedulerId).findFirst().orElse(null);
    }

    private String makeRandomId(String institutionName) {
        return institutionName + RandomStringUtils.randomAlphanumeric((int)6);
    }

    public BooleanResultDTO changeSubjectStatus(int subject, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        Subject s = this.subjectDAO.findBySubjectId(subject);
        if (s.getActive() == Boolean.FALSE.booleanValue()) {
            s.setActive(Boolean.TRUE);
        } else {
            s.setActive(Boolean.FALSE);
        }
        this.subjectDAO.editSubject(s);
        this.auditService.logSubjectActivity(ipAddress, s, user, "ACTIVATED SUBJECT", null, null);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public SubjectsDTO updateSubject(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = this.subjectDAO.findBySubjectId(subjectDTO.getId());
        if (!("".equalsIgnoreCase(subjectDTO.getMrn()) || subject.getMrn().equals(subjectDTO.getMrn()) || this.subjectDAO.checkMrn(subjectDTO.getMrn()))) {
            LOGGER.info((Object)"Mrn already exists mismatch -- cancelling update of subject");
            subjectDTO.setErrorMsg("Mrn already exists mismatch -- cancelling update of subject");
            subjectDTO.setResult(false);
            return subjectDTO;
        }
        if (subjectDTO.getStudyId() > 0) {
            Study study = this.studyDAO.findStudyById(subjectDTO.getStudyId());
            List<StudySubject> studySubjectlist = this.getStudySubjects(user, subject, study);
            if (ListUtils.nullOrEmpty(studySubjectlist)) {
                this.initNewStudy(user, ipAddress, subject, study);
            } else {
                boolean foundSubject = ListUtils.enrich(studySubjectlist).exists(s -> s.getStudy().getId().equals(study.getId()));
                if (foundSubject) {
                    subjectDTO.setErrorMsg("This subject is already enrolled in this study.");
                    subjectDTO.setResult(false);
                    return subjectDTO;
                }
                this.addSubjectToStudy(user, ipAddress, subject, study);
            }
        }
        String ethnicity = this.lookupFieldById(subjectDTO.getEthnicity(), this.subjectDAO::findByEthnicityId);
        String gender = this.lookupFieldById(subjectDTO.getGender(), this.subjectDAO::findByGenderId);
        String race = this.lookupFieldById(subjectDTO.getRace(), this.subjectDAO::findByRaceId);
        String country = this.lookupFieldById(subjectDTO.getCountry(), this.subjectDAO::findCountryById);
        Function<String, String> crypt = SubjectDataEncryptor::encrypt;
        Function<String, String> toUpper = String::toUpperCase;
        Function<String, String> cryptUpper = toUpper.andThen(crypt);
        ArrayList previousDataComponents = Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("Birth Date", subjectDTO.getBirthdate(), subject.getBirthdate()), this.makeFieldString("City", subjectDTO.getCity(), subject.getCity(), cryptUpper, cryptUpper), this.makeFieldString("Ethnicity", ethnicity.toUpperCase(), subject.getEthnicity(), subjectDTO.getEthnicity(), BaseEntity::getId, crypt, cryptUpper), this.makeFieldString("Gender", gender, subject.getGender(), subjectDTO.getGender(), BaseEntity::getId, crypt, cryptUpper), this.makeFieldString("First Name", subjectDTO.getFirstName(), subject.getFirstName(), crypt, cryptUpper), this.makeFieldString("Last Name", subjectDTO.getLastName(), subject.getLastName(), crypt, cryptUpper), this.makeFieldString("MRN", subjectDTO.getMrn(), subject.getMrn(), crypt, cryptUpper), this.makeFieldString("Primary Phone", subjectDTO.getPrimaryContactNumber(), subject.getPrimaryContactNumber(), crypt, cryptUpper), this.makeFieldString("Race", race, subject.getRace(), subjectDTO.getRace(), BaseEntity::getId, crypt, cryptUpper), this.makeFieldString("Street Address 1", subjectDTO.getStreetAddress1(), subject.getStreetAddress1(), crypt, cryptUpper), this.makeFieldString("Street Address 2", subjectDTO.getStreetAddress2(), subject.getStreetAddress2(), crypt, cryptUpper), this.makeFieldString("Country", country, subject.getCountry(), subjectDTO.getCountry(), BaseEntity::getId, crypt, cryptUpper), this.makeFieldString("Zip", subjectDTO.getZip(), subject.getZip(), crypt, cryptUpper)});
        ArrayList otherPreviousDataComponents = Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("State", subjectDTO.getState(), subject.getState()), this.makeFieldString("Middle Name", subjectDTO.getMiddleName(), subject.getMiddleName(), crypt, cryptUpper), this.makeFieldString("Secondary Phone", subjectDTO.getSecondaryContactNumber(), subject.getSecondaryContactNumber(), crypt, cryptUpper)});
        Joiner joiner = Joiner.on((String)"");
        String previousData = joiner.join((Iterable)ListUtils.flatten((List)previousDataComponents));
        String otherPreviousData = joiner.join((Iterable)ListUtils.flatten((List)otherPreviousDataComponents));
        subject.setId(subjectDTO.getId());
        this.setSomeEntityValuesViaDto(subject, subjectDTO);
        this.subjectDAO.editSubject(subject);
        this.auditService.logSubjectActivity(ipAddress, subject, user, "UPDATE SUBJECT", previousData, otherPreviousData);
        subjectDTO.setResult(true);
        return subjectDTO;
    }

    private void addSubjectToStudy(User user, String ipAddress, Subject subject, Study study) {
        StudySubject studySubject = new StudySubject(study, subject, Boolean.TRUE);
        this.studyDAO.createEntity(studySubject);
        this.studyService.stampStudyAndLogStudySubjectActivity(ipAddress, study, subject, user, "ADD STUDY SUBJECT", null, null);
    }

    private void initNewStudy(User user, String ipAddress, Subject subject, Study study) {
        StudySubject studySubject = new StudySubject(study, subject, Boolean.TRUE);
        try {
            this.studyDAO.createEntity(studySubject);
        }
        catch (ConstraintViolationException ex) {
            SchedulerRuntimeException.logDontThrow("updateSubject() constraint violation", (Exception)((Object)ex));
        }
        this.studyService.stampStudyAndLogStudySubjectActivity(ipAddress, study, subject, user, "ADD STUDY SUBJECT", null, null);
    }

    private List<StudySubject> getStudySubjects(User user, Subject subject, Study study) {
        if (user.isStudyStaff()) {
            return this.appointmentDAO.findStudySubjectBySubject(subject);
        }
        return this.appointmentDAO.findStudySubjectBySubjectAndStudy(subject, study);
    }

    void setSomeEntityValuesViaDto(Subject subject, SubjectsDTO subjectDTO) {
        subject.setBirthdate(subjectDTO.getBirthdate());
        subject.setCity(subjectDTO.getCity());
        subject.setEthnicity(this.subjectDAO.findByEthnicityId(subjectDTO.getEthnicity()));
        subject.setFirstName(subjectDTO.getFirstName());
        subject.setLastName(subjectDTO.getLastName());
        subject.setGender(this.subjectDAO.findByGenderId(subjectDTO.getGender()));
        subject.setFullName(subjectDTO.getFirstName() + " " + subject.getLastName());
        subject.setMrn(subjectDTO.getMrn());
        subject.setMiddleName(subjectDTO.getMiddleName());
        subject.setPrimaryContactNumber(subjectDTO.getPrimaryContactNumber());
        subject.setRace(this.subjectDAO.findByRaceId(subjectDTO.getRace()));
        subject.setSecure(Boolean.FALSE);
        subject.setSecondaryContactNumber(subjectDTO.getSecondaryContactNumber());
        subject.setStreetAddress1(subjectDTO.getStreetAddress1());
        subject.setStreetAddress2(subjectDTO.getStreetAddress2());
        subject.setState(subjectDTO.getState() != 0 ? this.subjectDAO.findByStateId(subjectDTO.getState()) : null);
        subject.setCountry(this.subjectDAO.findCountryById(subjectDTO.getCountry()));
        subject.setZip(subjectDTO.getZip());
        subject.setComment(subjectDTO.getComment());
    }

    public SubjectsResponse getSearchedSubjects(String subjectLastName, String subjectMrn, String subjectBirthdate, String subjectSchedulerId, String ipAddress, User user, String sortBy, String orderBy) {
        return this.subjectDAO.getStudyStaffSubjects(subjectLastName, subjectMrn, subjectBirthdate, subjectSchedulerId, sortBy, orderBy, ipAddress, user);
    }

    public SubjectsResponse getSubjects(String filterString, int maxResults, int page, String sortBy, String orderBy) {
        return this.subjectDAO.getSubjectsList(filterString, maxResults, page, sortBy, orderBy);
    }

    public SubjectDetailResponse getSubjectData(int subjectId, String ipAddress, User user) {
        Subject s = this.subjectDAO.findBySubjectId(subjectId);
        this.auditService.logSubjectActivity(ipAddress, s, user, "VIEW SUBJECT", null, null);
        return this.subjectDAO.getSubjectDataById(subjectId);
    }
}

