/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

@Component
public class MailHandler {
    private static final Logger logUtil = Logger.getLogger(MailHandler.class.getName());
    private final Boolean mailEnabled;
    private final String mailFrom;
    private final JavaMailSender mailSender;

    @Autowired
    public MailHandler(@Qualifier(value="mailEnabled") Boolean mailEnabled, @Qualifier(value="mailFrom") String mailFrom, JavaMailSender mailSender) {
        this.mailEnabled = mailEnabled;
        this.mailFrom = this.normalizeFrom(mailFrom);
        this.mailSender = mailSender;
    }

    private String normalizeFrom(String from) {
        return from == null || from.equals("") ? "AnonymousSender@harvard.edu" : from;
    }

    public void sendOptionalEmails(SimpleMailMessage message) {
        if (this.mailEnabled.booleanValue()) {
            this.sendEmail(message);
        } else {
            logUtil.info("Trigger to send email has been set to: " + this.mailEnabled);
        }
    }

    public void sendMandatoryEmails(SimpleMailMessage message) {
        this.sendEmail(message);
    }

    void sendEmail(SimpleMailMessage message) {
        try {
            if (message.getText().contains("html") || message.getSubject().contains("html")) {
                MimeMessage mimeMessage = this.mailSender.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage);
                messageHelper.setText(message.getText(), true);
                messageHelper.setTo(message.getTo());
                messageHelper.setFrom(this.mailFrom);
                if (message.getCc() != null) {
                    messageHelper.setCc(message.getCc());
                }
                if (message.getBcc() != null) {
                    messageHelper.setBcc(message.getBcc());
                }
                messageHelper.setSubject(message.getSubject());
                this.mailSender.send(mimeMessage);
            } else {
                message.setFrom(this.mailFrom);
                this.mailSender.send(message);
            }
        }
        catch (MessagingException me) {
            String complaint = "ERROR: sending mail to: " + message.getTo() + ", from: " + this.mailFrom + ", with subject: " + message.getSubject();
            logUtil.info(complaint);
        }
    }
}

