/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.common.collect.Maps;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.scheduler.dto.BookedVisitDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.GetTemplateResourceGroupDTO;
import edu.harvard.catalyst.scheduler.dto.TemplateResourceDTO;
import edu.harvard.catalyst.scheduler.dto.VisitTime;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.GanttComboResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttGroupablesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourceInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetSearchVisitResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudyVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.OverbookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithLlaListDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.AppointmentService;
import edu.harvard.catalyst.scheduler.service.ConfirmationStatus;
import edu.harvard.catalyst.scheduler.service.GanttInfoSortType;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Path(value="/appointment")
@Singleton
@Component
public class AppointmentResource
extends SecuredResource {
    private AppointmentService service;
    private final Gson bookedVisitSkippingGson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return clazz == BookedVisit.class;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }
    }}).serializeNulls().create();
    @Context
    private ServletContext context;

    @Autowired
    public AppointmentResource(AppointmentService service) {
        this.service = service;
    }

    AppointmentResource() {
    }

    @GET
    @Path(value="/getStudyVisits")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyVisits(@QueryParam(value="filterString") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="study") int studyId, @QueryParam(value="approved") boolean approved) {
        GetStudyVisitsResponse result = this.getStudyVisitsResponse(filterString, sortBy, orderBy, page, maxResults, studyId, approved);
        return this.gson.toJson((Object)result);
    }

    GetStudyVisitsResponse getStudyVisitsResponse(String filterString, String sortBy, String orderBy, int page, int maxResults, int studyId, boolean approved) {
        return this.service.getStudyVisits(filterString, sortBy, orderBy, page, maxResults, studyId, approved);
    }

    @GET
    @Path(value="/getVisitsByStudy")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getVisitsByStudy(@QueryParam(value="study") int studyId, @QueryParam(value="active") boolean active, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<VisitTemplatesResponse> bookedResources = this.getVisitsByStudyList(studyId, active, sortBy, orderBy, page, maxResults);
        return this.gson.toJson(bookedResources);
    }

    List<VisitTemplatesResponse> getVisitsByStudyList(int studyId, boolean active, String sortBy, String orderBy, int page, int maxResults) {
        return this.service.getVisitsByStudy(studyId, active, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getSearchVisitResource")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSearchVisitResource(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="visit") int visitId) {
        GetSearchVisitResourceResponse result = this.getSearchVisitResourceResponse(sortBy, orderBy, page, maxResults, visitId);
        return this.gson.toJson((Object)result);
    }

    GetSearchVisitResourceResponse getSearchVisitResourceResponse(String sortBy, String orderBy, int page, int maxResults, int visitId) {
        return this.service.getVisitResources(sortBy, orderBy, page, maxResults, visitId);
    }

    @GET
    @Path(value="/getAppointmentComments")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getAppointmentComments(@QueryParam(value="id") int visitId) {
        Map<String, Object> map = this.mapAppointmentSizeAndComments(visitId);
        return this.gson.toJson(map);
    }

    Map<String, Object> mapAppointmentSizeAndComments(int visitId) {
        List<VisitCommentsResponse.VisitComment> visitTemplateComments = this.service.getAppointmentComments(visitId);
        if (visitTemplateComments == null || visitTemplateComments.isEmpty()) {
            visitTemplateComments = new ArrayList<VisitCommentsResponse.VisitComment>();
        }
        return Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"total", (Object)visitTemplateComments.size()), Pair.pair((Object)"visitComments", visitTemplateComments)});
    }

    @GET
    @Path(value="/getOnlyTodaysBookedVisitsList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getOnlyTodaysBookedVisitsList(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        Date startDate = DateUtility.startOfDay(Calendar.getInstance());
        Date endDate = DateUtility.nextDay(startDate);
        List<BookedVisitsResponse> bookedVisits = this.getTodaysBookedVisits(sortBy, orderBy, page, maxResults, startDate, endDate, this.getUser().getId(), this.getRemoteHost());
        return this.gson.toJson(bookedVisits);
    }

    List<BookedVisitsResponse> getTodaysBookedVisits(String sortBy, String orderBy, int page, int maxResults, Date startDate, Date endDate, int userId, String ipAddress) {
        return this.service.getOnlyTodaysBookedVisitsHomeList(startDate, endDate, sortBy, orderBy, page, maxResults, userId, ipAddress);
    }

    @GET
    @Path(value="/getOverbookedVisitsData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String getOverbookedVisitsData(@QueryParam(value="id") int id) {
        this.service.logViewVisits(this.getUser(), this.getRemoteHost(), "Check for Overbooked Resources.");
        List<OverbookedResourcesResponse> getOverbookData = this.lookupOverbookedVisitData(id);
        return this.gson.toJson(getOverbookData);
    }

    List<OverbookedResourcesResponse> lookupOverbookedVisitData(int id) {
        return this.service.selectedVisitForOverbookChecks(id);
    }

    @GET
    @Path(value="/getEventResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getEventResources(@QueryParam(value="eventId") String eventId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<BookedResourcesResponse> bookedResources = this.getListOfEventResources(eventId, this.getUser());
        return this.gson.toJson(bookedResources);
    }

    List<BookedResourcesResponse> getListOfEventResources(String eventId, User user) {
        return this.service.getEventResources(eventId, user);
    }

    @POST
    @Path(value="/getResourcesList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getResourcesList(@FormParam(value="data") String data) {
        Map<String, List<Resource>> map = this.getResourcesList();
        return this.gson.toJson(map);
    }

    Map<String, List<Resource>> getResourcesList() {
        return Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"resourcesList", this.service.getResources())});
    }

    @POST
    @Path(value="/saveComment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String saveComment(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        Comments comment = this.service.saveComment(tr, this.getUser(), this.getRemoteHost());
        return this.bookedVisitSkippingGson.toJson((Object)comment);
    }

    @GET
    @Path(value="/copyDayInpatientResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String copyDayInpatientResources(@QueryParam(value="visitId") int visitId, @QueryParam(value="currentDay") int currentDay, @QueryParam(value="targetDaysCommaString") String targetDaysCommaString) {
        this.service.copyDayVisitResources(visitId, currentDay, targetDaysCommaString, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"));
        return null;
    }

    @GET
    @Path(value="/isDayCopyable")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String isDayCopyable(@QueryParam(value="visitId") int visitId, @QueryParam(value="currentDay") int currentDay) {
        Boolean result = this.service.isDayCopyable(visitId, currentDay);
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getGanttInfo/combo")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getTemplateResourcesForGanttCombo(@QueryParam(value="visit") Integer visitId, @QueryParam(value="dayOffset") int dayOffset, @QueryParam(value="sortType") GanttInfoSortType sortType) {
        if (sortType == null) {
            sortType = GanttInfoSortType.NameAsc;
        }
        GanttComboResponseDTO ganttResponseComboDTO = this.service.getTemplateResourcesForGanttCombo(visitId, dayOffset, sortType);
        return this.gson.toJson((Object)ganttResponseComboDTO);
    }

    @GET
    @Path(value="/getGanttInfo/candidateFloatables")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getGanttInfoCandidateFloatables(@QueryParam(value="visit") Integer visitId, @QueryParam(value="templateResource") Integer templateResourceId) {
        return this.service.getGanttInfoCandidateGroupables(visitId, templateResourceId, GanttResponseDTO.GanttGroupingType.Floatables).jsonify(this.gson);
    }

    @GET
    @Path(value="/getGanttInfo/candidateFlexibles")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getGanttInfoCandidateFlexibles(@QueryParam(value="visit") Integer visitId, @QueryParam(value="templateResourceId") Integer templateResourceId) {
        GanttGroupablesResponseDTO dtoResult = this.service.getGanttInfoCandidateGroupables(visitId, templateResourceId, GanttResponseDTO.GanttGroupingType.Flexibles);
        return dtoResult.jsonify(this.gson);
    }

    @GET
    @Path(value="/getRoomResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getRoomResources(@QueryParam(value="id") int visitId, @HeaderParam(value="User-Agent") String header) {
        this.service.logViewVisits(this.getUser(), this.getRemoteHost(), "Appointment Visit Selected");
        Map<String, String> map = this.getRoomData(visitId);
        return this.gson.toJson(map);
    }

    @GET
    @Path(value="/getSelectableTemplateResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getTemplateResources(@QueryParam(value="visitId") int visitId, @QueryParam(value="sortType") GanttInfoSortType sortType, @QueryParam(value="isBillable") boolean isBillable) {
        List<TemplateResource> resources = this.service.getSelectableTemplateResources(visitId, sortType, isBillable);
        return this.gson.toJson(resources);
    }

    @GET
    @Path(value="/updateTemplateResourcesBillable")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String updateTemplateResourcesBillable(@QueryParam(value="visitId") Integer visitId, @QueryParam(value="templateResourcesCommaString") String templateResourcesCommaString, @QueryParam(value="isBillable") boolean isBillable) {
        BooleanResultDTO booleanResultDTO = this.service.updateTemplateResourcesBillable(visitId, templateResourcesCommaString, isBillable);
        return this.gson.toJson((Object)booleanResultDTO);
    }

    Map<String, String> getRoomData(int visitId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<TemplateResource> r = this.service.getRoomResources(visitId);
        if (r == null || r.isEmpty() || r.size() == 0) {
            map.put("roomResources", null);
        } else {
            map.put("roomResources", r.get(0).getResource().getName());
        }
        return map;
    }

    @GET
    @Path(value="/getBookedVisitsList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getBookedVisitsList(@QueryParam(value="filterString") String filterString, @QueryParam(value="filterId") String filterId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="initialLoad") boolean initialLoad, @QueryParam(value="fromDate") Date fromDate, @QueryParam(value="toDate") Date toDate) {
        List<BookedVisitsResponse> getBookedVisitsDTO = this.getListOfBookedVisits(filterString, filterId, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate);
        return this.gson.toJson(getBookedVisitsDTO);
    }

    List<BookedVisitsResponse> getListOfBookedVisits(String filterString, String filterId, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        return this.service.getBookedVisitsList(this.getUser().getId(), filterString, filterId, sortBy, orderBy, page, maxResults, this.getRemoteHost(), initialLoad, fromDate, toDate);
    }

    @GET
    @Path(value="/getBookedVisitData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getBookedVisitData(@QueryParam(value="bookedVisit") int bookedVisitId) {
        BookedVisitDetailResponse getBookedVisitsDTO = this.service.getBookedVisitData(bookedVisitId);
        return this.gson.toJson((Object)getBookedVisitsDTO);
    }

    @GET
    @Path(value="/getOverbookedResourceDataByResourceType")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getOverbookedResourceDataByResourceType(@QueryParam(value="startDate") Long startDate, @QueryParam(value="endDate") Long endDate, @QueryParam(value="type") int type, @QueryParam(value="selectedSublocationFilters") String sublocationsJson, @QueryParam(value="orderBy") String orderBy) {
        Date selectedStartDate = new Date(startDate);
        Date selectedEndDate = new Date(endDate);
        List<Integer> sublocations = this.unmarshalJsonListOfInts(sublocationsJson);
        List<OverbookTimelineDataResponseDTO> resourceEventsList = this.service.getOverbookTimelineData(selectedStartDate, selectedEndDate, type, sublocations, orderBy, this.getUser());
        return this.gson.toJson(resourceEventsList);
    }

    List<Integer> unmarshalJsonListOfInts(String jsonArray) {
        if (jsonArray == null) {
            throw new IllegalArgumentException("input json can't be null");
        }
        Type listOfIntegers = new TypeToken<List<Integer>>(){}.getType();
        return (List)this.gson.fromJson(jsonArray, listOfIntegers);
    }

    @GET
    @Path(value="/getBookedVisitResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getBookedVisitResources(@QueryParam(value="eventid") int bookedVisitId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<BookedResourcesResponse> bookedResources = this.getBookedResourcesList(bookedVisitId, sortBy, orderBy, page, maxResults);
        return this.gson.toJson(bookedResources);
    }

    List<BookedResourcesResponse> getBookedResourcesList(int bookedVisitId, String sortBy, String orderBy, int page, int maxResults) {
        return this.service.getBookedResources(bookedVisitId, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getBookedResourceData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getBookedResourceData(@QueryParam(value="id") int id) {
        BookedResource bookedResource = this.service.getBookedResourceData(id, this.getRemoteHost(), this.getUser());
        return this.gson.toJson((Object)bookedResource);
    }

    @POST
    @Path(value="/overbookRoomSelected")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String overbookRoomSelected(@FormParam(value="data") String data) {
        this.service.logViewVisits(this.getUser(), this.getRemoteHost(), "Searching for available room through Reserve Room functionality");
        HashMap<String, String> map = new HashMap<String, String>();
        VisitTime ap = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BookedVisit searchedVisits = null;
        if (ap != null) {
            searchedVisits = this.service.overbookRoomData(ap);
        }
        if (searchedVisits.getSelectedRoom() == null) {
            map.put("overbookRoomSelected", "No Rooms Available. Go to previous screen to look for a room at a different time, or select a room from the list to overbook.");
            map.put("overbookRoomSelectedId", null);
        } else {
            map.put("overbookRoomSelected", searchedVisits.getSelectedRoom().getName());
            map.put("overbookRoomSelectedId", searchedVisits.getSelectedRoom().getId().toString());
        }
        return this.gson.toJson(map);
    }

    @POST
    @Path(value="/overbookRoomAppointment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String overbookRoomAppointment(@FormParam(value="data") String data) {
        BookedVisit searchedVisits;
        ArrayList<Map<String, Object>> visitsList = new ArrayList<Map<String, Object>>();
        VisitTime ap = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        if (ap != null && (searchedVisits = this.service.confirmOverbookRoomData(ap, this.getUser(), this.getRemoteHost(), this.context.getRealPath("/WEB-INF"))) != null) {
            HashMap<String, Object> visitInstance = new HashMap<String, Object>();
            StudySubject studySubject = this.service.findStudySubjectById(ap.getSubject());
            searchedVisits.setStudySubject(studySubject);
            String eventId = searchedVisits.getId().toString();
            this.setEventData("Scheduled", eventId, visitInstance, visitsList, searchedVisits, false);
        }
        return this.gson.toJson(visitsList);
    }

    @POST
    @Path(value="/addBookedResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String addBookedResourceOverride(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BooleanResultDTO visit = this.service.addBookedResourceOverride(tr, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/deleteBookedResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String deleteBookedResourceOverride(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BooleanResultDTO visit = this.service.deleteBookedResourceOverride(tr, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/editBookedResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String editBookedResourceOverride(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BooleanResultDTO visit = this.service.editBookedResourceOverride(tr, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/batchEntry")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String batchEntry(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BookedVisit visit = this.service.batchEntryUpdate(tr, this.getUser(), this.getRemoteHost(), this.context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/logAppointmentSearch")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String logAppointmentSearch(@FormParam(value="data") String data) {
        BookedVisitDTO dto = new BookedVisitDTO();
        this.service.logViewVisits(this.getUser(), this.getRemoteHost(), "Searching for a new Appointment");
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/logViewBookedVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String logViewBookedVisit(@FormParam(value="data") String data) {
        BookedVisitDTO dto = (BookedVisitDTO)this.gson.fromJson(data, BookedVisitDTO.class);
        dto = this.service.logViewBookedVisit(dto, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/logAddResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String logAddResourceOverride(@FormParam(value="data") String data) {
        return this.logOverrideActions(data, "Add");
    }

    @POST
    @Path(value="/logEditResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String logEditResourceOverride(@FormParam(value="data") String data) {
        return this.logOverrideActions(data, "Edit");
    }

    @POST
    @Path(value="/logDeleteResourceOverride")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String logDeleteResourceOverride(@FormParam(value="data") String data) {
        return this.logOverrideActions(data, "Delete");
    }

    private String logOverrideActions(String data, String action) {
        BookedVisitDTO dto = (BookedVisitDTO)this.gson.fromJson(data, BookedVisitDTO.class);
        if (dto == null) {
            dto = new BookedVisitDTO();
        }
        dto = this.service.logIncompleteOverrideActions(dto, this.getUser(), this.getRemoteHost(), action + " - Overriding an Appointment (Incomplete Action)");
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/crudTemplateResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String crudTemplateResources(@FormParam(value="data") String data, @QueryParam(value="actionType") String actionType, @HeaderParam(value="User-Agent") String header) {
        TemplateResourceDTO tr = (TemplateResourceDTO)this.gson.fromJson(data, TemplateResourceDTO.class);
        BooleanResultDTO result = this.service.crudTemplateResources(tr, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"), actionType, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/checkIfResourcesLinkableOnDeleteUnlink")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String checkIfResourcesLinkableOnDeleteUnlink(@QueryParam(value="templateResourceId") Integer templateResourceId) {
        BooleanResultDTO result = this.service.checkIfResourcesLinkableOnDeleteUnlink(templateResourceId, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getTemplateResourceDataWithAnnotations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getTemplateResourceData(@QueryParam(value="templateResourceId") Integer templateResourceId) {
        TemplateResourceWithLlaListDTO template = this.service.getTemplateResourceDataWithAnnotations(templateResourceId);
        return this.gson.toJson((Object)template);
    }

    @POST
    @Path(value="/linkResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String linkResources(@FormParam(value="data") String data) {
        GetTemplateResourceGroupDTO getTemplateResourceGroupDTO = (GetTemplateResourceGroupDTO)this.gson.fromJson(data, GetTemplateResourceGroupDTO.class);
        BooleanResultDTO booleanResultDTO = this.service.linkTemplateResourcesAsNewGroup(getTemplateResourceGroupDTO, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @GET
    @Path(value="/unlinkOneResource")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String unlinkOneResource(@QueryParam(value="templateResourceId") Integer templateResourceId) {
        BooleanResultDTO booleanResultDTO = this.service.unlinkOneResource(templateResourceId, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @GET
    @Path(value="/unlinkGroup")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String unlinkGroup(@QueryParam(value="groupId") String groupId) {
        BooleanResultDTO booleanResultDTO = this.service.unlinkGroup(groupId, this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @GET
    @Path(value="/updateTemplateResourceTime")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String updateTemplateResourceTime(@QueryParam(value="templateResourceId") Integer templateResourceId, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate) {
        BooleanResultDTO booleanResultDTO = this.service.updateTemplateResourceTime(templateResourceId, startDate, endDate);
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @GET
    @Path(value="/getGanttResourceInfo")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getGanttResourceInfo(@QueryParam(value="visitId") Integer visitId, @QueryParam(value="templateResourceId") Integer templateResourceId, @QueryParam(value="dayOffset") int dayOffset) {
        GanttResourceInfoDTO ganttResponseComboDTO = this.service.getGanttResourceInfo(visitId, templateResourceId, dayOffset);
        return this.gson.toJson((Object)ganttResponseComboDTO);
    }

    @GET
    @Path(value="/getCalendarBookedVisits")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getCalendarBookedVisits(@HeaderParam(value="User-Agent") String header, @QueryParam(value="start") int start, @QueryParam(value="starting") Long starting, @QueryParam(value="ending") Long ending, @QueryParam(value="filterId") String filterId, @QueryParam(value="filterString") String filterString, @QueryParam(value="todayVisits") boolean todayVisits) {
        Date startDate = new Date(starting);
        Date endDate = new Date(ending);
        endDate = DateUtility.adjustToEndOfDay(endDate);
        int userId = this.getUser().getId();
        String remoteHost = this.getRemoteHost();
        List<CalendarVisitsResponse> bookedVisits = this.getAppointmentsCalendar(userId, filterId, filterString, todayVisits, startDate, endDate, remoteHost);
        return this.gson.toJson(bookedVisits);
    }

    List<CalendarVisitsResponse> getAppointmentsCalendar(int userId, String filterId, String filterString, boolean todayVisits, Date startDate, Date endDate, String remoteHost) {
        return this.service.getCalendarBookedVisits(userId, filterString, filterId, startDate, endDate, remoteHost, todayVisits);
    }

    @POST
    @Path(value="/confirmAppointment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String confirmAppointment(@FormParam(value="data") String data, @HeaderParam(value="User-Agent") String header, @QueryParam(value="isInpatient") boolean isInpatient, @QueryParam(value="startDate") Date startDate, @QueryParam(value="endDate") Date endDate) {
        ConfirmationStatus confirmationStatus;
        VisitTime ap = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        if (ap != null) {
            ap.setStartDate(startDate.getTime());
            ap.setEndDate(endDate.getTime());
            confirmationStatus = this.service.confirmEvent(ap, this.getUserSession(), this.getRemoteHost(), this.getUser().getInstitution().getLongName(), this.context.getRealPath("/WEB-INF"), isInpatient);
            if (ap.getDoubleRoomMessage() != null) {
                HashMap doubleRooms = Maps.newHashMap();
                doubleRooms.put("doubleSharedRoom", ap.getDoubleRoomMessage());
                return this.gson.toJson((Object)doubleRooms);
            }
        } else {
            confirmationStatus = ConfirmationStatus.NotConfirmed;
        }
        HashMap doubleRooms = Maps.newHashMap();
        if (ap.getAlternateResourceUsed() != null) {
            doubleRooms.put("alternateResourceUsed", ap.getAlternateResourceUsed());
        }
        doubleRooms.put("doubleSharedRoom", null);
        doubleRooms.put("confirmationStatus", Boolean.valueOf(confirmationStatus.isConfirmed).toString());
        return this.gson.toJson((Object)doubleRooms);
    }

    @POST
    @Path(value="/getSearchedVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSearchedVisit(@FormParam(value="data") String data, @QueryParam(value="subject") String subject, @QueryParam(value="visit") String visit, @QueryParam(value="startDate") String startDate, @QueryParam(value="endDate") String endDate, @QueryParam(value="isInpatient") boolean isInpatientType) {
        HashMap<String, Object> visitInstance;
        ArrayList<BookedVisit> searchedVisits;
        this.service.logViewVisits(this.getUser(), this.getRemoteHost(), "Searching for a new Appointment");
        ArrayList<Map<String, Object>> visitsList = new ArrayList<Map<String, Object>>();
        VisitTime ap = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        if (ap == null && subject != null) {
            ap = new VisitTime();
            ap.setSubject(Integer.parseInt(subject));
            ap.setVisit(Integer.parseInt(visit));
            ap.setStartDate(Long.parseLong(startDate));
            ap.setEndDate(Long.parseLong(endDate));
            ap.setSessionId(this.getUser().getSessionId());
        }
        if (ap != null && (searchedVisits = new ArrayList<BookedVisit>(this.service.searchAvailabilityData(ap, this.getUserSession(), false, false, isInpatientType))) != null) {
            for (BookedVisit bookedVisit : searchedVisits) {
                visitInstance = new ConcurrentHashMap();
                String eventId = bookedVisit.getUniquekey();
                String className = "Searching";
                if (bookedVisit.isRejectedVisit()) {
                    className = "NotFound";
                }
                this.setEventData(className, eventId, visitInstance, visitsList, bookedVisit, false);
            }
        }
        if (visitsList.size() == 0) {
            visitInstance = new HashMap<String, Object>();
            visitInstance.put("id", 11111111);
            visitInstance.put("className", "false");
            visitsList.add(visitInstance);
            ap.setErrorMsg("false");
            return this.gson.toJson((Object)ap);
        }
        return this.gson.toJson(visitsList);
    }

    @GET
    @Path(value="/getSearchedSlotResources")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSearchedSlotResources(@QueryParam(value="subject") String subject, @QueryParam(value="visit") String visit, @QueryParam(value="startDate") Date startDate, @QueryParam(value="endDate") Date endDate, @QueryParam(value="isInpatient") boolean isInpatientType) {
        ArrayList<BookedResourcesResponse> bookedResources = new ArrayList<BookedResourcesResponse>();
        VisitTime ap = null;
        if (ap == null && subject != null) {
            ap = new VisitTime();
            ap.setSubject(Integer.parseInt(subject));
            ap.setVisit(Integer.parseInt(visit));
            ap.setStartDate(startDate.getTime());
            ap.setEndDate(endDate.getTime());
            ap.setSessionId(this.getUser().getSessionId());
        }
        if (ap != null) {
            BookedVisit potentialVisit = new ArrayList<BookedVisit>(this.service.searchAvailabilityData(ap, this.getUserSession(), false, true, isInpatientType)).get(0);
            List<BookedResource> potentialBookedResource = potentialVisit.getBookedResourceList();
            for (int i = 0; i < potentialBookedResource.size(); ++i) {
                String rejectedMessage = "";
                if (this.getUser().getInstitutionRole().getType() == InstitutionRoleType.ROLE_SUPER_ADMIN || this.getUser().getInstitutionRole().getType() == InstitutionRoleType.ROLE_RESOURCE_MANAGER || this.getUser().getInstitutionRole().getType() == InstitutionRoleType.ROLE_SCHEDULER) {
                    rejectedMessage = potentialBookedResource.get(i).getTemplateResource().getRejectedResourceMessage();
                }
                BookedResourcesResponse bookedResource = new BookedResourcesResponse(potentialBookedResource.get(i).getId(), potentialBookedResource.get(i).getResource().getName(), "", potentialBookedResource.get(i).getScheduledStartTime(), potentialBookedResource.get(i).getScheduledEndTime(), rejectedMessage, potentialBookedResource.get(i).getTemplateResource().getAvailable(), potentialBookedResource.get(i).getTemplateResource().getResourceGroupType(), Long.valueOf(potentialBookedResource.size()), false);
                bookedResources.add(bookedResource);
            }
        }
        return this.gson.toJson(bookedResources);
    }

    private void setEventData(String classNameString, String eventId, Map<String, Object> visitInstance, List<Map<String, Object>> visitsList, BookedVisit visits, boolean allDay) {
        String rooms = visits.getRooms() == null ? "" : visits.getRooms();
        visitInstance.put("id", eventId);
        visitInstance.put("localId", visits.getStudy().getLocalId());
        visitInstance.put("piName", visits.getStudy().getInvestigatorLastNameOrNA());
        visitInstance.put("visitName", visits.getName());
        visitInstance.put("room", rooms);
        visitInstance.put("title", visits.getStudySubject().getSubject().getLastName());
        visitInstance.put("start", DateUtility.format(DateUtility.dateHourMinSec(), visits.getScheduledStartTime()));
        visitInstance.put("end", DateUtility.format(DateUtility.dateHourMinSec(), visits.getScheduledEndTime()));
        visitInstance.put("className", classNameString);
        visitInstance.put("inpatientVisitType", visits.getVisitTemplate().getVisitType().getName().contains("Inpatient"));
        visitInstance.put("allDay", allDay);
        visitsList.add(visitInstance);
    }

    @POST
    @Path(value="/rescheduleAppointment")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String rescheduleAppointment(@FormParam(value="data") String data, @QueryParam(value="eventid") String bookedvisit, @QueryParam(value="startDate") Long startDate, @QueryParam(value="allResources") Boolean allresources, @QueryParam(value="overrideReason") int overrideReason, @QueryParam(value="followOriginalTemplate") Boolean followOriginalTemplate, @QueryParam(value="homeScreen") boolean homeScreen) {
        BookedVisit searchedVisits;
        ArrayList<Map<String, Object>> visitsList = new ArrayList<Map<String, Object>>();
        VisitTime ap = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        if (ap == null && bookedvisit != null) {
            ap = new VisitTime();
            ap.setStartDate(startDate);
            ap.setAllResources(allresources);
            ap.setOverrideReason(overrideReason);
            ap.setBookedvisit(Integer.parseInt(bookedvisit));
        }
        if (ap != null && (searchedVisits = this.service.rescheduleData(ap, this.getUser(), this.getRemoteHost(), this.context.getRealPath("/WEB-INF"), followOriginalTemplate)) != null) {
            HashMap<String, Object> visitInstance = new HashMap<String, Object>();
            String eventId = searchedVisits.getId().toString();
            boolean allDay = homeScreen && searchedVisits.getVisitType().getName().contains("Inpatient");
            this.setEventData("Scheduled", eventId, visitInstance, visitsList, searchedVisits, allDay);
        }
        return this.gson.toJson(visitsList);
    }

    @POST
    @Path(value="/checkinVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String checkinVisit(@FormParam(value="data") String data) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BookedVisit visit = this.service.checkInVisit(tr, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/checkoutVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String checkoutVisit(@FormParam(value="data") String data, @QueryParam(value="homeScreen") boolean homeScreen) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        BookedVisit visit = this.service.checkOutVisit(tr, this.getUser(), this.getRemoteHost());
        HashMap<String, Object> visitInstance = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> visitsList = new ArrayList<Map<String, Object>>();
        String eventId = visit.getId().toString();
        boolean allDay = homeScreen && visit.getVisitType().getName().contains("Inpatient");
        this.setEventData("Checked-Out", eventId, visitInstance, visitsList, visit, allDay);
        return this.gson.toJson(visitInstance);
    }

    @POST
    @Path(value="/cancelVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String cancelVisit(@FormParam(value="data") String data, @QueryParam(value="homeScreen") boolean homeScreen) {
        VisitTime tr = (VisitTime)this.gson.fromJson(data, VisitTime.class);
        ArrayList<Map<String, Object>> visitsList = new ArrayList<Map<String, Object>>();
        if (this.getUser().isStudyStaff() && !this.service.isStudyMember(this.getUser(), tr.getId())) {
            new AccessDeniedException("Cannot cancel a visit that you are not associated with.");
        }
        BookedVisit visit = this.service.cancelVisit(tr, this.getUser(), this.getRemoteHost(), this.context.getRealPath("/WEB-INF"));
        HashMap<String, Object> visitInstance = new HashMap<String, Object>();
        String eventId = visit.getId().toString();
        boolean allDay = homeScreen && visit.getVisitType().getName().contains("Inpatient");
        this.setEventData("Cancellation", eventId, visitInstance, visitsList, visit, allDay);
        return this.gson.toJson(visitInstance);
    }

    @GET
    @Path(value="/getScheduledVisitDetails")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getScheduledVisitDetails(@QueryParam(value="id") int id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BookedVisit s = this.service.getVisitDetails(id, this.getUser(), this.getRemoteHost());
        map.put("studydetailname", s.getStudy().getName());
        map.put("localid", s.getStudy().getLocalId());
        map.put("studyPIdetailname", s.getStudy().getInvestigatorLastNameOrNA());
        map.put("subjectdetailname", s.getStudySubject().getSubject().getFullName());
        map.put("visitdetailname", s.getVisitTemplate().getName());
        map.put("detailVisitTime", s.getVisitTemplate().getDuration().toString());
        map.put("visitTypeId", Integer.toString(s.getVisitType().getId()));
        map.put("relativeTime", s.getVisitTemplate().getRelativeTime().toString());
        map.put("scheduledata", s.getScheduledata());
        map.put("userdata", s.getUserdata());
        if (s.getAppointmentStatus().getId().equals(2) && s.getCheckInDate() != null) {
            map.put("visitdate", DateUtility.format(DateUtility.dateHourMin(), s.getCheckInDate()));
        } else if (s.getAppointmentStatus().getId().equals(3) && s.getCheckOutDate() != null) {
            map.put("visitdate", DateUtility.format(DateUtility.dateHourMin(), s.getCheckOutDate()));
            map.put("check_visit_duration_readonly", s.isVaryDuration());
            map.put("check_visit_activities_readonly", s.isOmmittedActivities());
        } else if (s.getAppointmentStatus().getId().equals(4) && s.getCancelDate() != null) {
            map.put("visitdate", DateUtility.format(DateUtility.dateHourMin(), s.getCancelDate()));
            map.put("visitreasons", s.getCancelStatusReason().getName());
            map.put("visitcomments", s.getComment());
        }
        SubjectDetailResponse subjectDetailsResponse = new SubjectDetailResponse(s.getStudySubject().getSubject());
        map.put("studySubject", subjectDetailsResponse);
        return this.gson.toJson(map);
    }
}

