/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ResourceTimeBoundsAndCountResponseDTO {
    private Long totalVisitResources;
    private List<String> daysList;

    public List<String> getDaysList() {
        return this.daysList;
    }

    ResourceTimeBoundsAndCountResponseDTO(Long totalVisitResources, List<String> daysList) {
        this.totalVisitResources = totalVisitResources;
        this.daysList = daysList;
    }

    public static ResourceTimeBoundsAndCountResponseDTO fromTriple(Long totalVisitResources, Date earlistStartDate, Date latestEndDate) {
        ArrayList<String> daysList = new ArrayList<String>();
        Date startDate = earlistStartDate;
        Date endDate = latestEndDate;
        if (startDate == null) {
            startDate = new Date();
        }
        if (endDate == null) {
            endDate = new Date();
        }
        startDate = DateUtility.parse(DateUtility.dateMonthYear(), DateUtility.format(DateUtility.dateMonthYear(), startDate));
        endDate = DateUtility.parse(DateUtility.dateMonthYear(), DateUtility.format(DateUtility.dateMonthYear(), endDate));
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(startDate);
        int startDay = calStart.get(6);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endDate);
        int endDay = calEnd.get(6);
        int days = endDay - startDay;
        for (int i = 1; i <= days + 1; ++i) {
            daysList.add("DAY " + i);
        }
        return new ResourceTimeBoundsAndCountResponseDTO(totalVisitResources, daysList);
    }
}

