/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

class HqlClauses {
    HqlClauses() {
    }

    static WhereBuilder whereBuilder() {
        return new WhereBuilder();
    }

    static class WhereBuilder {
        private final List<Optional<String>> list = Lists.newArrayList();

        private WhereBuilder() {
        }

        private WhereBuilder createClause(Optional<String> o, String prefix, String suffix) {
            this.list.add(o.map(s -> prefix + s + suffix));
            return this;
        }

        WhereBuilder like(Optional<String> o, String column) {
            return this.createClause(o, column + " like '%", "%'");
        }

        WhereBuilder in(Optional<String> o, String ... ins) {
            return this.createClause(o, "", " in (" + Joiner.on((String)", ").join((Object[])ins) + ")");
        }

        WhereBuilder equalTo(Optional<String> o, String column) {
            return this.createClause(o, column + " = ", "");
        }

        WhereBuilder between(String candidate, String first, String second) {
            return this.accumulate("(" + candidate + " BETWEEN " + first + " AND " + second + ")");
        }

        WhereBuilder beforeAndAfter(String earlyParam, String earlyTime, String lateParam, String lateTime) {
            return this.accumulate("(" + earlyTime + " >= " + earlyParam + " AND " + lateTime + " <= " + lateParam + ")");
        }

        private WhereBuilder accumulate(String clauseString) {
            Optional<String> clause = Optional.of(clauseString);
            this.list.add(clause);
            return this;
        }

        WhereBuilder and(WhereBuilder andBuilder) {
            return this.conjuction(andBuilder::combineViaAnd);
        }

        WhereBuilder or(WhereBuilder orBuilder) {
            return this.conjuction(orBuilder::combineViaOr);
        }

        private WhereBuilder conjuction(Function<Parens, Optional<String>> combine) {
            Optional<String> conjunctionList = combine.apply(Parens.USE);
            if (conjunctionList.isPresent()) {
                this.list.add(conjunctionList);
            }
            return this;
        }

        Optional<String> combineViaAnd(Parens parens) {
            Iterator presentWheres = ListUtils.flatten(this.list).iterator();
            if (presentWheres.hasNext()) {
                return parens.enclose(Joiner.on((String)" and ").join(presentWheres));
            }
            return Optional.empty();
        }

        Optional<String> combineViaOr(Parens parens) {
            Iterator presentWheres = ListUtils.flatten(this.list).iterator();
            if (presentWheres.hasNext()) {
                return parens.enclose(Joiner.on((String)" or ").join(presentWheres));
            }
            return Optional.empty();
        }

        String build() {
            Optional<String> andList = this.combineViaAnd(Parens.DONT_USE);
            return andList.map(al -> "where " + al + " ").orElse("");
        }
    }

    static enum Parens {
        USE("(", ")"),
        DONT_USE("", "");

        private final String open;
        private final String close;

        private Parens(String open, String close) {
            this.open = open;
            this.close = close;
        }

        Optional<String> enclose(String payload) {
            return Optional.of(this.open + payload + this.close);
        }
    }
}

