/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.core.Statics;
import edu.harvard.catalyst.scheduler.dto.AssignResourceAlternativesDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.SublocationClosureIntervalDTO;
import edu.harvard.catalyst.scheduler.dto.request.BooleanRequest;
import edu.harvard.catalyst.scheduler.dto.request.ResourceScheduleRequest;
import edu.harvard.catalyst.scheduler.dto.response.ResourceScheduleResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.SublocationClosureIntervalResponse;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.OverrideBookedResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAlternate;
import edu.harvard.catalyst.scheduler.entity.ResourceAnnotation;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceService {
    private MailHandler mailHandler;
    private AuthDAO authDAO;
    private ResourceDAO resourceDAO;
    private AppointmentDAO appointmentDAO;
    private AuditService auditService;

    @Autowired
    public ResourceService(AuthDAO authDAO, ResourceDAO resourceDAO, AuditService auditService, MailHandler mailHandler, AppointmentDAO appointmentDAO) {
        this.authDAO = authDAO;
        this.resourceDAO = resourceDAO;
        this.appointmentDAO = appointmentDAO;
        this.auditService = auditService;
        this.mailHandler = mailHandler;
    }

    ResourceService() {
    }

    public List<LineLevelAnnotations> getResourceAnnotations(int resource) {
        Resource r = this.resourceDAO.findResourceById(resource);
        ArrayList<LineLevelAnnotations> rs = new ArrayList<LineLevelAnnotations>();
        List<ResourceAnnotation> ra = this.resourceDAO.findResourcesAnnotationsByResource(r);
        if (ra != null && !ra.isEmpty()) {
            for (int i = 0; i < ra.size(); ++i) {
                rs.add(ra.get(i).getLineLevelAnnotations());
            }
        }
        Collections.sort(rs, new LineLevelAnnotations.AnnotationsComparator());
        return rs;
    }

    public BooleanResultDTO assignResourceAlternatives(AssignResourceAlternativesDTO dto, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        for (int i = 0; i < dto.getAlternatives().size(); ++i) {
            Resource altResource = this.resourceDAO.findResourceById(dto.getAlternatives().get(i));
            ResourceAlternate ra = new ResourceAlternate();
            ra.setSourceResource(resource);
            ra.setAlternateResource(altResource);
            this.resourceDAO.createEntity(ra);
        }
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE ALTERNATE", null, null);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public SublocationClosureInterval createSublocationClosureInterval(SublocationClosureIntervalDTO dto, User user, String ipAddress) {
        SublocationClosureInterval interval = new SublocationClosureInterval();
        interval.setStartTime(dto.getStartTime());
        interval.setEndTime(dto.getEndTime());
        interval.setReason(dto.getReason());
        interval.setSublocation(this.resourceDAO.findSublocationById(dto.getSublocationId()));
        this.resourceDAO.createEntity(interval);
        this.auditService.logResourceSublocationClosureActivity(ipAddress, interval.getSublocation(), user, "CREATE SUBLOCATION CLOSURE", null, null);
        return interval;
    }

    public List<SublocationClosureIntervalResponse> getSublocationClosureIntervals(String sortBy, String orderBy, int page, int maxResults) {
        return this.resourceDAO.getSublocationClosureInterval(sortBy, orderBy, page, maxResults);
    }

    public List<Resource> getResources(boolean annotations, String ipAddress, User user) {
        List<Resource> resourceList = this.resourceDAO.findResourcesListedInResourceSublocation();
        ArrayList<Resource> resourceCopies = new ArrayList<Resource>();
        this.auditService.logViewActivity(ipAddress, user, "All Resources Viewed");
        for (Resource r : resourceList) {
            Resource resourceCopy = new Resource(r.getId(), r.getName(), r.getResourceType(), r.getSharedResource(), r.getSublocations(), r.getAlternateResourceList(), r.getSourceResourceList(), r.getDefaultScheduleList(), r.getOverrideScheduleList());
            resourceCopies.add(resourceCopy);
            if (!annotations || !resourceCopy.getResourceType().getName().equalsIgnoreCase("ROOM")) continue;
            resourceCopy.setName("Room : " + resourceCopy.getName());
        }
        return resourceCopies;
    }

    public List<Resource> getRoomResources(String sublocation) {
        List<Resource> rs = this.resourceDAO.findRoomResourcesListedInResourceSublocation(sublocation);
        ArrayList<Resource> rooms = new ArrayList<Resource>();
        for (Resource r : rs) {
            if (r.getName().contains("Any Private Room") || r.getName().contains("All Rooms") || r.getName().contains("Feldberg Room")) continue;
            rooms.add(r);
        }
        return rooms;
    }

    public List<Resource> getNursingResources(String ipAddress, User user, String sublocation) {
        return this.resourceDAO.findNursingResourcesListedInResourceSublocation(sublocation);
    }

    public List<Resource> getNutritionResources(String ipAddress, User user, String sublocation) {
        return this.resourceDAO.findNutritionResourcesListedInResourceSublocation(sublocation);
    }

    public List<ResourcesResponse> getAlternateResources(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        List<ResourceAlternate> altResource = this.resourceDAO.findResourceAlternates(resource);
        ArrayList<Resource> altResourceList = new ArrayList<Resource>();
        for (ResourceAlternate resourceAlt : altResource) {
            altResourceList.add(resourceAlt.getAlternateResource());
        }
        List<ResourcesResponse> resourceList = this.resourceDAO.findResourcesWithSublocationAndAlternates(resource, altResourceList, sortBy, orderBy, page, maxResults);
        return resourceList;
    }

    public List<Resource> getUnassignedResources() {
        return this.resourceDAO.findResourcesNotListedInResourceSublocation();
    }

    public List<ResourceScheduleResponse> getResourceSchedules(int resourceId, boolean isOverride, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        if (isOverride) {
            return this.resourceDAO.findTemporarySchedulesByResource(resource, isOverride, sortBy, orderBy, page, maxResults);
        }
        return this.resourceDAO.findResourceSchedulesByResource(resource, isOverride, sortBy, orderBy, page, maxResults);
    }

    public ResourceScheduleResponse getResourceDefaultSchedule(int id) {
        return this.resourceDAO.resourceScheduleById(id);
    }

    public BooleanRequest addDefaultAvailability(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        for (int i = 0; i < dto.getDays().size(); ++i) {
            ResourceSchedule rs = new ResourceSchedule();
            rs.setResource(resource);
            rs.setDayOfWeek(dto.getDays().get(i));
            rs.setStartTime(dto.getStartDate());
            rs.setEndTime(dto.getEndDate());
            rs.setQuantity(dto.getQuantity());
            rs.setOverride(dto.isOverride());
            this.resourceDAO.createEntity(rs);
        }
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE DEFAULT SCHEDULE", null, null);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest updateDefaultAvailability(ResourceScheduleRequest dto, User user, String ipAddress, String templatePath) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(dto.getId());
        int editDay = rs.getDayOfWeek();
        String editStart = rs.getStartTime().toString();
        String editEnd = rs.getEndTime().toString();
        String editQuantity = rs.getQuantity().toString();
        String previousData = this.updateResourceAvailabilityData(dto, rs);
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "UPDATE RESOURCE DEFAULT SCHEDULE", previousData, null);
        this.resourceDAO.updateEntity(rs);
        booleanRequest.setResult(true);
        this.sendDefaultAvailabilityChangeEmail(rs, editDay, editStart, editEnd, editQuantity, user.getInstitution().getLongName(), templatePath);
        return booleanRequest;
    }

    String updateResourceAvailabilityData(ResourceScheduleRequest dto, ResourceSchedule rs) {
        String previousData = "";
        if (!rs.getStartTime().equals(dto.getStartDate())) {
            previousData = previousData + " Start Time: " + rs.getStartTime() + " to " + dto.getStartDate() + ", ";
        }
        if (!rs.getEndTime().equals(dto.getEndDate())) {
            previousData = previousData + " End Time: " + rs.getEndTime() + " to " + dto.getEndDate() + ", ";
        }
        if (!rs.getQuantity().equals(dto.getQuantity())) {
            previousData = previousData + " Quantity: " + rs.getQuantity() + " to " + dto.getQuantity() + ", ";
        }
        rs.setStartTime(dto.getStartDate());
        rs.setEndTime(dto.getEndDate());
        rs.setQuantity(dto.getQuantity());
        return previousData;
    }

    void sendDefaultAvailabilityChangeEmail(ResourceSchedule rs, int editDay, String editStart, String editEnd, String editQuantity, String institution, String templatePath) {
        List<User> schedulers = this.authDAO.findSchedulerUserByInstitutionRole();
        for (User u : schedulers) {
            String to = u.getEmail();
            String day = this.returnDayofWeek(editDay);
            int days = rs.getDayOfWeek();
            String newDay = this.returnDayofWeek(days);
            String resourceName = rs.getResource().getName();
            String start = rs.getStartTime().getHours() + " : " + rs.getStartTime().getMinutes();
            String end = rs.getEndTime().getHours() + " : " + rs.getEndTime().getMinutes();
            String quantity = rs.getQuantity().toString();
            String title = "Change in the default availablility of the resource.";
            StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
            StringTemplate schedulerEmail = group.getInstanceOf("resourceChangeEmail");
            schedulerEmail.setAttribute("institution", (Object)institution);
            schedulerEmail.setAttribute("resourceName", (Object)resourceName);
            schedulerEmail.setAttribute("editday", (Object)day);
            schedulerEmail.setAttribute("editstart", (Object)editStart);
            schedulerEmail.setAttribute("editend", (Object)editEnd);
            schedulerEmail.setAttribute("editquantity", (Object)editQuantity);
            schedulerEmail.setAttribute("newday", (Object)newDay);
            schedulerEmail.setAttribute("newstart", (Object)start);
            schedulerEmail.setAttribute("newend", (Object)end);
            schedulerEmail.setAttribute("newquantity", (Object)quantity);
            if (u.getEmail() == null) continue;
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(to).subject(title).text(schedulerEmail.toString()).build());
        }
    }

    public String returnDayofWeek(int editDay) {
        String day = null;
        try {
            day = Statics.DAYS_OF_WEEK[editDay - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            SchedulerRuntimeException.logDontThrow("Bad index for days-of-week: " + (editDay - 1), e);
        }
        return day;
    }

    public BooleanRequest addTemporaryAdjustment(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(dto.getResourceId());
        ResourceSchedule rs = new ResourceSchedule();
        rs.setResource(resource);
        rs.setStartTime(dto.getStartDate());
        rs.setEndTime(dto.getEndDate());
        rs.setQuantity(dto.getQuantity());
        rs.setOverride(dto.isOverride());
        this.auditService.logResourceActivity(ipAddress, resource, user, "CREATE RESOURCE TEMP ADJUSTMENT", null, null);
        this.resourceDAO.createEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest updateTemporaryAdjustment(ResourceScheduleRequest dto, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(dto.getId());
        String previousData = this.updateResourceAvailabilityData(dto, rs);
        rs.setOverride(dto.isOverride());
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "UPDATE RESOURCE TEMP ADJUSTMENT", previousData, null);
        this.resourceDAO.updateEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanRequest deleteTemporaryAdjustment(int id, User user, String ipAddress, String templateContext) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(id);
        String editStart = rs.getStartTime().toString();
        String editEnd = rs.getEndTime().toString();
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "DELETE RESOURCE TEMP ADJUSTMENT", null, null);
        this.resourceDAO.deleteEntity(rs);
        booleanRequest.setResult(true);
        this.sendRemoveOverrideScheduleMail(rs, editStart, editEnd, user.getInstitution().getLongName(), templateContext);
        return booleanRequest;
    }

    void sendRemoveOverrideScheduleMail(ResourceSchedule rs, String editStart, String editEnd, String institution, String templatePath) {
        List<User> schedulers = this.authDAO.findSchedulerUserByInstitutionRole();
        for (User u : schedulers) {
            String to = u.getPreferredNotificationEmail();
            String resourceName = rs.getResource().getName();
            String start = rs.getStartTime().toString();
            String end = rs.getEndTime().toString();
            String quant = rs.getQuantity().toString();
            String title = "Change in the temporary adjustments of the resource.";
            StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
            StringTemplate schedulerEmail = group.getInstanceOf("resourceTempChangeEmail");
            schedulerEmail.setAttribute("institution", (Object)institution);
            schedulerEmail.setAttribute("resourceName", (Object)resourceName);
            schedulerEmail.setAttribute("editstart", (Object)editStart);
            schedulerEmail.setAttribute("editend", (Object)editEnd);
            schedulerEmail.setAttribute("newstart", (Object)start);
            schedulerEmail.setAttribute("newend", (Object)end);
            schedulerEmail.setAttribute("newquantity", (Object)quant);
            if (u.getEmail() == null) continue;
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(to).subject(title).text(schedulerEmail.toString()).build());
        }
    }

    public BooleanRequest deleteDefaultSchedule(int id, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ResourceSchedule rs = this.resourceDAO.findResourceScheduleById(id);
        this.auditService.logResourceActivity(ipAddress, rs.getResource(), user, "DELETE RESOURCE DEFAULT SCHEDULE", null, null);
        this.resourceDAO.deleteEntity(rs);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public BooleanResultDTO deleteSublocationClosureInterval(SublocationClosureIntervalDTO dto, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        SublocationClosureInterval interval = this.resourceDAO.findBySublocationClosureIntervalId(dto.getSublocationClosureIntervalId());
        this.auditService.logResourceSublocationClosureActivity(ipAddress, interval.getSublocation(), user, "DELETE SUBLOCATION CLOSURE", null, null);
        this.resourceDAO.deleteEntity(interval);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanRequest removeResourceAlternative(int resourceId, int alternateResourceId, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        List<ResourceAlternate> list = this.resourceDAO.findResourceAlternates(resource);
        for (ResourceAlternate ra : list) {
            if (ra.getId() != alternateResourceId) continue;
            this.resourceDAO.deleteEntity(ra);
        }
        booleanRequest.setResult(true);
        this.auditService.logResourceActivity(ipAddress, resource, user, "DELETE RESOURCE ALTERNATE", null, null);
        return booleanRequest;
    }

    public List<LineLevelAnnotations> getSelectedResourceAnnotations(String annotations, String mode, int templateResourceId) {
        ArrayList<LineLevelAnnotations> la = new ArrayList<LineLevelAnnotations>();
        List<String> items = Arrays.asList(annotations.split("\\s*,\\s*"));
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (String s : items) {
            intList.add(Integer.valueOf(s));
        }
        for (int i = 0; i < intList.size(); ++i) {
            LineLevelAnnotations rs = this.resourceDAO.findLineLevelAnnotationsById((Integer)intList.get(i));
            la.add(rs);
            this.setLineLevelAnnotations(mode, templateResourceId, la, i);
        }
        return la;
    }

    private void setLineLevelAnnotations(String mode, int templateResourceId, List<LineLevelAnnotations> la, int i) {
        if (mode != null && mode.equalsIgnoreCase("edit")) {
            this.templateResourceAnnotations(templateResourceId, la, i);
        } else if (mode != null && mode.equalsIgnoreCase("override_edit")) {
            this.bookedResourceAnnotations(templateResourceId, la, i);
        } else if (mode != null && (mode.equalsIgnoreCase("new") || mode.equalsIgnoreCase("override_new"))) {
            la.get(i).setQuantity(1);
        }
    }

    private void bookedResourceAnnotations(int templateResourceId, List<LineLevelAnnotations> la, int i) {
        BookedResource r = this.appointmentDAO.findBookedResourceById(templateResourceId);
        OverrideBookedResourceAnnotations rsa = this.resourceDAO.findBookedResourceAnnotationsByBookedResourceAndLineLevel(r, la.get(i));
        if (rsa != null) {
            la.get(i).setQuantity(rsa.getQuantity());
            la.get(i).setComment(rsa.getComment());
            la.get(i).setResourceAnnotations(rsa.getId());
        } else {
            la.get(i).setQuantity(1);
        }
    }

    private void templateResourceAnnotations(int templateResourceId, List<LineLevelAnnotations> la, int i) {
        TemplateResource r = this.resourceDAO.findTemplateResourceById(templateResourceId);
        TemplateResourceAnnotations rsa = this.resourceDAO.findTemplateAnnotationsByTemplateResourceAndLineLevel(r, la.get(i));
        if (rsa != null) {
            la.get(i).setQuantity(rsa.getQuantity());
            la.get(i).setComment(rsa.getComment());
            la.get(i).setResourceAnnotations(rsa.getId());
        } else {
            la.get(i).setQuantity(1);
        }
    }

    public List<LineLevelAnnotations> getBookedResourceAnnotations(int bookedResourceId) {
        BookedResource bookedResourceById = this.appointmentDAO.findBookedResourceById(bookedResourceId);
        List<OverrideBookedResourceAnnotations> rs = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(bookedResourceById);
        List<LineLevelAnnotations> ls = this.getResourceAnnotations(bookedResourceById.getResource().getId());
        for (int i = 0; i < rs.size(); ++i) {
            int indexOf = ls.indexOf(rs.get(i).getLineLevelAnnotations());
            ls.get(indexOf).setSelected(true);
            ls.get(indexOf).setQuantity(rs.get(i).getQuantity());
            ls.get(indexOf).setComment(rs.get(i).getComment());
            ls.get(indexOf).setResourceAnnotations(rs.get(i).getId());
        }
        Collections.sort(ls, new LineLevelAnnotations.AnnotationsComparator());
        return ls;
    }

    public List<ResourcesResponse> getResourcesWithSublocation(String sortBy, String orderBy, int page, int maxResults, User user, String ipAddress) {
        this.auditService.logViewActivity(ipAddress, user, "VIEW RESOURCE");
        return this.resourceDAO.findResourceListWithSublocation(sortBy, orderBy, page, maxResults);
    }

    public ResourcesResponse getResourceDetail(int resourceId, User user, String ipAddress) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        this.auditService.logResourceActivity(ipAddress, resource, user, "VIEW RESOURCE", null, null);
        return this.resourceDAO.findResourceDetail(resource);
    }

    public List<ResourcesResponse> getResourceAlternates(int resourceId, String sortBy, String orderBy, int page, int maxResults) {
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        return this.resourceDAO.findResourceAlternatesByResource(resource, sortBy, orderBy, page, maxResults);
    }

    public BooleanRequest assignResource(int resourceId, int sublocations, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        ArrayList<Sublocation> list = new ArrayList<Sublocation>();
        Resource resource = this.resourceDAO.findResourceById(resourceId);
        resource.getSublocations().clear();
        this.resourceDAO.updateEntity(resource);
        Sublocation sublocation = this.resourceDAO.findSublocationById(sublocations);
        list.add(sublocation);
        resource.getSublocations().addAll(list);
        this.resourceDAO.updateEntity(resource);
        this.auditService.logResourceActivity(ipAddress, resource, user, "RESOURCE ASSIGNED ", null, null);
        booleanRequest.setResult(true);
        return booleanRequest;
    }
}

