/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.dto.ReportDTO;
import edu.harvard.catalyst.scheduler.dto.response.CancellationsReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataReportResponseDTO;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Report;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.ReportService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/report")
@Singleton
@Component
public class ReportResource
extends SecuredResource {
    private ReportService reportService;

    @Autowired
    public ReportResource(ReportService reportService) {
        this.reportService = reportService;
    }

    ReportResource() {
    }

    @POST
    @Path(value="/exportToExcelReports")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public Response exportToExcelReports(@FormParam(value="exportField") String exportdata, @FormParam(value="exportFileName") String exportfile) {
        Response.ResponseBuilder response = Response.ok((Object)exportdata);
        response.header("Pragma:", (Object)"public");
        response.header("Expires:", (Object)"0");
        response.header("Cache-Control:", (Object)"must-revalidate, post-check=0, pre-check=0");
        response.header("Cache-Control:", (Object)"public");
        response.header("Content-Type:", (Object)"application/octet-stream");
        response.header("Content-Disposition", (Object)("attachment; filename=\"" + exportfile + ".csv\""));
        response.header("Content-Transfer-Encoding:", (Object)"binary");
        return response.build();
    }

    @GET
    @Path(value="/getReports")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getReports() {
        this.reportService.logViewReports(this.getUser(), this.getRemoteHost(), "Reports Screen View");
        ReportDTO reportDTO = new ReportDTO();
        List<Report> reports = this.reportService.getReports(reportDTO);
        reportDTO.setReports(reports);
        return this.gson.toJson((Object)reportDTO);
    }

    @GET
    @Path(value="/getReportData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getReportData(@QueryParam(value="id") int id) {
        Report report = this.reportService.getReportData(this.getUser(), this.getRemoteHost(), id);
        return this.gson.toJson((Object)report);
    }

    @POST
    @Path(value="/getReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getReport(@FormParam(value="data") String data, @QueryParam(value="name") String name, @QueryParam(value="filterString") String filterString, @QueryParam(value="filterId") String filterId, @QueryParam(value="sortId") String sortId) {
        ReportDTO dto = (ReportDTO)this.gson.fromJson(data, ReportDTO.class);
        if (dto == null) {
            dto = new ReportDTO();
        }
        dto.setName(name);
        dto.setFilterString(filterString);
        dto.setFilterId(filterId);
        dto.setSortId(sortId);
        this.reportService.getReport(dto, this.getUser(), this.getRemoteHost());
        String result = this.subjectMrnSkippingGson.toJson((Object)dto);
        return result;
    }

    @POST
    @Path(value="/logViewReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public void logViewReport(@FormParam(value="data") String data) {
        ReportDTO dto = (ReportDTO)this.gson.fromJson(data, ReportDTO.class);
        this.reportService.logViewReports(this.getUser(), this.getRemoteHost(), "Report Clicked - " + dto.getName());
    }

    @POST
    @Path(value="/loadResourceTypes")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String loadResourceTypes(@FormParam(value="data") String data) {
        List<ResourceType> resourceTypes = this.reportService.getResourceTypes();
        ReportDTO dto = new ReportDTO();
        dto.setResourceTypes(resourceTypes);
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/loadSublocations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String loadSublocations(@FormParam(value="data") String data) {
        List<Sublocation> sublocations = this.reportService.getSublocations();
        ReportDTO dto = new ReportDTO();
        dto.setSublocations(sublocations);
        return this.gson.toJson((Object)dto);
    }

    @GET
    @Path(value="/studyDataReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String studyDataReport(@QueryParam(value="localId") String localId, @QueryParam(value="name") String name, @QueryParam(value="studyStatus") String studyStatus, @QueryParam(value="fundingSource") String fundingSource, @QueryParam(value="sortStrategy") String sortStrategy) {
        List<StudyDataReportResponseDTO> studyDataReportResponseDTOs = this.reportService.getStudyDataReport(Optional.of(this.getUser()), Optional.of(this.getRemoteHost()), Optional.ofNullable(localId), Optional.ofNullable(name), Optional.ofNullable(fundingSource), Optional.ofNullable(studyStatus), Optional.ofNullable(sortStrategy));
        String result = this.gson.toJson(studyDataReportResponseDTOs);
        return result;
    }

    @GET
    @Path(value="/cancellationsReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String cancellationsReport(@QueryParam(value="startTime") String startTimeLongString, @QueryParam(value="endTime") String endTimeLongString, @QueryParam(value="localId") String localId, @QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="reason") String reason, @QueryParam(value="noApprove") String noApprove, @QueryParam(value="sortStrategy") String sortStrategy) {
        Date startTime = DateUtility.parseLong(startTimeLongString);
        Date endTime = DateUtility.parseLong(endTimeLongString);
        endTime = DateUtility.adjustToEndOfDay(endTime);
        List<CancellationsReportResponseDTO> cancellationsReportResponseDTOs = this.reportService.getCancellationsReport(Optional.of(this.getUser()), Optional.of(this.getRemoteHost()), Optional.of(startTime), Optional.of(endTime), Optional.ofNullable(localId), Optional.ofNullable(name), Optional.ofNullable(type), Optional.ofNullable(reason), Optional.ofNullable(noApprove), Optional.ofNullable(sortStrategy));
        String result = this.gson.toJson(cancellationsReportResponseDTOs);
        return result;
    }

    public static class BadReport {
        static BadReport instance = new BadReport();

        static BadReport getInstance() {
            return instance;
        }
    }
}

