/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.context.SAMLContextProvider;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.log.SAMLLogger;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.Assert;

public class SAMLLogoutFilter
extends LogoutFilter {
    protected SingleLogoutProfile profile;
    protected SAMLLogger samlLogger;
    protected SAMLContextProvider contextProvider;
    protected static final String LOGOUT_PARAMETER = "local";
    protected LogoutHandler[] globalHandlers;
    public static final String FILTER_URL = "/saml/logout";

    public SAMLLogoutFilter(String successUrl, LogoutHandler[] localHandler, LogoutHandler[] globalHandlers) {
        super(successUrl, localHandler);
        this.globalHandlers = globalHandlers;
        this.setFilterProcessesUrl(FILTER_URL);
    }

    public SAMLLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler[] localHandler, LogoutHandler[] globalHandlers) {
        super(logoutSuccessHandler, localHandler);
        this.globalHandlers = globalHandlers;
        this.setFilterProcessesUrl(FILTER_URL);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterInvocation fi = new FilterInvocation(request, response, chain);
        this.processLogout(fi.getRequest(), fi.getResponse(), chain);
    }

    public void processLogout(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresLogout(request, response)) {
            try {
                Authentication auth = SecurityContextHolder.getContext().getAuthentication();
                if (auth != null && this.isGlobalLogout(request, auth)) {
                    Assert.isInstanceOf(SAMLCredential.class, (Object)auth.getCredentials(), (String)"Authentication object doesn't contain SAML credential, cannot perform global logout");
                    for (LogoutHandler handler : this.globalHandlers) {
                        handler.logout(request, response, auth);
                    }
                    SAMLCredential credential = (SAMLCredential)auth.getCredentials();
                    request.setAttribute("localEntityId", (Object)credential.getLocalEntityID());
                    request.setAttribute("peerEntityId", (Object)credential.getRemoteEntityID());
                    SAMLMessageContext context = this.contextProvider.getLocalAndPeerEntity(request, response);
                    this.profile.sendLogoutRequest(context, credential);
                    this.samlLogger.log("LogoutRequest", "SUCCESS", context);
                }
                super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
            catch (SAMLException e) {
                this.logger.debug((Object)"Error initializing global logout", (Throwable)e);
                throw new ServletException("Error initializing global logout", (Throwable)e);
            }
            catch (MetadataProviderException e) {
                this.logger.debug((Object)"Error processing metadata", (Throwable)e);
                throw new ServletException("Error processing metadata", (Throwable)e);
            }
            catch (MessageEncodingException e) {
                this.logger.debug((Object)"Error encoding outgoing message", (Throwable)e);
                throw new ServletException("Error encoding outgoing message", (Throwable)e);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        return SAMLUtil.processFilter(this.getFilterProcessesUrl(), request);
    }

    protected boolean isGlobalLogout(HttpServletRequest request, Authentication auth) {
        String localLogout = request.getParameter(LOGOUT_PARAMETER);
        return (localLogout == null || !"true".equals(localLogout.toLowerCase().trim())) && auth.getCredentials() instanceof SAMLCredential;
    }

    @Autowired
    public void setSamlLogger(SAMLLogger samlLogger) {
        Assert.notNull((Object)samlLogger, (String)"SAML Logger can't be null");
        this.samlLogger = samlLogger;
    }

    @Autowired
    public void setProfile(SingleLogoutProfile profile) {
        Assert.notNull((Object)profile, (String)"SingleLogoutProfile can't be null");
        this.profile = profile;
    }

    @Autowired
    public void setContextProvider(SAMLContextProvider contextProvider) {
        Assert.notNull((Object)contextProvider, (String)"Context provider can't be null");
        this.contextProvider = contextProvider;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.profile, (String)"Single logout profile must be set");
        Assert.notNull((Object)this.contextProvider, (String)"Context provider must be set");
        Assert.notNull((Object)this.samlLogger, (String)"SAML Logger must be set");
    }
}

