/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.fakeSubjects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.util.ClassPathUtil;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.PrintStream;
import java.security.Key;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FakeSubjects {
    private static Map<Integer, String> stateIdToCityMap = FakeSubjects.generateStateIdToCityMap();
    private static List<String> firstNames;
    private static List<String> lastNames;
    private static int firstNameCount;
    private static int lastNameCount;
    private static List<Integer> ethnicityIds;
    private static List<Integer> raceIds;
    private static List<Integer> genderIds;
    private static final int inverseFrequencyOfMrnMutations = 20;
    private static final Logger log;
    private final DataSource dataSource;

    private static Map<Integer, String> generateStateIdToCityMap() {
        HashMap mapToPopulate = Maps.newHashMap();
        mapToPopulate.put(1, "Boston");
        mapToPopulate.put(43, "Austin");
        mapToPopulate.put(32, "New York City");
        mapToPopulate.put(14, "Chicago");
        mapToPopulate.put(6, "Los Angeles");
        mapToPopulate.put(43, "Houston");
        mapToPopulate.put(47, "Seattle");
        mapToPopulate.put(11, "Atlanta");
        return mapToPopulate;
    }

    @Autowired
    public FakeSubjects(DataSource dataSource, @Qualifier(value="encryptionKeyFake") Key key) {
        ClassPathUtil.printClassPath((PrintStream)System.out);
        this.dataSource = dataSource;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws SQLException {
        Integer numSubjects = new Integer(args[0]);
        boolean randomizeMrn = false;
        boolean resetId = false;
        if (args.length > 1 && args[1].equals("--randomizeMrn")) {
            randomizeMrn = true;
            log.info((Object)"Running with --randomizeMrn option: MRN's will have random spaces and dashes");
        }
        if (args.length > 1 && args[1].equals("--resetId")) {
            resetId = true;
            log.info((Object)"Running with --resetId: reset autoincrement id column");
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-populate-fake-subjects.xml");
        FakeSubjects fakeSubjects = (FakeSubjects)context.getBean("fakeSubjects");
        fakeSubjects.run(numSubjects, randomizeMrn, resetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(int numSubjects, boolean randomizeMrn, boolean resetId) throws SQLException {
        int numFaked = 0;
        try (Connection connection = this.dataSource.getConnection();){
            if (resetId) {
                Statement statement = connection.createStatement();
                statement.executeUpdate("ALTER TABLE `subject` AUTO_INCREMENT = 1;");
            }
            String createSubjectString = "insert into subject ( id, first_name, middle_name, last_name, full_name, ethnicity, birthdate, race, gender, street_address1, street_address2, city, state, zip, comment, country, primary_contact_number, secondary_contact_number, created_date, secure, active, subject_scheduler_id, mrn )  values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement createSubjectStatement = connection.prepareStatement(createSubjectString);
            for (int i = 1; i <= numSubjects; ++i) {
                this.insertQuery(createSubjectStatement, i, randomizeMrn);
                ++numFaked;
            }
        }
        finally {
            String message = "Succeeded to create " + numFaked + " fake Subjects, out of " + numSubjects + " desired";
            if (randomizeMrn) {
                message = message + ", with randomized spaces and dashes";
            }
            System.out.println(message);
            log.info((Object)message);
        }
    }

    private Date randomDateOfBirth() {
        Calendar gc = Calendar.getInstance();
        gc.add(1, -1);
        int year = this.randBetween(1900, gc.get(1));
        gc.set(1, year);
        int dayOfYear = this.randBetween(1, gc.getActualMaximum(6));
        gc.set(6, dayOfYear);
        return new Date(gc.getTimeInMillis());
    }

    private String randomMrn(Random random, int index) {
        boolean hasLeadingSpace = random.nextInt(20) == 0;
        boolean hasMiddleSpace = random.nextInt(20) == 0;
        boolean hasTrailingSpace = random.nextInt(20) == 0;
        boolean hasLeadingDash = random.nextInt(20) == 0;
        boolean hasMiddleDash = random.nextInt(20) == 0;
        boolean hasTrailingDash = random.nextInt(20) == 0;
        StringBuffer buffer = new StringBuffer();
        if (hasLeadingSpace) {
            buffer.append(" ");
        }
        if (hasLeadingDash) {
            buffer.append("-");
        }
        buffer.append(index);
        if (hasMiddleSpace) {
            buffer.append(" ");
        }
        if (hasMiddleDash) {
            buffer.append("-");
        }
        buffer.append(index);
        if (hasTrailingSpace) {
            buffer.append(" ");
        }
        if (hasTrailingDash) {
            buffer.append("-");
        }
        return buffer.toString();
    }

    public int randBetween(int start, int end) {
        return start + (int)Math.round(Math.random() * (double)(end - start));
    }

    private void insertQuery(PreparedStatement createSubjectStatement, int index, boolean randomizeMrn) throws SQLException {
        Random random = new Random();
        ArrayList keys = Lists.newArrayList(stateIdToCityMap.keySet());
        Integer stateId = (Integer)keys.get(random.nextInt(keys.size()));
        String cityName = stateIdToCityMap.get(stateId).toUpperCase();
        Date birthDate = this.randomDateOfBirth();
        Timestamp createStamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Integer ethnicity = ethnicityIds.get(random.nextInt(ethnicityIds.size()));
        Integer race = raceIds.get(random.nextInt(raceIds.size()));
        Integer gender = genderIds.get(random.nextInt(genderIds.size()));
        Integer state = new Integer(stateId);
        Integer country = new Integer(1);
        String city = SubjectDataEncryptor.encrypt((String)cityName);
        String middleName = SubjectDataEncryptor.encrypt((String)"");
        String primaryContactNumber = SubjectDataEncryptor.encrypt((String)"555-111-1111");
        String secondaryContactNumber = SubjectDataEncryptor.encrypt((String)"555-111-1111");
        String streetAddress1 = SubjectDataEncryptor.encrypt((String)"123 Main St");
        String streetAddress2 = SubjectDataEncryptor.encrypt((String)"");
        String zip = SubjectDataEncryptor.encrypt((String)"01234");
        String schedulerId = "";
        String first = firstNames.get(random.nextInt(firstNameCount)).toUpperCase();
        String last = lastNames.get(random.nextInt(lastNameCount)).toUpperCase();
        String full = first + " " + last;
        String firstName = SubjectDataEncryptor.encrypt((String)first);
        String lastName = SubjectDataEncryptor.encrypt((String)last);
        String fullName = SubjectDataEncryptor.encrypt((String)full);
        String mrn = randomizeMrn ? SubjectDataEncryptor.encrypt((String)this.randomMrn(random, index)) : SubjectDataEncryptor.encrypt((String)("000" + index));
        Integer subjectId = new Integer(index);
        int index2 = 0;
        createSubjectStatement.setInt(++index2, subjectId);
        createSubjectStatement.setString(++index2, firstName);
        createSubjectStatement.setString(++index2, middleName);
        createSubjectStatement.setString(++index2, lastName);
        createSubjectStatement.setString(++index2, fullName);
        createSubjectStatement.setInt(++index2, ethnicity);
        createSubjectStatement.setDate(++index2, birthDate);
        createSubjectStatement.setInt(++index2, race);
        createSubjectStatement.setInt(++index2, gender);
        createSubjectStatement.setString(++index2, streetAddress1);
        createSubjectStatement.setString(++index2, streetAddress2);
        createSubjectStatement.setString(++index2, city);
        createSubjectStatement.setInt(++index2, state);
        createSubjectStatement.setString(++index2, zip);
        createSubjectStatement.setString(++index2, "");
        createSubjectStatement.setInt(++index2, country);
        createSubjectStatement.setString(++index2, primaryContactNumber);
        createSubjectStatement.setString(++index2, secondaryContactNumber);
        createSubjectStatement.setTimestamp(++index2, createStamp);
        createSubjectStatement.setBoolean(++index2, true);
        createSubjectStatement.setBoolean(++index2, true);
        createSubjectStatement.setString(++index2, schedulerId);
        createSubjectStatement.setString(++index2, mrn);
        createSubjectStatement.executeUpdate();
    }

    static {
        ethnicityIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        raceIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        genderIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        firstNames = Lists.newArrayList((Object[])new String[]{"Alma", "Bobby", "Carly", "Donny", "Edna", "Fanny", "Greg", "Helen", "Ingrid", "Jacob", "Kim", "Loyd", "Melnea", "Ned", "Orenthal", "Peter", "Quick", "Robert", "Suzy", "Tommy", "Ursula", "Veronica", "Wilson", "Xerxes", "Yemi", "Zooey", "Artie", "Billie", "Christina", "Deb", "Earl", "Fred", "Gina", "Huck", "Ilias", "Jenny", "Karl", "Lana", "Manny", "Nana", "Oby", "Patty", "Quiz", "Rita", "Stan", "Tammy", "Urie", "Vincent", "Wynona", "Burger", "Ray", "Sandy", "Andrea", "Louann", "Zora", "Tom", "Jean", "Scott", "Emma", "Betsy", "Rachel", "Alan"});
        lastNames = Lists.newArrayList((Object[])new String[]{"Apple", "Boyle", "Cart", "Dove", "Everage", "Farber", "Gumble", "Hayes", "India", "Jones", "Lamp", "Moses", "Needham", "Opp", "Pointer", "Quiet", "Redford", "Sandor", "Twotone", "Underwood", "White", "Xerlop", "Young", "Ziskin", "Ashford", "Blue", "Crawford", "Docker", "Easton", "Flinstone", "Grant", "Howe", "Inwood", "Jewel", "Kamp", "Luz", "Morgan", "Nickle", "Osman", "Park", "Quorum", "Rudner", "Smith", "Tent", "Udeen", "Voss", "West", "King", "Croc", "Smyth", "Small", "Sweet", "Sound", "Thompson", "Grey", "Harlow", "Frost", "Grae", "Summers", "Smithee"});
        firstNameCount = firstNames.size();
        lastNameCount = lastNames.size();
        log = Logger.getLogger(FakeSubjects.class);
    }
}

