/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.request.ReportTemplateCreateUsersDTO;
import edu.harvard.catalyst.scheduler.dto.request.ReportTemplateRequestDTO;
import edu.harvard.catalyst.scheduler.dto.response.CategoryDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateMetadataDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateResultDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateUsersDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateCategoryFieldDTO;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.HasReportFiltersNameAndId;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Category;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Field;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Graph;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.ReportTemplate;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.SubCategory;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategory;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategoryField;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUser;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserFilterSelection;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserSelection;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserSortSelection;
import edu.harvard.catalyst.scheduler.persistence.ReportTemplateDAO;
import edu.harvard.catalyst.scheduler.service.SubjectService;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class ReportTemplateService {
    private static final Logger LOGGER = Logger.getLogger(ReportTemplateService.class);
    public static final Integer RESULT_LIMIT = 1000;
    public static final int FIRST_LIMIT = 5;
    private final ReportTemplateDAO reportTemplateDAO;
    private final SubjectService subjectService;

    ReportTemplateService() {
        this(null, null);
    }

    @Autowired
    public ReportTemplateService(ReportTemplateDAO reportTemplateDAO, @Qualifier(value="subjectSSOTConfigured") SubjectService subjectService) {
        this.reportTemplateDAO = reportTemplateDAO;
        this.subjectService = subjectService;
    }

    public String getTemplateName(Integer templateId, String type, Integer templateUserId) {
        String reportTemplateName = type.equalsIgnoreCase("Custom") ? this.reportTemplateDAO.findTemplateUserById(templateUserId).getName() : this.reportTemplateDAO.findTemplateById(templateId).getDisplayName();
        return reportTemplateName;
    }

    Graph.QueryScalarsTcfs getQueryScalarsFields(ReportTemplate reportTemplate, ReportTemplateRequestDTO dto) {
        Graph templateGraph = reportTemplate.getGraph();
        List<Integer> templateCategoryFieldIdList = dto.getSelectedTemplateCategoryFieldIds();
        List<TemplateCategoryField> tcfList = this.reportTemplateDAO.findTcfsById(templateCategoryFieldIdList);
        Map<Integer, String> tcfIdToStringSortList = dto.getTcfIdToStringSortList();
        List<Integer> tcfIdsForSortPriority = dto.getSortSelectedIds();
        Map<Integer, String> tcfIdToStringFilterList = dto.getTcfIdToStringFilterList();
        List<Integer> tcfIdsForFilters = dto.getFilterSelectedIds();
        List<TemplateCategoryField> tcfsWithFilters = this.reportTemplateDAO.findTcfsById(tcfIdsForFilters);
        List<TemplateCategoryField> tcfsWithSorts = this.reportTemplateDAO.findTcfsById(tcfIdsForSortPriority);
        return templateGraph.createQueryScalarsTcfs(tcfList, tcfIdToStringSortList, tcfIdToStringFilterList, tcfsWithFilters, tcfsWithSorts, tcfIdsForSortPriority);
    }

    public ReportTemplateResultDTO runReportTemplateOneSegment(User user, String host, Integer templateId, ReportTemplateRequestDTO reportTemplateRequestDTO, Integer offset, Integer limit, Graph.QueryScalarsTcfs cachedQsTcfs) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.findTemplateById(templateId);
        Graph.QueryScalarsTcfs queryScalarsTcfs = cachedQsTcfs == null ? this.getQueryScalarsFields(reportTemplate, reportTemplateRequestDTO) : cachedQsTcfs;
        Date from = reportTemplateRequestDTO.getStartDate();
        Date to = reportTemplateRequestDTO.getEndDate();
        ReportTemplateResultDTO result = this.reportTemplateDAO.runQueryAndScalars(reportTemplate.getDisplayName(), queryScalarsTcfs, from, to, offset, limit);
        if (cachedQsTcfs == null) {
            result.setCachedQsTcfs(queryScalarsTcfs);
        }
        return result;
    }

    public void runReportTemplate(User user, String host, Integer templateId, ReportTemplateRequestDTO reportTemplateRequestDTO, OutputStream output, Graph.QueryScalarsTcfs queryScalarsTcfsParam) {
        LOGGER.info((Object)"\n--> Begin csv download");
        Graph.QueryScalarsTcfs cachedQsTcfs = queryScalarsTcfsParam;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));){
            int i = 0;
            while (true) {
                int currentLimit;
                int currentOffset;
                if (i == 0) {
                    currentOffset = 0;
                    currentLimit = 5;
                } else {
                    currentOffset = i * RESULT_LIMIT + 5 - RESULT_LIMIT;
                    currentLimit = RESULT_LIMIT;
                }
                if (cachedQsTcfs != null) {
                    reportTemplateRequestDTO.setCachedQuery(cachedQsTcfs);
                }
                ReportTemplateResultDTO resultsDTO = this.runReportTemplateOneSegment(user, host, templateId, reportTemplateRequestDTO, currentOffset, currentLimit, cachedQsTcfs);
                String resultString = resultsDTO.toCsvString();
                writer.write(resultString);
                if (i == 0) {
                    ((Writer)writer).flush();
                    cachedQsTcfs = resultsDTO.getCachedQsTcfs();
                }
                if (resultsDTO.getResultSize() < currentLimit) break;
                ++i;
            }
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            SchedulerRuntimeException.logAndThrow("Problem running report '" + reportTemplateRequestDTO.toString() + "'");
        }
        LOGGER.info((Object)"\n--> End csv download");
    }

    public List<ReportTemplateMetadataDTO> getReportTemplateList(User user) {
        return this.reportTemplateDAO.findTemplateListByTypeAndUser(user);
    }

    public List<ReportTemplateMetadataDTO> sortSavedReportTemplateList(User user, Integer id) {
        return this.reportTemplateDAO.findUsersReportListByTypeAndUser(user, id);
    }

    CategoryDTO createCategoryDTO(ReportTemplate reportTemplate, Category category, boolean expanded, ReportOrigin reportOrigin, Set<TemplateCategoryField> userSelectedTcfs) {
        List<TemplateCategoryField> templateCategoryFieldList = this.reportTemplateDAO.findTcfsByCategoryAndTemplate(category, reportTemplate);
        List<TemplateCategoryFieldDTO> tcfDTOList = this.createTcfDtoList(templateCategoryFieldList, reportOrigin.createSelectionMap(templateCategoryFieldList, userSelectedTcfs));
        List<SubCategory> subCategories = this.reportTemplateDAO.findSubCategoriesByCategoryAndTemplate(category, reportTemplate);
        ArrayList childrenCategoryDTOs = Lists.newArrayList();
        for (SubCategory subCategory : subCategories) {
            CategoryDTO childCategoryDTO = this.createCategoryDTO(subCategory.getReportTemplate(), subCategory.getChild(), subCategory.getExpanded(), reportOrigin, userSelectedTcfs);
            childrenCategoryDTOs.add(childCategoryDTO);
        }
        return new CategoryDTO(category.getId(), category.getDisplayName(), tcfDTOList, childrenCategoryDTOs, expanded);
    }

    public ReportTemplateDTO getReportTemplate(Integer id) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.findTemplateById(id);
        List<CategoryDTO> categoryDTOList = this.createCategoryDtoList(reportTemplate, ReportOrigin.System, Sets.newHashSet());
        return new ReportTemplateDTO(reportTemplate.getId(), reportTemplate.getType().toString(), reportTemplate.getDisplayName(), categoryDTOList, reportTemplate.getDateBound());
    }

    List<CategoryDTO> createCategoryDtoList(ReportTemplate reportTemplate, ReportOrigin reportOrigin, Set<TemplateCategoryField> tcfUserSelections) {
        List<TemplateCategory> templateCategories = this.reportTemplateDAO.findCategoriesByTemplate(reportTemplate);
        ArrayList categoryDTOList = Lists.newArrayList();
        for (TemplateCategory templateCategory : templateCategories) {
            CategoryDTO categoryDTO = this.createCategoryDTO(templateCategory.getReportTemplate(), templateCategory.getCategory(), templateCategory.getExpanded(), reportOrigin, tcfUserSelections);
            categoryDTOList.add(categoryDTO);
        }
        return categoryDTOList;
    }

    public ReportTemplateUsersDTO getUsersReport(Integer id) {
        TemplateUser templateUser = this.reportTemplateDAO.findTemplateUserById(id);
        ReportTemplate reportTemplate = templateUser.getReportTemplate();
        Set<TemplateCategoryField> selectedTcfs = templateUser.getSelectedTcfs();
        Set<TemplateUserSelection> userSelectionList = templateUser.getUserSelections();
        ArrayList sortList = Lists.newArrayList();
        ArrayList sortDirectionList = Lists.newArrayList();
        TreeMap tussToTcfId = Maps.newTreeMap();
        TreeMap tussToOrderBy = Maps.newTreeMap();
        TreeMap tufsToTcfId = Maps.newTreeMap();
        TreeMap tufsToFilterExpression = Maps.newTreeMap();
        ArrayList filterList = Lists.newArrayList();
        ArrayList filterExpressionList = Lists.newArrayList();
        for (TemplateUserSelection tus : userSelectionList) {
            TemplateUserFilterSelection tufs;
            TemplateUserSortSelection tuss = tus.getUserSortSelection();
            if (tuss != null) {
                Integer tcfId = tuss.getTemplateUserSelection().getTcf().getId();
                tussToTcfId.put(tuss.getId(), tcfId);
                tussToOrderBy.put(tuss.getId(), tuss.getOrderBy());
            }
            if ((tufs = tus.getUserFilterSelection()) == null) continue;
            Integer tcfId = tufs.getTemplateUserSelection().getTcf().getId();
            tufsToTcfId.put(tufs.getId(), tcfId);
            tufsToFilterExpression.put(tufs.getId(), tufs.getExpression());
        }
        for (Integer tussId : tussToTcfId.keySet()) {
            sortList.add(tussToTcfId.get(tussId));
            sortDirectionList.add(tussToOrderBy.get(tussId));
        }
        for (Integer tufsId : tufsToTcfId.keySet()) {
            filterList.add(tufsToTcfId.get(tufsId));
            filterExpressionList.add(tufsToFilterExpression.get(tufsId));
        }
        List<CategoryDTO> categoryDTOList = this.createCategoryDtoList(reportTemplate, ReportOrigin.User, selectedTcfs);
        return new ReportTemplateUsersDTO(reportTemplate.getId(), reportTemplate.getType().toString(), reportTemplate.getDisplayName(), categoryDTOList, reportTemplate.getDateBound(), templateUser.getLastUpdateTime(), templateUser.getName(), sortList, sortDirectionList, filterList, filterExpressionList);
    }

    List<TemplateCategoryFieldDTO> createTcfDtoList(List<TemplateCategoryField> tcfList, Map<TemplateCategoryField, Boolean> selectionMap) {
        ArrayList tcfDTOList = Lists.newArrayList();
        for (TemplateCategoryField tcf : tcfList) {
            Field field = tcf.getField();
            Boolean selected = selectionMap.get(tcf) != null;
            Boolean filterable = field.getFieldType() != null;
            Field.FieldType fieldType = field.getFieldType();
            String type = fieldType != null ? fieldType.toString() : null;
            TemplateCategoryFieldDTO tcfDTO = new TemplateCategoryFieldDTO(tcf.getId(), tcf.getCategory().getDisplayName(), field.getDisplayName(), selected, field.isSortable(), filterable, type);
            tcfDTOList.add(tcfDTO);
        }
        Collections.sort(tcfDTOList, new TemplateCategoryFieldDTO.TemplateCategoryFieldsComparatorAsc());
        return tcfDTOList;
    }

    public ReportTemplateMetadataDTO createUserReport(User user, ReportTemplateCreateUsersDTO reportTemplateCreateUsersDTO, Integer id) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.findTemplateById(id);
        ReportTemplateMetadataDTO reportTemplateMetadataDTO = null;
        String name = reportTemplateCreateUsersDTO.getReportName();
        boolean exists = this.checkSavedReportNameExists(name, null, true, user);
        if (!exists) {
            TemplateUser templateUser = new TemplateUser(reportTemplate, user, name);
            this.reportTemplateDAO.createEntity(templateUser);
            this.createTcfsForSavedReport(reportTemplateCreateUsersDTO, templateUser);
            reportTemplateMetadataDTO = new ReportTemplateMetadataDTO(templateUser.getId(), templateUser.getReportTemplate().getId(), templateUser.getName(), "Administrative", templateUser.getReportTemplate().getDisplayName(), templateUser.getLastUpdateTime());
        }
        return reportTemplateMetadataDTO;
    }

    private boolean checkSavedReportNameExists(String name, Integer id, boolean isNewReport, User user) {
        return this.reportTemplateDAO.checkSavedReportName(name, id, isNewReport, user.getId());
    }

    public ReportTemplateMetadataDTO updateUserReport(User user, ReportTemplateCreateUsersDTO reportTemplateCreateUsersDTO, Integer id) {
        TemplateUser templateUser = this.reportTemplateDAO.findTemplateUserById(id);
        ReportTemplateMetadataDTO reportTemplateMetadataDTO = null;
        String name = reportTemplateCreateUsersDTO.getReportName();
        boolean exists = this.checkSavedReportNameExists(name, templateUser.getId(), false, user);
        if (!exists) {
            templateUser.setLastUpdateTime(Calendar.getInstance().getTime());
            templateUser.setName(name);
            templateUser.setUser(user);
            this.reportTemplateDAO.updateEntity(templateUser);
            List<TemplateUserSelection> templateUserSelectionList = this.reportTemplateDAO.findTemplateUserSelectionsById(templateUser.getId());
            this.deleteUserSortSelections(templateUserSelectionList);
            this.deleteUserFilterSelections(templateUserSelectionList);
            templateUserSelectionList.forEach(this.reportTemplateDAO::deleteEntity);
            this.createTcfsForSavedReport(reportTemplateCreateUsersDTO, templateUser);
            reportTemplateMetadataDTO = new ReportTemplateMetadataDTO(templateUser.getId(), templateUser.getReportTemplate().getId(), templateUser.getName(), "Administrative", templateUser.getReportTemplate().getDisplayName(), templateUser.getLastUpdateTime());
        }
        return reportTemplateMetadataDTO;
    }

    void deleteUserSortSelections(List<TemplateUserSelection> templateUserSelectionList) {
        List<Integer> selectionIds = templateUserSelectionList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<TemplateUserSortSelection> templateUserSortSelectionList = this.reportTemplateDAO.findTemplateUserSortSelectionsByTemplateUserSelection(selectionIds);
        templateUserSortSelectionList.forEach(this.reportTemplateDAO::deleteEntity);
    }

    void deleteUserFilterSelections(List<TemplateUserSelection> templateUserSelectionList) {
        List<Integer> selectionIds = templateUserSelectionList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<TemplateUserFilterSelection> templateUserFilterSelectionList = this.reportTemplateDAO.findTemplateUserFilterSelectionsByTemplateUserSelection(selectionIds);
        templateUserFilterSelectionList.forEach(this.reportTemplateDAO::deleteEntity);
    }

    private void createTcfsForSavedReport(ReportTemplateCreateUsersDTO dto, TemplateUser templateUser) {
        HashSet selectedTcfsSet = Sets.newHashSet(this.reportTemplateDAO.findTcfsById(dto.getSelectedTemplateCategoryFieldIds()));
        Map<Integer, String> tcfIdToStringSortList = dto.getTcfIdToStringSortList();
        List<Integer> idsOfTcfsWithSorts = dto.getSortSelectedIds();
        Map<Integer, String> tcfIdToStringFilterList = dto.getTcfIdToStringFilterList();
        List<Integer> idsOfTcfsWithFilters = dto.getFilterSelectedIds();
        List<TemplateCategoryField> tcfsWithFilters = this.reportTemplateDAO.findTcfsById(idsOfTcfsWithFilters);
        List<TemplateCategoryField> tcfsWithSorts = this.reportTemplateDAO.findTcfsById(idsOfTcfsWithSorts);
        HashMap tcfToNewFilterSelection = Maps.newHashMap();
        HashMap tcfToNewSortSelection = Maps.newHashMap();
        for (TemplateCategoryField selectedTcf : selectedTcfsSet) {
            TemplateUserSelection templateUserSelection = new TemplateUserSelection(templateUser, selectedTcf);
            this.reportTemplateDAO.createEntity(templateUserSelection);
            if (tcfsWithSorts.contains(selectedTcf)) {
                String orderBy = tcfIdToStringSortList.get(selectedTcf.getId());
                TemplateUserSortSelection sortSelection = new TemplateUserSortSelection(templateUserSelection, orderBy);
                tcfToNewSortSelection.put(selectedTcf.getId(), sortSelection);
            }
            if (!tcfsWithFilters.contains(selectedTcf)) continue;
            String expression = tcfIdToStringFilterList.get(selectedTcf.getId());
            Field tcfField = selectedTcf.getField();
            Field.FieldType fieldType = tcfField.getFieldType();
            if (fieldType == null) {
                SchedulerRuntimeException.logAndThrow("Hey, field " + tcfField.getDisplayName() + " doesn't have a filter!");
            }
            TemplateUserFilterSelection filterSelection = new TemplateUserFilterSelection(templateUserSelection, expression);
            tcfToNewFilterSelection.put(selectedTcf.getId(), filterSelection);
        }
        for (Integer tcfId : idsOfTcfsWithFilters) {
            TemplateUserFilterSelection templateUserFilterSelection = (TemplateUserFilterSelection)tcfToNewFilterSelection.get(tcfId);
            this.reportTemplateDAO.createEntity(templateUserFilterSelection);
        }
        for (Integer tcfId : idsOfTcfsWithSorts) {
            TemplateUserSortSelection templateUserSortSelection = (TemplateUserSortSelection)tcfToNewSortSelection.get(tcfId);
            this.reportTemplateDAO.createEntity(templateUserSortSelection);
        }
    }

    public BooleanResultDTO deleteUsersReport(Integer id) {
        TemplateUser templateUser = this.reportTemplateDAO.findTemplateUserById(id);
        List<TemplateUserSelection> templateUserSelectionList = this.reportTemplateDAO.findTemplateUserSelectionsById(templateUser.getId());
        this.deleteUserSortSelections(templateUserSelectionList);
        this.deleteUserFilterSelections(templateUserSelectionList);
        templateUserSelectionList.forEach(this.reportTemplateDAO::deleteEntity);
        this.reportTemplateDAO.deleteEntity(templateUser);
        return new BooleanResultDTO(true);
    }

    public List<Object> getStaticListByTcf(Integer tcfId, String columnName) {
        TemplateCategoryField tcf = this.reportTemplateDAO.findById(TemplateCategoryField.class, tcfId);
        return this.reportTemplateDAO.findListByClass(tcf.getField().getFieldProcessingEnum().getStaticClassName(), columnName);
    }

    public List<Field.HasReportFiltersNameAndIdPair> getEnumListByTcf(Integer tcfId) {
        TemplateCategoryField tcf = this.reportTemplateDAO.findById(TemplateCategoryField.class, tcfId);
        Field enumTypeField = tcf.getField();
        List<HasReportFiltersNameAndId> enumList = Field.FieldType.getFieldTypeEnums(enumTypeField);
        enumList.sort((p1, p2) -> p1.getReportFiltersName().compareToIgnoreCase(p2.getReportFiltersName()));
        return enumList.stream().map(Field.HasReportFiltersNameAndIdPair::new).collect(Collectors.toList());
    }

    public List<Object> getListsByField(Integer tcfId, String filterBy, String selectedTerms) {
        TemplateCategoryField tcf = this.reportTemplateDAO.findById(TemplateCategoryField.class, tcfId);
        String tableName = tcf.getField().getTable();
        String columnName = tcf.getField().getColumn();
        if (!selectedTerms.isEmpty()) {
            selectedTerms = Field.FieldType.quotifyCommaString(selectedTerms, "'", "'", ",");
        }
        return this.reportTemplateDAO.findListByColumn(tableName, columnName, filterBy, selectedTerms);
    }

    static enum ReportOrigin {
        System{

            @Override
            Map<TemplateCategoryField, Boolean> createSelectionMap(Collection<TemplateCategoryField> tcfFullCollection, Collection<TemplateCategoryField> tcfSelectionCollection) {
                return this.createSelectionMapHelper(tcfFullCollection, false);
            }
        }
        ,
        User{

            @Override
            Map<TemplateCategoryField, Boolean> createSelectionMap(Collection<TemplateCategoryField> tcfFullCollection, Collection<TemplateCategoryField> tcfSelectionCollection) {
                return this.createSelectionMapHelper(tcfSelectionCollection, true);
            }
        };


        abstract Map<TemplateCategoryField, Boolean> createSelectionMap(Collection<TemplateCategoryField> var1, Collection<TemplateCategoryField> var2);

        Map<TemplateCategoryField, Boolean> createSelectionMapHelper(Collection<TemplateCategoryField> tcfCollection, boolean ignoreItsOwn) {
            HashMap<TemplateCategoryField, Boolean> map = new HashMap<TemplateCategoryField, Boolean>();
            for (TemplateCategoryField tcf : tcfCollection) {
                if (!ignoreItsOwn && !tcf.isSelected()) continue;
                map.put(tcf, Boolean.TRUE);
            }
            return map;
        }
    }
}

