/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.User;

public class UserDetailResponse {
    private Integer id;
    private String lastName;
    private String firstName;
    private String ecommonsId;
    private String middleName;
    private String primaryPhone;
    private String secondaryPhone;
    private String email;
    private String notificationEmail;
    private String fax;
    private String pager;
    private String division;
    private Integer divisionId;
    private String department;
    private Integer departmentId;
    private String institution;
    private Integer institutionId;
    private String institutionRole;
    private Integer institutionRoleId;
    private InstitutionRoleType institutionRoleType;
    private String role;
    private Integer roleId;
    private String credential;
    private Integer credentialId;
    private String facultyRank;
    private Integer facultyRankId;

    public UserDetailResponse(User user) {
        if (user == null) {
            SchedulerRuntimeException.logAndThrow("user parameter should be non-null");
        }
        this.id = user.getId();
        this.lastName = user.getLastName();
        this.firstName = user.getFirstName();
        this.ecommonsId = user.getEcommonsId();
        this.middleName = user.getMiddleName();
        this.primaryPhone = user.getPrimaryPhone();
        this.secondaryPhone = user.getSecondaryPhone();
        this.email = user.getEmail();
        this.notificationEmail = user.getNotificationEmail();
        this.fax = user.getFax();
        this.pager = user.getPager();
        if (user.getDivision() != null) {
            this.division = user.getDivision().getName();
            this.divisionId = user.getDivision().getId();
        }
        if (user.getDepartment() != null) {
            this.department = user.getDepartment().getName();
            this.departmentId = user.getDepartment().getId();
        }
        if (user.getInstitution() != null) {
            this.institution = user.getInstitution().getName();
            this.institutionId = user.getInstitution().getId();
        }
        if (user.getInstitutionRole() != null) {
            this.institutionRole = user.getInstitutionRole().getName();
            this.institutionRoleId = user.getInstitutionRole().getId();
            this.institutionRoleType = user.getInstitutionRole().getType();
        }
        if (user.getRole() != null) {
            this.role = user.getRole().getName();
            this.roleId = user.getRole().getId();
        }
        if (user.getCredential() != null) {
            this.credential = user.getCredential().getName();
            this.credentialId = user.getCredential().getId();
        }
        if (user.getFacultyRank() != null) {
            this.facultyRank = user.getFacultyRank().getName();
            this.facultyRankId = user.getFacultyRank().getId();
        }
    }
}

