/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.SubjectsDTO;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ServiceHelpers;
import edu.harvard.catalyst.scheduler.service.StudyService;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SubjectServiceClassic
implements ServiceHelpers {
    private static final Logger LOGGER = Logger.getLogger(SubjectServiceClassic.class);
    static final Function<String, String> CRYPT = SubjectDataEncryptor::encrypt;
    private static final Function<String, String> TO_UPPER = String::toUpperCase;
    static final Function<String, String> CRYPT_UPPER = TO_UPPER.andThen(CRYPT);
    private final SubjectDAO subjectDAO;
    private final StudyDAO studyDAO;
    private final AuditService auditService;
    private final StudyService studyService;
    private final AppointmentDAO appointmentDAO;

    @Autowired
    public SubjectServiceClassic(AuditService auditService, SubjectDAO subjectDAO, StudyDAO studyDAO, StudyService studyService, AppointmentDAO appointmentDAO, @Qualifier(value="encryptionKey") Key encryptionKey) {
        this.auditService = auditService;
        this.studyService = studyService;
        this.subjectDAO = subjectDAO;
        this.studyDAO = studyDAO;
        this.appointmentDAO = appointmentDAO;
        SubjectDataEncryptor.setEncryptionKey(encryptionKey);
    }

    SubjectServiceClassic() {
        this(null, null, null, null, null, null);
    }

    public void createSubjectForDto(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = this.createSubject(subjectDTO, user, ipAddress);
        if (subject == null) {
            return;
        }
        subjectDTO.setResult(true);
        subjectDTO.setId(subject.getId());
    }

    public Subject createSubject(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = new Subject();
        if (this.mrnBelongsToAnotherSubject(subjectDTO)) {
            LOGGER.info((Object)"MRN already exists -- cancelling creation of subject");
            subjectDTO.setResult(false);
            subjectDTO.setMrnAlreadyExistsError(true);
            return null;
        }
        subject.setActive(Boolean.TRUE);
        subject.setCreatedDate(new Date());
        this.setSomeEntityValuesViaDto(subject, subjectDTO);
        this.subjectDAO.createSubject(subject);
        MrnInfoDTO mrnInfoDTO = subjectDTO.getMrnInfo();
        SubjectMrn newSubjectMrn = new SubjectMrn(subject, mrnInfoDTO.getValue(), mrnInfoDTO.getInstitution(), mrnInfoDTO.getStatus(), null);
        subject.getSubjectMrnSet().add(newSubjectMrn);
        this.subjectDAO.saveSubjectMrn(newSubjectMrn);
        this.auditService.logSubjectActivity(ipAddress, subject, user, "CREATE SUBJECT", null, null);
        if (subjectDTO.getStudyId() > 0) {
            Study study = this.studyDAO.findStudyById(subjectDTO.getStudyId());
            this.addSubjectToStudy(user, ipAddress, newSubjectMrn, study);
        }
        return subject;
    }

    public SubjectsDTO updateSubject(SubjectsDTO subjectDTO, User user, String ipAddress, boolean allowOnlyOneMrn) {
        MrnInfoDTO mrnInfoDTO;
        Subject subject = this.subjectDAO.findBySubjectId(subjectDTO.getId());
        SubjectMrn newSubjectMrn = new SubjectMrn(subject, (mrnInfoDTO = subjectDTO.getMrnInfo()).getValue(), mrnInfoDTO.getInstitution(), mrnInfoDTO.getStatus(), null);
        SubjectMrn subjectMrn = this.subjectDAO.getSubjectMrn(newSubjectMrn);
        if (subjectMrn == null) {
            if (this.mrnBelongsToAnotherSubject(subjectDTO)) {
                LOGGER.info((Object)"MRN already exists -- cancelling update of subject");
                subjectDTO.setMrnAlreadyExistsError(true);
                subjectDTO.setResult(false);
                return subjectDTO;
            }
            try {
                subjectMrn = this.createSubjectMrnIfNeeded(allowOnlyOneMrn, subject, newSubjectMrn);
            }
            catch (NoMrnFoundException e) {
                subjectDTO.setErrorMsg(e.getMessage());
                subjectDTO.setResult(false);
                return subjectDTO;
            }
        }
        if (subjectDTO.getStudyId() > 0) {
            Study study = this.studyDAO.findStudyById(subjectDTO.getStudyId());
            if (this.isSubjectAlreadyInThisStudy(user, subject, study)) {
                subjectDTO.setErrorMsg("This subject is already enrolled in this study.");
                subjectDTO.setResult(false);
                return subjectDTO;
            }
            this.addSubjectToStudy(user, ipAddress, subjectMrn, study);
        }
        this.updateSubjectFieldsIfNeeded(subjectDTO, user, ipAddress, subject);
        subjectDTO.setResult(true);
        return subjectDTO;
    }

    boolean isSubjectAlreadyInThisStudy(User user, Subject subject, Study study) {
        List<StudySubject> studySubjectList = this.getStudySubjects(user, subject, study);
        if (ListUtils.nullOrEmpty(studySubjectList)) {
            return false;
        }
        return ListUtils.enrich(studySubjectList).exists(s -> s.getStudy().getId().equals(study.getId()));
    }

    private void updateSubjectFieldsIfNeeded(SubjectsDTO subjectDTO, User user, String ipAddress, Subject subject) {
        List<Optional<String>> previousDataComponents = this.gatherPreviousData(subjectDTO, subject);
        List<Optional<String>> otherPreviousDataComponents = this.gatherOtherPreviousData(subjectDTO, subject);
        Joiner joiner = Joiner.on((String)"");
        String previousData = joiner.join((Iterable)ListUtils.flatten(previousDataComponents));
        String otherPreviousData = joiner.join((Iterable)ListUtils.flatten(otherPreviousDataComponents));
        subject.setId(subjectDTO.getId());
        this.setSomeEntityValuesViaDto(subject, subjectDTO);
        this.subjectDAO.encryptAndSave(subject);
        this.auditService.logSubjectActivity(ipAddress, subject, user, "UPDATE SUBJECT", previousData, otherPreviousData);
    }

    private List<Optional<String>> gatherOtherPreviousData(SubjectsDTO subjectDTO, Subject subject) {
        return Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("State", subjectDTO.getState(), subject.getState()), this.makeFieldString("Middle Name", subjectDTO.getMiddleName(), subject.getMiddleName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Secondary Phone", subjectDTO.getSecondaryContactNumber(), subject.getSecondaryContactNumber(), CRYPT, CRYPT_UPPER)});
    }

    private List<Optional<String>> gatherPreviousData(SubjectsDTO subjectDTO, Subject subject) {
        String ethnicity = this.lookupFieldById(subjectDTO.getEthnicity(), this.subjectDAO::findByEthnicityId);
        String gender = this.lookupFieldById(subjectDTO.getGender(), this.subjectDAO::findByGenderId);
        String race = this.lookupFieldById(subjectDTO.getRace(), this.subjectDAO::findByRaceId);
        String country = this.lookupFieldById(subjectDTO.getCountry(), this.subjectDAO::findCountryById);
        return Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("Birth Date", subjectDTO.getBirthdate(), subject.getBirthdate()), this.makeFieldString("City", subjectDTO.getCity(), subject.getCity(), CRYPT_UPPER, CRYPT_UPPER), this.makeFieldString("Ethnicity", ethnicity.toUpperCase(), subject.getEthnicity(), subjectDTO.getEthnicity(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Gender", gender, subject.getGender(), subjectDTO.getGender(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("First Name", subjectDTO.getFirstName(), subject.getFirstName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Last Name", subjectDTO.getLastName(), subject.getLastName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Primary Phone", subjectDTO.getPrimaryContactNumber(), subject.getPrimaryContactNumber(), CRYPT, CRYPT_UPPER), this.makeFieldString("Race", race, subject.getRace(), subjectDTO.getRace(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Street Address 1", subjectDTO.getStreetAddress1(), subject.getStreetAddress1(), CRYPT, CRYPT_UPPER), this.makeFieldString("Street Address 2", subjectDTO.getStreetAddress2(), subject.getStreetAddress2(), CRYPT, CRYPT_UPPER), this.makeFieldString("Zip", subjectDTO.getZip(), subject.getZip(), CRYPT, CRYPT_UPPER), this.makeFieldString("Country", country, subject.getCountry(), subjectDTO.getCountry(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Active", subjectDTO.getActive(), subject.getActive()), this.makeFieldString("Puid", subjectDTO.getPartnersUid(), subject.getPuid(), CRYPT, CRYPT_UPPER)});
    }

    boolean mrnBelongsToAnotherSubject(SubjectsDTO subjectDTO) {
        return subjectDTO.getMrnInfo() != null && this.subjectDAO.mrnInfoExists(subjectDTO.getMrnInfo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SubjectMrn createSubjectMrnIfNeeded(boolean allowOnlyOneMrn, Subject subject, SubjectMrn newSubjectMrn) throws NoMrnFoundException {
        SubjectMrn subjectMrnResult = null;
        if (allowOnlyOneMrn) {
            Optional result = subject.getSubjectMrnSet().stream().findFirst();
            if (!result.isPresent()) throw new NoMrnFoundException("Updating Subject Failed, the Subject's previous MRN was not found");
            subjectMrnResult = (SubjectMrn)result.get();
            subjectMrnResult = this.subjectDAO.getSubjectMrn(subjectMrnResult);
            subjectMrnResult.setMrn(newSubjectMrn.getMrn());
        } else {
            subjectMrnResult = newSubjectMrn;
        }
        this.subjectDAO.saveSubjectMrn(subjectMrnResult);
        return subjectMrnResult;
    }

    private void addSubjectToStudy(User user, String ipAddress, SubjectMrn subjectMrn, Study study) {
        StudySubject studySubject = new StudySubject(study, subjectMrn, Boolean.TRUE);
        try {
            this.studyDAO.createEntity(studySubject);
        }
        catch (ConstraintViolationException ex) {
            this.logDontThrow("updateSubject() constraint violation", (Exception)((Object)ex));
        }
        this.studyService.stampStudyAndLogStudySubjectMrnActivity(ipAddress, study, subjectMrn, user, "ADD STUDY SUBJECT", null, null);
    }

    void logDontThrow(String message, Exception cause) {
        SchedulerRuntimeException.logDontThrow(message, cause);
    }

    private List<StudySubject> getStudySubjects(User user, Subject subject, Study study) {
        if (user.isStudyStaff()) {
            return this.appointmentDAO.findStudySubjectBySubject(subject);
        }
        return this.appointmentDAO.findStudySubjectBySubjectAndStudy(subject, study);
    }

    void setSomeEntityValuesViaDto(Subject subject, SubjectsDTO subjectDTO) {
        subject.setBirthdate(subjectDTO.getBirthdate());
        subject.setCity(subjectDTO.getCity());
        subject.setEthnicity(this.subjectDAO.findByEthnicityId(subjectDTO.getEthnicity()));
        subject.setFirstName(subjectDTO.getFirstName());
        subject.setLastName(subjectDTO.getLastName());
        Gender genderEntity = this.subjectDAO.findByGenderId(subjectDTO.getGender());
        subject.setGender(genderEntity);
        subject.setGenderEmpi(subjectDTO.getGenderEmpi());
        String genderCode = genderEntity.getCode();
        if (genderCode == null) {
            SchedulerRuntimeException.logAndThrow("Cannot set subject.genderType because of null gender code on gender entity");
        } else {
            subject.setGenderType(GenderType.valueOf(genderCode));
        }
        subject.setDerivedFullName();
        subject.setMiddleName(subjectDTO.getMiddleName());
        subject.setPrimaryContactNumber(subjectDTO.getPrimaryContactNumber());
        subject.setRace(this.subjectDAO.findByRaceId(subjectDTO.getRace()));
        subject.setSecure(Boolean.FALSE);
        subject.setSecondaryContactNumber(subjectDTO.getSecondaryContactNumber());
        subject.setStreetAddress1(subjectDTO.getStreetAddress1());
        subject.setStreetAddress2(subjectDTO.getStreetAddress2());
        subject.setState(subjectDTO.getState() != 0 ? this.subjectDAO.findByStateId(subjectDTO.getState()) : null);
        subject.setCountry(this.subjectDAO.findCountryById(subjectDTO.getCountry()));
        subject.setZip(subjectDTO.getZip());
        subject.setComment(subjectDTO.getComment());
        subject.setActive(subjectDTO.getActive());
        subject.setComment(subjectDTO.getComment());
        subject.setPuid(subjectDTO.getPartnersUid());
    }

    class NoMrnFoundException
    extends Exception {
        NoMrnFoundException(String message) {
            super(message);
        }
    }
}

