/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.fakeSubjects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.util.ClassPathUtil;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.PrintStream;
import java.security.Key;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class FakeSubjects {
    private static Map<Integer, String> stateIdToCityMap;
    private static List<Integer> ethnicityIds;
    private static List<Integer> raceIds;
    private static List<Integer> genderIds;
    private static final int inverseFrequencyOfMrnMutations = 20;
    private static String fakeSite;
    private static final Logger log;
    private final DataSource dataSource;

    private static Map<Integer, String> generateStateIdToCityMap() {
        HashMap mapToPopulate = Maps.newHashMap();
        mapToPopulate.put(1, "Boston");
        mapToPopulate.put(43, "Austin");
        mapToPopulate.put(32, "New York City");
        mapToPopulate.put(14, "Chicago");
        mapToPopulate.put(6, "Los Angeles");
        mapToPopulate.put(43, "Houston");
        mapToPopulate.put(47, "Seattle");
        mapToPopulate.put(11, "Atlanta");
        return mapToPopulate;
    }

    @Autowired
    public FakeSubjects(DataSource dataSource, @Qualifier(value="encryptionKeyFake") Key key) {
        ClassPathUtil.printClassPath((PrintStream)System.out);
        this.dataSource = dataSource;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    public static void main(String[] args) throws SQLException {
        Integer numSubjects = new Integer(args[0]);
        if (args.length > 1) {
            fakeSite = args[1];
        }
        boolean resetId = true;
        if (args.length > 2 && args[2].equals("--noResetId")) {
            resetId = false;
        }
        log.info((Object)("reset autoincrement id column: " + resetId));
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-populate-fake-subjects.xml");
        FakeSubjects fakeSubjects = (FakeSubjects)context.getBean("fakeSubjects");
        fakeSubjects.runSubjects(numSubjects, resetId);
        fakeSubjects.runSubjectMrns(numSubjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSubjectMrns(int numSubjects) throws SQLException {
        int numFaked = 0;
        int numPrevious = 0;
        try (Connection connection = this.dataSource.getConnection();){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select count(*) from subject_mrn");
            resultSet.first();
            numPrevious = resultSet.getInt(1);
            if (numPrevious == 0) {
                statement.executeUpdate("ALTER TABLE `subject_mrn` AUTO_INCREMENT = 1;");
                String createSubjectMrnString = "insert into subject_mrn ( subject, mrn, site, status )  values ( ?,?,?,?)";
                PreparedStatement createSubjectMrnStatement = connection.prepareStatement(createSubjectMrnString);
                for (int i = 1; i <= numSubjects; ++i) {
                    int paramIndex = 0;
                    String encryptedMrn = SubjectDataEncryptor.encrypt((String)Integer.toString(888000 + i));
                    createSubjectMrnStatement.setInt(++paramIndex, i);
                    createSubjectMrnStatement.setString(++paramIndex, encryptedMrn);
                    createSubjectMrnStatement.setString(++paramIndex, fakeSite);
                    createSubjectMrnStatement.setString(++paramIndex, null);
                    createSubjectMrnStatement.executeUpdate();
                    ++numFaked;
                }
            } else {
                String updateSubjectMrnString = "update subject_mrn set mrn=?, site=? where id=?";
                PreparedStatement updateSubjectMrnStatement = connection.prepareStatement(updateSubjectMrnString);
                statement.executeQuery("set FOREIGN_KEY_CHECKS=0");
                resultSet = statement.executeQuery("select id from subject_mrn");
                while (resultSet != null && resultSet.next()) {
                    int id = resultSet.getInt(1);
                    this.updateSubjectMrnQuery(updateSubjectMrnStatement, id, numSubjects);
                    ++numFaked;
                }
                statement.executeQuery("set FOREIGN_KEY_CHECKS=1");
            }
        }
        finally {
            String message = "Succeeded to update/insert " + numFaked + " SubjectMrns, based on " + numPrevious + " previous records and " + numSubjects + " subjects";
            System.out.println(message);
            log.info((Object)message);
        }
    }

    void updateSubjectMrnQuery(PreparedStatement updateSubjectMrnStatement, int id, int numSubjects) throws SQLException {
        String encryptedMrn = SubjectDataEncryptor.encrypt((String)Integer.toString(888000 + id));
        int numIdOverSubject = id / numSubjects;
        String fakeSuffix = numIdOverSubject == 0 ? "" : Integer.toString(numIdOverSubject);
        String suffixedSite = fakeSite + fakeSuffix;
        updateSubjectMrnStatement.setString(1, encryptedMrn);
        updateSubjectMrnStatement.setString(2, suffixedSite);
        updateSubjectMrnStatement.setInt(3, id);
        updateSubjectMrnStatement.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSubjects(int numSubjects, boolean resetId) throws SQLException {
        int numFaked = 0;
        try (Connection connection = this.dataSource.getConnection();){
            if (resetId) {
                Statement statement = connection.createStatement();
                statement.executeUpdate("ALTER TABLE `subject` AUTO_INCREMENT = 1;");
            }
            String createSubjectString = "insert into subject ( first_name, middle_name, last_name, full_name, ethnicity, birthdate, race, gender, gender_empi, gender_enum, puid, latest_ssot_refresh, archival_status, street_address1, street_address2, city, state, zip, comment, country, primary_contact_number, secondary_contact_number, created_date, secure, active )  values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement createSubjectStatement = connection.prepareStatement(createSubjectString);
            for (int i = 1; i <= numSubjects; ++i) {
                this.insertSubjectQuery(createSubjectStatement, i);
                ++numFaked;
            }
        }
        finally {
            String message = "Succeeded to create " + numFaked + " fake Subjects, out of " + numSubjects + " desired";
            System.out.println(message);
            log.info((Object)message);
        }
    }

    private Date randomDateOfBirth() {
        Calendar gc = Calendar.getInstance();
        gc.add(1, -1);
        int year = this.randBetween(1900, gc.get(1));
        gc.set(1, year);
        int dayOfYear = this.randBetween(1, gc.getActualMaximum(6));
        gc.set(6, dayOfYear);
        return new Date(gc.getTimeInMillis());
    }

    private String randomMrn(Random random, int index) {
        boolean hasLeadingSpace = random.nextInt(20) == 0;
        boolean hasMiddleSpace = random.nextInt(20) == 0;
        boolean hasTrailingSpace = random.nextInt(20) == 0;
        boolean hasLeadingDash = random.nextInt(20) == 0;
        boolean hasMiddleDash = random.nextInt(20) == 0;
        boolean hasTrailingDash = random.nextInt(20) == 0;
        StringBuffer buffer = new StringBuffer();
        if (hasLeadingSpace) {
            buffer.append(" ");
        }
        if (hasLeadingDash) {
            buffer.append("-");
        }
        buffer.append(index);
        if (hasMiddleSpace) {
            buffer.append(" ");
        }
        if (hasMiddleDash) {
            buffer.append("-");
        }
        buffer.append(index);
        if (hasTrailingSpace) {
            buffer.append(" ");
        }
        if (hasTrailingDash) {
            buffer.append("-");
        }
        return buffer.toString();
    }

    public int randBetween(int start, int end) {
        return start + (int)Math.round(Math.random() * (double)(end - start));
    }

    void insertSubjectQuery(PreparedStatement createSubjectStatement, int index) throws SQLException {
        Random random = new Random();
        ArrayList keys = Lists.newArrayList(stateIdToCityMap.keySet());
        Integer stateId = (Integer)keys.get(random.nextInt(keys.size()));
        String cityName = stateIdToCityMap.get(stateId).toUpperCase();
        Date birthDate = this.randomDateOfBirth();
        Date ssot_refresh = new Date(DateUtility.toDate((LocalDateTime)LocalDateTime.now()).getTime());
        Timestamp createStamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Integer ethnicity = ethnicityIds.get(random.nextInt(ethnicityIds.size()));
        Integer race = raceIds.get(random.nextInt(raceIds.size()));
        Integer gender = genderIds.get(random.nextInt(genderIds.size()));
        Integer state = new Integer(stateId);
        Integer country = new Integer(1);
        String city = SubjectDataEncryptor.encrypt((String)cityName);
        String middleName = SubjectDataEncryptor.encrypt((String)"");
        String primaryContactNumber = SubjectDataEncryptor.encrypt((String)"(555) 111-1111");
        String secondaryContactNumber = SubjectDataEncryptor.encrypt((String)"(555) 111-1111");
        String streetAddress1 = SubjectDataEncryptor.encrypt((String)"123 Main St");
        String streetAddress2 = SubjectDataEncryptor.encrypt((String)"");
        String zip = SubjectDataEncryptor.encrypt((String)"01234");
        String first = "TEST";
        String last = "SUBJECT" + index;
        String full = first + " " + last;
        String firstName = SubjectDataEncryptor.encrypt((String)first);
        String lastName = SubjectDataEncryptor.encrypt((String)last);
        String fullName = SubjectDataEncryptor.encrypt((String)full);
        String puid = SubjectDataEncryptor.encrypt((String)Integer.toString(888000 + index));
        int index2 = 0;
        createSubjectStatement.setString(++index2, firstName);
        createSubjectStatement.setString(++index2, middleName);
        createSubjectStatement.setString(++index2, lastName);
        createSubjectStatement.setString(++index2, fullName);
        createSubjectStatement.setInt(++index2, ethnicity);
        createSubjectStatement.setDate(++index2, birthDate);
        createSubjectStatement.setInt(++index2, race);
        createSubjectStatement.setInt(++index2, gender);
        createSubjectStatement.setString(++index2, "U");
        createSubjectStatement.setString(++index2, GenderType.UNREPORTED.name());
        createSubjectStatement.setString(++index2, puid);
        createSubjectStatement.setDate(++index2, ssot_refresh);
        createSubjectStatement.setNull(++index2, 12);
        createSubjectStatement.setString(++index2, streetAddress1);
        createSubjectStatement.setString(++index2, streetAddress2);
        createSubjectStatement.setString(++index2, city);
        createSubjectStatement.setInt(++index2, state);
        createSubjectStatement.setString(++index2, zip);
        createSubjectStatement.setString(++index2, "");
        createSubjectStatement.setInt(++index2, country);
        createSubjectStatement.setString(++index2, primaryContactNumber);
        createSubjectStatement.setString(++index2, secondaryContactNumber);
        createSubjectStatement.setTimestamp(++index2, createStamp);
        createSubjectStatement.setBoolean(++index2, true);
        createSubjectStatement.setBoolean(++index2, true);
        createSubjectStatement.executeUpdate();
    }

    static {
        fakeSite = "nss";
        stateIdToCityMap = FakeSubjects.generateStateIdToCityMap();
        ethnicityIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
        raceIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        genderIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6});
        log = Logger.getLogger(FakeSubjects.class);
    }
}

