/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.Address;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.NightlyBatchChanges;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class SubjectDAO
extends SiteDAO {
    static int CHUNK_SIZE = 200;
    private static final Comparator<Subject> subjectComparator = (o1, o2) -> o1.getLastName().compareToIgnoreCase(o2.getLastName());

    public void createSubject(Subject entity) {
        Subject subject = entity == null ? null : SubjectDataEncryptor.encryptSubjectInPlace(entity);
        Session session = this.session();
        session.save((Object)subject);
        session.flush();
    }

    public void saveSubjectMrn(SubjectMrn newMrn) {
        Session session = this.session();
        String encryptedMrnVal = SubjectDataEncryptor.encrypt(newMrn.getMrn());
        newMrn.setMrn(encryptedMrnVal);
        session.saveOrUpdate((Object)newMrn);
        session.flush();
    }

    public SubjectMrn getSubjectMrn(SubjectMrn subjectMrn) {
        StringBuffer findSubjectMrnQueryString = new StringBuffer();
        String encryptedMrn = SubjectDataEncryptor.encrypt(subjectMrn.getMrn());
        findSubjectMrnQueryString.append("FROM SubjectMrn sm WHERE sm.mrn = :mrn and (sm.site is NULL or sm.site = :site) and sm.subject = :subject");
        Query query = this.newQuery(findSubjectMrnQueryString.toString());
        query.setParameter("mrn", (Object)encryptedMrn);
        query.setParameter("site", (Object)subjectMrn.getSite());
        query.setParameter("subject", (Object)subjectMrn.getSubject());
        return (SubjectMrn)query.uniqueResult();
    }

    public void encryptAndSave(Subject entity) {
        if (entity != null) {
            Subject subject = SubjectDataEncryptor.encryptSubjectInPlace(entity);
            Session session = this.session();
            session.update((Object)subject);
            session.flush();
        }
    }

    public void logNightlyBatchDeltas(String encryptedChanges) {
        NightlyBatchChanges nightlyBatchChanges = new NightlyBatchChanges();
        nightlyBatchChanges.setChanges(encryptedChanges);
        this.createEntity(nightlyBatchChanges);
    }

    public void save(Subject subject) {
        Session session = this.session();
        session.update((Object)subject);
        session.flush();
    }

    public List<Subject> findAllSubjectsHql() {
        String findSubjects = "SELECT s FROM Subject s ";
        return this.newQuery("SELECT s FROM Subject s ").list();
    }

    public Criteria newSubjectCriteria() {
        return this.newCriteria(Subject.class);
    }

    public Criteria newSubjectMrnCriteria() {
        return this.newCriteria(SubjectMrn.class);
    }

    public int findNumberOfSubjects() {
        Criteria criteria = this.newSubjectCriteria();
        Number numberOfSubjects = (Number)criteria.setProjection(Projections.rowCount()).uniqueResult();
        return numberOfSubjects.intValue();
    }

    public int findNumberOfSubjectMrns() {
        Criteria criteria = this.newSubjectMrnCriteria();
        Number numberOfSubjectMrns = (Number)criteria.setProjection(Projections.rowCount()).uniqueResult();
        return numberOfSubjectMrns.intValue();
    }

    public List<Subject> findAllSubjectsInChunks() {
        int numSubjects = this.findNumberOfSubjects();
        ArrayList allSubjects = Lists.newArrayList();
        String findAllSubjects = "FROM Subject";
        Query query = this.newQuery(findAllSubjects);
        for (int start = 0; start < numSubjects; start += CHUNK_SIZE) {
            query.setFirstResult(start);
            query.setMaxResults(CHUNK_SIZE);
            List someSubjects = query.list();
            allSubjects.addAll(someSubjects);
        }
        return allSubjects;
    }

    public List<SubjectMrn> findAllSubjectMrns() {
        int numSubjectMrns = this.findNumberOfSubjectMrns();
        ArrayList allSubjectsMrns = Lists.newArrayList();
        Criteria criteria = this.newSubjectMrnCriteria();
        for (int start = 0; start < numSubjectMrns; start += CHUNK_SIZE) {
            criteria.setFirstResult(start);
            criteria.setMaxResults(CHUNK_SIZE);
            List someSubjectMrns = criteria.list();
            allSubjectsMrns.addAll(someSubjectMrns);
        }
        return allSubjectsMrns;
    }

    static final Predicate<Row> subjectsPredicate(Optional<String> normalizedFilterString) {
        boolean filterStringIsPresent = normalizedFilterString.isPresent();
        return row -> {
            if (filterStringIsPresent) {
                String filterStringToUse = (String)normalizedFilterString.get();
                boolean mrnMatches = ((Row)row).mrn.contains(filterStringToUse);
                boolean lastNameMatches = ((Row)row).subjectData.name.lastName.contains(filterStringToUse);
                return mrnMatches || lastNameMatches;
            }
            return true;
        };
    }

    static Optional<String> normalizeFilterString(String filterString) {
        return Optional.ofNullable(filterString).map(fs -> fs.trim().toUpperCase()).filter(fs -> !fs.isEmpty());
    }

    static final String encryptIgnoringLiteralNullsNullsOrBlanks(String rawField) {
        if (!SubjectDAO.isLiteralNullNullOrBlank(rawField)) {
            return SubjectDataEncryptor.encrypt(rawField.toUpperCase());
        }
        return null;
    }

    static boolean isLiteralNullNullOrBlank(String lastName) {
        return lastName == null || lastName.equalsIgnoreCase("null") || lastName.isEmpty();
    }

    public Subject findById(int id) {
        return this.findById(Subject.class, id);
    }

    public Subject findBySubjectId(int id) {
        Subject subject = this.findById(Subject.class, id);
        if (subject == null) {
            SchedulerRuntimeException.logAndThrow("No Subject found with ID: " + id);
        }
        return SubjectDataEncryptor.decryptSubject(subject);
    }

    public SubjectDetailResponse getSubjectDataById(int subjectId) {
        Subject subject = this.findBySubjectId(subjectId);
        Subject subjectCopy = Subject.defensiveCopy(subject);
        return new SubjectDetailResponse(subjectCopy);
    }

    public StudySubject findStudySubjectById(Integer id) {
        StudySubject studySubject = this.findById(StudySubject.class, id);
        return studySubject;
    }

    public SubjectMrn findSubjectMrnById(Integer id) {
        SubjectMrn subjectMrn = this.findById(SubjectMrn.class, id);
        return subjectMrn;
    }

    public List<Subject> filterSubjectByLastNames(String lastName) {
        String encName = lastName == null ? null : SubjectDataEncryptor.encrypt(lastName.toUpperCase());
        List<Subject> list = this.findSubjectByLastNames(encName);
        if (list != null) {
            return ListUtils.enrich(list).map(SubjectDataEncryptor::decryptSubject).toList();
        }
        return new ArrayList<Subject>();
    }

    public List<Subject> getSubjectByLastName(String lastName, InstitutionRole institutionRole) {
        boolean isStudyStaff = InstitutionRole.isStudyStaff(institutionRole);
        Predicate<Subject> matches = subject -> isStudyStaff ? SubjectDAO.lastNameIs(subject, lastName) : SubjectDAO.lastNameMatches(subject, lastName);
        List<Subject> subjects = this.findAllSubjectsInChunks();
        return ListUtils.enrich(subjects).map(SubjectDataEncryptor::decryptSubject).filter(matches).toList();
    }

    private static boolean lastNameIs(Subject subject, String lastName) {
        return subject.getLastName().equalsIgnoreCase(lastName);
    }

    private static boolean lastNameMatches(Subject subject, String lastName) {
        return subject.getLastName().toLowerCase().contains(lastName.toLowerCase());
    }

    public List<Subject> filterSubjectsByMRN(String mrn, InstitutionRole institutionRole, String institution) {
        if (mrn != null) {
            List<Subject> encryptedList = this.findAllSubjectsInChunks();
            RichList decryptedList = ListUtils.enrich(encryptedList).map(SubjectDataEncryptor::decryptSubject);
            boolean isStudyStaff = InstitutionRole.isStudyStaff(institutionRole);
            Predicate<Subject> shouldBeReturned = subject -> isStudyStaff ? SubjectDAO.mrnMatchesIgnoreCaseExactly(subject, mrn) : SubjectDAO.mrnMatchesIgnoreCaseAtLeastPartially(subject, mrn);
            return decryptedList.sortWith(subjectComparator).filter(shouldBeReturned).toList();
        }
        return new ArrayList<Subject>();
    }

    static boolean mrnMatchesIgnoreCaseExactly(Subject subject, String desiredMrn) {
        Set<SubjectMrn> mrnSet = subject.getSubjectMrnSet();
        Optional<SubjectMrn> match = mrnSet.stream().filter(sm -> sm.getMrn().equalsIgnoreCase(desiredMrn)).findFirst();
        return match.isPresent();
    }

    static boolean mrnMatchesIgnoreCaseAtLeastPartially(Subject subject, String desiredMrn) {
        Set<SubjectMrn> mrnSet = subject.getSubjectMrnSet();
        Optional<SubjectMrn> match = mrnSet.stream().filter(sm -> sm.getMrn().toUpperCase().contains(desiredMrn.toUpperCase())).findFirst();
        return match.isPresent();
    }

    public List<State> getStates() {
        return this.findAll(State.class);
    }

    public List<Race> getRaces() {
        return this.findAll(Race.class);
    }

    public List<Ethnicity> getEthnicities() {
        return this.findAll(Ethnicity.class);
    }

    public List<Gender> getGenders() {
        return this.findAll(Gender.class);
    }

    public List<Country> getCountries() {
        return this.findAll(Country.class);
    }

    public List<Subject> findSubjectByLastNames(String lastName) {
        Criteria crit = this.newCriteria(Subject.class);
        crit.add((Criterion)Restrictions.eq((String)"lastName", (Object)lastName));
        return crit.list();
    }

    public boolean mrnInfoExists(MrnInfoDTO mrnInfoDTO) {
        List resultRows;
        if (mrnInfoDTO == null || mrnInfoDTO.getValue() == null) {
            return false;
        }
        StringBuffer findSubjects = new StringBuffer();
        findSubjects.append("FROM SubjectMrn sm WHERE sm.mrn = :mrn");
        if (mrnInfoDTO.getInstitution() == null) {
            findSubjects.append(" and sm.site IS NULL");
        } else {
            findSubjects.append(" and sm.site = :site");
        }
        Query query = this.newQuery(findSubjects.toString());
        String encryptedMrn = SubjectDataEncryptor.encrypt(mrnInfoDTO.getValue());
        query.setParameter("mrn", (Object)encryptedMrn);
        if (mrnInfoDTO.getInstitution() != null) {
            query.setParameter("site", (Object)mrnInfoDTO.getInstitution());
        }
        return !(resultRows = query.list()).isEmpty();
    }

    public Gender findByGenderId(Integer id) {
        return this.findById(Gender.class, id);
    }

    public Gender findGenderByCode(Class<Gender> genderClass, String code) {
        Criteria criteria = this.newCriteria(genderClass);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)code));
        return (Gender)criteria.uniqueResult();
    }

    public Race findByRaceId(Integer id) {
        return this.findById(Race.class, id);
    }

    public Ethnicity findByEthnicityId(Integer id) {
        return this.findById(Ethnicity.class, id);
    }

    public State findByStateId(Integer id) {
        return this.findById(State.class, id);
    }

    public Country findCountryById(Integer id) {
        return this.findById(Country.class, id);
    }

    public SubjectsResponseDTO getSearchSubjects(String lastName, String firstName, String mrn, String bday, List<String> genderList) {
        String encLastName = SubjectDAO.encryptIgnoringLiteralNullsNullsOrBlanks(lastName);
        String encFirstName = SubjectDAO.encryptIgnoringLiteralNullsNullsOrBlanks(firstName);
        String encMrn = SubjectDAO.encryptIgnoringLiteralNullsNullsOrBlanks(mrn);
        Date date = !bday.isEmpty() ? DateUtility.parse(DateUtility.monthDayYear(), bday) : null;
        ArrayList<Integer> genderIdList = new ArrayList<Integer>();
        for (String gender : genderList) {
            genderIdList.add(Integer.parseInt(gender));
        }
        List<SubjectsResponseDTO> resultRows = this.findSubjectByLastAndFirstNameMrnBdateGender(encLastName, encFirstName, encMrn, date, genderIdList);
        Long total = resultRows.size();
        return new SubjectsResponseDTO(resultRows, total);
    }

    public List<SubjectsResponseDTO> findSubjectByLastAndFirstNameMrnBdateGender(String lastName, String firstName, String medicalRecordNumber, Date birthDate, List<Integer> genderIdList) {
        String findSubjects = "FROM SubjectMrn sm" + this.findSubjectWhereClause(lastName, firstName, medicalRecordNumber, birthDate, genderIdList);
        Query query = this.newQuery(findSubjects);
        this.setSubjectQueryParameters(query, lastName, firstName, medicalRecordNumber, birthDate, genderIdList);
        List resultRows = query.list();
        return ListUtils.enrich((List)resultRows).map(s -> Row.fromSubject(s)).map(Row::decrypt).map(Row::toSubjectsResponse).toList();
    }

    private String findSubjectWhereClause(String lastName, String firstName, String medicalRecordNumber, Date birthDate, List<Integer> genderIdList) {
        String whereClause = "";
        if (medicalRecordNumber != null) {
            whereClause = " WHERE sm.mrn = :medicalRecordNumber";
        } else if (lastName != null && firstName != null && birthDate != null) {
            whereClause = " WHERE sm.subject.lastName = :lastName and sm.subject.firstName = :firstName and sm.subject.birthdate = :birthDate";
        }
        if (genderIdList != null && !genderIdList.isEmpty()) {
            whereClause = whereClause + " and sm.subject.gender.id in (:genderIdList)";
        }
        return whereClause;
    }

    private void setSubjectQueryParameters(Query query, String lastName, String firstName, String medicalRecordNumber, Date birthDate, List<Integer> genderIdList) {
        if (lastName != null) {
            query.setParameter("lastName", (Object)lastName);
        }
        if (firstName != null) {
            query.setParameter("firstName", (Object)firstName);
        }
        if (medicalRecordNumber != null) {
            query.setParameter("medicalRecordNumber", (Object)medicalRecordNumber);
        }
        if (birthDate != null) {
            query.setParameter("birthDate", (Object)birthDate);
        }
        if (genderIdList != null && !genderIdList.isEmpty()) {
            query.setParameterList("genderIdList", genderIdList);
        }
    }

    public Subject findInternalSubjectByPuid(String puid) {
        String encryptedPuid = SubjectDataEncryptor.encrypt(puid);
        String queryString = "Select subject FROM Subject subject WHERE puid = '" + encryptedPuid + "'";
        Query query = this.newQuery(queryString);
        Subject result = (Subject)query.uniqueResult();
        return result;
    }

    public SubjectDetailResponse findInternalSubjectByMrn(List<MrnInfoDTO> mrnInfoDTOList) {
        if (mrnInfoDTOList == null || mrnInfoDTOList.isEmpty()) {
            return new SubjectDetailResponse();
        }
        StringBuilder findSubjects = new StringBuilder();
        findSubjects.append("Select sm.subject FROM SubjectMrn sm WHERE ");
        for (int i = 0; i < mrnInfoDTOList.size(); ++i) {
            if (i != 0) {
                findSubjects.append(" or ");
            }
            String encryptedMrn = SubjectDataEncryptor.encrypt(mrnInfoDTOList.get(i).getValue());
            String institution = mrnInfoDTOList.get(i).getInstitution();
            findSubjects.append("sm.mrn = '" + encryptedMrn + "' and sm.site = '" + institution + "'");
        }
        Query query = this.newQuery(findSubjects.toString());
        List subjectList = query.list();
        SubjectDetailResponse subjectDetailResponse = new SubjectDetailResponse();
        if (!subjectList.isEmpty()) {
            Subject decryptedSubject = SubjectDataEncryptor.decryptSubject((Subject)subjectList.get(0));
            subjectDetailResponse = new SubjectDetailResponse(decryptedSubject);
        }
        return subjectDetailResponse;
    }

    static final class Row {
        private final Integer id;
        private final String mrn;
        private final Boolean status;
        private final SubjectData subjectData;

        public Row(Integer id, SubjectData subjectData, String mrn, Boolean status) {
            this.id = id;
            this.mrn = mrn;
            this.subjectData = subjectData;
            this.status = status;
        }

        public static Row fromSubject(SubjectMrn subjectMrn) {
            Subject subject = subjectMrn.getSubject();
            String gender = "";
            if (subject.getGender() != null) {
                gender = subject.getGender().getName();
            }
            Address address = new Address();
            if (subject.getCity() != null) {
                address.setCity(subject.getCity());
            }
            if (subject.getState() != null) {
                address.setStateName(subject.getState().getName().toUpperCase());
            }
            RowBuilder rowBuilder = new RowBuilder();
            rowBuilder.id(subject.getId()).lastName(subject.getLastName()).firstName(subject.getFirstName()).middleName(subject.getMiddleName()).mrn(subjectMrn.getMrn()).dob(subject.getBirthdate()).gender(gender).address(address).primaryContact(subject.getPrimaryContactNumber()).status(subject.getActive());
            return rowBuilder.createRow();
        }

        public Row decrypt() {
            RowBuilder rowBuilder = new RowBuilder();
            this.subjectData.address.setAddressLine1(SubjectDataEncryptor.decrypt(this.subjectData.address.getAddressLine1()));
            this.subjectData.address.setAddressLine2(SubjectDataEncryptor.decrypt(this.subjectData.address.getAddressLine2()));
            this.subjectData.address.setCity(SubjectDataEncryptor.decrypt(this.subjectData.address.getCity()));
            this.subjectData.address.setZipCode(SubjectDataEncryptor.decrypt(this.subjectData.address.getZipCode()));
            rowBuilder.id(this.id).lastName(SubjectDataEncryptor.decrypt(this.subjectData.getName().getLastName())).firstName(SubjectDataEncryptor.decrypt(this.subjectData.getName().getFirstName())).middleName(SubjectDataEncryptor.decrypt(this.subjectData.getName().getMiddleName())).mrn(SubjectDataEncryptor.decrypt(this.mrn)).dob(this.subjectData.getDob()).gender(this.subjectData.getGender()).address(this.subjectData.getAddress()).primaryContact(this.subjectData.primaryContact == null ? null : SubjectDataEncryptor.decrypt(this.subjectData.primaryContact).replaceAll("[^a-zA-Z0-9]+", "")).status(this.status);
            return rowBuilder.createRow();
        }

        public SubjectsResponseDTO toSubjectsResponse() {
            return new SubjectsResponseDTO(this.id, this.subjectData.getName().getLastName(), this.subjectData.getName().getFirstName(), this.subjectData.getName().getMiddleName(), this.subjectData.getDob(), this.subjectData.getGender(), this.subjectData.getAddress(), this.subjectData.getPrimaryContact(), this.status);
        }

        public static class RowBuilder {
            private Integer id;
            private String lastName;
            private String firstName;
            private String middleName;
            private String mrn;
            private Date dob;
            private String gender;
            private Address address;
            private String primaryContact;
            private Boolean status;

            public RowBuilder id(Integer id) {
                this.id = id;
                return this;
            }

            public RowBuilder lastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public RowBuilder firstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public RowBuilder middleName(String middleName) {
                this.middleName = middleName;
                return this;
            }

            public RowBuilder mrn(String mrn) {
                this.mrn = mrn;
                return this;
            }

            public RowBuilder dob(Date dob) {
                this.dob = dob;
                return this;
            }

            public RowBuilder gender(String gender) {
                this.gender = gender;
                return this;
            }

            public RowBuilder address(Address address) {
                this.address = address;
                return this;
            }

            public RowBuilder primaryContact(String primaryContact) {
                this.primaryContact = primaryContact;
                return this;
            }

            public RowBuilder status(Boolean status) {
                this.status = status;
                return this;
            }

            public Row createRow() {
                Name name = new Name(this.lastName, this.firstName, this.middleName);
                SubjectData subjectData = new SubjectData(name, this.dob, this.gender, this.address, this.primaryContact);
                return new Row(this.id, subjectData, this.mrn, this.status);
            }
        }
    }

    static final class SubjectData {
        private final Name name;
        private final Date dob;
        private final String gender;
        private final Address address;
        private final String primaryContact;

        public Name getName() {
            return this.name;
        }

        public Date getDob() {
            return this.dob;
        }

        public String getGender() {
            return this.gender;
        }

        public Address getAddress() {
            return this.address;
        }

        public String getPrimaryContact() {
            return this.primaryContact;
        }

        public SubjectData(Name name, Date dob, String gender, Address address, String primaryContact) {
            this.name = name;
            this.dob = dob;
            this.gender = gender;
            this.address = address;
            this.primaryContact = primaryContact;
        }
    }

    static final class Name {
        private final String lastName;
        private final String firstName;
        private final String middleName;

        public Name(String lastName, String firstName, String middleName) {
            this.lastName = lastName;
            this.firstName = firstName;
            this.middleName = middleName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }
    }
}

