/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.websso;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpClientInTransport;
import org.opensaml.ws.transport.http.HttpClientOutTransport;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.trust.X509KeyManager;
import org.springframework.security.saml.websso.ArtifactResolutionProfileBase;

public class ArtifactResolutionProfileImpl
extends ArtifactResolutionProfileBase {
    private HttpClient httpClient;

    public ArtifactResolutionProfileImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected void getArtifactResponse(String endpointURI, SAMLMessageContext context) throws SAMLException, MessageEncodingException, MessageDecodingException, MetadataProviderException, SecurityException {
        PostMethod postMethod = null;
        try {
            URI uri = new URI(context.getPeerEntityEndpoint().getLocation(), true, "UTF-8");
            postMethod = new PostMethod();
            postMethod.setPath(uri.getPath());
            HostConfiguration hc = this.getHostConfiguration(uri, context);
            HttpClientOutTransport clientOutTransport = new HttpClientOutTransport(postMethod);
            HttpClientInTransport clientInTransport = new HttpClientInTransport(postMethod, endpointURI);
            context.setInboundMessageTransport((InTransport)clientInTransport);
            context.setOutboundMessageTransport((OutTransport)clientOutTransport);
            boolean signMessage = context.getPeerExtendedMetadata().isRequireArtifactResolveSigned();
            this.processor.sendMessage(context, signMessage, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            this.log.debug("Sending ArtifactResolution message to {}", (Object)uri);
            int responseCode = this.httpClient.executeMethod(hc, (HttpMethod)postMethod);
            if (responseCode != 200) {
                String responseBody = postMethod.getResponseBodyAsString();
                throw new MessageDecodingException("Problem communicating with Artifact Resolution service, received response " + responseCode + ", body " + responseBody);
            }
            this.processor.retrieveMessage(context, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        }
        catch (IOException e) {
            throw new MessageDecodingException("Error when sending request to artifact resolution service.", (Exception)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }

    protected HostConfiguration getHostConfiguration(URI uri, SAMLMessageContext context) throws MessageEncodingException {
        try {
            HostConfiguration hc = this.httpClient.getHostConfiguration();
            hc = hc != null ? new HostConfiguration(hc) : new HostConfiguration();
            if (uri.getScheme().equalsIgnoreCase("http")) {
                this.log.debug("Using HTTP configuration");
                hc.setHost(uri);
            } else {
                this.log.debug("Using HTTPS configuration");
                CriteriaSet criteriaSet = new CriteriaSet();
                criteriaSet.add((Object)new EntityIDCriteria(context.getPeerEntityId()));
                criteriaSet.add((Object)new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
                criteriaSet.add((Object)new UsageCriteria(UsageType.UNSPECIFIED));
                org.springframework.security.saml.trust.X509TrustManager trustManager = new org.springframework.security.saml.trust.X509TrustManager(criteriaSet, context.getLocalSSLTrustEngine());
                X509KeyManager manager = new X509KeyManager(context.getLocalSSLCredential());
                HostnameVerifier hostnameVerifier = context.getLocalSSLHostnameVerifier();
                SecureProtocolSocketFactory socketFactory = this.getSSLSocketFactory(context, manager, trustManager, hostnameVerifier);
                Protocol protocol = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
                hc.setHost(uri.getHost(), uri.getPort(), protocol);
            }
            return hc;
        }
        catch (URIException e) {
            throw new MessageEncodingException("Error parsing remote location URI", (Exception)((Object)e));
        }
    }

    protected SecureProtocolSocketFactory getSSLSocketFactory(SAMLMessageContext context, X509KeyManager manager, org.springframework.security.saml.trust.X509TrustManager trustManager, HostnameVerifier hostnameVerifier) {
        if (this.isHostnameVerificationSupported()) {
            return new TLSProtocolSocketFactory((javax.net.ssl.X509KeyManager)manager, (X509TrustManager)trustManager, hostnameVerifier);
        }
        return new TLSProtocolSocketFactory((javax.net.ssl.X509KeyManager)manager, (X509TrustManager)trustManager);
    }

    protected boolean isHostnameVerificationSupported() {
        try {
            TLSProtocolSocketFactory.class.getConstructor(javax.net.ssl.X509KeyManager.class, X509TrustManager.class, HostnameVerifier.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            this.log.warn("HostnameVerification is not supported, update your OpenSAML libraries");
            return false;
        }
    }
}

