/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public abstract class AbstractIOStrategy
implements IOStrategy {
    private static final EnumSet<IOEvent> READ_WRITE_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.WRITE);
    private static final EnumSet<IOEvent> WORKER_THREAD_EVENT_SET = EnumSet.of(IOEvent.READ, IOEvent.WRITE, IOEvent.CLOSED);
    protected static final IOEventProcessingHandler ENABLE_INTEREST_PROCESSING_HANDLER = new EnableInterestProcessingHandler();

    @Override
    public ThreadPoolConfig createDefaultWorkerPoolConfig(Transport transport) {
        ThreadPoolConfig config = ThreadPoolConfig.defaultConfig().copy();
        int coresCount = Runtime.getRuntime().availableProcessors();
        config.setCorePoolSize(coresCount * 2);
        config.setMaxPoolSize(coresCount * 2);
        config.setMemoryManager(transport.getMemoryManager());
        return config;
    }

    @Override
    public final boolean executeIoEvent(Connection connection, IOEvent ioEvent) throws IOException {
        return this.executeIoEvent(connection, ioEvent, true);
    }

    protected static boolean isReadWrite(IOEvent ioEvent) {
        return READ_WRITE_EVENT_SET.contains((Object)ioEvent);
    }

    protected static boolean isExecuteInWorkerThread(IOEvent ioEvent) {
        return WORKER_THREAD_EVENT_SET.contains((Object)ioEvent);
    }

    protected static Executor getWorkerThreadPool(Connection c) {
        return c.getTransport().getWorkerThreadPool();
    }

    protected static void fireIOEvent(Connection connection, IOEvent ioEvent, IOEventProcessingHandler ph, Logger logger) {
        try {
            connection.getTransport().fireIOEvent(ioEvent, connection, ph);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_IOSTRATEGY_UNCAUGHT_EXCEPTION(), e);
            connection.closeSilently();
        }
    }

    private static final class EnableInterestProcessingHandler
    extends EmptyIOEventProcessingHandler {
        private EnableInterestProcessingHandler() {
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            IOEvent ioEvent = context.getIoEvent();
            Connection connection = context.getConnection();
            if (AsyncQueue.EXPECTING_MORE_OPTION.equals(data)) {
                connection.simulateIOEvent(ioEvent);
            } else {
                connection.enableIOEvent(ioEvent);
            }
        }
    }
}

