/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.keygen;

import java.security.SecureRandom;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;

final class SecureRandomBytesKeyGenerator
implements BytesKeyGenerator {
    private final SecureRandom random = new SecureRandom();
    private final int keyLength;
    private static final int DEFAULT_KEY_LENGTH = 8;

    public SecureRandomBytesKeyGenerator() {
        this(8);
    }

    public SecureRandomBytesKeyGenerator(int keyLength) {
        this.keyLength = keyLength;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public byte[] generateKey() {
        byte[] bytes = new byte[this.keyLength];
        this.random.nextBytes(bytes);
        return bytes;
    }
}

