/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.statics;

import java.util.ArrayList;
import java.util.List;

public enum StudyStatusFilter {
    NO_FILTER(null, "Choose..."),
    BY_PENDING_STATUS("isPending", "Pending"),
    BY_OPEN_STATUS("isClosed", "Closed"),
    BY_CLOSED_STATUS("isOpen", "Open");

    private String entityFlagName;
    private String menuLabel;

    private StudyStatusFilter(String entityFlagName, String menuLabel) {
        this.entityFlagName = entityFlagName;
        this.menuLabel = menuLabel;
    }

    public String getEntityFlagName() {
        return this.entityFlagName;
    }

    public static List<MenuItem> getMenuContents() {
        ArrayList<MenuItem> menuMap = new ArrayList<MenuItem>();
        for (StudyStatusFilter filterValue : StudyStatusFilter.values()) {
            MenuItem menuItem = new MenuItem();
            menuItem.id = filterValue.name();
            menuItem.label = filterValue.menuLabel;
            menuMap.add(menuItem);
        }
        return menuMap;
    }

    private static class MenuItem {
        String label;
        String id;

        private MenuItem() {
        }
    }
}

