/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.LazyList;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ListUtils {
    private ListUtils() {
    }

    @SafeVarargs
    public static <A> List<A> concat(List<A> first, List<A> ... rest) {
        ArrayList<A> result = new ArrayList<A>(first);
        for (List<A> other : rest) {
            result.addAll(other);
        }
        return result;
    }

    public static boolean nullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <A> List<A> toList(Optional<A> o) {
        if (o.isPresent()) {
            return Lists.newArrayList((Object[])new Object[]{o.get()});
        }
        return Collections.emptyList();
    }

    public static <A> List<A> flatten(List<Optional<A>> optionals) {
        return optionals.stream().map(ListUtils::toList).flatMap(l -> l.stream()).collect(Collectors.toList());
    }

    public static <A> RichList<A> enrich(List<A> list) {
        return RichList.enrich(list);
    }

    public static <A> LazyList<A> lazy(List<A> list) {
        return LazyList.lazy(list);
    }

    public static <A> RichList<A> enrich(A[] array) {
        return ListUtils.enrich(Arrays.asList(array));
    }

    public static <A> RichList<A> enrich(Iterable<? extends A> as) {
        return ListUtils.enrich(Lists.newArrayList(as));
    }
}

