/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OverrideReportDTO
implements CsvAbleDTO {
    private String performingUser_firstName;
    private String performingUser_middleName;
    private String performingUser_lastName;
    private String performingUser_ecommonsId;
    private Integer performingUser_id;
    private Date date;
    private String appointmentOverrideReason;
    private String affectedResource;
    private String bookedVisit;
    private String bookedVisit_study_catalystId;
    private String bookedVisit_study_localId;
    private String bookedVisit_study_irb;
    private Date bookedVisit_scheduledStartTime;

    public OverrideReportDTO(ActivityLog al) {
        this.performingUser_firstName = al.getPerformingUser().getFirstName();
        this.performingUser_middleName = al.getPerformingUser().getMiddleName();
        this.performingUser_lastName = al.getPerformingUser().getLastName();
        this.performingUser_ecommonsId = al.getPerformingUser().getEcommonsId();
        this.performingUser_id = al.getPerformingUser().getId();
        this.date = al.getDate();
        this.appointmentOverrideReason = al.getAppointmentOverrideReason().getName();
        this.affectedResource = al.getAffectedResource().getName();
        this.bookedVisit = al.getBookedVisit().getName();
        this.bookedVisit_scheduledStartTime = al.getBookedVisit().getScheduledStartTime();
        this.bookedVisit_study_catalystId = al.getBookedVisit().getStudy().getCatalystId();
        this.bookedVisit_study_localId = al.getBookedVisit().getStudy().getLocalId();
        this.bookedVisit_study_irb = al.getBookedVisit().getStudy().getIrb();
    }

    @Override
    public String toCsvHeaders() {
        return "Performing User,Override Time,Override Reason,Resource Name,Visit Name,Scheduled Visit Time,Catalyst ID,Local Id,IRB #";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        int previousUserId = -1;
        for (Object object : dtoList) {
            OverrideReportDTO d = (OverrideReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentUserId = d.performingUser_id;
            if (currentUserId != previousUserId) {
                columns.add(MiscUtil.q(MiscUtil.fullName(d.performingUser_firstName, d.performingUser_middleName, d.performingUser_lastName)));
            } else {
                columns.add("");
            }
            previousUserId = currentUserId;
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.date)));
            columns.add(MiscUtil.q(d.appointmentOverrideReason));
            columns.add(MiscUtil.q(d.affectedResource));
            columns.add(MiscUtil.q(d.bookedVisit));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.bookedVisit_scheduledStartTime)));
            columns.add(MiscUtil.q(d.bookedVisit_study_catalystId));
            columns.add(MiscUtil.q(d.bookedVisit_study_localId));
            columns.add(MiscUtil.q(d.bookedVisit_study_irb));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

