/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import java.util.Comparator;

public final class Vertex {
    private static int counter = 0;
    private final String tableName;
    private final String tableShortName;
    private int priority = counter++;

    public Vertex(String tableName, String tableShortName) {
        this.tableName = tableName;
        this.tableShortName = tableShortName;
    }

    public String getTableShortName() {
        return this.tableShortName;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableShortName == null ? 0 : this.tableShortName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        if (this.tableShortName == null && other.tableShortName != null) {
            return false;
        }
        return this.tableShortName.equals(other.tableShortName);
    }

    public String toString() {
        return this.priority + ":" + this.fullName();
    }

    public String fullName() {
        return this.tableName + " " + this.tableShortName;
    }

    static class VertexComparator
    implements Comparator<Vertex> {
        VertexComparator() {
        }

        @Override
        public int compare(Vertex thisOne, Vertex otherOne) {
            Integer thisPriority = thisOne.getPriority();
            Integer otherPriority = otherOne.getPriority();
            return thisPriority.compareTo(otherPriority);
        }
    }
}

