/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.CentersAndInstitutions;
import edu.harvard.catalyst.scheduler.entity.FundingSource;
import edu.harvard.catalyst.scheduler.entity.Study;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="study_funding_source_cai")
public class StudyFundingSource
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 6189764272430222862L;
    private Integer studyId;
    private FundingSource fundingSource;
    private CentersAndInstitutions centersAndInstitutions;
    private Integer oneToFour;
    private String comment;
    private String grantId;
    private String siteCostCenter;
    private Double totalDirectAward;
    private Double totalIndirectAward;
    private Date projectStartDate;
    private Date projectEndDate;

    @Deprecated
    public StudyFundingSource() {
        super(null);
    }

    public StudyFundingSource(Study study, FundingSource fundingSource, CentersAndInstitutions cai, Integer oneToFour, String comment, String grantId, String siteCostCenter, Double totalDirectAward, Double totalIndirectAward, Date projectStartDate, Date projectEndDate) {
        super(null);
        this.studyId = study.getId();
        this.fundingSource = fundingSource;
        this.centersAndInstitutions = cai;
        this.oneToFour = oneToFour;
        this.comment = comment;
        this.grantId = grantId;
        this.siteCostCenter = siteCostCenter;
        this.totalDirectAward = totalDirectAward;
        this.totalIndirectAward = totalIndirectAward;
        this.projectStartDate = projectStartDate;
        this.projectEndDate = projectEndDate;
    }

    @Column(name="study")
    @Basic(optional=false)
    public Integer getStudyId() {
        return this.studyId;
    }

    public void setStudyId(Integer studyId) {
        this.studyId = studyId;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="centers_and_institutions", referencedColumnName="id")
    public CentersAndInstitutions getCentersAndInstitutions() {
        return this.centersAndInstitutions;
    }

    public void setCentersAndInstitutions(CentersAndInstitutions centersAndInstitutions) {
        this.centersAndInstitutions = centersAndInstitutions;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="funding_source", referencedColumnName="id")
    public FundingSource getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSource fundingSource) {
        this.fundingSource = fundingSource;
    }

    @Column(name="one_to_four")
    @Basic(optional=false)
    public Integer getOneToFour() {
        return this.oneToFour;
    }

    public void setOneToFour(Integer oneToFour) {
        this.oneToFour = oneToFour;
    }

    @Column(name="comment")
    @Basic(optional=true)
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="grant_id")
    @Basic(optional=true)
    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    @Column(name="site_cost_center")
    @Basic(optional=true)
    public String getSiteCostCenter() {
        return this.siteCostCenter;
    }

    public void setSiteCostCenter(String siteCostCenter) {
        this.siteCostCenter = siteCostCenter;
    }

    @Column(name="total_direct_award")
    @Basic(optional=true)
    public Double getTotalDirectAward() {
        return this.totalDirectAward;
    }

    public void setTotalDirectAward(Double totalDirectAward) {
        this.totalDirectAward = totalDirectAward;
    }

    @Column(name="total_indirect_award")
    @Basic(optional=true)
    public Double getTotalIndirectAward() {
        return this.totalIndirectAward;
    }

    public void setTotalIndirectAward(Double totalIndirectAward) {
        this.totalIndirectAward = totalIndirectAward;
    }

    @Column(name="project_start_date")
    @Basic(optional=true)
    public Date getProjectStartDate() {
        return this.projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    @Column(name="project_end_date")
    @Basic(optional=true)
    public Date getProjectEndDate() {
        return this.projectEndDate;
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    public String toString() {
        return "StudyFundingSource [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

